<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

June 16, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital
  * [X] Michael Parsons - MPC
  * [X] Chris Clark - Netflix
  * [X] Rémi Achard - DNEG
  * [X] Troy Sobotka

# **OCIO Configs Working Group Meeting Notes**

* Working group direction:
    - Michael: Goal of group could be to design and develop the next gen ACES
      config, but also to maintain it long-term. Do we want to make it a formal 
      working group with dedicated leadership?
    - Thomas: Good to formalize the group. Current ACES config work is done 
      when there is time. There's not a good commitment which can lead to 
      delays. Group would be good for prioritizing work.
    - Sean: Should it be distinct from OCIO TSC, or a subgroup?
    - Mark: Division of power is better. There's some overlap, but the OCIO TSC
      is more dev centric. This is more user centric.
    - Michael: There could be a formal chair, or co-chairs, but without a 
      formalized group. 
    - Sean: The TSC has the benefit of governance structure.
    - ACES will likely be involved to support the work, but the goal from our 
      previous meeting was for OCIO to own the ACES config.
    - Carol: We just need to make sure the OCIO TSC is represented in the 
      group.
    - Michael: Studios will become highly dependent on this config, so it 
      will be important work.
    - Mark: Software vendors (i.e. Foundry) will also be dependent on it.
    - Thomas: Vendors are already asking about it.
    - Michael: Anyone interested in leading the group?
    - Sean and Matthias will co-chair.

* Config structure:
    - ACES reference config, studio in a box, or both:
        - Michael: As discussed, could potentially have one code base which can
          create an ACES reference config (minimal), and the big "studio in a 
          box" config.
        - Mark: If nobody is using the reference config, there's no point in 
          duplicating efforts.
        - Thomas: The smaller config is a subset of the bigger one. May not 
          need everything depending on what you are using. A base.
        - Kevin: We will often take a stock config and strip out stuff not 
          needed. Depends on distribution. How we generate it could lead to 
          module configuration.
        - Doug: Does seem like build settings to select options would be good. 
          Pure ACES model is good for OCIO as an ACES product partner, to 
          submit the implementation to the ACES logo program.
        - Carol: Something to be said for ACES transforms being builtin to OCIO 
          v2. Not needing external files is nice.
        - Mark: If you have multiple things to release, people have to make a 
          choice of what they use. People who want the studio in the box will 
          be upset depending on what DCCs choose as default. Lose benefit of 
          consistency. If we up front have minimal ACES only, that has some 
          value. We should be clear about what we’re giving out.
        - Matthias: Will the config be OCIO v2 only? Is it backwards 
          compatible.
        - Sean: Needs to be backwards compatible. We’re probably the wrong 
          people to answer this question. Should ask community what they want, 
          rather than deciding on something.
        - Thomas: Breaking backwards compatibility makes migration hard.
        - Carol: We might get polarizing opinions.
        - Mark: Almost feel whole idea of giant config is atypical of how OCIO 
          works. People are supposed to have their own configs. May as well 
          build everything into the library at that point.
        - Carol: Some just use whatever config ships with an application.
        - Michael: Think it is useful to support ACES-only reference for 
          checking against ACES, etc.
        - Thomas: ACES would like this config to be “the” config, to make 
          exchange between studios easier. Something ready to use out of the 
          box seems to be desired.
        - Doug: Some projects, Like MaterialX, want to make this config their 
          default.
        - Thomas: That could be done for USD as well.
- Utilizing OCIO v2 BuiltinTransform, and CLF where needed:
    - Michael: The implementation could focus on utilizing BuiltinTransform, 
      and CLF where external files are needed, since CLF is the ACES format.
    - Doug: If Academy publishes transforms in CLF as well as CTL, would be 
      interesting.
    - Mark: Doesn't hurt to use it.
    - Doug: CLF also supports metadata.
    - Thomas: We currently ship ICC profiles, for things like Adobe tools. Need 
      those for wider support. We could provide scripts to help people generate 
      ICC profiles. Would result in simpler package.
    - Mark: ICC profiles generated with ociobakelut often need to have 
      additional stuff injected into them from an external script. Cant just 
      use ociobakelut directly necessarily.
    - Kevin: Repo should mostly be Python code, and generated artifacts.

* Repository:
    - Python code base
    - Store generated config in repo? Or only as build artifact?
        - Mark: Nothing in repo but code.
        - Michael: We discussed previously if we should include the generated 
          config in the repo for reference.
        - Thomas: Need everything to go with config. Would be missing LUTs, 
          etc. We need to get past that old issue.
        - Matthias: Might be some vendor LUTs that are needed, where it is just 
          a curve. Would potentially need to be in version control then.
        - Mark: if the only source is only a LUT.
        - Michael: Thoughts on pulling dependent data from upstream?
        - Mark: Prefer to store it in repo if it's ASCII.
        - Kevin: Need to be careful relying on vendor storage. May not always 
          be available.
        - Config repo will only contain config generation code, and text data 
          resources where absolutely necessary (i.e. LUT data where no 
          BuiltinTransform is available)
    - Compound versioning (OCIO, ACES, semver):
        - Michael: People need to know what they are getting. Sean proposed a 
          compound versioning structure previously, to include OCIO version, 
          ACES version, and a config release version.
        - Carol: Yes, users need to know what is being used.
        - Mark: Version structure like: 
          `<OCIO version>_<ACES version>_<Build/Patch version>`
        - Kevin: Recommend incremental build #.
        - Michael: Could also use metadata to associate with ACES version.
        - Mark: Can reset build number counter at new ACES version or OCIO 
          version, etc.
        - Doug: Could be comment in config file that shows what you have. 
          Printed out nicely with different components.
        - Mark: There could also just be a text file with the config.
        - **TODO**: Determine how and where to differentiate the config release 
          versions.

* CI/CD:
    - Build configs/LUTs for download
        - Use CI to build complete config packages for release and easy 
          download.
        - Mark: In releases tab should be multiple entries at a time. Can 
          generate: ACES reference config, ACES full config etc. Any variations 
          are present for download independently.
    - Validate config results against ground truth (ACES images, CTL)
        - Michael: Proposing (and volunteering) to setup CI system, via GH 
          Actions, to validate config transforms against ground truth CLF 
          and/or ACES images.
        - Thomas: There is facilities like that now, in the current ACES 
          config. Optional utility. Generator is slow.
        - Michael: GH Actions supports 20 concurrent jobs, so can be sped up a 
          bit there.

* Config contents:
    - Color space, alias naming
        - Michael: Do we keep names consistent with existing config? A question 
          was raised in ocio-dev regarding underscores in alias names. Without 
          underscores, many color space names become problematic.
        - Thomas: Make configurable delimiter for future version.
        - Stick with existing names?
        - Thomas: Can change names, but need easy way to migrate. People are 
          building pipelines around this to do conversion. If we break 
          everything, people will be sad.
        - Kevin: Is there anything wrong with existing names? Or just opinions?
        - Thomas: The later.
        - Kevin: For OCIO v2 we had discussed being able to deprecate color 
          space names but maintain backwards compatibility. 
        - Doug: The new inactive color space feature supports this, yes. 
          Deprecated spaces would work in color space transforms, but not 
          discoverable in menus.
        - Kevin: Need survey monkey to get feedback on general opinions of 
          naming, etc.
    - Displays, views, reference spaces, looks.
        - Michael: Should displays and views be restructured to use OCIO v2 
          features like display reference space and view transform. Might be
          good to organize views by actual display instead of grouping under
          one ACES display.
        - Doug: Current config was setup to avoid display use. Needs to be 
          revisited. To what extent do we want to use v2 features. They are 
          optional, but would help with working.
        - Mark: Make it v2 as much as possible, and if someone complains, 
          make a backwards compatible config off the tail-end of the project. 
          Good opportunity to force DCCs to do the right thing. Incentive.
        - Carol: v2 makes things easier to implement. Will want config that 
          works and takes advantage of new features.
        - Doug: Good opportunity to ask vendors to improve things. Could put 
          together list of minimum expectations: support displays, views, 
          looks, etc.
        - Sean: Agree on using displays properly.
        - Matthias: Maintain family names (which group color spaces in some 
          DCCs, like Nuke)? Want to keep name similar to aid migration, but 
          might want to fix family names.
        - Doug: v2 has option to build hierarchical menus from family.
        - Sean: I think the ACES config families were a reaction to the size 
          of the config.
        - Thomas: Worth pinging vendors, to have more people on the table 
          discussing that.
        - Sean: Can't blame vendors in previous version. We didn't tell them 
          what we were looking for.
        - Kevin: Think the idea of roles appearing in menus was an annoyance. 
          Roles should be a Pipeline detail.
        - Michael: The new categories don't work with roles right?
        - Doug: Categories are for reducing color spaces in menus based on use.

* New code base:
    - Doug: Where did we land on whether old code could brought over?
    - Michael: I don't think it can with the current license.
    - Thomas: Would be better to start fresh.
    - Sean: Also thinking to start from scratch. To make it work well for CI 
      too.
    - Doug: Agree.
    - Michael: When should we target completion for this project?
    - Doug: OCIO v2 stabilization period over second half of year. Vendors will 
      work on incorporating, and find bugs, etc. Want people to start using it 
      before that.
    - Thomas: Are builtin transforms being shipped at that point?
    - Doug: ACES transforms are there now. Over stabilization period we could 
      increase number of builtin transforms. Not changing API. Just adding stuff.
    - Michael: Can we have something functional by end of year?
    - Sean: Good to have unit test config at feature complete time. Need 
      something to get right impression at start.
    - Mark: There will be a long period of requiring v1 configs, until every 
      DCC at studios is updated. Might be period where this config can't be 
      used.
    - Carol: Some people might not use OCIO v2 until there's a config.
    - Goal is to target reference config at feature complete time, and 
      end of year for "studio in a box". This working group will meet at the 
      same day and time every other week, for now.
