
local x0   = matrix.vec { 10, -1, 0.05, -0.00001, -0.05, 0.001, -0.000001 }
local x0_2 = matrix.vec { 1, -0.1, 0.005, -0.000001, -0.005, 0.0001, -0.0000001 }

local x = matrix.vec {
       1.0776351733E+00,
      -1.2269296921E-01,
       4.0863750610E-03,
      -1.4262662514E-06,
      -5.7609940901E-03,
       2.4053735503E-04,
      -1.2314450199E-07 }

local sumsq = 1.5324382854E+00

local sigma = matrix.vec {
   1.7070154742E-01,
  -1.2269296921E-01,
   4.0863750610E-03,
  -1.4262662514E-06,
  -5.7609940901E-03,
   2.4053735503E-04,
  -1.2314450199E-07 }

local data = matrix.def {
  {0.591, 24.41},
  {1.547, 34.82},
  {2.902, 44.09},
  {2.894, 45.07},
  {4.703, 54.98},
  {6.307, 65.51},
  {7.03, 70.53},
  {7.898, 75.70},
  {9.470, 89.57},
  {9.484, 91.14},
  {10.072, 96.40},
  {10.163, 97.19},
  {11.615, 114.26},
  {12.005, 120.25},
  {12.478, 127.08},
  {12.982, 133.55},
  {12.970, 133.61},
  {13.926, 158.67},
  {14.452, 172.74},
  {14.404, 171.31},
  {15.190, 202.14},
  {15.550, 220.55},
  {15.528, 221.05},
  {15.499, 221.39},
  {16.131, 250.99},
  {16.438, 268.99},
  {16.387, 271.80},
  {16.549, 271.97},
  {16.872, 321.31},
  {16.830, 321.69},
  {16.926, 330.14},
  {16.907, 333.03},
  {16.966, 333.47},
  {17.060, 340.77},
  {17.122, 345.65},
  {17.311, 373.11},
  {17.355, 373.79},
  {17.668, 411.82},
  {17.767, 419.51},
  {17.803, 421.59},
  {17.765, 422.02},
  {17.768, 422.47},
  {17.736, 422.61},
  {17.858, 441.75},
  {17.877, 447.41},
  {17.912, 448.7},
  {18.046, 472.89},
  {18.085, 476.69},
  {18.291, 522.47},
  {18.357, 522.62},
  {18.426, 524.43},
  {18.584, 546.75},
  {18.610, 549.53},
  {18.870, 575.29},
  {18.795, 576.00},
  {19.111, 625.55},
  {.367, 20.15},
  {.796, 28.78},
  {0.892, 29.57},
  {1.903, 37.41},
  {2.150, 39.12},
  {3.697, 50.24},
  {5.870, 61.38},
  {6.421, 66.25},
  {7.422, 73.42},
  {9.944, 95.52},
  {11.023, 107.32},
  {11.87, 122.04},
  {12.786, 134.03},
  {14.067, 163.19},
  {13.974, 163.48},
  {14.462, 175.70},
  {14.464, 179.86},
  {15.381, 211.27},
  {15.483, 217.78},
  {15.59, 219.14},
  {16.075, 262.52},
  {16.347, 268.01},
  {16.181, 268.62},
  {16.915, 336.25},
  {17.003, 337.23},
  {16.978, 339.33},
  {17.756, 427.38},
  {17.808, 428.58},
  {17.868, 432.68},
  {18.481, 528.99},
  {18.486, 531.08},
  {19.090, 628.34},
  {16.062, 253.24},
  {16.337, 273.13},
  {16.345, 273.66},
  {16.388, 282.10},
  {17.159, 346.62},
  {17.116, 347.19},
  {17.164, 348.78},
  {17.123, 351.18},
  {17.979, 450.10},
  {17.974, 450.35},
  {18.007, 451.92},
  {17.993, 455.56},
  {18.523, 552.22},
  {18.669, 553.56},
  {18.617, 555.74},
  {19.371, 652.59},
  {19.330, 656.20},
  {0.080, 14.13},
  {0.248, 20.41},
  {1.089, 31.30},
  {1.418, 33.84},
  {2.278, 39.70},
  {3.624, 48.83},
  {4.574, 54.50},
  {5.556, 60.41},
  {7.267, 72.77},
  {7.695, 75.25},
  {9.136, 86.84},
  {9.959, 94.88},
  {9.957, 96.40},
  {11.600, 117.37},
  {13.138, 139.08},
  {13.564, 147.73},
  {13.871, 158.63},
  {13.994, 161.84},
  {14.947, 192.11},
  {15.473, 206.76},
  {15.379, 209.07},
  {15.455, 213.32},
  {15.908, 226.44},
  {16.114, 237.12},
  {17.071, 330.90},
  {17.135, 358.72},
  {17.282, 370.77},
  {17.368, 372.72},
  {17.483, 396.24},
  {17.764, 416.59},
  {18.185, 484.02},
  {18.271, 495.47},
  {18.236, 514.78},
  {18.237, 515.65},
  {18.523, 519.47},
  {18.627, 544.47},
  {18.665, 560.11},
  {19.086, 620.77},
  {0.214, 18.97},
  {0.943, 28.93},
  {1.429, 33.91},
  {2.241, 40.03},
  {2.951, 44.66},
  {3.782, 49.87},
  {4.757, 55.16},
  {5.602, 60.90},
  {7.169, 72.08},
  {8.920, 85.15},
  {10.055, 97.06},
  {12.035, 119.63},
  {12.861, 133.27},
  {13.436, 143.84},
  {14.167, 161.91},
  {14.755, 180.67},
  {15.168, 198.44},
  {15.651, 226.86},
  {15.746, 229.65},
  {16.216, 258.27},
  {16.445, 273.77},
  {16.965, 339.15},
  {17.121, 350.13},
  {17.206, 362.75},
  {17.250, 371.03},
  {17.339, 393.32},
  {17.793, 448.53},
  {18.123, 473.78},
  {18.49, 511.12},
  {18.566, 524.70},
  {18.645, 548.75},
  {18.706, 551.64},
  {18.924, 574.02},
  {19.1, 623.86},
  {0.375, 21.46},
  {0.471, 24.33},
  {1.504, 33.43},
  {2.204, 39.22},
  {2.813, 44.18},
  {4.765, 55.02},
  {9.835, 94.33},
  {10.040, 96.44},
  {11.946, 118.82},
  {12.596, 128.48},
  {13.303, 141.94},
  {13.922, 156.92},
  {14.440, 171.65},
  {14.951, 190.00},
  {15.627, 223.26},
  {15.639, 223.88},
  {15.814, 231.50},
  {16.315, 265.05},
  {16.334, 269.44},
  {16.430, 271.78},
  {16.423, 273.46},
  {17.024, 334.61},
  {17.009, 339.79},
  {17.165, 349.52},
  {17.134, 358.18},
  {17.349, 377.98},
  {17.576, 394.77},
  {17.848, 429.66},
  {18.090, 468.22},
  {18.276, 487.27},
  {18.404, 519.54},
  {18.519, 523.03},
  {19.133, 612.99},
  {19.074, 638.59},
  {19.239, 641.36},
  {19.280, 622.05},
  {19.101, 631.50},
  {19.398, 663.97},
  {19.252, 646.9},
  {19.89, 748.29},
  {20.007, 749.21},
  {19.929, 750.14},
  {19.268, 647.04},
  {19.324, 646.89},
  {20.049, 746.9},
  {20.107, 748.43},
  {20.062, 747.35},
  {20.065, 749.27},
  {19.286, 647.61},
  {19.972, 747.78},
  {20.088, 750.51},
  {20.743, 851.37},
  {20.83, 845.97},
  {20.935, 847.54},
  {21.035, 849.93},
  {20.93, 851.61},
  {21.074, 849.75},
  {21.085, 850.98},
  {20.935, 848.23}}


local function iter()
   local i, n = 0, #data
   return function()
	     i = i + 1
	     if i <= n then
		return data:get(i,2), data:get(i,1)
	     end
	  end
end

local F = data:col(1)

return {title = 'Hahn1 non-linear fit NIST test',
	iter= iter,
        N= 236, P= 7,
	x0= x0, xref= x, F= data:col(1), t= data:col(2),
	t0= 14, t1= 860}
