/*
 * =============================================================================
 * 
 *   Copyright (c) 2014-2017, The UNBESCAPE team (http://www.unbescape.org)
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * 
 * =============================================================================
 */
package org.unbescape.html;

import java.util.Arrays;

/**
 * <p>
 *   This class initializes the {@link org.unbescape.html.HtmlEscapeSymbols#HTML5_SYMBOLS} structure.
 * </p>
 *
 * @author Daniel Fern&aacute;ndez
 * 
 * @since 1.0.0
 *
 */
final class Html5EscapeSymbolsInitializer {


    static HtmlEscapeSymbols initializeHtml5() {

        final HtmlEscapeSymbols.References html5References = new HtmlEscapeSymbols.References();

        /*
         * --------------------------------------------------------------------------------------------------
         *   HTML5 NAMED CHARACTER REFERENCES
         *   See: http://www.w3.org/TR/html5/syntax.html#named-character-references  [HTML5]
         *        http://www.w3.org/TR/html51/syntax.html#named-character-references [HTML 5.1]
         * --------------------------------------------------------------------------------------------------
         */
        html5References.addReference(     9, "&Tab;");
        html5References.addReference(    10, "&NewLine;");
        html5References.addReference(    33, "&excl;");
        html5References.addReference(    34, "&quot;");
        html5References.addReference(    34, "&quot");
        html5References.addReference(    34, "&QUOT");
        html5References.addReference(    34, "&QUOT;");
        html5References.addReference(    35, "&num;");
        html5References.addReference(    36, "&dollar;");
        html5References.addReference(    37, "&percnt;");
        html5References.addReference(    38, "&amp;");
        html5References.addReference(    38, "&amp");
        html5References.addReference(    38, "&AMP");
        html5References.addReference(    38, "&AMP;");
        html5References.addReference(    39, "&apos;");
        html5References.addReference(    40, "&lpar;");
        html5References.addReference(    41, "&rpar;");
        html5References.addReference(    42, "&ast;");
        html5References.addReference(    42, "&midast;");
        html5References.addReference(    43, "&plus;");
        html5References.addReference(    44, "&comma;");
        html5References.addReference(    46, "&period;");
        html5References.addReference(    47, "&sol;");
        html5References.addReference(    58, "&colon;");
        html5References.addReference(    59, "&semi;");
        html5References.addReference(    60, "&lt;");
        html5References.addReference(    60, "&lt");
        html5References.addReference(    60, "&LT");
        html5References.addReference(    60, "&LT;");
        html5References.addReference(    60,  8402, "&nvlt;");
        html5References.addReference(    61, "&equals;");
        html5References.addReference(    61,  8421, "&bne;");
        html5References.addReference(    62, "&gt;");
        html5References.addReference(    62, "&gt");
        html5References.addReference(    62, "&GT");
        html5References.addReference(    62, "&GT;");
        html5References.addReference(    62,  8402, "&nvgt;");
        html5References.addReference(    63, "&quest;");
        html5References.addReference(    64, "&commat;");
        html5References.addReference(    91, "&lbrack;");
        html5References.addReference(    91, "&lsqb;");
        html5References.addReference(    92, "&bsol;");
        html5References.addReference(    93, "&rbrack;");
        html5References.addReference(    93, "&rsqb;");
        html5References.addReference(    94, "&Hat;");
        html5References.addReference(    95, "&lowbar;");
        html5References.addReference(    95, "&UnderBar;");
        html5References.addReference(    96, "&grave;");
        html5References.addReference(    96, "&DiacriticalGrave;");
        html5References.addReference(   102,   106, "&fjlig;");
        html5References.addReference(   123, "&lbrace;");
        html5References.addReference(   123, "&lcub;");
        html5References.addReference(   124, "&verbar;");
        html5References.addReference(   124, "&vert;");
        html5References.addReference(   124, "&VerticalLine;");
        html5References.addReference(   125, "&rbrace;");
        html5References.addReference(   125, "&rcub;");
        html5References.addReference(   160, "&nbsp;");
        html5References.addReference(   160, "&nbsp");
        html5References.addReference(   160, "&NonBreakingSpace;");
        html5References.addReference(   161, "&iexcl;");
        html5References.addReference(   161, "&iexcl");
        html5References.addReference(   162, "&cent;");
        html5References.addReference(   162, "&cent");
        html5References.addReference(   163, "&pound;");
        html5References.addReference(   163, "&pound");
        html5References.addReference(   164, "&curren;");
        html5References.addReference(   164, "&curren");
        html5References.addReference(   165, "&yen;");
        html5References.addReference(   165, "&yen");
        html5References.addReference(   166, "&brvbar;");
        html5References.addReference(   166, "&brvbar");
        html5References.addReference(   167, "&sect;");
        html5References.addReference(   167, "&sect");
        html5References.addReference(   168, "&uml;");
        html5References.addReference(   168, "&die;");
        html5References.addReference(   168, "&uml");
        html5References.addReference(   168, "&Dot;");
        html5References.addReference(   168, "&DoubleDot;");
        html5References.addReference(   169, "&copy;");
        html5References.addReference(   169, "&copy");
        html5References.addReference(   169, "&COPY");
        html5References.addReference(   169, "&COPY;");
        html5References.addReference(   170, "&ordf;");
        html5References.addReference(   170, "&ordf");
        html5References.addReference(   171, "&laquo;");
        html5References.addReference(   171, "&laquo");
        html5References.addReference(   172, "&not;");
        html5References.addReference(   172, "&not");
        html5References.addReference(   173, "&shy;");
        html5References.addReference(   173, "&shy");
        html5References.addReference(   174, "&reg;");
        html5References.addReference(   174, "&circledR;");
        html5References.addReference(   174, "&reg");
        html5References.addReference(   174, "&REG");
        html5References.addReference(   174, "&REG;");
        html5References.addReference(   175, "&macr;");
        html5References.addReference(   175, "&macr");
        html5References.addReference(   175, "&strns;");
        html5References.addReference(   176, "&deg;");
        html5References.addReference(   176, "&deg");
        html5References.addReference(   177, "&plusmn;");
        html5References.addReference(   177, "&plusmn");
        html5References.addReference(   177, "&pm;");
        html5References.addReference(   177, "&PlusMinus;");
        html5References.addReference(   178, "&sup2;");
        html5References.addReference(   178, "&sup2");
        html5References.addReference(   179, "&sup3;");
        html5References.addReference(   179, "&sup3");
        html5References.addReference(   180, "&acute;");
        html5References.addReference(   180, "&acute");
        html5References.addReference(   180, "&DiacriticalAcute;");
        html5References.addReference(   181, "&micro;");
        html5References.addReference(   181, "&micro");
        html5References.addReference(   182, "&para;");
        html5References.addReference(   182, "&para");
        html5References.addReference(   183, "&middot;");
        html5References.addReference(   183, "&centerdot;");
        html5References.addReference(   183, "&middot");
        html5References.addReference(   183, "&CenterDot;");
        html5References.addReference(   184, "&cedil;");
        html5References.addReference(   184, "&cedil");
        html5References.addReference(   184, "&Cedilla;");
        html5References.addReference(   185, "&sup1;");
        html5References.addReference(   185, "&sup1");
        html5References.addReference(   186, "&ordm;");
        html5References.addReference(   186, "&ordm");
        html5References.addReference(   187, "&raquo;");
        html5References.addReference(   187, "&raquo");
        html5References.addReference(   188, "&frac14;");
        html5References.addReference(   188, "&frac14");
        html5References.addReference(   189, "&frac12;");
        html5References.addReference(   189, "&frac12");
        html5References.addReference(   189, "&half;");
        html5References.addReference(   190, "&frac34;");
        html5References.addReference(   190, "&frac34");
        html5References.addReference(   191, "&iquest;");
        html5References.addReference(   191, "&iquest");
        html5References.addReference(   192, "&Agrave;");
        html5References.addReference(   192, "&Agrave");
        html5References.addReference(   193, "&Aacute;");
        html5References.addReference(   193, "&Aacute");
        html5References.addReference(   194, "&Acirc;");
        html5References.addReference(   194, "&Acirc");
        html5References.addReference(   195, "&Atilde;");
        html5References.addReference(   195, "&Atilde");
        html5References.addReference(   196, "&Auml;");
        html5References.addReference(   196, "&Auml");
        html5References.addReference(   197, "&Aring;");
        html5References.addReference(   197, "&angst;");
        html5References.addReference(   197, "&Aring");
        html5References.addReference(   198, "&AElig;");
        html5References.addReference(   198, "&AElig");
        html5References.addReference(   199, "&Ccedil;");
        html5References.addReference(   199, "&Ccedil");
        html5References.addReference(   200, "&Egrave;");
        html5References.addReference(   200, "&Egrave");
        html5References.addReference(   201, "&Eacute;");
        html5References.addReference(   201, "&Eacute");
        html5References.addReference(   202, "&Ecirc;");
        html5References.addReference(   202, "&Ecirc");
        html5References.addReference(   203, "&Euml;");
        html5References.addReference(   203, "&Euml");
        html5References.addReference(   204, "&Igrave;");
        html5References.addReference(   204, "&Igrave");
        html5References.addReference(   205, "&Iacute;");
        html5References.addReference(   205, "&Iacute");
        html5References.addReference(   206, "&Icirc;");
        html5References.addReference(   206, "&Icirc");
        html5References.addReference(   207, "&Iuml;");
        html5References.addReference(   207, "&Iuml");
        html5References.addReference(   208, "&ETH;");
        html5References.addReference(   208, "&ETH");
        html5References.addReference(   209, "&Ntilde;");
        html5References.addReference(   209, "&Ntilde");
        html5References.addReference(   210, "&Ograve;");
        html5References.addReference(   210, "&Ograve");
        html5References.addReference(   211, "&Oacute;");
        html5References.addReference(   211, "&Oacute");
        html5References.addReference(   212, "&Ocirc;");
        html5References.addReference(   212, "&Ocirc");
        html5References.addReference(   213, "&Otilde;");
        html5References.addReference(   213, "&Otilde");
        html5References.addReference(   214, "&Ouml;");
        html5References.addReference(   214, "&Ouml");
        html5References.addReference(   215, "&times;");
        html5References.addReference(   215, "&times");
        html5References.addReference(   216, "&Oslash;");
        html5References.addReference(   216, "&Oslash");
        html5References.addReference(   217, "&Ugrave;");
        html5References.addReference(   217, "&Ugrave");
        html5References.addReference(   218, "&Uacute;");
        html5References.addReference(   218, "&Uacute");
        html5References.addReference(   219, "&Ucirc;");
        html5References.addReference(   219, "&Ucirc");
        html5References.addReference(   220, "&Uuml;");
        html5References.addReference(   220, "&Uuml");
        html5References.addReference(   221, "&Yacute;");
        html5References.addReference(   221, "&Yacute");
        html5References.addReference(   222, "&THORN;");
        html5References.addReference(   222, "&THORN");
        html5References.addReference(   223, "&szlig;");
        html5References.addReference(   223, "&szlig");
        html5References.addReference(   224, "&agrave;");
        html5References.addReference(   224, "&agrave");
        html5References.addReference(   225, "&aacute;");
        html5References.addReference(   225, "&aacute");
        html5References.addReference(   226, "&acirc;");
        html5References.addReference(   226, "&acirc");
        html5References.addReference(   227, "&atilde;");
        html5References.addReference(   227, "&atilde");
        html5References.addReference(   228, "&auml;");
        html5References.addReference(   228, "&auml");
        html5References.addReference(   229, "&aring;");
        html5References.addReference(   229, "&aring");
        html5References.addReference(   230, "&aelig;");
        html5References.addReference(   230, "&aelig");
        html5References.addReference(   231, "&ccedil;");
        html5References.addReference(   231, "&ccedil");
        html5References.addReference(   232, "&egrave;");
        html5References.addReference(   232, "&egrave");
        html5References.addReference(   233, "&eacute;");
        html5References.addReference(   233, "&eacute");
        html5References.addReference(   234, "&ecirc;");
        html5References.addReference(   234, "&ecirc");
        html5References.addReference(   235, "&euml;");
        html5References.addReference(   235, "&euml");
        html5References.addReference(   236, "&igrave;");
        html5References.addReference(   236, "&igrave");
        html5References.addReference(   237, "&iacute;");
        html5References.addReference(   237, "&iacute");
        html5References.addReference(   238, "&icirc;");
        html5References.addReference(   238, "&icirc");
        html5References.addReference(   239, "&iuml;");
        html5References.addReference(   239, "&iuml");
        html5References.addReference(   240, "&eth;");
        html5References.addReference(   240, "&eth");
        html5References.addReference(   241, "&ntilde;");
        html5References.addReference(   241, "&ntilde");
        html5References.addReference(   242, "&ograve;");
        html5References.addReference(   242, "&ograve");
        html5References.addReference(   243, "&oacute;");
        html5References.addReference(   243, "&oacute");
        html5References.addReference(   244, "&ocirc;");
        html5References.addReference(   244, "&ocirc");
        html5References.addReference(   245, "&otilde;");
        html5References.addReference(   245, "&otilde");
        html5References.addReference(   246, "&ouml;");
        html5References.addReference(   246, "&ouml");
        html5References.addReference(   247, "&divide;");
        html5References.addReference(   247, "&div;");
        html5References.addReference(   247, "&divide");
        html5References.addReference(   248, "&oslash;");
        html5References.addReference(   248, "&oslash");
        html5References.addReference(   249, "&ugrave;");
        html5References.addReference(   249, "&ugrave");
        html5References.addReference(   250, "&uacute;");
        html5References.addReference(   250, "&uacute");
        html5References.addReference(   251, "&ucirc;");
        html5References.addReference(   251, "&ucirc");
        html5References.addReference(   252, "&uuml;");
        html5References.addReference(   252, "&uuml");
        html5References.addReference(   253, "&yacute;");
        html5References.addReference(   253, "&yacute");
        html5References.addReference(   254, "&thorn;");
        html5References.addReference(   254, "&thorn");
        html5References.addReference(   255, "&yuml;");
        html5References.addReference(   255, "&yuml");
        html5References.addReference(   256, "&Amacr;");
        html5References.addReference(   257, "&amacr;");
        html5References.addReference(   258, "&Abreve;");
        html5References.addReference(   259, "&abreve;");
        html5References.addReference(   260, "&Aogon;");
        html5References.addReference(   261, "&aogon;");
        html5References.addReference(   262, "&Cacute;");
        html5References.addReference(   263, "&cacute;");
        html5References.addReference(   264, "&Ccirc;");
        html5References.addReference(   265, "&ccirc;");
        html5References.addReference(   266, "&Cdot;");
        html5References.addReference(   267, "&cdot;");
        html5References.addReference(   268, "&Ccaron;");
        html5References.addReference(   269, "&ccaron;");
        html5References.addReference(   270, "&Dcaron;");
        html5References.addReference(   271, "&dcaron;");
        html5References.addReference(   272, "&Dstrok;");
        html5References.addReference(   273, "&dstrok;");
        html5References.addReference(   274, "&Emacr;");
        html5References.addReference(   275, "&emacr;");
        html5References.addReference(   278, "&Edot;");
        html5References.addReference(   279, "&edot;");
        html5References.addReference(   280, "&Eogon;");
        html5References.addReference(   281, "&eogon;");
        html5References.addReference(   282, "&Ecaron;");
        html5References.addReference(   283, "&ecaron;");
        html5References.addReference(   284, "&Gcirc;");
        html5References.addReference(   285, "&gcirc;");
        html5References.addReference(   286, "&Gbreve;");
        html5References.addReference(   287, "&gbreve;");
        html5References.addReference(   288, "&Gdot;");
        html5References.addReference(   289, "&gdot;");
        html5References.addReference(   290, "&Gcedil;");
        html5References.addReference(   292, "&Hcirc;");
        html5References.addReference(   293, "&hcirc;");
        html5References.addReference(   294, "&Hstrok;");
        html5References.addReference(   295, "&hstrok;");
        html5References.addReference(   296, "&Itilde;");
        html5References.addReference(   297, "&itilde;");
        html5References.addReference(   298, "&Imacr;");
        html5References.addReference(   299, "&imacr;");
        html5References.addReference(   302, "&Iogon;");
        html5References.addReference(   303, "&iogon;");
        html5References.addReference(   304, "&Idot;");
        html5References.addReference(   305, "&imath;");
        html5References.addReference(   305, "&inodot;");
        html5References.addReference(   306, "&IJlig;");
        html5References.addReference(   307, "&ijlig;");
        html5References.addReference(   308, "&Jcirc;");
        html5References.addReference(   309, "&jcirc;");
        html5References.addReference(   310, "&Kcedil;");
        html5References.addReference(   311, "&kcedil;");
        html5References.addReference(   312, "&kgreen;");
        html5References.addReference(   313, "&Lacute;");
        html5References.addReference(   314, "&lacute;");
        html5References.addReference(   315, "&Lcedil;");
        html5References.addReference(   316, "&lcedil;");
        html5References.addReference(   317, "&Lcaron;");
        html5References.addReference(   318, "&lcaron;");
        html5References.addReference(   319, "&Lmidot;");
        html5References.addReference(   320, "&lmidot;");
        html5References.addReference(   321, "&Lstrok;");
        html5References.addReference(   322, "&lstrok;");
        html5References.addReference(   323, "&Nacute;");
        html5References.addReference(   324, "&nacute;");
        html5References.addReference(   325, "&Ncedil;");
        html5References.addReference(   326, "&ncedil;");
        html5References.addReference(   327, "&Ncaron;");
        html5References.addReference(   328, "&ncaron;");
        html5References.addReference(   329, "&napos;");
        html5References.addReference(   330, "&ENG;");
        html5References.addReference(   331, "&eng;");
        html5References.addReference(   332, "&Omacr;");
        html5References.addReference(   333, "&omacr;");
        html5References.addReference(   336, "&Odblac;");
        html5References.addReference(   337, "&odblac;");
        html5References.addReference(   338, "&OElig;");
        html5References.addReference(   339, "&oelig;");
        html5References.addReference(   340, "&Racute;");
        html5References.addReference(   341, "&racute;");
        html5References.addReference(   342, "&Rcedil;");
        html5References.addReference(   343, "&rcedil;");
        html5References.addReference(   344, "&Rcaron;");
        html5References.addReference(   345, "&rcaron;");
        html5References.addReference(   346, "&Sacute;");
        html5References.addReference(   347, "&sacute;");
        html5References.addReference(   348, "&Scirc;");
        html5References.addReference(   349, "&scirc;");
        html5References.addReference(   350, "&Scedil;");
        html5References.addReference(   351, "&scedil;");
        html5References.addReference(   352, "&Scaron;");
        html5References.addReference(   353, "&scaron;");
        html5References.addReference(   354, "&Tcedil;");
        html5References.addReference(   355, "&tcedil;");
        html5References.addReference(   356, "&Tcaron;");
        html5References.addReference(   357, "&tcaron;");
        html5References.addReference(   358, "&Tstrok;");
        html5References.addReference(   359, "&tstrok;");
        html5References.addReference(   360, "&Utilde;");
        html5References.addReference(   361, "&utilde;");
        html5References.addReference(   362, "&Umacr;");
        html5References.addReference(   363, "&umacr;");
        html5References.addReference(   364, "&Ubreve;");
        html5References.addReference(   365, "&ubreve;");
        html5References.addReference(   366, "&Uring;");
        html5References.addReference(   367, "&uring;");
        html5References.addReference(   368, "&Udblac;");
        html5References.addReference(   369, "&udblac;");
        html5References.addReference(   370, "&Uogon;");
        html5References.addReference(   371, "&uogon;");
        html5References.addReference(   372, "&Wcirc;");
        html5References.addReference(   373, "&wcirc;");
        html5References.addReference(   374, "&Ycirc;");
        html5References.addReference(   375, "&ycirc;");
        html5References.addReference(   376, "&Yuml;");
        html5References.addReference(   377, "&Zacute;");
        html5References.addReference(   378, "&zacute;");
        html5References.addReference(   379, "&Zdot;");
        html5References.addReference(   380, "&zdot;");
        html5References.addReference(   381, "&Zcaron;");
        html5References.addReference(   382, "&zcaron;");
        html5References.addReference(   402, "&fnof;");
        html5References.addReference(   437, "&imped;");
        html5References.addReference(   501, "&gacute;");
        html5References.addReference(   567, "&jmath;");
        html5References.addReference(   710, "&circ;");
        html5References.addReference(   711, "&caron;");
        html5References.addReference(   711, "&Hacek;");
        html5References.addReference(   728, "&breve;");
        html5References.addReference(   728, "&Breve;");
        html5References.addReference(   729, "&dot;");
        html5References.addReference(   729, "&DiacriticalDot;");
        html5References.addReference(   730, "&ring;");
        html5References.addReference(   731, "&ogon;");
        html5References.addReference(   732, "&tilde;");
        html5References.addReference(   732, "&DiacriticalTilde;");
        html5References.addReference(   733, "&dblac;");
        html5References.addReference(   733, "&DiacriticalDoubleAcute;");
        html5References.addReference(   785, "&DownBreve;");
        html5References.addReference(   913, "&Alpha;");
        html5References.addReference(   914, "&Beta;");
        html5References.addReference(   915, "&Gamma;");
        html5References.addReference(   916, "&Delta;");
        html5References.addReference(   917, "&Epsilon;");
        html5References.addReference(   918, "&Zeta;");
        html5References.addReference(   919, "&Eta;");
        html5References.addReference(   920, "&Theta;");
        html5References.addReference(   921, "&Iota;");
        html5References.addReference(   922, "&Kappa;");
        html5References.addReference(   923, "&Lambda;");
        html5References.addReference(   924, "&Mu;");
        html5References.addReference(   925, "&Nu;");
        html5References.addReference(   926, "&Xi;");
        html5References.addReference(   927, "&Omicron;");
        html5References.addReference(   928, "&Pi;");
        html5References.addReference(   929, "&Rho;");
        html5References.addReference(   931, "&Sigma;");
        html5References.addReference(   932, "&Tau;");
        html5References.addReference(   933, "&Upsilon;");
        html5References.addReference(   934, "&Phi;");
        html5References.addReference(   935, "&Chi;");
        html5References.addReference(   936, "&Psi;");
        html5References.addReference(   937, "&Omega;");
        html5References.addReference(   937, "&ohm;");
        html5References.addReference(   945, "&alpha;");
        html5References.addReference(   946, "&beta;");
        html5References.addReference(   947, "&gamma;");
        html5References.addReference(   948, "&delta;");
        html5References.addReference(   949, "&epsilon;");
        html5References.addReference(   949, "&epsi;");
        html5References.addReference(   950, "&zeta;");
        html5References.addReference(   951, "&eta;");
        html5References.addReference(   952, "&theta;");
        html5References.addReference(   953, "&iota;");
        html5References.addReference(   954, "&kappa;");
        html5References.addReference(   955, "&lambda;");
        html5References.addReference(   956, "&mu;");
        html5References.addReference(   957, "&nu;");
        html5References.addReference(   958, "&xi;");
        html5References.addReference(   959, "&omicron;");
        html5References.addReference(   960, "&pi;");
        html5References.addReference(   961, "&rho;");
        html5References.addReference(   962, "&sigmaf;");
        html5References.addReference(   962, "&sigmav;");
        html5References.addReference(   962, "&varsigma;");
        html5References.addReference(   963, "&sigma;");
        html5References.addReference(   964, "&tau;");
        html5References.addReference(   965, "&upsilon;");
        html5References.addReference(   965, "&upsi;");
        html5References.addReference(   966, "&phi;");
        html5References.addReference(   967, "&chi;");
        html5References.addReference(   968, "&psi;");
        html5References.addReference(   969, "&omega;");
        html5References.addReference(   977, "&thetasym;");
        html5References.addReference(   977, "&thetav;");
        html5References.addReference(   977, "&vartheta;");
        html5References.addReference(   978, "&upsih;");
        html5References.addReference(   978, "&Upsi;");
        html5References.addReference(   981, "&phiv;");
        html5References.addReference(   981, "&straightphi;");
        html5References.addReference(   981, "&varphi;");
        html5References.addReference(   982, "&piv;");
        html5References.addReference(   982, "&varpi;");
        html5References.addReference(   988, "&Gammad;");
        html5References.addReference(   989, "&digamma;");
        html5References.addReference(   989, "&gammad;");
        html5References.addReference(  1008, "&kappav;");
        html5References.addReference(  1008, "&varkappa;");
        html5References.addReference(  1009, "&rhov;");
        html5References.addReference(  1009, "&varrho;");
        html5References.addReference(  1013, "&epsiv;");
        html5References.addReference(  1013, "&straightepsilon;");
        html5References.addReference(  1013, "&varepsilon;");
        html5References.addReference(  1014, "&backepsilon;");
        html5References.addReference(  1014, "&bepsi;");
        html5References.addReference(  1025, "&IOcy;");
        html5References.addReference(  1026, "&DJcy;");
        html5References.addReference(  1027, "&GJcy;");
        html5References.addReference(  1028, "&Jukcy;");
        html5References.addReference(  1029, "&DScy;");
        html5References.addReference(  1030, "&Iukcy;");
        html5References.addReference(  1031, "&YIcy;");
        html5References.addReference(  1032, "&Jsercy;");
        html5References.addReference(  1033, "&LJcy;");
        html5References.addReference(  1034, "&NJcy;");
        html5References.addReference(  1035, "&TSHcy;");
        html5References.addReference(  1036, "&KJcy;");
        html5References.addReference(  1038, "&Ubrcy;");
        html5References.addReference(  1039, "&DZcy;");
        html5References.addReference(  1040, "&Acy;");
        html5References.addReference(  1041, "&Bcy;");
        html5References.addReference(  1042, "&Vcy;");
        html5References.addReference(  1043, "&Gcy;");
        html5References.addReference(  1044, "&Dcy;");
        html5References.addReference(  1045, "&IEcy;");
        html5References.addReference(  1046, "&ZHcy;");
        html5References.addReference(  1047, "&Zcy;");
        html5References.addReference(  1048, "&Icy;");
        html5References.addReference(  1049, "&Jcy;");
        html5References.addReference(  1050, "&Kcy;");
        html5References.addReference(  1051, "&Lcy;");
        html5References.addReference(  1052, "&Mcy;");
        html5References.addReference(  1053, "&Ncy;");
        html5References.addReference(  1054, "&Ocy;");
        html5References.addReference(  1055, "&Pcy;");
        html5References.addReference(  1056, "&Rcy;");
        html5References.addReference(  1057, "&Scy;");
        html5References.addReference(  1058, "&Tcy;");
        html5References.addReference(  1059, "&Ucy;");
        html5References.addReference(  1060, "&Fcy;");
        html5References.addReference(  1061, "&KHcy;");
        html5References.addReference(  1062, "&TScy;");
        html5References.addReference(  1063, "&CHcy;");
        html5References.addReference(  1064, "&SHcy;");
        html5References.addReference(  1065, "&SHCHcy;");
        html5References.addReference(  1066, "&HARDcy;");
        html5References.addReference(  1067, "&Ycy;");
        html5References.addReference(  1068, "&SOFTcy;");
        html5References.addReference(  1069, "&Ecy;");
        html5References.addReference(  1070, "&YUcy;");
        html5References.addReference(  1071, "&YAcy;");
        html5References.addReference(  1072, "&acy;");
        html5References.addReference(  1073, "&bcy;");
        html5References.addReference(  1074, "&vcy;");
        html5References.addReference(  1075, "&gcy;");
        html5References.addReference(  1076, "&dcy;");
        html5References.addReference(  1077, "&iecy;");
        html5References.addReference(  1078, "&zhcy;");
        html5References.addReference(  1079, "&zcy;");
        html5References.addReference(  1080, "&icy;");
        html5References.addReference(  1081, "&jcy;");
        html5References.addReference(  1082, "&kcy;");
        html5References.addReference(  1083, "&lcy;");
        html5References.addReference(  1084, "&mcy;");
        html5References.addReference(  1085, "&ncy;");
        html5References.addReference(  1086, "&ocy;");
        html5References.addReference(  1087, "&pcy;");
        html5References.addReference(  1088, "&rcy;");
        html5References.addReference(  1089, "&scy;");
        html5References.addReference(  1090, "&tcy;");
        html5References.addReference(  1091, "&ucy;");
        html5References.addReference(  1092, "&fcy;");
        html5References.addReference(  1093, "&khcy;");
        html5References.addReference(  1094, "&tscy;");
        html5References.addReference(  1095, "&chcy;");
        html5References.addReference(  1096, "&shcy;");
        html5References.addReference(  1097, "&shchcy;");
        html5References.addReference(  1098, "&hardcy;");
        html5References.addReference(  1099, "&ycy;");
        html5References.addReference(  1100, "&softcy;");
        html5References.addReference(  1101, "&ecy;");
        html5References.addReference(  1102, "&yucy;");
        html5References.addReference(  1103, "&yacy;");
        html5References.addReference(  1105, "&iocy;");
        html5References.addReference(  1106, "&djcy;");
        html5References.addReference(  1107, "&gjcy;");
        html5References.addReference(  1108, "&jukcy;");
        html5References.addReference(  1109, "&dscy;");
        html5References.addReference(  1110, "&iukcy;");
        html5References.addReference(  1111, "&yicy;");
        html5References.addReference(  1112, "&jsercy;");
        html5References.addReference(  1113, "&ljcy;");
        html5References.addReference(  1114, "&njcy;");
        html5References.addReference(  1115, "&tshcy;");
        html5References.addReference(  1116, "&kjcy;");
        html5References.addReference(  1118, "&ubrcy;");
        html5References.addReference(  1119, "&dzcy;");
        html5References.addReference(  8194, "&ensp;");
        html5References.addReference(  8195, "&emsp;");
        html5References.addReference(  8196, "&emsp13;");
        html5References.addReference(  8197, "&emsp14;");
        html5References.addReference(  8199, "&numsp;");
        html5References.addReference(  8200, "&puncsp;");
        html5References.addReference(  8201, "&thinsp;");
        html5References.addReference(  8201, "&ThinSpace;");
        html5References.addReference(  8202, "&hairsp;");
        html5References.addReference(  8202, "&VeryThinSpace;");
        html5References.addReference(  8203, "&NegativeMediumSpace;");
        html5References.addReference(  8203, "&NegativeThickSpace;");
        html5References.addReference(  8203, "&NegativeThinSpace;");
        html5References.addReference(  8203, "&NegativeVeryThinSpace;");
        html5References.addReference(  8203, "&ZeroWidthSpace;");
        html5References.addReference(  8204, "&zwnj;");
        html5References.addReference(  8205, "&zwj;");
        html5References.addReference(  8206, "&lrm;");
        html5References.addReference(  8207, "&rlm;");
        html5References.addReference(  8208, "&dash;");
        html5References.addReference(  8208, "&hyphen;");
        html5References.addReference(  8211, "&ndash;");
        html5References.addReference(  8212, "&mdash;");
        html5References.addReference(  8213, "&horbar;");
        html5References.addReference(  8214, "&Verbar;");
        html5References.addReference(  8214, "&Vert;");
        html5References.addReference(  8216, "&lsquo;");
        html5References.addReference(  8216, "&OpenCurlyQuote;");
        html5References.addReference(  8217, "&rsquo;");
        html5References.addReference(  8217, "&rsquor;");
        html5References.addReference(  8217, "&CloseCurlyQuote;");
        html5References.addReference(  8218, "&sbquo;");
        html5References.addReference(  8218, "&lsquor;");
        html5References.addReference(  8220, "&ldquo;");
        html5References.addReference(  8220, "&OpenCurlyDoubleQuote;");
        html5References.addReference(  8221, "&rdquo;");
        html5References.addReference(  8221, "&rdquor;");
        html5References.addReference(  8221, "&CloseCurlyDoubleQuote;");
        html5References.addReference(  8222, "&bdquo;");
        html5References.addReference(  8222, "&ldquor;");
        html5References.addReference(  8224, "&dagger;");
        html5References.addReference(  8225, "&Dagger;");
        html5References.addReference(  8225, "&ddagger;");
        html5References.addReference(  8226, "&bull;");
        html5References.addReference(  8226, "&bullet;");
        html5References.addReference(  8229, "&nldr;");
        html5References.addReference(  8230, "&hellip;");
        html5References.addReference(  8230, "&mldr;");
        html5References.addReference(  8240, "&permil;");
        html5References.addReference(  8241, "&pertenk;");
        html5References.addReference(  8242, "&prime;");
        html5References.addReference(  8243, "&Prime;");
        html5References.addReference(  8244, "&tprime;");
        html5References.addReference(  8245, "&backprime;");
        html5References.addReference(  8245, "&bprime;");
        html5References.addReference(  8249, "&lsaquo;");
        html5References.addReference(  8250, "&rsaquo;");
        html5References.addReference(  8254, "&oline;");
        html5References.addReference(  8254, "&OverBar;");
        html5References.addReference(  8257, "&caret;");
        html5References.addReference(  8259, "&hybull;");
        html5References.addReference(  8260, "&frasl;");
        html5References.addReference(  8271, "&bsemi;");
        html5References.addReference(  8279, "&qprime;");
        html5References.addReference(  8287, "&MediumSpace;");
        html5References.addReference(  8287,  8202, "&ThickSpace;");
        html5References.addReference(  8288, "&NoBreak;");
        html5References.addReference(  8289, "&af;");
        html5References.addReference(  8289, "&ApplyFunction;");
        html5References.addReference(  8290, "&it;");
        html5References.addReference(  8290, "&InvisibleTimes;");
        html5References.addReference(  8291, "&ic;");
        html5References.addReference(  8291, "&InvisibleComma;");
        html5References.addReference(  8364, "&euro;");
        html5References.addReference(  8411, "&tdot;");
        html5References.addReference(  8411, "&TripleDot;");
        html5References.addReference(  8412, "&DotDot;");
        html5References.addReference(  8450, "&complexes;");
        html5References.addReference(  8450, "&Copf;");
        html5References.addReference(  8453, "&incare;");
        html5References.addReference(  8458, "&gscr;");
        html5References.addReference(  8459, "&hamilt;");
        html5References.addReference(  8459, "&HilbertSpace;");
        html5References.addReference(  8459, "&Hscr;");
        html5References.addReference(  8460, "&Hfr;");
        html5References.addReference(  8460, "&Poincareplane;");
        html5References.addReference(  8461, "&quaternions;");
        html5References.addReference(  8461, "&Hopf;");
        html5References.addReference(  8462, "&planckh;");
        html5References.addReference(  8463, "&hbar;");
        html5References.addReference(  8463, "&hslash;");
        html5References.addReference(  8463, "&planck;");
        html5References.addReference(  8463, "&plankv;");
        html5References.addReference(  8464, "&imagline;");
        html5References.addReference(  8464, "&Iscr;");
        html5References.addReference(  8465, "&image;");
        html5References.addReference(  8465, "&imagpart;");
        html5References.addReference(  8465, "&Ifr;");
        html5References.addReference(  8465, "&Im;");
        html5References.addReference(  8466, "&lagran;");
        html5References.addReference(  8466, "&Laplacetrf;");
        html5References.addReference(  8466, "&Lscr;");
        html5References.addReference(  8467, "&ell;");
        html5References.addReference(  8469, "&naturals;");
        html5References.addReference(  8469, "&Nopf;");
        html5References.addReference(  8470, "&numero;");
        html5References.addReference(  8471, "&copysr;");
        html5References.addReference(  8472, "&weierp;");
        html5References.addReference(  8472, "&wp;");
        html5References.addReference(  8473, "&primes;");
        html5References.addReference(  8473, "&Popf;");
        html5References.addReference(  8474, "&rationals;");
        html5References.addReference(  8474, "&Qopf;");
        html5References.addReference(  8475, "&realine;");
        html5References.addReference(  8475, "&Rscr;");
        html5References.addReference(  8476, "&real;");
        html5References.addReference(  8476, "&realpart;");
        html5References.addReference(  8476, "&Re;");
        html5References.addReference(  8476, "&Rfr;");
        html5References.addReference(  8477, "&reals;");
        html5References.addReference(  8477, "&Ropf;");
        html5References.addReference(  8478, "&rx;");
        html5References.addReference(  8482, "&trade;");
        html5References.addReference(  8482, "&TRADE;");
        html5References.addReference(  8484, "&integers;");
        html5References.addReference(  8484, "&Zopf;");
        html5References.addReference(  8487, "&mho;");
        html5References.addReference(  8488, "&zeetrf;");
        html5References.addReference(  8488, "&Zfr;");
        html5References.addReference(  8489, "&iiota;");
        html5References.addReference(  8492, "&bernou;");
        html5References.addReference(  8492, "&Bernoullis;");
        html5References.addReference(  8492, "&Bscr;");
        html5References.addReference(  8493, "&Cayleys;");
        html5References.addReference(  8493, "&Cfr;");
        html5References.addReference(  8495, "&escr;");
        html5References.addReference(  8496, "&expectation;");
        html5References.addReference(  8496, "&Escr;");
        html5References.addReference(  8497, "&Fouriertrf;");
        html5References.addReference(  8497, "&Fscr;");
        html5References.addReference(  8499, "&phmmat;");
        html5References.addReference(  8499, "&Mellintrf;");
        html5References.addReference(  8499, "&Mscr;");
        html5References.addReference(  8500, "&order;");
        html5References.addReference(  8500, "&orderof;");
        html5References.addReference(  8500, "&oscr;");
        html5References.addReference(  8501, "&alefsym;");
        html5References.addReference(  8501, "&aleph;");
        html5References.addReference(  8502, "&beth;");
        html5References.addReference(  8503, "&gimel;");
        html5References.addReference(  8504, "&daleth;");
        html5References.addReference(  8517, "&CapitalDifferentialD;");
        html5References.addReference(  8517, "&DD;");
        html5References.addReference(  8518, "&dd;");
        html5References.addReference(  8518, "&DifferentialD;");
        html5References.addReference(  8519, "&ee;");
        html5References.addReference(  8519, "&exponentiale;");
        html5References.addReference(  8519, "&ExponentialE;");
        html5References.addReference(  8520, "&ii;");
        html5References.addReference(  8520, "&ImaginaryI;");
        html5References.addReference(  8531, "&frac13;");
        html5References.addReference(  8532, "&frac23;");
        html5References.addReference(  8533, "&frac15;");
        html5References.addReference(  8534, "&frac25;");
        html5References.addReference(  8535, "&frac35;");
        html5References.addReference(  8536, "&frac45;");
        html5References.addReference(  8537, "&frac16;");
        html5References.addReference(  8538, "&frac56;");
        html5References.addReference(  8539, "&frac18;");
        html5References.addReference(  8540, "&frac38;");
        html5References.addReference(  8541, "&frac58;");
        html5References.addReference(  8542, "&frac78;");
        html5References.addReference(  8592, "&larr;");
        html5References.addReference(  8592, "&leftarrow;");
        html5References.addReference(  8592, "&slarr;");
        html5References.addReference(  8592, "&LeftArrow;");
        html5References.addReference(  8592, "&ShortLeftArrow;");
        html5References.addReference(  8593, "&uarr;");
        html5References.addReference(  8593, "&uparrow;");
        html5References.addReference(  8593, "&ShortUpArrow;");
        html5References.addReference(  8593, "&UpArrow;");
        html5References.addReference(  8594, "&rarr;");
        html5References.addReference(  8594, "&rightarrow;");
        html5References.addReference(  8594, "&srarr;");
        html5References.addReference(  8594, "&RightArrow;");
        html5References.addReference(  8594, "&ShortRightArrow;");
        html5References.addReference(  8595, "&darr;");
        html5References.addReference(  8595, "&downarrow;");
        html5References.addReference(  8595, "&DownArrow;");
        html5References.addReference(  8595, "&ShortDownArrow;");
        html5References.addReference(  8596, "&harr;");
        html5References.addReference(  8596, "&leftrightarrow;");
        html5References.addReference(  8596, "&LeftRightArrow;");
        html5References.addReference(  8597, "&updownarrow;");
        html5References.addReference(  8597, "&varr;");
        html5References.addReference(  8597, "&UpDownArrow;");
        html5References.addReference(  8598, "&nwarr;");
        html5References.addReference(  8598, "&nwarrow;");
        html5References.addReference(  8598, "&UpperLeftArrow;");
        html5References.addReference(  8599, "&nearr;");
        html5References.addReference(  8599, "&nearrow;");
        html5References.addReference(  8599, "&UpperRightArrow;");
        html5References.addReference(  8600, "&searr;");
        html5References.addReference(  8600, "&searrow;");
        html5References.addReference(  8600, "&LowerRightArrow;");
        html5References.addReference(  8601, "&swarr;");
        html5References.addReference(  8601, "&swarrow;");
        html5References.addReference(  8601, "&LowerLeftArrow;");
        html5References.addReference(  8602, "&nlarr;");
        html5References.addReference(  8602, "&nleftarrow;");
        html5References.addReference(  8603, "&nrarr;");
        html5References.addReference(  8603, "&nrightarrow;");
        html5References.addReference(  8605, "&rarrw;");
        html5References.addReference(  8605, "&rightsquigarrow;");
        html5References.addReference(  8605,   824, "&nrarrw;");
        html5References.addReference(  8606, "&twoheadleftarrow;");
        html5References.addReference(  8606, "&Larr;");
        html5References.addReference(  8607, "&Uarr;");
        html5References.addReference(  8608, "&twoheadrightarrow;");
        html5References.addReference(  8608, "&Rarr;");
        html5References.addReference(  8609, "&Darr;");
        html5References.addReference(  8610, "&larrtl;");
        html5References.addReference(  8610, "&leftarrowtail;");
        html5References.addReference(  8611, "&rarrtl;");
        html5References.addReference(  8611, "&rightarrowtail;");
        html5References.addReference(  8612, "&mapstoleft;");
        html5References.addReference(  8612, "&LeftTeeArrow;");
        html5References.addReference(  8613, "&mapstoup;");
        html5References.addReference(  8613, "&UpTeeArrow;");
        html5References.addReference(  8614, "&map;");
        html5References.addReference(  8614, "&mapsto;");
        html5References.addReference(  8614, "&RightTeeArrow;");
        html5References.addReference(  8615, "&mapstodown;");
        html5References.addReference(  8615, "&DownTeeArrow;");
        html5References.addReference(  8617, "&hookleftarrow;");
        html5References.addReference(  8617, "&larrhk;");
        html5References.addReference(  8618, "&hookrightarrow;");
        html5References.addReference(  8618, "&rarrhk;");
        html5References.addReference(  8619, "&larrlp;");
        html5References.addReference(  8619, "&looparrowleft;");
        html5References.addReference(  8620, "&looparrowright;");
        html5References.addReference(  8620, "&rarrlp;");
        html5References.addReference(  8621, "&harrw;");
        html5References.addReference(  8621, "&leftrightsquigarrow;");
        html5References.addReference(  8622, "&nharr;");
        html5References.addReference(  8622, "&nleftrightarrow;");
        html5References.addReference(  8624, "&lsh;");
        html5References.addReference(  8624, "&Lsh;");
        html5References.addReference(  8625, "&rsh;");
        html5References.addReference(  8625, "&Rsh;");
        html5References.addReference(  8626, "&ldsh;");
        html5References.addReference(  8627, "&rdsh;");
        html5References.addReference(  8629, "&crarr;");
        html5References.addReference(  8630, "&cularr;");
        html5References.addReference(  8630, "&curvearrowleft;");
        html5References.addReference(  8631, "&curarr;");
        html5References.addReference(  8631, "&curvearrowright;");
        html5References.addReference(  8634, "&circlearrowleft;");
        html5References.addReference(  8634, "&olarr;");
        html5References.addReference(  8635, "&circlearrowright;");
        html5References.addReference(  8635, "&orarr;");
        html5References.addReference(  8636, "&leftharpoonup;");
        html5References.addReference(  8636, "&lharu;");
        html5References.addReference(  8636, "&LeftVector;");
        html5References.addReference(  8637, "&leftharpoondown;");
        html5References.addReference(  8637, "&lhard;");
        html5References.addReference(  8637, "&DownLeftVector;");
        html5References.addReference(  8638, "&uharr;");
        html5References.addReference(  8638, "&upharpoonright;");
        html5References.addReference(  8638, "&RightUpVector;");
        html5References.addReference(  8639, "&uharl;");
        html5References.addReference(  8639, "&upharpoonleft;");
        html5References.addReference(  8639, "&LeftUpVector;");
        html5References.addReference(  8640, "&rharu;");
        html5References.addReference(  8640, "&rightharpoonup;");
        html5References.addReference(  8640, "&RightVector;");
        html5References.addReference(  8641, "&rhard;");
        html5References.addReference(  8641, "&rightharpoondown;");
        html5References.addReference(  8641, "&DownRightVector;");
        html5References.addReference(  8642, "&dharr;");
        html5References.addReference(  8642, "&downharpoonright;");
        html5References.addReference(  8642, "&RightDownVector;");
        html5References.addReference(  8643, "&dharl;");
        html5References.addReference(  8643, "&downharpoonleft;");
        html5References.addReference(  8643, "&LeftDownVector;");
        html5References.addReference(  8644, "&rightleftarrows;");
        html5References.addReference(  8644, "&rlarr;");
        html5References.addReference(  8644, "&RightArrowLeftArrow;");
        html5References.addReference(  8645, "&udarr;");
        html5References.addReference(  8645, "&UpArrowDownArrow;");
        html5References.addReference(  8646, "&leftrightarrows;");
        html5References.addReference(  8646, "&lrarr;");
        html5References.addReference(  8646, "&LeftArrowRightArrow;");
        html5References.addReference(  8647, "&leftleftarrows;");
        html5References.addReference(  8647, "&llarr;");
        html5References.addReference(  8648, "&upuparrows;");
        html5References.addReference(  8648, "&uuarr;");
        html5References.addReference(  8649, "&rightrightarrows;");
        html5References.addReference(  8649, "&rrarr;");
        html5References.addReference(  8650, "&ddarr;");
        html5References.addReference(  8650, "&downdownarrows;");
        html5References.addReference(  8651, "&leftrightharpoons;");
        html5References.addReference(  8651, "&lrhar;");
        html5References.addReference(  8651, "&ReverseEquilibrium;");
        html5References.addReference(  8652, "&rightleftharpoons;");
        html5References.addReference(  8652, "&rlhar;");
        html5References.addReference(  8652, "&Equilibrium;");
        html5References.addReference(  8653, "&nLeftarrow;");
        html5References.addReference(  8653, "&nlArr;");
        html5References.addReference(  8654, "&nLeftrightarrow;");
        html5References.addReference(  8654, "&nhArr;");
        html5References.addReference(  8655, "&nRightarrow;");
        html5References.addReference(  8655, "&nrArr;");
        html5References.addReference(  8656, "&lArr;");
        html5References.addReference(  8656, "&DoubleLeftArrow;");
        html5References.addReference(  8656, "&Leftarrow;");
        html5References.addReference(  8657, "&uArr;");
        html5References.addReference(  8657, "&DoubleUpArrow;");
        html5References.addReference(  8657, "&Uparrow;");
        html5References.addReference(  8658, "&rArr;");
        html5References.addReference(  8658, "&DoubleRightArrow;");
        html5References.addReference(  8658, "&Implies;");
        html5References.addReference(  8658, "&Rightarrow;");
        html5References.addReference(  8659, "&dArr;");
        html5References.addReference(  8659, "&DoubleDownArrow;");
        html5References.addReference(  8659, "&Downarrow;");
        html5References.addReference(  8660, "&hArr;");
        html5References.addReference(  8660, "&iff;");
        html5References.addReference(  8660, "&DoubleLeftRightArrow;");
        html5References.addReference(  8660, "&Leftrightarrow;");
        html5References.addReference(  8661, "&vArr;");
        html5References.addReference(  8661, "&DoubleUpDownArrow;");
        html5References.addReference(  8661, "&Updownarrow;");
        html5References.addReference(  8662, "&nwArr;");
        html5References.addReference(  8663, "&neArr;");
        html5References.addReference(  8664, "&seArr;");
        html5References.addReference(  8665, "&swArr;");
        html5References.addReference(  8666, "&lAarr;");
        html5References.addReference(  8666, "&Lleftarrow;");
        html5References.addReference(  8667, "&rAarr;");
        html5References.addReference(  8667, "&Rrightarrow;");
        html5References.addReference(  8669, "&zigrarr;");
        html5References.addReference(  8676, "&larrb;");
        html5References.addReference(  8676, "&LeftArrowBar;");
        html5References.addReference(  8677, "&rarrb;");
        html5References.addReference(  8677, "&RightArrowBar;");
        html5References.addReference(  8693, "&duarr;");
        html5References.addReference(  8693, "&DownArrowUpArrow;");
        html5References.addReference(  8701, "&loarr;");
        html5References.addReference(  8702, "&roarr;");
        html5References.addReference(  8703, "&hoarr;");
        html5References.addReference(  8704, "&forall;");
        html5References.addReference(  8704, "&ForAll;");
        html5References.addReference(  8705, "&comp;");
        html5References.addReference(  8705, "&complement;");
        html5References.addReference(  8706, "&part;");
        html5References.addReference(  8706, "&PartialD;");
        html5References.addReference(  8706,   824, "&npart;");
        html5References.addReference(  8707, "&exist;");
        html5References.addReference(  8707, "&Exists;");
        html5References.addReference(  8708, "&nexist;");
        html5References.addReference(  8708, "&nexists;");
        html5References.addReference(  8708, "&NotExists;");
        html5References.addReference(  8709, "&empty;");
        html5References.addReference(  8709, "&emptyset;");
        html5References.addReference(  8709, "&emptyv;");
        html5References.addReference(  8709, "&varnothing;");
        html5References.addReference(  8711, "&nabla;");
        html5References.addReference(  8711, "&Del;");
        html5References.addReference(  8712, "&isin;");
        html5References.addReference(  8712, "&in;");
        html5References.addReference(  8712, "&isinv;");
        html5References.addReference(  8712, "&Element;");
        html5References.addReference(  8713, "&notin;");
        html5References.addReference(  8713, "&notinva;");
        html5References.addReference(  8713, "&NotElement;");
        html5References.addReference(  8715, "&ni;");
        html5References.addReference(  8715, "&niv;");
        html5References.addReference(  8715, "&ReverseElement;");
        html5References.addReference(  8715, "&SuchThat;");
        html5References.addReference(  8716, "&notni;");
        html5References.addReference(  8716, "&notniva;");
        html5References.addReference(  8716, "&NotReverseElement;");
        html5References.addReference(  8719, "&prod;");
        html5References.addReference(  8719, "&Product;");
        html5References.addReference(  8720, "&coprod;");
        html5References.addReference(  8720, "&Coproduct;");
        html5References.addReference(  8721, "&sum;");
        html5References.addReference(  8721, "&Sum;");
        html5References.addReference(  8722, "&minus;");
        html5References.addReference(  8723, "&mnplus;");
        html5References.addReference(  8723, "&mp;");
        html5References.addReference(  8723, "&MinusPlus;");
        html5References.addReference(  8724, "&dotplus;");
        html5References.addReference(  8724, "&plusdo;");
        html5References.addReference(  8726, "&setminus;");
        html5References.addReference(  8726, "&setmn;");
        html5References.addReference(  8726, "&smallsetminus;");
        html5References.addReference(  8726, "&ssetmn;");
        html5References.addReference(  8726, "&Backslash;");
        html5References.addReference(  8727, "&lowast;");
        html5References.addReference(  8728, "&compfn;");
        html5References.addReference(  8728, "&SmallCircle;");
        html5References.addReference(  8730, "&radic;");
        html5References.addReference(  8730, "&Sqrt;");
        html5References.addReference(  8733, "&prop;");
        html5References.addReference(  8733, "&propto;");
        html5References.addReference(  8733, "&varpropto;");
        html5References.addReference(  8733, "&vprop;");
        html5References.addReference(  8733, "&Proportional;");
        html5References.addReference(  8734, "&infin;");
        html5References.addReference(  8735, "&angrt;");
        html5References.addReference(  8736, "&ang;");
        html5References.addReference(  8736, "&angle;");
        html5References.addReference(  8736,  8402, "&nang;");
        html5References.addReference(  8737, "&angmsd;");
        html5References.addReference(  8737, "&measuredangle;");
        html5References.addReference(  8738, "&angsph;");
        html5References.addReference(  8739, "&mid;");
        html5References.addReference(  8739, "&shortmid;");
        html5References.addReference(  8739, "&smid;");
        html5References.addReference(  8739, "&VerticalBar;");
        html5References.addReference(  8740, "&nmid;");
        html5References.addReference(  8740, "&nshortmid;");
        html5References.addReference(  8740, "&nsmid;");
        html5References.addReference(  8740, "&NotVerticalBar;");
        html5References.addReference(  8741, "&par;");
        html5References.addReference(  8741, "&parallel;");
        html5References.addReference(  8741, "&shortparallel;");
        html5References.addReference(  8741, "&spar;");
        html5References.addReference(  8741, "&DoubleVerticalBar;");
        html5References.addReference(  8742, "&npar;");
        html5References.addReference(  8742, "&nparallel;");
        html5References.addReference(  8742, "&nshortparallel;");
        html5References.addReference(  8742, "&nspar;");
        html5References.addReference(  8742, "&NotDoubleVerticalBar;");
        html5References.addReference(  8743, "&and;");
        html5References.addReference(  8743, "&wedge;");
        html5References.addReference(  8744, "&or;");
        html5References.addReference(  8744, "&vee;");
        html5References.addReference(  8745, "&cap;");
        html5References.addReference(  8745, 65024, "&caps;");
        html5References.addReference(  8746, "&cup;");
        html5References.addReference(  8746, 65024, "&cups;");
        html5References.addReference(  8747, "&int;");
        html5References.addReference(  8747, "&Integral;");
        html5References.addReference(  8748, "&Int;");
        html5References.addReference(  8749, "&iiint;");
        html5References.addReference(  8749, "&tint;");
        html5References.addReference(  8750, "&conint;");
        html5References.addReference(  8750, "&oint;");
        html5References.addReference(  8750, "&ContourIntegral;");
        html5References.addReference(  8751, "&Conint;");
        html5References.addReference(  8751, "&DoubleContourIntegral;");
        html5References.addReference(  8752, "&Cconint;");
        html5References.addReference(  8753, "&cwint;");
        html5References.addReference(  8754, "&cwconint;");
        html5References.addReference(  8754, "&ClockwiseContourIntegral;");
        html5References.addReference(  8755, "&awconint;");
        html5References.addReference(  8755, "&CounterClockwiseContourIntegral;");
        html5References.addReference(  8756, "&there4;");
        html5References.addReference(  8756, "&therefore;");
        html5References.addReference(  8756, "&Therefore;");
        html5References.addReference(  8757, "&becaus;");
        html5References.addReference(  8757, "&because;");
        html5References.addReference(  8757, "&Because;");
        html5References.addReference(  8758, "&ratio;");
        html5References.addReference(  8759, "&Colon;");
        html5References.addReference(  8759, "&Proportion;");
        html5References.addReference(  8760, "&dotminus;");
        html5References.addReference(  8760, "&minusd;");
        html5References.addReference(  8762, "&mDDot;");
        html5References.addReference(  8763, "&homtht;");
        html5References.addReference(  8764, "&sim;");
        html5References.addReference(  8764, "&thicksim;");
        html5References.addReference(  8764, "&thksim;");
        html5References.addReference(  8764, "&Tilde;");
        html5References.addReference(  8764,  8402, "&nvsim;");
        html5References.addReference(  8765, "&backsim;");
        html5References.addReference(  8765, "&bsim;");
        html5References.addReference(  8765,   817, "&race;");
        html5References.addReference(  8766, "&ac;");
        html5References.addReference(  8766, "&mstpos;");
        html5References.addReference(  8766,   819, "&acE;");
        html5References.addReference(  8767, "&acd;");
        html5References.addReference(  8768, "&wr;");
        html5References.addReference(  8768, "&wreath;");
        html5References.addReference(  8768, "&VerticalTilde;");
        html5References.addReference(  8769, "&nsim;");
        html5References.addReference(  8769, "&NotTilde;");
        html5References.addReference(  8770, "&eqsim;");
        html5References.addReference(  8770, "&esim;");
        html5References.addReference(  8770, "&EqualTilde;");
        html5References.addReference(  8770,   824, "&nesim;");
        html5References.addReference(  8770,   824, "&NotEqualTilde;");
        html5References.addReference(  8771, "&sime;");
        html5References.addReference(  8771, "&simeq;");
        html5References.addReference(  8771, "&TildeEqual;");
        html5References.addReference(  8772, "&nsime;");
        html5References.addReference(  8772, "&nsimeq;");
        html5References.addReference(  8772, "&NotTildeEqual;");
        html5References.addReference(  8773, "&cong;");
        html5References.addReference(  8773, "&TildeFullEqual;");
        html5References.addReference(  8774, "&simne;");
        html5References.addReference(  8775, "&ncong;");
        html5References.addReference(  8775, "&NotTildeFullEqual;");
        html5References.addReference(  8776, "&asymp;");
        html5References.addReference(  8776, "&ap;");
        html5References.addReference(  8776, "&approx;");
        html5References.addReference(  8776, "&thickapprox;");
        html5References.addReference(  8776, "&thkap;");
        html5References.addReference(  8776, "&TildeTilde;");
        html5References.addReference(  8777, "&nap;");
        html5References.addReference(  8777, "&napprox;");
        html5References.addReference(  8777, "&NotTildeTilde;");
        html5References.addReference(  8778, "&ape;");
        html5References.addReference(  8778, "&approxeq;");
        html5References.addReference(  8779, "&apid;");
        html5References.addReference(  8779,   824, "&napid;");
        html5References.addReference(  8780, "&backcong;");
        html5References.addReference(  8780, "&bcong;");
        html5References.addReference(  8781, "&asympeq;");
        html5References.addReference(  8781, "&CupCap;");
        html5References.addReference(  8781,  8402, "&nvap;");
        html5References.addReference(  8782, "&bump;");
        html5References.addReference(  8782, "&Bumpeq;");
        html5References.addReference(  8782, "&HumpDownHump;");
        html5References.addReference(  8782,   824, "&nbump;");
        html5References.addReference(  8782,   824, "&NotHumpDownHump;");
        html5References.addReference(  8783, "&bumpe;");
        html5References.addReference(  8783, "&bumpeq;");
        html5References.addReference(  8783, "&HumpEqual;");
        html5References.addReference(  8783,   824, "&nbumpe;");
        html5References.addReference(  8783,   824, "&NotHumpEqual;");
        html5References.addReference(  8784, "&doteq;");
        html5References.addReference(  8784, "&esdot;");
        html5References.addReference(  8784, "&DotEqual;");
        html5References.addReference(  8784,   824, "&nedot;");
        html5References.addReference(  8785, "&doteqdot;");
        html5References.addReference(  8785, "&eDot;");
        html5References.addReference(  8786, "&efDot;");
        html5References.addReference(  8786, "&fallingdotseq;");
        html5References.addReference(  8787, "&erDot;");
        html5References.addReference(  8787, "&risingdotseq;");
        html5References.addReference(  8788, "&colone;");
        html5References.addReference(  8788, "&coloneq;");
        html5References.addReference(  8788, "&Assign;");
        html5References.addReference(  8789, "&ecolon;");
        html5References.addReference(  8789, "&eqcolon;");
        html5References.addReference(  8790, "&ecir;");
        html5References.addReference(  8790, "&eqcirc;");
        html5References.addReference(  8791, "&circeq;");
        html5References.addReference(  8791, "&cire;");
        html5References.addReference(  8793, "&wedgeq;");
        html5References.addReference(  8794, "&veeeq;");
        html5References.addReference(  8796, "&triangleq;");
        html5References.addReference(  8796, "&trie;");
        html5References.addReference(  8799, "&equest;");
        html5References.addReference(  8799, "&questeq;");
        html5References.addReference(  8800, "&ne;");
        html5References.addReference(  8800, "&NotEqual;");
        html5References.addReference(  8801, "&equiv;");
        html5References.addReference(  8801, "&Congruent;");
        html5References.addReference(  8801,  8421, "&bnequiv;");
        html5References.addReference(  8802, "&nequiv;");
        html5References.addReference(  8802, "&NotCongruent;");
        html5References.addReference(  8804, "&le;");
        html5References.addReference(  8804, "&leq;");
        html5References.addReference(  8804,  8402, "&nvle;");
        html5References.addReference(  8805, "&ge;");
        html5References.addReference(  8805, "&geq;");
        html5References.addReference(  8805, "&GreaterEqual;");
        html5References.addReference(  8805,  8402, "&nvge;");
        html5References.addReference(  8806, "&lE;");
        html5References.addReference(  8806, "&leqq;");
        html5References.addReference(  8806, "&LessFullEqual;");
        html5References.addReference(  8806,   824, "&nlE;");
        html5References.addReference(  8806,   824, "&nleqq;");
        html5References.addReference(  8807, "&gE;");
        html5References.addReference(  8807, "&geqq;");
        html5References.addReference(  8807, "&GreaterFullEqual;");
        html5References.addReference(  8807,   824, "&ngE;");
        html5References.addReference(  8807,   824, "&ngeqq;");
        html5References.addReference(  8807,   824, "&NotGreaterFullEqual;");
        html5References.addReference(  8808, "&lnE;");
        html5References.addReference(  8808, "&lneqq;");
        html5References.addReference(  8808, 65024, "&lvertneqq;");
        html5References.addReference(  8808, 65024, "&lvnE;");
        html5References.addReference(  8809, "&gnE;");
        html5References.addReference(  8809, "&gneqq;");
        html5References.addReference(  8809, 65024, "&gvertneqq;");
        html5References.addReference(  8809, 65024, "&gvnE;");
        html5References.addReference(  8810, "&ll;");
        html5References.addReference(  8810, "&Lt;");
        html5References.addReference(  8810, "&NestedLessLess;");
        html5References.addReference(  8810,   824, "&nLtv;");
        html5References.addReference(  8810,   824, "&NotLessLess;");
        html5References.addReference(  8810,  8402, "&nLt;");
        html5References.addReference(  8811, "&gg;");
        html5References.addReference(  8811, "&Gt;");
        html5References.addReference(  8811, "&NestedGreaterGreater;");
        html5References.addReference(  8811,   824, "&nGtv;");
        html5References.addReference(  8811,   824, "&NotGreaterGreater;");
        html5References.addReference(  8811,  8402, "&nGt;");
        html5References.addReference(  8812, "&between;");
        html5References.addReference(  8812, "&twixt;");
        html5References.addReference(  8813, "&NotCupCap;");
        html5References.addReference(  8814, "&nless;");
        html5References.addReference(  8814, "&nlt;");
        html5References.addReference(  8814, "&NotLess;");
        html5References.addReference(  8815, "&ngt;");
        html5References.addReference(  8815, "&ngtr;");
        html5References.addReference(  8815, "&NotGreater;");
        html5References.addReference(  8816, "&nle;");
        html5References.addReference(  8816, "&nleq;");
        html5References.addReference(  8816, "&NotLessEqual;");
        html5References.addReference(  8817, "&nge;");
        html5References.addReference(  8817, "&ngeq;");
        html5References.addReference(  8817, "&NotGreaterEqual;");
        html5References.addReference(  8818, "&lesssim;");
        html5References.addReference(  8818, "&lsim;");
        html5References.addReference(  8818, "&LessTilde;");
        html5References.addReference(  8819, "&gsim;");
        html5References.addReference(  8819, "&gtrsim;");
        html5References.addReference(  8819, "&GreaterTilde;");
        html5References.addReference(  8820, "&nlsim;");
        html5References.addReference(  8820, "&NotLessTilde;");
        html5References.addReference(  8821, "&ngsim;");
        html5References.addReference(  8821, "&NotGreaterTilde;");
        html5References.addReference(  8822, "&lessgtr;");
        html5References.addReference(  8822, "&lg;");
        html5References.addReference(  8822, "&LessGreater;");
        html5References.addReference(  8823, "&gl;");
        html5References.addReference(  8823, "&gtrless;");
        html5References.addReference(  8823, "&GreaterLess;");
        html5References.addReference(  8824, "&ntlg;");
        html5References.addReference(  8824, "&NotLessGreater;");
        html5References.addReference(  8825, "&ntgl;");
        html5References.addReference(  8825, "&NotGreaterLess;");
        html5References.addReference(  8826, "&pr;");
        html5References.addReference(  8826, "&prec;");
        html5References.addReference(  8826, "&Precedes;");
        html5References.addReference(  8827, "&sc;");
        html5References.addReference(  8827, "&succ;");
        html5References.addReference(  8827, "&Succeeds;");
        html5References.addReference(  8828, "&prcue;");
        html5References.addReference(  8828, "&preccurlyeq;");
        html5References.addReference(  8828, "&PrecedesSlantEqual;");
        html5References.addReference(  8829, "&sccue;");
        html5References.addReference(  8829, "&succcurlyeq;");
        html5References.addReference(  8829, "&SucceedsSlantEqual;");
        html5References.addReference(  8830, "&precsim;");
        html5References.addReference(  8830, "&prsim;");
        html5References.addReference(  8830, "&PrecedesTilde;");
        html5References.addReference(  8831, "&scsim;");
        html5References.addReference(  8831, "&succsim;");
        html5References.addReference(  8831, "&SucceedsTilde;");
        html5References.addReference(  8831,   824, "&NotSucceedsTilde;");
        html5References.addReference(  8832, "&npr;");
        html5References.addReference(  8832, "&nprec;");
        html5References.addReference(  8832, "&NotPrecedes;");
        html5References.addReference(  8833, "&nsc;");
        html5References.addReference(  8833, "&nsucc;");
        html5References.addReference(  8833, "&NotSucceeds;");
        html5References.addReference(  8834, "&sub;");
        html5References.addReference(  8834, "&subset;");
        html5References.addReference(  8834,  8402, "&nsubset;");
        html5References.addReference(  8834,  8402, "&vnsub;");
        html5References.addReference(  8834,  8402, "&NotSubset;");
        html5References.addReference(  8835, "&sup;");
        html5References.addReference(  8835, "&supset;");
        html5References.addReference(  8835, "&Superset;");
        html5References.addReference(  8835,  8402, "&nsupset;");
        html5References.addReference(  8835,  8402, "&vnsup;");
        html5References.addReference(  8835,  8402, "&NotSuperset;");
        html5References.addReference(  8836, "&nsub;");
        html5References.addReference(  8837, "&nsup;");
        html5References.addReference(  8838, "&sube;");
        html5References.addReference(  8838, "&subseteq;");
        html5References.addReference(  8838, "&SubsetEqual;");
        html5References.addReference(  8839, "&supe;");
        html5References.addReference(  8839, "&supseteq;");
        html5References.addReference(  8839, "&SupersetEqual;");
        html5References.addReference(  8840, "&nsube;");
        html5References.addReference(  8840, "&nsubseteq;");
        html5References.addReference(  8840, "&NotSubsetEqual;");
        html5References.addReference(  8841, "&nsupe;");
        html5References.addReference(  8841, "&nsupseteq;");
        html5References.addReference(  8841, "&NotSupersetEqual;");
        html5References.addReference(  8842, "&subne;");
        html5References.addReference(  8842, "&subsetneq;");
        html5References.addReference(  8842, 65024, "&varsubsetneq;");
        html5References.addReference(  8842, 65024, "&vsubne;");
        html5References.addReference(  8843, "&supne;");
        html5References.addReference(  8843, "&supsetneq;");
        html5References.addReference(  8843, 65024, "&varsupsetneq;");
        html5References.addReference(  8843, 65024, "&vsupne;");
        html5References.addReference(  8845, "&cupdot;");
        html5References.addReference(  8846, "&uplus;");
        html5References.addReference(  8846, "&UnionPlus;");
        html5References.addReference(  8847, "&sqsub;");
        html5References.addReference(  8847, "&sqsubset;");
        html5References.addReference(  8847, "&SquareSubset;");
        html5References.addReference(  8847,   824, "&NotSquareSubset;");
        html5References.addReference(  8848, "&sqsup;");
        html5References.addReference(  8848, "&sqsupset;");
        html5References.addReference(  8848, "&SquareSuperset;");
        html5References.addReference(  8848,   824, "&NotSquareSuperset;");
        html5References.addReference(  8849, "&sqsube;");
        html5References.addReference(  8849, "&sqsubseteq;");
        html5References.addReference(  8849, "&SquareSubsetEqual;");
        html5References.addReference(  8850, "&sqsupe;");
        html5References.addReference(  8850, "&sqsupseteq;");
        html5References.addReference(  8850, "&SquareSupersetEqual;");
        html5References.addReference(  8851, "&sqcap;");
        html5References.addReference(  8851, "&SquareIntersection;");
        html5References.addReference(  8851, 65024, "&sqcaps;");
        html5References.addReference(  8852, "&sqcup;");
        html5References.addReference(  8852, "&SquareUnion;");
        html5References.addReference(  8852, 65024, "&sqcups;");
        html5References.addReference(  8853, "&oplus;");
        html5References.addReference(  8853, "&CirclePlus;");
        html5References.addReference(  8854, "&ominus;");
        html5References.addReference(  8854, "&CircleMinus;");
        html5References.addReference(  8855, "&otimes;");
        html5References.addReference(  8855, "&CircleTimes;");
        html5References.addReference(  8856, "&osol;");
        html5References.addReference(  8857, "&odot;");
        html5References.addReference(  8857, "&CircleDot;");
        html5References.addReference(  8858, "&circledcirc;");
        html5References.addReference(  8858, "&ocir;");
        html5References.addReference(  8859, "&circledast;");
        html5References.addReference(  8859, "&oast;");
        html5References.addReference(  8861, "&circleddash;");
        html5References.addReference(  8861, "&odash;");
        html5References.addReference(  8862, "&boxplus;");
        html5References.addReference(  8862, "&plusb;");
        html5References.addReference(  8863, "&boxminus;");
        html5References.addReference(  8863, "&minusb;");
        html5References.addReference(  8864, "&boxtimes;");
        html5References.addReference(  8864, "&timesb;");
        html5References.addReference(  8865, "&dotsquare;");
        html5References.addReference(  8865, "&sdotb;");
        html5References.addReference(  8866, "&vdash;");
        html5References.addReference(  8866, "&RightTee;");
        html5References.addReference(  8867, "&dashv;");
        html5References.addReference(  8867, "&LeftTee;");
        html5References.addReference(  8868, "&top;");
        html5References.addReference(  8868, "&DownTee;");
        html5References.addReference(  8869, "&perp;");
        html5References.addReference(  8869, "&bot;");
        html5References.addReference(  8869, "&bottom;");
        html5References.addReference(  8869, "&UpTee;");
        html5References.addReference(  8871, "&models;");
        html5References.addReference(  8872, "&vDash;");
        html5References.addReference(  8872, "&DoubleRightTee;");
        html5References.addReference(  8873, "&Vdash;");
        html5References.addReference(  8874, "&Vvdash;");
        html5References.addReference(  8875, "&VDash;");
        html5References.addReference(  8876, "&nvdash;");
        html5References.addReference(  8877, "&nvDash;");
        html5References.addReference(  8878, "&nVdash;");
        html5References.addReference(  8879, "&nVDash;");
        html5References.addReference(  8880, "&prurel;");
        html5References.addReference(  8882, "&vartriangleleft;");
        html5References.addReference(  8882, "&vltri;");
        html5References.addReference(  8882, "&LeftTriangle;");
        html5References.addReference(  8883, "&vartriangleright;");
        html5References.addReference(  8883, "&vrtri;");
        html5References.addReference(  8883, "&RightTriangle;");
        html5References.addReference(  8884, "&ltrie;");
        html5References.addReference(  8884, "&trianglelefteq;");
        html5References.addReference(  8884, "&LeftTriangleEqual;");
        html5References.addReference(  8884,  8402, "&nvltrie;");
        html5References.addReference(  8885, "&rtrie;");
        html5References.addReference(  8885, "&trianglerighteq;");
        html5References.addReference(  8885, "&RightTriangleEqual;");
        html5References.addReference(  8885,  8402, "&nvrtrie;");
        html5References.addReference(  8886, "&origof;");
        html5References.addReference(  8887, "&imof;");
        html5References.addReference(  8888, "&multimap;");
        html5References.addReference(  8888, "&mumap;");
        html5References.addReference(  8889, "&hercon;");
        html5References.addReference(  8890, "&intcal;");
        html5References.addReference(  8890, "&intercal;");
        html5References.addReference(  8891, "&veebar;");
        html5References.addReference(  8893, "&barvee;");
        html5References.addReference(  8894, "&angrtvb;");
        html5References.addReference(  8895, "&lrtri;");
        html5References.addReference(  8896, "&bigwedge;");
        html5References.addReference(  8896, "&xwedge;");
        html5References.addReference(  8896, "&Wedge;");
        html5References.addReference(  8897, "&bigvee;");
        html5References.addReference(  8897, "&xvee;");
        html5References.addReference(  8897, "&Vee;");
        html5References.addReference(  8898, "&bigcap;");
        html5References.addReference(  8898, "&xcap;");
        html5References.addReference(  8898, "&Intersection;");
        html5References.addReference(  8899, "&bigcup;");
        html5References.addReference(  8899, "&xcup;");
        html5References.addReference(  8899, "&Union;");
        html5References.addReference(  8900, "&diam;");
        html5References.addReference(  8900, "&diamond;");
        html5References.addReference(  8900, "&Diamond;");
        html5References.addReference(  8901, "&sdot;");
        html5References.addReference(  8902, "&sstarf;");
        html5References.addReference(  8902, "&Star;");
        html5References.addReference(  8903, "&divideontimes;");
        html5References.addReference(  8903, "&divonx;");
        html5References.addReference(  8904, "&bowtie;");
        html5References.addReference(  8905, "&ltimes;");
        html5References.addReference(  8906, "&rtimes;");
        html5References.addReference(  8907, "&leftthreetimes;");
        html5References.addReference(  8907, "&lthree;");
        html5References.addReference(  8908, "&rightthreetimes;");
        html5References.addReference(  8908, "&rthree;");
        html5References.addReference(  8909, "&backsimeq;");
        html5References.addReference(  8909, "&bsime;");
        html5References.addReference(  8910, "&curlyvee;");
        html5References.addReference(  8910, "&cuvee;");
        html5References.addReference(  8911, "&curlywedge;");
        html5References.addReference(  8911, "&cuwed;");
        html5References.addReference(  8912, "&Sub;");
        html5References.addReference(  8912, "&Subset;");
        html5References.addReference(  8913, "&Sup;");
        html5References.addReference(  8913, "&Supset;");
        html5References.addReference(  8914, "&Cap;");
        html5References.addReference(  8915, "&Cup;");
        html5References.addReference(  8916, "&fork;");
        html5References.addReference(  8916, "&pitchfork;");
        html5References.addReference(  8917, "&epar;");
        html5References.addReference(  8918, "&lessdot;");
        html5References.addReference(  8918, "&ltdot;");
        html5References.addReference(  8919, "&gtdot;");
        html5References.addReference(  8919, "&gtrdot;");
        html5References.addReference(  8920, "&Ll;");
        html5References.addReference(  8920,   824, "&nLl;");
        html5References.addReference(  8921, "&ggg;");
        html5References.addReference(  8921, "&Gg;");
        html5References.addReference(  8921,   824, "&nGg;");
        html5References.addReference(  8922, "&leg;");
        html5References.addReference(  8922, "&lesseqgtr;");
        html5References.addReference(  8922, "&LessEqualGreater;");
        html5References.addReference(  8922, 65024, "&lesg;");
        html5References.addReference(  8923, "&gel;");
        html5References.addReference(  8923, "&gtreqless;");
        html5References.addReference(  8923, "&GreaterEqualLess;");
        html5References.addReference(  8923, 65024, "&gesl;");
        html5References.addReference(  8926, "&cuepr;");
        html5References.addReference(  8926, "&curlyeqprec;");
        html5References.addReference(  8927, "&cuesc;");
        html5References.addReference(  8927, "&curlyeqsucc;");
        html5References.addReference(  8928, "&nprcue;");
        html5References.addReference(  8928, "&NotPrecedesSlantEqual;");
        html5References.addReference(  8929, "&nsccue;");
        html5References.addReference(  8929, "&NotSucceedsSlantEqual;");
        html5References.addReference(  8930, "&nsqsube;");
        html5References.addReference(  8930, "&NotSquareSubsetEqual;");
        html5References.addReference(  8931, "&nsqsupe;");
        html5References.addReference(  8931, "&NotSquareSupersetEqual;");
        html5References.addReference(  8934, "&lnsim;");
        html5References.addReference(  8935, "&gnsim;");
        html5References.addReference(  8936, "&precnsim;");
        html5References.addReference(  8936, "&prnsim;");
        html5References.addReference(  8937, "&scnsim;");
        html5References.addReference(  8937, "&succnsim;");
        html5References.addReference(  8938, "&nltri;");
        html5References.addReference(  8938, "&ntriangleleft;");
        html5References.addReference(  8938, "&NotLeftTriangle;");
        html5References.addReference(  8939, "&nrtri;");
        html5References.addReference(  8939, "&ntriangleright;");
        html5References.addReference(  8939, "&NotRightTriangle;");
        html5References.addReference(  8940, "&nltrie;");
        html5References.addReference(  8940, "&ntrianglelefteq;");
        html5References.addReference(  8940, "&NotLeftTriangleEqual;");
        html5References.addReference(  8941, "&nrtrie;");
        html5References.addReference(  8941, "&ntrianglerighteq;");
        html5References.addReference(  8941, "&NotRightTriangleEqual;");
        html5References.addReference(  8942, "&vellip;");
        html5References.addReference(  8943, "&ctdot;");
        html5References.addReference(  8944, "&utdot;");
        html5References.addReference(  8945, "&dtdot;");
        html5References.addReference(  8946, "&disin;");
        html5References.addReference(  8947, "&isinsv;");
        html5References.addReference(  8948, "&isins;");
        html5References.addReference(  8949, "&isindot;");
        html5References.addReference(  8949,   824, "&notindot;");
        html5References.addReference(  8950, "&notinvc;");
        html5References.addReference(  8951, "&notinvb;");
        html5References.addReference(  8953, "&isinE;");
        html5References.addReference(  8953,   824, "&notinE;");
        html5References.addReference(  8954, "&nisd;");
        html5References.addReference(  8955, "&xnis;");
        html5References.addReference(  8956, "&nis;");
        html5References.addReference(  8957, "&notnivc;");
        html5References.addReference(  8958, "&notnivb;");
        html5References.addReference(  8965, "&barwed;");
        html5References.addReference(  8965, "&barwedge;");
        html5References.addReference(  8966, "&doublebarwedge;");
        html5References.addReference(  8966, "&Barwed;");
        html5References.addReference(  8968, "&lceil;");
        html5References.addReference(  8968, "&LeftCeiling;");
        html5References.addReference(  8969, "&rceil;");
        html5References.addReference(  8969, "&RightCeiling;");
        html5References.addReference(  8970, "&lfloor;");
        html5References.addReference(  8970, "&LeftFloor;");
        html5References.addReference(  8971, "&rfloor;");
        html5References.addReference(  8971, "&RightFloor;");
        html5References.addReference(  8972, "&drcrop;");
        html5References.addReference(  8973, "&dlcrop;");
        html5References.addReference(  8974, "&urcrop;");
        html5References.addReference(  8975, "&ulcrop;");
        html5References.addReference(  8976, "&bnot;");
        html5References.addReference(  8978, "&profline;");
        html5References.addReference(  8979, "&profsurf;");
        html5References.addReference(  8981, "&telrec;");
        html5References.addReference(  8982, "&target;");
        html5References.addReference(  8988, "&ulcorn;");
        html5References.addReference(  8988, "&ulcorner;");
        html5References.addReference(  8989, "&urcorn;");
        html5References.addReference(  8989, "&urcorner;");
        html5References.addReference(  8990, "&dlcorn;");
        html5References.addReference(  8990, "&llcorner;");
        html5References.addReference(  8991, "&drcorn;");
        html5References.addReference(  8991, "&lrcorner;");
        html5References.addReference(  8994, "&frown;");
        html5References.addReference(  8994, "&sfrown;");
        html5References.addReference(  8995, "&smile;");
        html5References.addReference(  8995, "&ssmile;");
        html5References.addReference(  9005, "&cylcty;");
        html5References.addReference(  9006, "&profalar;");
        html5References.addReference(  9014, "&topbot;");
        html5References.addReference(  9021, "&ovbar;");
        html5References.addReference(  9023, "&solbar;");
        html5References.addReference(  9084, "&angzarr;");
        html5References.addReference(  9136, "&lmoust;");
        html5References.addReference(  9136, "&lmoustache;");
        html5References.addReference(  9137, "&rmoust;");
        html5References.addReference(  9137, "&rmoustache;");
        html5References.addReference(  9140, "&tbrk;");
        html5References.addReference(  9140, "&OverBracket;");
        html5References.addReference(  9141, "&bbrk;");
        html5References.addReference(  9141, "&UnderBracket;");
        html5References.addReference(  9142, "&bbrktbrk;");
        html5References.addReference(  9180, "&OverParenthesis;");
        html5References.addReference(  9181, "&UnderParenthesis;");
        html5References.addReference(  9182, "&OverBrace;");
        html5References.addReference(  9183, "&UnderBrace;");
        html5References.addReference(  9186, "&trpezium;");
        html5References.addReference(  9191, "&elinters;");
        html5References.addReference(  9251, "&blank;");
        html5References.addReference(  9416, "&circledS;");
        html5References.addReference(  9416, "&oS;");
        html5References.addReference(  9472, "&boxh;");
        html5References.addReference(  9472, "&HorizontalLine;");
        html5References.addReference(  9474, "&boxv;");
        html5References.addReference(  9484, "&boxdr;");
        html5References.addReference(  9488, "&boxdl;");
        html5References.addReference(  9492, "&boxur;");
        html5References.addReference(  9496, "&boxul;");
        html5References.addReference(  9500, "&boxvr;");
        html5References.addReference(  9508, "&boxvl;");
        html5References.addReference(  9516, "&boxhd;");
        html5References.addReference(  9524, "&boxhu;");
        html5References.addReference(  9532, "&boxvh;");
        html5References.addReference(  9552, "&boxH;");
        html5References.addReference(  9553, "&boxV;");
        html5References.addReference(  9554, "&boxdR;");
        html5References.addReference(  9555, "&boxDr;");
        html5References.addReference(  9556, "&boxDR;");
        html5References.addReference(  9557, "&boxdL;");
        html5References.addReference(  9558, "&boxDl;");
        html5References.addReference(  9559, "&boxDL;");
        html5References.addReference(  9560, "&boxuR;");
        html5References.addReference(  9561, "&boxUr;");
        html5References.addReference(  9562, "&boxUR;");
        html5References.addReference(  9563, "&boxuL;");
        html5References.addReference(  9564, "&boxUl;");
        html5References.addReference(  9565, "&boxUL;");
        html5References.addReference(  9566, "&boxvR;");
        html5References.addReference(  9567, "&boxVr;");
        html5References.addReference(  9568, "&boxVR;");
        html5References.addReference(  9569, "&boxvL;");
        html5References.addReference(  9570, "&boxVl;");
        html5References.addReference(  9571, "&boxVL;");
        html5References.addReference(  9572, "&boxHd;");
        html5References.addReference(  9573, "&boxhD;");
        html5References.addReference(  9574, "&boxHD;");
        html5References.addReference(  9575, "&boxHu;");
        html5References.addReference(  9576, "&boxhU;");
        html5References.addReference(  9577, "&boxHU;");
        html5References.addReference(  9578, "&boxvH;");
        html5References.addReference(  9579, "&boxVh;");
        html5References.addReference(  9580, "&boxVH;");
        html5References.addReference(  9600, "&uhblk;");
        html5References.addReference(  9604, "&lhblk;");
        html5References.addReference(  9608, "&block;");
        html5References.addReference(  9617, "&blk14;");
        html5References.addReference(  9618, "&blk12;");
        html5References.addReference(  9619, "&blk34;");
        html5References.addReference(  9633, "&squ;");
        html5References.addReference(  9633, "&square;");
        html5References.addReference(  9633, "&Square;");
        html5References.addReference(  9642, "&blacksquare;");
        html5References.addReference(  9642, "&squarf;");
        html5References.addReference(  9642, "&squf;");
        html5References.addReference(  9642, "&FilledVerySmallSquare;");
        html5References.addReference(  9643, "&EmptyVerySmallSquare;");
        html5References.addReference(  9645, "&rect;");
        html5References.addReference(  9646, "&marker;");
        html5References.addReference(  9649, "&fltns;");
        html5References.addReference(  9651, "&bigtriangleup;");
        html5References.addReference(  9651, "&xutri;");
        html5References.addReference(  9652, "&blacktriangle;");
        html5References.addReference(  9652, "&utrif;");
        html5References.addReference(  9653, "&triangle;");
        html5References.addReference(  9653, "&utri;");
        html5References.addReference(  9656, "&blacktriangleright;");
        html5References.addReference(  9656, "&rtrif;");
        html5References.addReference(  9657, "&rtri;");
        html5References.addReference(  9657, "&triangleright;");
        html5References.addReference(  9661, "&bigtriangledown;");
        html5References.addReference(  9661, "&xdtri;");
        html5References.addReference(  9662, "&blacktriangledown;");
        html5References.addReference(  9662, "&dtrif;");
        html5References.addReference(  9663, "&dtri;");
        html5References.addReference(  9663, "&triangledown;");
        html5References.addReference(  9666, "&blacktriangleleft;");
        html5References.addReference(  9666, "&ltrif;");
        html5References.addReference(  9667, "&ltri;");
        html5References.addReference(  9667, "&triangleleft;");
        html5References.addReference(  9674, "&loz;");
        html5References.addReference(  9674, "&lozenge;");
        html5References.addReference(  9675, "&cir;");
        html5References.addReference(  9708, "&tridot;");
        html5References.addReference(  9711, "&bigcirc;");
        html5References.addReference(  9711, "&xcirc;");
        html5References.addReference(  9720, "&ultri;");
        html5References.addReference(  9721, "&urtri;");
        html5References.addReference(  9722, "&lltri;");
        html5References.addReference(  9723, "&EmptySmallSquare;");
        html5References.addReference(  9724, "&FilledSmallSquare;");
        html5References.addReference(  9733, "&bigstar;");
        html5References.addReference(  9733, "&starf;");
        html5References.addReference(  9734, "&star;");
        html5References.addReference(  9742, "&phone;");
        html5References.addReference(  9792, "&female;");
        html5References.addReference(  9794, "&male;");
        html5References.addReference(  9824, "&spades;");
        html5References.addReference(  9824, "&spadesuit;");
        html5References.addReference(  9827, "&clubs;");
        html5References.addReference(  9827, "&clubsuit;");
        html5References.addReference(  9829, "&hearts;");
        html5References.addReference(  9829, "&heartsuit;");
        html5References.addReference(  9830, "&diams;");
        html5References.addReference(  9830, "&diamondsuit;");
        html5References.addReference(  9834, "&sung;");
        html5References.addReference(  9837, "&flat;");
        html5References.addReference(  9838, "&natur;");
        html5References.addReference(  9838, "&natural;");
        html5References.addReference(  9839, "&sharp;");
        html5References.addReference( 10003, "&check;");
        html5References.addReference( 10003, "&checkmark;");
        html5References.addReference( 10007, "&cross;");
        html5References.addReference( 10016, "&malt;");
        html5References.addReference( 10016, "&maltese;");
        html5References.addReference( 10038, "&sext;");
        html5References.addReference( 10072, "&VerticalSeparator;");
        html5References.addReference( 10098, "&lbbrk;");
        html5References.addReference( 10099, "&rbbrk;");
        html5References.addReference( 10184, "&bsolhsub;");
        html5References.addReference( 10185, "&suphsol;");
        html5References.addReference( 10214, "&lobrk;");
        html5References.addReference( 10214, "&LeftDoubleBracket;");
        html5References.addReference( 10215, "&robrk;");
        html5References.addReference( 10215, "&RightDoubleBracket;");
        html5References.addReference( 10216, "&lang;");
        html5References.addReference( 10216, "&langle;");
        html5References.addReference( 10216, "&LeftAngleBracket;");
        html5References.addReference( 10217, "&rang;");
        html5References.addReference( 10217, "&rangle;");
        html5References.addReference( 10217, "&RightAngleBracket;");
        html5References.addReference( 10218, "&Lang;");
        html5References.addReference( 10219, "&Rang;");
        html5References.addReference( 10220, "&loang;");
        html5References.addReference( 10221, "&roang;");
        html5References.addReference( 10229, "&longleftarrow;");
        html5References.addReference( 10229, "&xlarr;");
        html5References.addReference( 10229, "&LongLeftArrow;");
        html5References.addReference( 10230, "&longrightarrow;");
        html5References.addReference( 10230, "&xrarr;");
        html5References.addReference( 10230, "&LongRightArrow;");
        html5References.addReference( 10231, "&longleftrightarrow;");
        html5References.addReference( 10231, "&xharr;");
        html5References.addReference( 10231, "&LongLeftRightArrow;");
        html5References.addReference( 10232, "&xlArr;");
        html5References.addReference( 10232, "&DoubleLongLeftArrow;");
        html5References.addReference( 10232, "&Longleftarrow;");
        html5References.addReference( 10233, "&xrArr;");
        html5References.addReference( 10233, "&DoubleLongRightArrow;");
        html5References.addReference( 10233, "&Longrightarrow;");
        html5References.addReference( 10234, "&xhArr;");
        html5References.addReference( 10234, "&DoubleLongLeftRightArrow;");
        html5References.addReference( 10234, "&Longleftrightarrow;");
        html5References.addReference( 10236, "&longmapsto;");
        html5References.addReference( 10236, "&xmap;");
        html5References.addReference( 10239, "&dzigrarr;");
        html5References.addReference( 10498, "&nvlArr;");
        html5References.addReference( 10499, "&nvrArr;");
        html5References.addReference( 10500, "&nvHarr;");
        html5References.addReference( 10501, "&Map;");
        html5References.addReference( 10508, "&lbarr;");
        html5References.addReference( 10509, "&bkarow;");
        html5References.addReference( 10509, "&rbarr;");
        html5References.addReference( 10510, "&lBarr;");
        html5References.addReference( 10511, "&dbkarow;");
        html5References.addReference( 10511, "&rBarr;");
        html5References.addReference( 10512, "&drbkarow;");
        html5References.addReference( 10512, "&RBarr;");
        html5References.addReference( 10513, "&DDotrahd;");
        html5References.addReference( 10514, "&UpArrowBar;");
        html5References.addReference( 10515, "&DownArrowBar;");
        html5References.addReference( 10518, "&Rarrtl;");
        html5References.addReference( 10521, "&latail;");
        html5References.addReference( 10522, "&ratail;");
        html5References.addReference( 10523, "&lAtail;");
        html5References.addReference( 10524, "&rAtail;");
        html5References.addReference( 10525, "&larrfs;");
        html5References.addReference( 10526, "&rarrfs;");
        html5References.addReference( 10527, "&larrbfs;");
        html5References.addReference( 10528, "&rarrbfs;");
        html5References.addReference( 10531, "&nwarhk;");
        html5References.addReference( 10532, "&nearhk;");
        html5References.addReference( 10533, "&hksearow;");
        html5References.addReference( 10533, "&searhk;");
        html5References.addReference( 10534, "&hkswarow;");
        html5References.addReference( 10534, "&swarhk;");
        html5References.addReference( 10535, "&nwnear;");
        html5References.addReference( 10536, "&nesear;");
        html5References.addReference( 10536, "&toea;");
        html5References.addReference( 10537, "&seswar;");
        html5References.addReference( 10537, "&tosa;");
        html5References.addReference( 10538, "&swnwar;");
        html5References.addReference( 10547, "&rarrc;");
        html5References.addReference( 10547,   824, "&nrarrc;");
        html5References.addReference( 10549, "&cudarrr;");
        html5References.addReference( 10550, "&ldca;");
        html5References.addReference( 10551, "&rdca;");
        html5References.addReference( 10552, "&cudarrl;");
        html5References.addReference( 10553, "&larrpl;");
        html5References.addReference( 10556, "&curarrm;");
        html5References.addReference( 10557, "&cularrp;");
        html5References.addReference( 10565, "&rarrpl;");
        html5References.addReference( 10568, "&harrcir;");
        html5References.addReference( 10569, "&Uarrocir;");
        html5References.addReference( 10570, "&lurdshar;");
        html5References.addReference( 10571, "&ldrushar;");
        html5References.addReference( 10574, "&LeftRightVector;");
        html5References.addReference( 10575, "&RightUpDownVector;");
        html5References.addReference( 10576, "&DownLeftRightVector;");
        html5References.addReference( 10577, "&LeftUpDownVector;");
        html5References.addReference( 10578, "&LeftVectorBar;");
        html5References.addReference( 10579, "&RightVectorBar;");
        html5References.addReference( 10580, "&RightUpVectorBar;");
        html5References.addReference( 10581, "&RightDownVectorBar;");
        html5References.addReference( 10582, "&DownLeftVectorBar;");
        html5References.addReference( 10583, "&DownRightVectorBar;");
        html5References.addReference( 10584, "&LeftUpVectorBar;");
        html5References.addReference( 10585, "&LeftDownVectorBar;");
        html5References.addReference( 10586, "&LeftTeeVector;");
        html5References.addReference( 10587, "&RightTeeVector;");
        html5References.addReference( 10588, "&RightUpTeeVector;");
        html5References.addReference( 10589, "&RightDownTeeVector;");
        html5References.addReference( 10590, "&DownLeftTeeVector;");
        html5References.addReference( 10591, "&DownRightTeeVector;");
        html5References.addReference( 10592, "&LeftUpTeeVector;");
        html5References.addReference( 10593, "&LeftDownTeeVector;");
        html5References.addReference( 10594, "&lHar;");
        html5References.addReference( 10595, "&uHar;");
        html5References.addReference( 10596, "&rHar;");
        html5References.addReference( 10597, "&dHar;");
        html5References.addReference( 10598, "&luruhar;");
        html5References.addReference( 10599, "&ldrdhar;");
        html5References.addReference( 10600, "&ruluhar;");
        html5References.addReference( 10601, "&rdldhar;");
        html5References.addReference( 10602, "&lharul;");
        html5References.addReference( 10603, "&llhard;");
        html5References.addReference( 10604, "&rharul;");
        html5References.addReference( 10605, "&lrhard;");
        html5References.addReference( 10606, "&udhar;");
        html5References.addReference( 10606, "&UpEquilibrium;");
        html5References.addReference( 10607, "&duhar;");
        html5References.addReference( 10607, "&ReverseUpEquilibrium;");
        html5References.addReference( 10608, "&RoundImplies;");
        html5References.addReference( 10609, "&erarr;");
        html5References.addReference( 10610, "&simrarr;");
        html5References.addReference( 10611, "&larrsim;");
        html5References.addReference( 10612, "&rarrsim;");
        html5References.addReference( 10613, "&rarrap;");
        html5References.addReference( 10614, "&ltlarr;");
        html5References.addReference( 10616, "&gtrarr;");
        html5References.addReference( 10617, "&subrarr;");
        html5References.addReference( 10619, "&suplarr;");
        html5References.addReference( 10620, "&lfisht;");
        html5References.addReference( 10621, "&rfisht;");
        html5References.addReference( 10622, "&ufisht;");
        html5References.addReference( 10623, "&dfisht;");
        html5References.addReference( 10629, "&lopar;");
        html5References.addReference( 10630, "&ropar;");
        html5References.addReference( 10635, "&lbrke;");
        html5References.addReference( 10636, "&rbrke;");
        html5References.addReference( 10637, "&lbrkslu;");
        html5References.addReference( 10638, "&rbrksld;");
        html5References.addReference( 10639, "&lbrksld;");
        html5References.addReference( 10640, "&rbrkslu;");
        html5References.addReference( 10641, "&langd;");
        html5References.addReference( 10642, "&rangd;");
        html5References.addReference( 10643, "&lparlt;");
        html5References.addReference( 10644, "&rpargt;");
        html5References.addReference( 10645, "&gtlPar;");
        html5References.addReference( 10646, "&ltrPar;");
        html5References.addReference( 10650, "&vzigzag;");
        html5References.addReference( 10652, "&vangrt;");
        html5References.addReference( 10653, "&angrtvbd;");
        html5References.addReference( 10660, "&ange;");
        html5References.addReference( 10661, "&range;");
        html5References.addReference( 10662, "&dwangle;");
        html5References.addReference( 10663, "&uwangle;");
        html5References.addReference( 10664, "&angmsdaa;");
        html5References.addReference( 10665, "&angmsdab;");
        html5References.addReference( 10666, "&angmsdac;");
        html5References.addReference( 10667, "&angmsdad;");
        html5References.addReference( 10668, "&angmsdae;");
        html5References.addReference( 10669, "&angmsdaf;");
        html5References.addReference( 10670, "&angmsdag;");
        html5References.addReference( 10671, "&angmsdah;");
        html5References.addReference( 10672, "&bemptyv;");
        html5References.addReference( 10673, "&demptyv;");
        html5References.addReference( 10674, "&cemptyv;");
        html5References.addReference( 10675, "&raemptyv;");
        html5References.addReference( 10676, "&laemptyv;");
        html5References.addReference( 10677, "&ohbar;");
        html5References.addReference( 10678, "&omid;");
        html5References.addReference( 10679, "&opar;");
        html5References.addReference( 10681, "&operp;");
        html5References.addReference( 10683, "&olcross;");
        html5References.addReference( 10684, "&odsold;");
        html5References.addReference( 10686, "&olcir;");
        html5References.addReference( 10687, "&ofcir;");
        html5References.addReference( 10688, "&olt;");
        html5References.addReference( 10689, "&ogt;");
        html5References.addReference( 10690, "&cirscir;");
        html5References.addReference( 10691, "&cirE;");
        html5References.addReference( 10692, "&solb;");
        html5References.addReference( 10693, "&bsolb;");
        html5References.addReference( 10697, "&boxbox;");
        html5References.addReference( 10701, "&trisb;");
        html5References.addReference( 10702, "&rtriltri;");
        html5References.addReference( 10703, "&LeftTriangleBar;");
        html5References.addReference( 10703,   824, "&NotLeftTriangleBar;");
        html5References.addReference( 10704, "&RightTriangleBar;");
        html5References.addReference( 10704,   824, "&NotRightTriangleBar;");
        html5References.addReference( 10716, "&iinfin;");
        html5References.addReference( 10717, "&infintie;");
        html5References.addReference( 10718, "&nvinfin;");
        html5References.addReference( 10723, "&eparsl;");
        html5References.addReference( 10724, "&smeparsl;");
        html5References.addReference( 10725, "&eqvparsl;");
        html5References.addReference( 10731, "&blacklozenge;");
        html5References.addReference( 10731, "&lozf;");
        html5References.addReference( 10740, "&RuleDelayed;");
        html5References.addReference( 10742, "&dsol;");
        html5References.addReference( 10752, "&bigodot;");
        html5References.addReference( 10752, "&xodot;");
        html5References.addReference( 10753, "&bigoplus;");
        html5References.addReference( 10753, "&xoplus;");
        html5References.addReference( 10754, "&bigotimes;");
        html5References.addReference( 10754, "&xotime;");
        html5References.addReference( 10756, "&biguplus;");
        html5References.addReference( 10756, "&xuplus;");
        html5References.addReference( 10758, "&bigsqcup;");
        html5References.addReference( 10758, "&xsqcup;");
        html5References.addReference( 10764, "&iiiint;");
        html5References.addReference( 10764, "&qint;");
        html5References.addReference( 10765, "&fpartint;");
        html5References.addReference( 10768, "&cirfnint;");
        html5References.addReference( 10769, "&awint;");
        html5References.addReference( 10770, "&rppolint;");
        html5References.addReference( 10771, "&scpolint;");
        html5References.addReference( 10772, "&npolint;");
        html5References.addReference( 10773, "&pointint;");
        html5References.addReference( 10774, "&quatint;");
        html5References.addReference( 10775, "&intlarhk;");
        html5References.addReference( 10786, "&pluscir;");
        html5References.addReference( 10787, "&plusacir;");
        html5References.addReference( 10788, "&simplus;");
        html5References.addReference( 10789, "&plusdu;");
        html5References.addReference( 10790, "&plussim;");
        html5References.addReference( 10791, "&plustwo;");
        html5References.addReference( 10793, "&mcomma;");
        html5References.addReference( 10794, "&minusdu;");
        html5References.addReference( 10797, "&loplus;");
        html5References.addReference( 10798, "&roplus;");
        html5References.addReference( 10799, "&Cross;");
        html5References.addReference( 10800, "&timesd;");
        html5References.addReference( 10801, "&timesbar;");
        html5References.addReference( 10803, "&smashp;");
        html5References.addReference( 10804, "&lotimes;");
        html5References.addReference( 10805, "&rotimes;");
        html5References.addReference( 10806, "&otimesas;");
        html5References.addReference( 10807, "&Otimes;");
        html5References.addReference( 10808, "&odiv;");
        html5References.addReference( 10809, "&triplus;");
        html5References.addReference( 10810, "&triminus;");
        html5References.addReference( 10811, "&tritime;");
        html5References.addReference( 10812, "&intprod;");
        html5References.addReference( 10812, "&iprod;");
        html5References.addReference( 10815, "&amalg;");
        html5References.addReference( 10816, "&capdot;");
        html5References.addReference( 10818, "&ncup;");
        html5References.addReference( 10819, "&ncap;");
        html5References.addReference( 10820, "&capand;");
        html5References.addReference( 10821, "&cupor;");
        html5References.addReference( 10822, "&cupcap;");
        html5References.addReference( 10823, "&capcup;");
        html5References.addReference( 10824, "&cupbrcap;");
        html5References.addReference( 10825, "&capbrcup;");
        html5References.addReference( 10826, "&cupcup;");
        html5References.addReference( 10827, "&capcap;");
        html5References.addReference( 10828, "&ccups;");
        html5References.addReference( 10829, "&ccaps;");
        html5References.addReference( 10832, "&ccupssm;");
        html5References.addReference( 10835, "&And;");
        html5References.addReference( 10836, "&Or;");
        html5References.addReference( 10837, "&andand;");
        html5References.addReference( 10838, "&oror;");
        html5References.addReference( 10839, "&orslope;");
        html5References.addReference( 10840, "&andslope;");
        html5References.addReference( 10842, "&andv;");
        html5References.addReference( 10843, "&orv;");
        html5References.addReference( 10844, "&andd;");
        html5References.addReference( 10845, "&ord;");
        html5References.addReference( 10847, "&wedbar;");
        html5References.addReference( 10854, "&sdote;");
        html5References.addReference( 10858, "&simdot;");
        html5References.addReference( 10861, "&congdot;");
        html5References.addReference( 10861,   824, "&ncongdot;");
        html5References.addReference( 10862, "&easter;");
        html5References.addReference( 10863, "&apacir;");
        html5References.addReference( 10864, "&apE;");
        html5References.addReference( 10864,   824, "&napE;");
        html5References.addReference( 10865, "&eplus;");
        html5References.addReference( 10866, "&pluse;");
        html5References.addReference( 10867, "&Esim;");
        html5References.addReference( 10868, "&Colone;");
        html5References.addReference( 10869, "&Equal;");
        html5References.addReference( 10871, "&ddotseq;");
        html5References.addReference( 10871, "&eDDot;");
        html5References.addReference( 10872, "&equivDD;");
        html5References.addReference( 10873, "&ltcir;");
        html5References.addReference( 10874, "&gtcir;");
        html5References.addReference( 10875, "&ltquest;");
        html5References.addReference( 10876, "&gtquest;");
        html5References.addReference( 10877, "&leqslant;");
        html5References.addReference( 10877, "&les;");
        html5References.addReference( 10877, "&LessSlantEqual;");
        html5References.addReference( 10877,   824, "&nleqslant;");
        html5References.addReference( 10877,   824, "&nles;");
        html5References.addReference( 10877,   824, "&NotLessSlantEqual;");
        html5References.addReference( 10878, "&geqslant;");
        html5References.addReference( 10878, "&ges;");
        html5References.addReference( 10878, "&GreaterSlantEqual;");
        html5References.addReference( 10878,   824, "&ngeqslant;");
        html5References.addReference( 10878,   824, "&nges;");
        html5References.addReference( 10878,   824, "&NotGreaterSlantEqual;");
        html5References.addReference( 10879, "&lesdot;");
        html5References.addReference( 10880, "&gesdot;");
        html5References.addReference( 10881, "&lesdoto;");
        html5References.addReference( 10882, "&gesdoto;");
        html5References.addReference( 10883, "&lesdotor;");
        html5References.addReference( 10884, "&gesdotol;");
        html5References.addReference( 10885, "&lap;");
        html5References.addReference( 10885, "&lessapprox;");
        html5References.addReference( 10886, "&gap;");
        html5References.addReference( 10886, "&gtrapprox;");
        html5References.addReference( 10887, "&lne;");
        html5References.addReference( 10887, "&lneq;");
        html5References.addReference( 10888, "&gne;");
        html5References.addReference( 10888, "&gneq;");
        html5References.addReference( 10889, "&lnap;");
        html5References.addReference( 10889, "&lnapprox;");
        html5References.addReference( 10890, "&gnap;");
        html5References.addReference( 10890, "&gnapprox;");
        html5References.addReference( 10891, "&lEg;");
        html5References.addReference( 10891, "&lesseqqgtr;");
        html5References.addReference( 10892, "&gEl;");
        html5References.addReference( 10892, "&gtreqqless;");
        html5References.addReference( 10893, "&lsime;");
        html5References.addReference( 10894, "&gsime;");
        html5References.addReference( 10895, "&lsimg;");
        html5References.addReference( 10896, "&gsiml;");
        html5References.addReference( 10897, "&lgE;");
        html5References.addReference( 10898, "&glE;");
        html5References.addReference( 10899, "&lesges;");
        html5References.addReference( 10900, "&gesles;");
        html5References.addReference( 10901, "&els;");
        html5References.addReference( 10901, "&eqslantless;");
        html5References.addReference( 10902, "&egs;");
        html5References.addReference( 10902, "&eqslantgtr;");
        html5References.addReference( 10903, "&elsdot;");
        html5References.addReference( 10904, "&egsdot;");
        html5References.addReference( 10905, "&el;");
        html5References.addReference( 10906, "&eg;");
        html5References.addReference( 10909, "&siml;");
        html5References.addReference( 10910, "&simg;");
        html5References.addReference( 10911, "&simlE;");
        html5References.addReference( 10912, "&simgE;");
        html5References.addReference( 10913, "&LessLess;");
        html5References.addReference( 10913,   824, "&NotNestedLessLess;");
        html5References.addReference( 10914, "&GreaterGreater;");
        html5References.addReference( 10914,   824, "&NotNestedGreaterGreater;");
        html5References.addReference( 10916, "&glj;");
        html5References.addReference( 10917, "&gla;");
        html5References.addReference( 10918, "&ltcc;");
        html5References.addReference( 10919, "&gtcc;");
        html5References.addReference( 10920, "&lescc;");
        html5References.addReference( 10921, "&gescc;");
        html5References.addReference( 10922, "&smt;");
        html5References.addReference( 10923, "&lat;");
        html5References.addReference( 10924, "&smte;");
        html5References.addReference( 10924, 65024, "&smtes;");
        html5References.addReference( 10925, "&late;");
        html5References.addReference( 10925, 65024, "&lates;");
        html5References.addReference( 10926, "&bumpE;");
        html5References.addReference( 10927, "&pre;");
        html5References.addReference( 10927, "&preceq;");
        html5References.addReference( 10927, "&PrecedesEqual;");
        html5References.addReference( 10927,   824, "&npre;");
        html5References.addReference( 10927,   824, "&npreceq;");
        html5References.addReference( 10927,   824, "&NotPrecedesEqual;");
        html5References.addReference( 10928, "&sce;");
        html5References.addReference( 10928, "&succeq;");
        html5References.addReference( 10928, "&SucceedsEqual;");
        html5References.addReference( 10928,   824, "&nsce;");
        html5References.addReference( 10928,   824, "&nsucceq;");
        html5References.addReference( 10928,   824, "&NotSucceedsEqual;");
        html5References.addReference( 10931, "&prE;");
        html5References.addReference( 10932, "&scE;");
        html5References.addReference( 10933, "&precneqq;");
        html5References.addReference( 10933, "&prnE;");
        html5References.addReference( 10934, "&scnE;");
        html5References.addReference( 10934, "&succneqq;");
        html5References.addReference( 10935, "&prap;");
        html5References.addReference( 10935, "&precapprox;");
        html5References.addReference( 10936, "&scap;");
        html5References.addReference( 10936, "&succapprox;");
        html5References.addReference( 10937, "&precnapprox;");
        html5References.addReference( 10937, "&prnap;");
        html5References.addReference( 10938, "&scnap;");
        html5References.addReference( 10938, "&succnapprox;");
        html5References.addReference( 10939, "&Pr;");
        html5References.addReference( 10940, "&Sc;");
        html5References.addReference( 10941, "&subdot;");
        html5References.addReference( 10942, "&supdot;");
        html5References.addReference( 10943, "&subplus;");
        html5References.addReference( 10944, "&supplus;");
        html5References.addReference( 10945, "&submult;");
        html5References.addReference( 10946, "&supmult;");
        html5References.addReference( 10947, "&subedot;");
        html5References.addReference( 10948, "&supedot;");
        html5References.addReference( 10949, "&subE;");
        html5References.addReference( 10949, "&subseteqq;");
        html5References.addReference( 10949,   824, "&nsubE;");
        html5References.addReference( 10949,   824, "&nsubseteqq;");
        html5References.addReference( 10950, "&supE;");
        html5References.addReference( 10950, "&supseteqq;");
        html5References.addReference( 10950,   824, "&nsupE;");
        html5References.addReference( 10950,   824, "&nsupseteqq;");
        html5References.addReference( 10951, "&subsim;");
        html5References.addReference( 10952, "&supsim;");
        html5References.addReference( 10955, "&subnE;");
        html5References.addReference( 10955, "&subsetneqq;");
        html5References.addReference( 10955, 65024, "&varsubsetneqq;");
        html5References.addReference( 10955, 65024, "&vsubnE;");
        html5References.addReference( 10956, "&supnE;");
        html5References.addReference( 10956, "&supsetneqq;");
        html5References.addReference( 10956, 65024, "&varsupsetneqq;");
        html5References.addReference( 10956, 65024, "&vsupnE;");
        html5References.addReference( 10959, "&csub;");
        html5References.addReference( 10960, "&csup;");
        html5References.addReference( 10961, "&csube;");
        html5References.addReference( 10962, "&csupe;");
        html5References.addReference( 10963, "&subsup;");
        html5References.addReference( 10964, "&supsub;");
        html5References.addReference( 10965, "&subsub;");
        html5References.addReference( 10966, "&supsup;");
        html5References.addReference( 10967, "&suphsub;");
        html5References.addReference( 10968, "&supdsub;");
        html5References.addReference( 10969, "&forkv;");
        html5References.addReference( 10970, "&topfork;");
        html5References.addReference( 10971, "&mlcp;");
        html5References.addReference( 10980, "&Dashv;");
        html5References.addReference( 10980, "&DoubleLeftTee;");
        html5References.addReference( 10982, "&Vdashl;");
        html5References.addReference( 10983, "&Barv;");
        html5References.addReference( 10984, "&vBar;");
        html5References.addReference( 10985, "&vBarv;");
        html5References.addReference( 10987, "&Vbar;");
        html5References.addReference( 10988, "&Not;");
        html5References.addReference( 10989, "&bNot;");
        html5References.addReference( 10990, "&rnmid;");
        html5References.addReference( 10991, "&cirmid;");
        html5References.addReference( 10992, "&midcir;");
        html5References.addReference( 10993, "&topcir;");
        html5References.addReference( 10994, "&nhpar;");
        html5References.addReference( 10995, "&parsim;");
        html5References.addReference( 11005, "&parsl;");
        html5References.addReference( 11005,  8421, "&nparsl;");
        html5References.addReference( 64256, "&fflig;");
        html5References.addReference( 64257, "&filig;");
        html5References.addReference( 64258, "&fllig;");
        html5References.addReference( 64259, "&ffilig;");
        html5References.addReference( 64260, "&ffllig;");
        html5References.addReference(119964, "&Ascr;");
        html5References.addReference(119966, "&Cscr;");
        html5References.addReference(119967, "&Dscr;");
        html5References.addReference(119970, "&Gscr;");
        html5References.addReference(119973, "&Jscr;");
        html5References.addReference(119974, "&Kscr;");
        html5References.addReference(119977, "&Nscr;");
        html5References.addReference(119978, "&Oscr;");
        html5References.addReference(119979, "&Pscr;");
        html5References.addReference(119980, "&Qscr;");
        html5References.addReference(119982, "&Sscr;");
        html5References.addReference(119983, "&Tscr;");
        html5References.addReference(119984, "&Uscr;");
        html5References.addReference(119985, "&Vscr;");
        html5References.addReference(119986, "&Wscr;");
        html5References.addReference(119987, "&Xscr;");
        html5References.addReference(119988, "&Yscr;");
        html5References.addReference(119989, "&Zscr;");
        html5References.addReference(119990, "&ascr;");
        html5References.addReference(119991, "&bscr;");
        html5References.addReference(119992, "&cscr;");
        html5References.addReference(119993, "&dscr;");
        html5References.addReference(119995, "&fscr;");
        html5References.addReference(119997, "&hscr;");
        html5References.addReference(119998, "&iscr;");
        html5References.addReference(119999, "&jscr;");
        html5References.addReference(120000, "&kscr;");
        html5References.addReference(120001, "&lscr;");
        html5References.addReference(120002, "&mscr;");
        html5References.addReference(120003, "&nscr;");
        html5References.addReference(120005, "&pscr;");
        html5References.addReference(120006, "&qscr;");
        html5References.addReference(120007, "&rscr;");
        html5References.addReference(120008, "&sscr;");
        html5References.addReference(120009, "&tscr;");
        html5References.addReference(120010, "&uscr;");
        html5References.addReference(120011, "&vscr;");
        html5References.addReference(120012, "&wscr;");
        html5References.addReference(120013, "&xscr;");
        html5References.addReference(120014, "&yscr;");
        html5References.addReference(120015, "&zscr;");
        html5References.addReference(120068, "&Afr;");
        html5References.addReference(120069, "&Bfr;");
        html5References.addReference(120071, "&Dfr;");
        html5References.addReference(120072, "&Efr;");
        html5References.addReference(120073, "&Ffr;");
        html5References.addReference(120074, "&Gfr;");
        html5References.addReference(120077, "&Jfr;");
        html5References.addReference(120078, "&Kfr;");
        html5References.addReference(120079, "&Lfr;");
        html5References.addReference(120080, "&Mfr;");
        html5References.addReference(120081, "&Nfr;");
        html5References.addReference(120082, "&Ofr;");
        html5References.addReference(120083, "&Pfr;");
        html5References.addReference(120084, "&Qfr;");
        html5References.addReference(120086, "&Sfr;");
        html5References.addReference(120087, "&Tfr;");
        html5References.addReference(120088, "&Ufr;");
        html5References.addReference(120089, "&Vfr;");
        html5References.addReference(120090, "&Wfr;");
        html5References.addReference(120091, "&Xfr;");
        html5References.addReference(120092, "&Yfr;");
        html5References.addReference(120094, "&afr;");
        html5References.addReference(120095, "&bfr;");
        html5References.addReference(120096, "&cfr;");
        html5References.addReference(120097, "&dfr;");
        html5References.addReference(120098, "&efr;");
        html5References.addReference(120099, "&ffr;");
        html5References.addReference(120100, "&gfr;");
        html5References.addReference(120101, "&hfr;");
        html5References.addReference(120102, "&ifr;");
        html5References.addReference(120103, "&jfr;");
        html5References.addReference(120104, "&kfr;");
        html5References.addReference(120105, "&lfr;");
        html5References.addReference(120106, "&mfr;");
        html5References.addReference(120107, "&nfr;");
        html5References.addReference(120108, "&ofr;");
        html5References.addReference(120109, "&pfr;");
        html5References.addReference(120110, "&qfr;");
        html5References.addReference(120111, "&rfr;");
        html5References.addReference(120112, "&sfr;");
        html5References.addReference(120113, "&tfr;");
        html5References.addReference(120114, "&ufr;");
        html5References.addReference(120115, "&vfr;");
        html5References.addReference(120116, "&wfr;");
        html5References.addReference(120117, "&xfr;");
        html5References.addReference(120118, "&yfr;");
        html5References.addReference(120119, "&zfr;");
        html5References.addReference(120120, "&Aopf;");
        html5References.addReference(120121, "&Bopf;");
        html5References.addReference(120123, "&Dopf;");
        html5References.addReference(120124, "&Eopf;");
        html5References.addReference(120125, "&Fopf;");
        html5References.addReference(120126, "&Gopf;");
        html5References.addReference(120128, "&Iopf;");
        html5References.addReference(120129, "&Jopf;");
        html5References.addReference(120130, "&Kopf;");
        html5References.addReference(120131, "&Lopf;");
        html5References.addReference(120132, "&Mopf;");
        html5References.addReference(120134, "&Oopf;");
        html5References.addReference(120138, "&Sopf;");
        html5References.addReference(120139, "&Topf;");
        html5References.addReference(120140, "&Uopf;");
        html5References.addReference(120141, "&Vopf;");
        html5References.addReference(120142, "&Wopf;");
        html5References.addReference(120143, "&Xopf;");
        html5References.addReference(120144, "&Yopf;");
        html5References.addReference(120146, "&aopf;");
        html5References.addReference(120147, "&bopf;");
        html5References.addReference(120148, "&copf;");
        html5References.addReference(120149, "&dopf;");
        html5References.addReference(120150, "&eopf;");
        html5References.addReference(120151, "&fopf;");
        html5References.addReference(120152, "&gopf;");
        html5References.addReference(120153, "&hopf;");
        html5References.addReference(120154, "&iopf;");
        html5References.addReference(120155, "&jopf;");
        html5References.addReference(120156, "&kopf;");
        html5References.addReference(120157, "&lopf;");
        html5References.addReference(120158, "&mopf;");
        html5References.addReference(120159, "&nopf;");
        html5References.addReference(120160, "&oopf;");
        html5References.addReference(120161, "&popf;");
        html5References.addReference(120162, "&qopf;");
        html5References.addReference(120163, "&ropf;");
        html5References.addReference(120164, "&sopf;");
        html5References.addReference(120165, "&topf;");
        html5References.addReference(120166, "&uopf;");
        html5References.addReference(120167, "&vopf;");
        html5References.addReference(120168, "&wopf;");
        html5References.addReference(120169, "&xopf;");
        html5References.addReference(120170, "&yopf;");
        html5References.addReference(120171, "&zopf;");

        /*
         * Initialization of escape levels.
         * Defined levels :
         *
         *    - Level 0 : Only markup-significant characters except the apostrophe (')
         *    - Level 1 : Only markup-significant characters (including the apostrophe)
         *    - Level 2 : Markup-significant characters plus all non-ASCII
         *    - Level 3 : All non-alphanumeric characters
         *    - Level 4 : All characters
         */
        final byte[] escapeLevels = new byte[0x7f + 2];
        Arrays.fill(escapeLevels, (byte)3);
        for (char c = 'A'; c <= 'Z'; c++) {
            escapeLevels[c] = 4;
        }
        for (char c = 'a'; c <= 'z'; c++) {
            escapeLevels[c] = 4;
        }
        for (char c = '0'; c <= '9'; c++) {
            escapeLevels[c] = 4;
        }
        escapeLevels['\''] = 1;
        escapeLevels['"'] = 0;
        escapeLevels['<'] = 0;
        escapeLevels['>'] = 0;
        escapeLevels['&'] = 0;
        escapeLevels[0x7f + 1] = 2;


        return new HtmlEscapeSymbols(html5References, escapeLevels);

    }



    private Html5EscapeSymbolsInitializer() {
        super();
    }

}

