/*
 * =======================================================================================
 *
 *      Filename:  perfmon_knl_counters.h
 *
 *      Description: Counter header file of perfmon module for Intel Atom (Silvermont)
 *
 *      Version:   5.2.1
 *      Released:  03.12.2021
 *
 *      Author:   Thomas Gruber (tr), thomas.roehl@googlemail.com
 *      Project:  likwid
 *
 *      Copyright (C) 2021 NHR@FAU, University Erlangen-Nuremberg
 *
 *      This program is free software: you can redistribute it and/or modify it under
 *      the terms of the GNU General Public License as published by the Free Software
 *      Foundation, either version 3 of the License, or (at your option) any later
 *      version.
 *
 *      This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *      WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *      PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along with
 *      this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * =======================================================================================
 */
#include <registers.h>

#define NUM_COUNTERS_CORE_KNL 6
#define NUM_COUNTERS_UNCORE_KNL 290
#define NUM_COUNTERS_KNL 294

#define KNL_VALID_OPTIONS_FIXED EVENT_OPTION_COUNT_KERNEL_MASK|EVENT_OPTION_ANYTHREAD_MASK
#define KNL_VALID_OPTIONS_PMC EVENT_OPTION_EDGE_MASK|EVENT_OPTION_COUNT_KERNEL_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_THRESHOLD_MASK
#define KNL_VALID_OPTIONS_UBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_TID_MASK
#define KNL_VALID_OPTIONS_CBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_TID_MASK
#define KNL_VALID_OPTIONS_WBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK|\
            EVENT_OPTION_OCCUPANCY_MASK|EVENT_OPTION_OCCUPANCY_FILTER_MASK|EVENT_OPTION_OCCUPANCY_EDGE_MASK|\
            EVENT_OPTION_OCCUPANCY_INVERT_MASK
#define KNL_VALID_OPTIONS_MBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define KNL_VALID_OPTIONS_EBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define KNL_VALID_OPTIONS_PBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define KNL_VALID_OPTIONS_IBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK

static RegisterMap knl_counter_map[NUM_COUNTERS_KNL] = {
    /* Fixed Counters: instructions retired, cycles unhalted core */
    {"FIXC0", PMC0, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR0, 0, 0, KNL_VALID_OPTIONS_FIXED},
    {"FIXC1", PMC1, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR1, 0, 0, KNL_VALID_OPTIONS_FIXED},
    {"FIXC2", PMC2, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR2, 0, 0, KNL_VALID_OPTIONS_FIXED},
    /* PMC Counters: 4 48bit wide */
    {"PMC0", PMC3, PMC, MSR_MIC2_PERFEVTSEL0, MSR_MIC2_PMC0, MSR_OFFCORE_RESP0, 0, KNL_VALID_OPTIONS_PMC},
    {"PMC1", PMC4, PMC, MSR_MIC2_PERFEVTSEL1, MSR_MIC2_PMC1, MSR_OFFCORE_RESP1, 0, KNL_VALID_OPTIONS_PMC},
    /* Temperature Sensor*/
    {"TMP0", PMC5, THERMAL, 0, IA32_THERM_STATUS, 0, 0},
    /* RAPL counters */
    {"PWR0", PMC6, POWER, 0, MSR_PKG_ENERGY_STATUS, 0, 0},
    {"PWR1", PMC7, POWER, 0, MSR_PP0_ENERGY_STATUS, 0, 0},
    {"PWR3", PMC8, POWER, 0, MSR_DRAM_ENERGY_STATUS, 0, 0},
    {"UBOX0", PMC9, UBOX, MSR_MIC2_U_CTRL0, MSR_MIC2_U_CTR0, 0, 0, KNL_VALID_OPTIONS_UBOX},
    {"UBOX1", PMC10, UBOX, MSR_MIC2_U_CTRL1, MSR_MIC2_U_CTR1, 0, 0, KNL_VALID_OPTIONS_UBOX},
    {"UBOXFIX", PMC11, UBOXFIX, MSR_MIC2_U_FIXED_CTRL, MSR_MIC2_U_FIXED_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"CBOX0C0", PMC12, CBOX0, MSR_MIC2_C0_CTRL0, MSR_MIC2_C0_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX0C1", PMC13, CBOX0, MSR_MIC2_C0_CTRL1, MSR_MIC2_C0_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX0C2", PMC14, CBOX0, MSR_MIC2_C0_CTRL2, MSR_MIC2_C0_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX0C3", PMC15, CBOX0, MSR_MIC2_C0_CTRL3, MSR_MIC2_C0_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX1C0", PMC16, CBOX1, MSR_MIC2_C1_CTRL0, MSR_MIC2_C1_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX1C1", PMC17, CBOX1, MSR_MIC2_C1_CTRL1, MSR_MIC2_C1_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX1C2", PMC18, CBOX1, MSR_MIC2_C1_CTRL2, MSR_MIC2_C1_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX1C3", PMC19, CBOX1, MSR_MIC2_C1_CTRL3, MSR_MIC2_C1_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX2C0", PMC20, CBOX2, MSR_MIC2_C2_CTRL0, MSR_MIC2_C2_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX2C1", PMC21, CBOX2, MSR_MIC2_C2_CTRL1, MSR_MIC2_C2_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX2C2", PMC22, CBOX2, MSR_MIC2_C2_CTRL2, MSR_MIC2_C2_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX2C3", PMC23, CBOX2, MSR_MIC2_C2_CTRL3, MSR_MIC2_C2_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX3C0", PMC24, CBOX3, MSR_MIC2_C3_CTRL0, MSR_MIC2_C3_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX3C1", PMC25, CBOX3, MSR_MIC2_C3_CTRL1, MSR_MIC2_C3_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX3C2", PMC26, CBOX3, MSR_MIC2_C3_CTRL2, MSR_MIC2_C3_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX3C3", PMC27, CBOX3, MSR_MIC2_C3_CTRL3, MSR_MIC2_C3_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX4C0", PMC28, CBOX4, MSR_MIC2_C4_CTRL0, MSR_MIC2_C4_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX4C1", PMC29, CBOX4, MSR_MIC2_C4_CTRL1, MSR_MIC2_C4_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX4C2", PMC30, CBOX4, MSR_MIC2_C4_CTRL2, MSR_MIC2_C4_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX4C3", PMC31, CBOX4, MSR_MIC2_C4_CTRL3, MSR_MIC2_C4_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX5C0", PMC32, CBOX5, MSR_MIC2_C5_CTRL0, MSR_MIC2_C5_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX5C1", PMC33, CBOX5, MSR_MIC2_C5_CTRL1, MSR_MIC2_C5_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX5C2", PMC34, CBOX5, MSR_MIC2_C5_CTRL2, MSR_MIC2_C5_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX5C3", PMC35, CBOX5, MSR_MIC2_C5_CTRL3, MSR_MIC2_C5_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX6C0", PMC36, CBOX6, MSR_MIC2_C6_CTRL0, MSR_MIC2_C6_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX6C1", PMC37, CBOX6, MSR_MIC2_C6_CTRL1, MSR_MIC2_C6_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX6C2", PMC38, CBOX6, MSR_MIC2_C6_CTRL2, MSR_MIC2_C6_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX6C3", PMC39, CBOX6, MSR_MIC2_C6_CTRL3, MSR_MIC2_C6_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX7C0", PMC40, CBOX7, MSR_MIC2_C7_CTRL0, MSR_MIC2_C7_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX7C1", PMC41, CBOX7, MSR_MIC2_C7_CTRL1, MSR_MIC2_C7_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX7C2", PMC42, CBOX7, MSR_MIC2_C7_CTRL2, MSR_MIC2_C7_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX7C3", PMC43, CBOX7, MSR_MIC2_C7_CTRL3, MSR_MIC2_C7_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX8C0", PMC44, CBOX8, MSR_MIC2_C8_CTRL0, MSR_MIC2_C8_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX8C1", PMC45, CBOX8, MSR_MIC2_C8_CTRL1, MSR_MIC2_C8_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX8C2", PMC46, CBOX8, MSR_MIC2_C8_CTRL2, MSR_MIC2_C8_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX8C3", PMC47, CBOX8, MSR_MIC2_C8_CTRL3, MSR_MIC2_C8_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX9C0", PMC48, CBOX9, MSR_MIC2_C9_CTRL0, MSR_MIC2_C9_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX9C1", PMC49, CBOX9, MSR_MIC2_C9_CTRL1, MSR_MIC2_C9_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX9C2", PMC50, CBOX9, MSR_MIC2_C9_CTRL2, MSR_MIC2_C9_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX9C3", PMC51, CBOX9, MSR_MIC2_C9_CTRL3, MSR_MIC2_C9_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX10C0", PMC52, CBOX10, MSR_MIC2_C10_CTRL0, MSR_MIC2_C10_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX10C1", PMC53, CBOX10, MSR_MIC2_C10_CTRL1, MSR_MIC2_C10_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX10C2", PMC54, CBOX10, MSR_MIC2_C10_CTRL2, MSR_MIC2_C10_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX10C3", PMC55, CBOX10, MSR_MIC2_C10_CTRL3, MSR_MIC2_C10_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX11C0", PMC56, CBOX11, MSR_MIC2_C11_CTRL0, MSR_MIC2_C11_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX11C1", PMC57, CBOX11, MSR_MIC2_C11_CTRL1, MSR_MIC2_C11_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX11C2", PMC58, CBOX11, MSR_MIC2_C11_CTRL2, MSR_MIC2_C11_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX11C3", PMC59, CBOX11, MSR_MIC2_C11_CTRL3, MSR_MIC2_C11_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX12C0", PMC60, CBOX12, MSR_MIC2_C12_CTRL0, MSR_MIC2_C12_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX12C1", PMC61, CBOX12, MSR_MIC2_C12_CTRL1, MSR_MIC2_C12_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX12C2", PMC62, CBOX12, MSR_MIC2_C12_CTRL2, MSR_MIC2_C12_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX12C3", PMC63, CBOX12, MSR_MIC2_C12_CTRL3, MSR_MIC2_C12_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX13C0", PMC64, CBOX13, MSR_MIC2_C13_CTRL0, MSR_MIC2_C13_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX13C1", PMC65, CBOX13, MSR_MIC2_C13_CTRL1, MSR_MIC2_C13_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX13C2", PMC66, CBOX13, MSR_MIC2_C13_CTRL2, MSR_MIC2_C13_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX13C3", PMC67, CBOX13, MSR_MIC2_C13_CTRL3, MSR_MIC2_C13_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX14C0", PMC68, CBOX14, MSR_MIC2_C14_CTRL0, MSR_MIC2_C14_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX14C1", PMC69, CBOX14, MSR_MIC2_C14_CTRL1, MSR_MIC2_C14_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX14C2", PMC70, CBOX14, MSR_MIC2_C14_CTRL2, MSR_MIC2_C14_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX14C3", PMC71, CBOX14, MSR_MIC2_C14_CTRL3, MSR_MIC2_C14_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX15C0", PMC72, CBOX15, MSR_MIC2_C15_CTRL0, MSR_MIC2_C15_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX15C1", PMC73, CBOX15, MSR_MIC2_C15_CTRL1, MSR_MIC2_C15_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX15C2", PMC74, CBOX15, MSR_MIC2_C15_CTRL2, MSR_MIC2_C15_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX15C3", PMC75, CBOX15, MSR_MIC2_C15_CTRL3, MSR_MIC2_C15_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX16C0", PMC76, CBOX16, MSR_MIC2_C16_CTRL0, MSR_MIC2_C16_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX16C1", PMC77, CBOX16, MSR_MIC2_C16_CTRL1, MSR_MIC2_C16_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX16C2", PMC78, CBOX16, MSR_MIC2_C16_CTRL2, MSR_MIC2_C16_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX16C3", PMC79, CBOX16, MSR_MIC2_C16_CTRL3, MSR_MIC2_C16_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX17C0", PMC80, CBOX17, MSR_MIC2_C17_CTRL0, MSR_MIC2_C17_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX17C1", PMC81, CBOX17, MSR_MIC2_C17_CTRL1, MSR_MIC2_C17_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX17C2", PMC82, CBOX17, MSR_MIC2_C17_CTRL2, MSR_MIC2_C17_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX17C3", PMC83, CBOX17, MSR_MIC2_C17_CTRL3, MSR_MIC2_C17_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX18C0", PMC84, CBOX18, MSR_MIC2_C18_CTRL0, MSR_MIC2_C18_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX18C1", PMC85, CBOX18, MSR_MIC2_C18_CTRL1, MSR_MIC2_C18_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX18C2", PMC86, CBOX18, MSR_MIC2_C18_CTRL2, MSR_MIC2_C18_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX18C3", PMC87, CBOX18, MSR_MIC2_C18_CTRL3, MSR_MIC2_C18_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX19C0", PMC88, CBOX19, MSR_MIC2_C19_CTRL0, MSR_MIC2_C19_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX19C1", PMC89, CBOX19, MSR_MIC2_C19_CTRL1, MSR_MIC2_C19_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX19C2", PMC90, CBOX19, MSR_MIC2_C19_CTRL2, MSR_MIC2_C19_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX19C3", PMC91, CBOX19, MSR_MIC2_C19_CTRL3, MSR_MIC2_C19_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX20C0", PMC92, CBOX20, MSR_MIC2_C20_CTRL0, MSR_MIC2_C20_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX20C1", PMC93, CBOX20, MSR_MIC2_C20_CTRL1, MSR_MIC2_C20_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX20C2", PMC94, CBOX20, MSR_MIC2_C20_CTRL2, MSR_MIC2_C20_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX20C3", PMC95, CBOX20, MSR_MIC2_C20_CTRL3, MSR_MIC2_C20_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX21C0", PMC96, CBOX21, MSR_MIC2_C21_CTRL0, MSR_MIC2_C21_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX21C1", PMC97, CBOX21, MSR_MIC2_C21_CTRL1, MSR_MIC2_C21_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX21C2", PMC98, CBOX21, MSR_MIC2_C21_CTRL2, MSR_MIC2_C21_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX21C3", PMC99, CBOX21, MSR_MIC2_C21_CTRL3, MSR_MIC2_C21_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX22C0", PMC100, CBOX22, MSR_MIC2_C22_CTRL0, MSR_MIC2_C22_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX22C1", PMC101, CBOX22, MSR_MIC2_C22_CTRL1, MSR_MIC2_C22_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX22C2", PMC102, CBOX22, MSR_MIC2_C22_CTRL2, MSR_MIC2_C22_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX22C3", PMC103, CBOX22, MSR_MIC2_C22_CTRL3, MSR_MIC2_C22_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX23C0", PMC104, CBOX23, MSR_MIC2_C23_CTRL0, MSR_MIC2_C23_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX23C1", PMC105, CBOX23, MSR_MIC2_C23_CTRL1, MSR_MIC2_C23_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX23C2", PMC106, CBOX23, MSR_MIC2_C23_CTRL2, MSR_MIC2_C23_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX23C3", PMC107, CBOX23, MSR_MIC2_C23_CTRL3, MSR_MIC2_C23_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX24C0", PMC108, CBOX24, MSR_MIC2_C24_CTRL0, MSR_MIC2_C24_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX24C1", PMC109, CBOX24, MSR_MIC2_C24_CTRL1, MSR_MIC2_C24_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX24C2", PMC110, CBOX24, MSR_MIC2_C24_CTRL2, MSR_MIC2_C24_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX24C3", PMC111, CBOX24, MSR_MIC2_C24_CTRL3, MSR_MIC2_C24_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX25C0", PMC112, CBOX25, MSR_MIC2_C25_CTRL0, MSR_MIC2_C25_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX25C1", PMC113, CBOX25, MSR_MIC2_C25_CTRL1, MSR_MIC2_C25_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX25C2", PMC114, CBOX25, MSR_MIC2_C25_CTRL2, MSR_MIC2_C25_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX25C3", PMC115, CBOX25, MSR_MIC2_C25_CTRL3, MSR_MIC2_C25_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX26C0", PMC116, CBOX26, MSR_MIC2_C26_CTRL0, MSR_MIC2_C26_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX26C1", PMC117, CBOX26, MSR_MIC2_C26_CTRL1, MSR_MIC2_C26_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX26C2", PMC118, CBOX26, MSR_MIC2_C26_CTRL2, MSR_MIC2_C26_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX26C3", PMC119, CBOX26, MSR_MIC2_C26_CTRL3, MSR_MIC2_C26_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX27C0", PMC120, CBOX27, MSR_MIC2_C27_CTRL0, MSR_MIC2_C27_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX27C1", PMC121, CBOX27, MSR_MIC2_C27_CTRL1, MSR_MIC2_C27_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX27C2", PMC122, CBOX27, MSR_MIC2_C27_CTRL2, MSR_MIC2_C27_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX27C3", PMC123, CBOX27, MSR_MIC2_C27_CTRL3, MSR_MIC2_C27_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX28C0", PMC124, CBOX28, MSR_MIC2_C28_CTRL0, MSR_MIC2_C28_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX28C1", PMC125, CBOX28, MSR_MIC2_C28_CTRL1, MSR_MIC2_C28_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX28C2", PMC126, CBOX28, MSR_MIC2_C28_CTRL2, MSR_MIC2_C28_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX28C3", PMC127, CBOX28, MSR_MIC2_C28_CTRL3, MSR_MIC2_C28_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX29C0", PMC128, CBOX29, MSR_MIC2_C29_CTRL0, MSR_MIC2_C29_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX29C1", PMC129, CBOX29, MSR_MIC2_C29_CTRL1, MSR_MIC2_C29_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX29C2", PMC130, CBOX29, MSR_MIC2_C29_CTRL2, MSR_MIC2_C29_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX29C3", PMC131, CBOX29, MSR_MIC2_C29_CTRL3, MSR_MIC2_C29_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX30C0", PMC132, CBOX30, MSR_MIC2_C30_CTRL0, MSR_MIC2_C30_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX30C1", PMC133, CBOX30, MSR_MIC2_C30_CTRL1, MSR_MIC2_C30_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX30C2", PMC134, CBOX30, MSR_MIC2_C30_CTRL2, MSR_MIC2_C30_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX30C3", PMC135, CBOX30, MSR_MIC2_C30_CTRL3, MSR_MIC2_C30_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX31C0", PMC136, CBOX31, MSR_MIC2_C31_CTRL0, MSR_MIC2_C31_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX31C1", PMC137, CBOX31, MSR_MIC2_C31_CTRL1, MSR_MIC2_C31_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX31C2", PMC138, CBOX31, MSR_MIC2_C31_CTRL2, MSR_MIC2_C31_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX31C3", PMC139, CBOX31, MSR_MIC2_C31_CTRL3, MSR_MIC2_C31_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX32C0", PMC140, CBOX32, MSR_MIC2_C32_CTRL0, MSR_MIC2_C32_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX32C1", PMC141, CBOX32, MSR_MIC2_C32_CTRL1, MSR_MIC2_C32_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX32C2", PMC142, CBOX32, MSR_MIC2_C32_CTRL2, MSR_MIC2_C32_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX32C3", PMC143, CBOX32, MSR_MIC2_C32_CTRL3, MSR_MIC2_C32_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX33C0", PMC144, CBOX33, MSR_MIC2_C33_CTRL0, MSR_MIC2_C33_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX33C1", PMC145, CBOX33, MSR_MIC2_C33_CTRL1, MSR_MIC2_C33_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX33C2", PMC146, CBOX33, MSR_MIC2_C33_CTRL2, MSR_MIC2_C33_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX33C3", PMC147, CBOX33, MSR_MIC2_C33_CTRL3, MSR_MIC2_C33_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX34C0", PMC148, CBOX34, MSR_MIC2_C34_CTRL0, MSR_MIC2_C34_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX34C1", PMC149, CBOX34, MSR_MIC2_C34_CTRL1, MSR_MIC2_C34_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX34C2", PMC150, CBOX34, MSR_MIC2_C34_CTRL2, MSR_MIC2_C34_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX34C3", PMC151, CBOX34, MSR_MIC2_C34_CTRL3, MSR_MIC2_C34_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX35C0", PMC152, CBOX35, MSR_MIC2_C35_CTRL0, MSR_MIC2_C35_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX35C1", PMC153, CBOX35, MSR_MIC2_C35_CTRL1, MSR_MIC2_C35_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX35C2", PMC154, CBOX35, MSR_MIC2_C35_CTRL2, MSR_MIC2_C35_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX35C3", PMC155, CBOX35, MSR_MIC2_C35_CTRL3, MSR_MIC2_C35_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX36C0", PMC156, CBOX36, MSR_MIC2_C36_CTRL0, MSR_MIC2_C36_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX36C1", PMC157, CBOX36, MSR_MIC2_C36_CTRL1, MSR_MIC2_C36_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX36C2", PMC158, CBOX36, MSR_MIC2_C36_CTRL2, MSR_MIC2_C36_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX36C3", PMC159, CBOX36, MSR_MIC2_C36_CTRL3, MSR_MIC2_C36_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX37C0", PMC160, CBOX37, MSR_MIC2_C37_CTRL0, MSR_MIC2_C37_CTR0, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX37C1", PMC161, CBOX37, MSR_MIC2_C37_CTRL1, MSR_MIC2_C37_CTR1, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX37C2", PMC162, CBOX37, MSR_MIC2_C37_CTRL2, MSR_MIC2_C37_CTR2, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"CBOX37C3", PMC163, CBOX37, MSR_MIC2_C37_CTRL3, MSR_MIC2_C37_CTR3, 0, 0, KNL_VALID_OPTIONS_CBOX},
    {"WBOX0", PMC164, WBOX, MSR_MIC2_PCU_CTRL0, MSR_MIC2_PCU_CTR0, 0, 0, KNL_VALID_OPTIONS_WBOX},
    {"WBOX1", PMC165, WBOX, MSR_MIC2_PCU_CTRL1, MSR_MIC2_PCU_CTR1, 0, 0, KNL_VALID_OPTIONS_WBOX},
    {"WBOX2", PMC166, WBOX, MSR_MIC2_PCU_CTRL2, MSR_MIC2_PCU_CTR2, 0, 0, KNL_VALID_OPTIONS_WBOX},
    {"WBOX3", PMC167, WBOX, MSR_MIC2_PCU_CTRL3, MSR_MIC2_PCU_CTR3, 0, 0, KNL_VALID_OPTIONS_WBOX},
    {"MBOX0C0", PMC168, MBOX0, PCI_MIC2_MC_D_CTRL0, PCI_MIC2_MC_D_CTR0_A, PCI_MIC2_MC_D_CTR0_B, PCI_IMC_DEVICE_0_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX0C1", PMC169, MBOX0, PCI_MIC2_MC_D_CTRL1, PCI_MIC2_MC_D_CTR1_A, PCI_MIC2_MC_D_CTR1_B, PCI_IMC_DEVICE_0_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX0C2", PMC170, MBOX0, PCI_MIC2_MC_D_CTRL2, PCI_MIC2_MC_D_CTR2_A, PCI_MIC2_MC_D_CTR2_B, PCI_IMC_DEVICE_0_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX0C3", PMC171, MBOX0, PCI_MIC2_MC_D_CTRL3, PCI_MIC2_MC_D_CTR3_A, PCI_MIC2_MC_D_CTR3_B, PCI_IMC_DEVICE_0_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX0FIX", PMC172, MBOX0FIX, PCI_MIC2_MC_D_FIXED_CTRL, PCI_MIC2_MC_D_FIXED_CTR_A, PCI_MIC2_MC_D_FIXED_CTR_B, PCI_IMC_DEVICE_0_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX1C0", PMC173, MBOX1, PCI_MIC2_MC_D_CTRL0, PCI_MIC2_MC_D_CTR0_A, PCI_MIC2_MC_D_CTR0_B, PCI_IMC_DEVICE_0_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX1C1", PMC174, MBOX1, PCI_MIC2_MC_D_CTRL1, PCI_MIC2_MC_D_CTR1_A, PCI_MIC2_MC_D_CTR1_B, PCI_IMC_DEVICE_0_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX1C2", PMC175, MBOX1, PCI_MIC2_MC_D_CTRL2, PCI_MIC2_MC_D_CTR2_A, PCI_MIC2_MC_D_CTR2_B, PCI_IMC_DEVICE_0_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX1C3", PMC176, MBOX1, PCI_MIC2_MC_D_CTRL3, PCI_MIC2_MC_D_CTR3_A, PCI_MIC2_MC_D_CTR3_B, PCI_IMC_DEVICE_0_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX1FIX", PMC177, MBOX1FIX, PCI_MIC2_MC_D_FIXED_CTRL, PCI_MIC2_MC_D_FIXED_CTR_A, PCI_MIC2_MC_D_FIXED_CTR_B, PCI_IMC_DEVICE_0_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX2C0", PMC178, MBOX2, PCI_MIC2_MC_D_CTRL0, PCI_MIC2_MC_D_CTR0_A, PCI_MIC2_MC_D_CTR0_B, PCI_IMC_DEVICE_0_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX2C1", PMC179, MBOX2, PCI_MIC2_MC_D_CTRL1, PCI_MIC2_MC_D_CTR1_A, PCI_MIC2_MC_D_CTR1_B, PCI_IMC_DEVICE_0_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX2C2", PMC180, MBOX2, PCI_MIC2_MC_D_CTRL2, PCI_MIC2_MC_D_CTR2_A, PCI_MIC2_MC_D_CTR2_B, PCI_IMC_DEVICE_0_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX2C3", PMC181, MBOX2, PCI_MIC2_MC_D_CTRL3, PCI_MIC2_MC_D_CTR3_A, PCI_MIC2_MC_D_CTR3_B, PCI_IMC_DEVICE_0_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX2FIX", PMC182, MBOX2FIX, PCI_MIC2_MC_D_FIXED_CTRL, PCI_MIC2_MC_D_FIXED_CTR_A, PCI_MIC2_MC_D_FIXED_CTR_B, PCI_IMC_DEVICE_0_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX3C0", PMC183, MBOX3, PCI_MIC2_MC_U_CTRL0, PCI_MIC2_MC_U_CTR0_A, PCI_MIC2_MC_U_CTR0_B, PCI_IMC_DEVICE_0_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX3C1", PMC184, MBOX3, PCI_MIC2_MC_U_CTRL1, PCI_MIC2_MC_U_CTR1_A, PCI_MIC2_MC_U_CTR1_B, PCI_IMC_DEVICE_0_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX3C2", PMC185, MBOX3, PCI_MIC2_MC_U_CTRL2, PCI_MIC2_MC_U_CTR2_A, PCI_MIC2_MC_U_CTR2_B, PCI_IMC_DEVICE_0_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX3C3", PMC186, MBOX3, PCI_MIC2_MC_U_CTRL3, PCI_MIC2_MC_U_CTR3_A, PCI_MIC2_MC_U_CTR3_B, PCI_IMC_DEVICE_0_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX3FIX", PMC187, MBOX3FIX, PCI_MIC2_MC_U_FIXED_CTRL, PCI_MIC2_MC_U_FIXED_CTR_A, PCI_MIC2_MC_U_FIXED_CTR_B, PCI_IMC_DEVICE_0_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX4C0", PMC188, MBOX4, PCI_MIC2_MC_D_CTRL0, PCI_MIC2_MC_D_CTR0_A, PCI_MIC2_MC_D_CTR0_B, PCI_IMC_DEVICE_1_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX4C1", PMC189, MBOX4, PCI_MIC2_MC_D_CTRL1, PCI_MIC2_MC_D_CTR1_A, PCI_MIC2_MC_D_CTR1_B, PCI_IMC_DEVICE_1_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX4C2", PMC190, MBOX4, PCI_MIC2_MC_D_CTRL2, PCI_MIC2_MC_D_CTR2_A, PCI_MIC2_MC_D_CTR2_B, PCI_IMC_DEVICE_1_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX4C3", PMC191, MBOX4, PCI_MIC2_MC_D_CTRL3, PCI_MIC2_MC_D_CTR3_A, PCI_MIC2_MC_D_CTR3_B, PCI_IMC_DEVICE_1_CH_0, KNL_VALID_OPTIONS_MBOX},
    {"MBOX4FIX", PMC192, MBOX4FIX, PCI_MIC2_MC_D_FIXED_CTRL, PCI_MIC2_MC_D_FIXED_CTR_A, PCI_MIC2_MC_D_FIXED_CTR_B, PCI_IMC_DEVICE_1_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX5C0", PMC193, MBOX5, PCI_MIC2_MC_D_CTRL0, PCI_MIC2_MC_D_CTR0_A, PCI_MIC2_MC_D_CTR0_B, PCI_IMC_DEVICE_1_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX5C1", PMC194, MBOX5, PCI_MIC2_MC_D_CTRL1, PCI_MIC2_MC_D_CTR1_A, PCI_MIC2_MC_D_CTR1_B, PCI_IMC_DEVICE_1_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX5C2", PMC195, MBOX5, PCI_MIC2_MC_D_CTRL2, PCI_MIC2_MC_D_CTR2_A, PCI_MIC2_MC_D_CTR2_B, PCI_IMC_DEVICE_1_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX5C3", PMC196, MBOX5, PCI_MIC2_MC_D_CTRL3, PCI_MIC2_MC_D_CTR3_A, PCI_MIC2_MC_D_CTR3_B, PCI_IMC_DEVICE_1_CH_1, KNL_VALID_OPTIONS_MBOX},
    {"MBOX5FIX", PMC197, MBOX5FIX, PCI_MIC2_MC_D_FIXED_CTRL, PCI_MIC2_MC_D_FIXED_CTR_A, PCI_MIC2_MC_D_FIXED_CTR_B, PCI_IMC_DEVICE_1_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX6C0", PMC198, MBOX6, PCI_MIC2_MC_D_CTRL0, PCI_MIC2_MC_D_CTR0_A, PCI_MIC2_MC_D_CTR0_B, PCI_IMC_DEVICE_1_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX6C1", PMC199, MBOX6, PCI_MIC2_MC_D_CTRL1, PCI_MIC2_MC_D_CTR1_A, PCI_MIC2_MC_D_CTR1_B, PCI_IMC_DEVICE_1_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX6C2", PMC200, MBOX6, PCI_MIC2_MC_D_CTRL2, PCI_MIC2_MC_D_CTR2_A, PCI_MIC2_MC_D_CTR2_B, PCI_IMC_DEVICE_1_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX6C3", PMC201, MBOX6, PCI_MIC2_MC_D_CTRL3, PCI_MIC2_MC_D_CTR3_A, PCI_MIC2_MC_D_CTR3_B, PCI_IMC_DEVICE_1_CH_2, KNL_VALID_OPTIONS_MBOX},
    {"MBOX6FIX", PMC202, MBOX6FIX, PCI_MIC2_MC_D_FIXED_CTRL, PCI_MIC2_MC_D_FIXED_CTR_A, PCI_MIC2_MC_D_FIXED_CTR_B, PCI_IMC_DEVICE_1_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX7C0", PMC203, MBOX7, PCI_MIC2_MC_U_CTRL0, PCI_MIC2_MC_U_CTR0_A, PCI_MIC2_MC_U_CTR0_B, PCI_IMC_DEVICE_1_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX7C1", PMC204, MBOX7, PCI_MIC2_MC_U_CTRL1, PCI_MIC2_MC_U_CTR1_A, PCI_MIC2_MC_U_CTR1_B, PCI_IMC_DEVICE_1_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX7C2", PMC205, MBOX7, PCI_MIC2_MC_U_CTRL2, PCI_MIC2_MC_U_CTR2_A, PCI_MIC2_MC_U_CTR2_B, PCI_IMC_DEVICE_1_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX7C3", PMC206, MBOX7, PCI_MIC2_MC_U_CTRL3, PCI_MIC2_MC_U_CTR3_A, PCI_MIC2_MC_U_CTR3_B, PCI_IMC_DEVICE_1_CH_3, KNL_VALID_OPTIONS_MBOX},
    {"MBOX7FIX", PMC207, MBOX7FIX, PCI_MIC2_MC_U_FIXED_CTRL, PCI_MIC2_MC_U_FIXED_CTR_A, PCI_MIC2_MC_U_FIXED_CTR_B, PCI_IMC_DEVICE_1_CH_3, EVENT_OPTION_NONE_MASK},
    {"EUBOX0C0", PMC208, EUBOX0, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC0_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX0C1", PMC209, EUBOX0, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC0_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX0C2", PMC210, EUBOX0, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC0_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX0C3", PMC211, EUBOX0, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC0_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX0FIX", PMC212, EUBOX0FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC0_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX0C0", PMC213, EDBOX0, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC0_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX0C1", PMC214, EDBOX0, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC0_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX0C2", PMC215, EDBOX0, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC0_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX0C3", PMC216, EDBOX0, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC0_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX0FIX", PMC217, EDBOX0FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC0_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EUBOX1C0", PMC218, EUBOX1, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC1_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX1C1", PMC219, EUBOX1, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC1_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX1C2", PMC220, EUBOX1, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC1_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX1C3", PMC221, EUBOX1, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC1_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX1FIX", PMC222, EUBOX1FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC1_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX1C0", PMC223, EDBOX1, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC1_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX1C1", PMC224, EDBOX1, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC1_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX1C2", PMC225, EDBOX1, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC1_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX1C3", PMC226, EDBOX1, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC1_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX1FIX", PMC227, EDBOX1FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC1_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EUBOX2C0", PMC228, EUBOX2, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC2_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX2C1", PMC229, EUBOX2, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC2_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX2C2", PMC230, EUBOX2, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC2_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX2C3", PMC231, EUBOX2, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC2_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX2FIX", PMC232, EUBOX2FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC2_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX2C0", PMC233, EDBOX2, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC2_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX2C1", PMC234, EDBOX2, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC2_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX2C2", PMC235, EDBOX2, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC2_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX2C3", PMC236, EDBOX2, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC2_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX2FIX", PMC237, EDBOX2FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC2_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EUBOX3C0", PMC238, EUBOX3, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC3_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX3C1", PMC239, EUBOX3, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC3_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX3C2", PMC240, EUBOX3, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC3_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX3C3", PMC241, EUBOX3, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC3_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX3FIX", PMC242, EUBOX3FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC3_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX3C0", PMC243, EDBOX3, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC3_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX3C1", PMC244, EDBOX3, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC3_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX3C2", PMC245, EDBOX3, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC3_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX3C3", PMC246, EDBOX3, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC3_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX3FIX", PMC247, EDBOX3FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC3_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EUBOX4C0", PMC248, EUBOX4, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC4_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX4C1", PMC249, EUBOX4, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC4_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX4C2", PMC250, EUBOX4, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC4_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX4C3", PMC251, EUBOX4, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC4_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX4FIX", PMC252, EUBOX4FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC4_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX4C0", PMC253, EDBOX4, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC4_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX4C1", PMC254, EDBOX4, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC4_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX4C2", PMC255, EDBOX4, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC4_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX4C3", PMC256, EDBOX4, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC4_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX4FIX", PMC257, EDBOX4FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC4_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EUBOX5C0", PMC258, EUBOX5, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC5_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX5C1", PMC259, EUBOX5, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC5_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX5C2", PMC260, EUBOX5, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC5_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX5C3", PMC261, EUBOX5, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC5_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX5FIX", PMC262, EUBOX5FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC5_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX5C0", PMC263, EDBOX5, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC5_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX5C1", PMC264, EDBOX5, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC5_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX5C2", PMC265, EDBOX5, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC5_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX5C3", PMC266, EDBOX5, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC5_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX5FIX", PMC267, EDBOX5FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC5_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EUBOX6C0", PMC268, EUBOX6, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC6_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX6C1", PMC269, EUBOX6, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC6_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX6C2", PMC270, EUBOX6, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC6_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX6C3", PMC271, EUBOX6, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC6_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX6FIX", PMC272, EUBOX6FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC6_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX6C0", PMC273, EDBOX6, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC6_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX6C1", PMC274, EDBOX6, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC6_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX6C2", PMC275, EDBOX6, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC6_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX6C3", PMC276, EDBOX6, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC6_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX6FIX", PMC277, EDBOX6FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC6_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EUBOX7C0", PMC278, EUBOX7, PCI_MIC2_EDC_U_CTRL0, PCI_MIC2_EDC_U_CTR0_A, PCI_MIC2_EDC_U_CTR0_B, PCI_EDC7_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX7C1", PMC279, EUBOX7, PCI_MIC2_EDC_U_CTRL1, PCI_MIC2_EDC_U_CTR1_A, PCI_MIC2_EDC_U_CTR1_B, PCI_EDC7_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX7C2", PMC280, EUBOX7, PCI_MIC2_EDC_U_CTRL2, PCI_MIC2_EDC_U_CTR2_A, PCI_MIC2_EDC_U_CTR2_B, PCI_EDC7_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX7C3", PMC281, EUBOX7, PCI_MIC2_EDC_U_CTRL3, PCI_MIC2_EDC_U_CTR3_A, PCI_MIC2_EDC_U_CTR3_B, PCI_EDC7_UCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EUBOX7FIX", PMC282, EUBOX7FIX, PCI_MIC2_EDC_U_FIXED_CTRL, PCI_MIC2_EDC_U_FIXED_CTR_A, PCI_MIC2_EDC_U_FIXED_CTR_B, PCI_EDC7_UCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"EDBOX7C0", PMC283, EDBOX7, PCI_MIC2_EDC_D_CTRL0, PCI_MIC2_EDC_D_CTR0_A, PCI_MIC2_EDC_D_CTR0_B, PCI_EDC7_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX7C1", PMC284, EDBOX7, PCI_MIC2_EDC_D_CTRL1, PCI_MIC2_EDC_D_CTR1_A, PCI_MIC2_EDC_D_CTR1_B, PCI_EDC7_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX7C2", PMC285, EDBOX7, PCI_MIC2_EDC_D_CTRL2, PCI_MIC2_EDC_D_CTR2_A, PCI_MIC2_EDC_D_CTR2_B, PCI_EDC7_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX7C3", PMC286, EDBOX7, PCI_MIC2_EDC_D_CTRL3, PCI_MIC2_EDC_D_CTR3_A, PCI_MIC2_EDC_D_CTR3_B, PCI_EDC7_DCLK_DEVICE, KNL_VALID_OPTIONS_EBOX},
    {"EDBOX7FIX", PMC287, EDBOX7FIX, PCI_MIC2_EDC_D_FIXED_CTRL, PCI_MIC2_EDC_D_FIXED_CTR_A, PCI_MIC2_EDC_D_FIXED_CTR_B, PCI_EDC7_DCLK_DEVICE, EVENT_OPTION_NONE_MASK},
    {"PBOX0", PMC288, PBOX, PCI_MIC2_M2PCIE_CTRL0, PCI_MIC2_M2PCIE_CTR0_A, PCI_MIC2_M2PCIE_CTR0_B, PCI_R2PCIE_DEVICE, KNL_VALID_OPTIONS_PBOX},
    {"PBOX1", PMC289, PBOX, PCI_MIC2_M2PCIE_CTRL1, PCI_MIC2_M2PCIE_CTR1_A, PCI_MIC2_M2PCIE_CTR1_B, PCI_R2PCIE_DEVICE, KNL_VALID_OPTIONS_PBOX},
    {"PBOX2", PMC290, PBOX, PCI_MIC2_M2PCIE_CTRL2, PCI_MIC2_M2PCIE_CTR2_A, PCI_MIC2_M2PCIE_CTR2_B, PCI_R2PCIE_DEVICE, KNL_VALID_OPTIONS_PBOX},
    {"PBOX3", PMC291, PBOX, PCI_MIC2_M2PCIE_CTRL3, PCI_MIC2_M2PCIE_CTR3_A, PCI_MIC2_M2PCIE_CTR3_B, PCI_R2PCIE_DEVICE, KNL_VALID_OPTIONS_PBOX},
    {"IBOX0", PMC292, IBOX0, PCI_MIC2_IRP_CTRL0, PCI_MIC2_IRP_CTR0, 0, PCI_IRP_DEVICE, KNL_VALID_OPTIONS_IBOX},
    {"IBOX1", PMC293, IBOX0, PCI_MIC2_IRP_CTRL1, PCI_MIC2_IRP_CTR1, 0, PCI_IRP_DEVICE, KNL_VALID_OPTIONS_IBOX},
};

static BoxMap knl_box_map[NUM_UNITS] = {
    [PMC] = {MSR_PERF_GLOBAL_CTRL, MSR_PERF_GLOBAL_STATUS, MSR_PERF_GLOBAL_OVF_CTRL, -1, 0, 0, 48},
    [FIXED] = {MSR_PERF_GLOBAL_CTRL, MSR_PERF_GLOBAL_STATUS, MSR_PERF_GLOBAL_OVF_CTRL, -1, 0, 0, 48},
    [THERMAL] = {0, 0, 0, 0, 0, MSR_DEV, 8},
    [POWER] = {0, 0, 0, 0, 0, MSR_DEV, 32},
    [UBOX] = {MSR_MIC2_U_GLOBAL_CTRL, MSR_MIC2_U_GLOBAL_STATUS, MSR_MIC2_U_GLOBAL_STATUS, 1, 0, 0, 48},
    [UBOXFIX] = {MSR_MIC2_U_GLOBAL_CTRL, MSR_MIC2_U_GLOBAL_STATUS, MSR_MIC2_U_GLOBAL_STATUS, 0, 0, 0, 48},
    [CBOX0] = {MSR_MIC2_C0_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 3, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX1] = {MSR_MIC2_C1_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 4, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX2] = {MSR_MIC2_C2_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 5, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX3] = {MSR_MIC2_C3_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 6, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX4] = {MSR_MIC2_C4_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 7, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX5] = {MSR_MIC2_C5_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 8, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX6] = {MSR_MIC2_C6_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 9, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX7] = {MSR_MIC2_C7_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 10, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX8] = {MSR_MIC2_C8_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 11, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX9] = {MSR_MIC2_C9_GLOBAL_CTRL, MSR_MIC2_C0_STATUS, MSR_MIC2_C0_STATUS, 12, 0, 0, 48, MSR_MIC2_C0_FILTER0, MSR_MIC2_C0_FILTER1},
    [CBOX10] = {MSR_MIC2_C10_GLOBAL_CTRL, MSR_MIC2_C10_STATUS, MSR_MIC2_C10_STATUS, 13, 0, 0, 48, MSR_MIC2_C10_FILTER0, MSR_MIC2_C10_FILTER1},
    [CBOX11] = {MSR_MIC2_C11_GLOBAL_CTRL, MSR_MIC2_C11_STATUS, MSR_MIC2_C11_STATUS, 14, 0, 0, 48, MSR_MIC2_C11_FILTER0, MSR_MIC2_C11_FILTER1},
    [CBOX12] = {MSR_MIC2_C12_GLOBAL_CTRL, MSR_MIC2_C12_STATUS, MSR_MIC2_C12_STATUS, 15, 0, 0, 48, MSR_MIC2_C12_FILTER0, MSR_MIC2_C12_FILTER1},
    [CBOX13] = {MSR_MIC2_C13_GLOBAL_CTRL, MSR_MIC2_C13_STATUS, MSR_MIC2_C13_STATUS, 16, 0, 0, 48, MSR_MIC2_C13_FILTER0, MSR_MIC2_C13_FILTER1},
    [CBOX14] = {MSR_MIC2_C14_GLOBAL_CTRL, MSR_MIC2_C14_STATUS, MSR_MIC2_C14_STATUS, 17, 0, 0, 48, MSR_MIC2_C14_FILTER0, MSR_MIC2_C14_FILTER1},
    [CBOX15] = {MSR_MIC2_C15_GLOBAL_CTRL, MSR_MIC2_C15_STATUS, MSR_MIC2_C15_STATUS, 18, 0, 0, 48, MSR_MIC2_C15_FILTER0, MSR_MIC2_C15_FILTER1},
    [CBOX16] = {MSR_MIC2_C16_GLOBAL_CTRL, MSR_MIC2_C16_STATUS, MSR_MIC2_C16_STATUS, 19, 0, 0, 48, MSR_MIC2_C16_FILTER0, MSR_MIC2_C16_FILTER1},
    [CBOX17] = {MSR_MIC2_C17_GLOBAL_CTRL, MSR_MIC2_C17_STATUS, MSR_MIC2_C17_STATUS, 20, 0, 0, 48, MSR_MIC2_C17_FILTER0, MSR_MIC2_C17_FILTER1},
    [CBOX18] = {MSR_MIC2_C18_GLOBAL_CTRL, MSR_MIC2_C18_STATUS, MSR_MIC2_C18_STATUS, 21, 0, 0, 48, MSR_MIC2_C18_FILTER0, MSR_MIC2_C18_FILTER1},
    [CBOX19] = {MSR_MIC2_C19_GLOBAL_CTRL, MSR_MIC2_C19_STATUS, MSR_MIC2_C19_STATUS, 22, 0, 0, 48, MSR_MIC2_C19_FILTER0, MSR_MIC2_C19_FILTER1},
    [CBOX20] = {MSR_MIC2_C20_GLOBAL_CTRL, MSR_MIC2_C20_STATUS, MSR_MIC2_C20_STATUS, 23, 0, 0, 48, MSR_MIC2_C20_FILTER0, MSR_MIC2_C20_FILTER1},
    [CBOX21] = {MSR_MIC2_C21_GLOBAL_CTRL, MSR_MIC2_C21_STATUS, MSR_MIC2_C21_STATUS, 24, 0, 0, 48, MSR_MIC2_C21_FILTER0, MSR_MIC2_C21_FILTER1},
    [CBOX22] = {MSR_MIC2_C22_GLOBAL_CTRL, MSR_MIC2_C22_STATUS, MSR_MIC2_C22_STATUS, 25, 0, 0, 48, MSR_MIC2_C22_FILTER0, MSR_MIC2_C22_FILTER1},
    [CBOX23] = {MSR_MIC2_C23_GLOBAL_CTRL, MSR_MIC2_C23_STATUS, MSR_MIC2_C23_STATUS, 26, 0, 0, 48, MSR_MIC2_C23_FILTER0, MSR_MIC2_C23_FILTER1},
    [CBOX24] = {MSR_MIC2_C24_GLOBAL_CTRL, MSR_MIC2_C24_STATUS, MSR_MIC2_C24_STATUS, 27, 0, 0, 48, MSR_MIC2_C24_FILTER0, MSR_MIC2_C24_FILTER1},
    [CBOX25] = {MSR_MIC2_C25_GLOBAL_CTRL, MSR_MIC2_C25_STATUS, MSR_MIC2_C25_STATUS, 28, 0, 0, 48, MSR_MIC2_C25_FILTER0, MSR_MIC2_C25_FILTER1},
    [CBOX26] = {MSR_MIC2_C26_GLOBAL_CTRL, MSR_MIC2_C26_STATUS, MSR_MIC2_C26_STATUS, 29, 0, 0, 48, MSR_MIC2_C26_FILTER0, MSR_MIC2_C26_FILTER1},
    [CBOX27] = {MSR_MIC2_C27_GLOBAL_CTRL, MSR_MIC2_C27_STATUS, MSR_MIC2_C27_STATUS, 30, 0, 0, 48, MSR_MIC2_C27_FILTER0, MSR_MIC2_C27_FILTER1},
    [CBOX28] = {MSR_MIC2_C28_GLOBAL_CTRL, MSR_MIC2_C28_STATUS, MSR_MIC2_C28_STATUS, 31, 0, 0, 48, MSR_MIC2_C28_FILTER0, MSR_MIC2_C28_FILTER1},
    [CBOX29] = {MSR_MIC2_C29_GLOBAL_CTRL, MSR_MIC2_C29_STATUS, MSR_MIC2_C29_STATUS, 32, 0, 0, 48, MSR_MIC2_C29_FILTER0, MSR_MIC2_C29_FILTER1},
    [CBOX30] = {MSR_MIC2_C30_GLOBAL_CTRL, MSR_MIC2_C30_STATUS, MSR_MIC2_C30_STATUS, 33, 0, 0, 48, MSR_MIC2_C30_FILTER0, MSR_MIC2_C30_FILTER1},
    [CBOX31] = {MSR_MIC2_C31_GLOBAL_CTRL, MSR_MIC2_C31_STATUS, MSR_MIC2_C31_STATUS, 34, 0, 0, 48, MSR_MIC2_C31_FILTER0, MSR_MIC2_C31_FILTER1},
    [CBOX32] = {MSR_MIC2_C32_GLOBAL_CTRL, MSR_MIC2_C32_STATUS, MSR_MIC2_C32_STATUS, 35, 0, 0, 48, MSR_MIC2_C32_FILTER0, MSR_MIC2_C32_FILTER1},
    [CBOX33] = {MSR_MIC2_C33_GLOBAL_CTRL, MSR_MIC2_C33_STATUS, MSR_MIC2_C33_STATUS, 36, 0, 0, 48, MSR_MIC2_C33_FILTER0, MSR_MIC2_C33_FILTER1},
    [CBOX34] = {MSR_MIC2_C34_GLOBAL_CTRL, MSR_MIC2_C34_STATUS, MSR_MIC2_C34_STATUS, 37, 0, 0, 48, MSR_MIC2_C34_FILTER0, MSR_MIC2_C34_FILTER1},
    [CBOX35] = {MSR_MIC2_C35_GLOBAL_CTRL, MSR_MIC2_C35_STATUS, MSR_MIC2_C35_STATUS, 38, 0, 0, 48, MSR_MIC2_C35_FILTER0, MSR_MIC2_C35_FILTER1},
    [CBOX36] = {MSR_MIC2_C36_GLOBAL_CTRL, MSR_MIC2_C36_STATUS, MSR_MIC2_C36_STATUS, 39, 0, 0, 48, MSR_MIC2_C36_FILTER0, MSR_MIC2_C36_FILTER1},
    [CBOX37] = {MSR_MIC2_C37_GLOBAL_CTRL, MSR_MIC2_C37_STATUS, MSR_MIC2_C37_STATUS, 40, 0, 0, 48, MSR_MIC2_C37_FILTER0, MSR_MIC2_C37_FILTER1},
    [WBOX] = {MSR_MIC2_PCU_GLOBAL_CTRL, 0, 0, 2, 0, 0, 48},
    [MBOX0] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_0, 48},
    [MBOX1] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_1, 48},
    [MBOX2] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_2, 48},
    [MBOX3] = {PCI_MIC2_MC_U_BOX_CTRL, PCI_MIC2_MC_U_BOX_STATUS, PCI_MIC2_MC_U_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_3, 48},
    [MBOX4] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 42, 1, PCI_IMC_DEVICE_1_CH_0, 48},
    [MBOX5] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 42, 1, PCI_IMC_DEVICE_1_CH_1, 48},
    [MBOX6] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 42, 1, PCI_IMC_DEVICE_1_CH_2, 48},
    [MBOX7] = {PCI_MIC2_MC_U_BOX_CTRL, PCI_MIC2_MC_U_BOX_STATUS, PCI_MIC2_MC_U_BOX_STATUS, 42, 1, PCI_IMC_DEVICE_1_CH_3, 48},
    [MBOX0FIX] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_0, 48},
    [MBOX1FIX] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_1, 48},
    [MBOX2FIX] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_2, 48},
    [MBOX3FIX] =  {PCI_MIC2_MC_U_BOX_CTRL, PCI_MIC2_MC_U_BOX_STATUS, PCI_MIC2_MC_U_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_0_CH_3, 48},
    [MBOX4FIX] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_1_CH_0, 48},
    [MBOX5FIX] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_1_CH_1, 48},
    [MBOX6FIX] = {PCI_MIC2_MC_D_BOX_CTRL, PCI_MIC2_MC_D_BOX_STATUS, PCI_MIC2_MC_D_BOX_STATUS, 41, 1, PCI_IMC_DEVICE_1_CH_2, 48},
    [MBOX7FIX] = {PCI_MIC2_MC_U_BOX_CTRL, PCI_MIC2_MC_U_BOX_STATUS, PCI_MIC2_MC_U_BOX_STATUS, 42, 1, PCI_IMC_DEVICE_1_CH_3, 48},
    [EUBOX0] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 43, 1, PCI_EDC0_UCLK_DEVICE, 48},
    [EUBOX0FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 43, 1, PCI_EDC0_UCLK_DEVICE, 48},
    [EDBOX0] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 43, 1, PCI_EDC0_DCLK_DEVICE, 48},
    [EDBOX0FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 43, 1, PCI_EDC0_DCLK_DEVICE, 48},
    [EUBOX1] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 44, 1, PCI_EDC1_UCLK_DEVICE, 48},
    [EUBOX1FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 44, 1, PCI_EDC1_UCLK_DEVICE, 48},
    [EDBOX1] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 44, 1, PCI_EDC1_DCLK_DEVICE, 48},
    [EDBOX1FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 44, 1, PCI_EDC1_DCLK_DEVICE, 48},
    [EUBOX2] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 45, 1, PCI_EDC2_UCLK_DEVICE, 48},
    [EUBOX2FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 45, 1, PCI_EDC2_UCLK_DEVICE, 48},
    [EDBOX2] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 45, 1, PCI_EDC2_DCLK_DEVICE, 48},
    [EDBOX2FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 45, 1, PCI_EDC2_DCLK_DEVICE, 48},
    [EUBOX3] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 46, 1, PCI_EDC3_UCLK_DEVICE, 48},
    [EUBOX3FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 46, 1, PCI_EDC3_UCLK_DEVICE, 48},
    [EDBOX3] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 46, 1, PCI_EDC3_DCLK_DEVICE, 48},
    [EDBOX3FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 46, 1, PCI_EDC3_DCLK_DEVICE, 48},
    [EUBOX4] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 47, 1, PCI_EDC4_UCLK_DEVICE, 48},
    [EUBOX4FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 47, 1, PCI_EDC4_UCLK_DEVICE, 48},
    [EDBOX4] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 47, 1, PCI_EDC4_DCLK_DEVICE, 48},
    [EDBOX4FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 47, 1, PCI_EDC4_DCLK_DEVICE, 48},
    [EUBOX5] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 48, 1, PCI_EDC5_UCLK_DEVICE, 48},
    [EUBOX5FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 48, 1, PCI_EDC5_UCLK_DEVICE, 48},
    [EDBOX5] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 48, 1, PCI_EDC5_DCLK_DEVICE, 48},
    [EDBOX5FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 48, 1, PCI_EDC5_DCLK_DEVICE, 48},
    [EUBOX6] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 49, 1, PCI_EDC6_UCLK_DEVICE, 48},
    [EUBOX6FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 49, 1, PCI_EDC6_UCLK_DEVICE, 48},
    [EDBOX6] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 49, 1, PCI_EDC6_DCLK_DEVICE, 48},
    [EDBOX6FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 49, 1, PCI_EDC6_DCLK_DEVICE, 48},
    [EUBOX7] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 50, 1, PCI_EDC7_UCLK_DEVICE, 48},
    [EUBOX7FIX] = {PCI_MIC2_EDC_U_BOX_CTRL, PCI_MIC2_EDC_U_BOX_STATUS, PCI_MIC2_EDC_U_BOX_STATUS, 50, 1, PCI_EDC7_UCLK_DEVICE, 48},
    [EDBOX7] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 50, 1, PCI_EDC7_DCLK_DEVICE, 48},
    [EDBOX7FIX] = {PCI_MIC2_EDC_D_BOX_CTRL, PCI_MIC2_EDC_D_BOX_STATUS, PCI_MIC2_EDC_D_BOX_STATUS, 50, 1, PCI_EDC7_DCLK_DEVICE, 48},
    [PBOX] = {PCI_MIC2_M2PCIE_BOX_CTRL, PCI_MIC2_M2PCIE_BOX_STATUS, PCI_MIC2_M2PCIE_BOX_STATUS, 51, 1, PCI_R2PCIE_DEVICE, 48},
    [IBOX0] = {PCI_MIC2_IRP_BOX_CTRL, PCI_MIC2_IRP_BOX_STATUS, PCI_MIC2_IRP_BOX_STATUS, 52, 1, PCI_IRP_DEVICE, 48},
};

static PciDevice knl_pci_devices[MAX_NUM_PCI_DEVICES] = {
 [MSR_DEV] = {NODEVTYPE, "", "", ""},
 [PCI_IMC_DEVICE_0_CH_0] = {IMC, "08.2", "PCI_IMC_DEVICE_0_CH_0", "MBOX0", 0x7843},
 [PCI_IMC_DEVICE_0_CH_1] = {IMC, "08.3", "PCI_IMC_DEVICE_0_CH_1", "MBOX1", 0x7843},
 [PCI_IMC_DEVICE_0_CH_2] = {IMC, "08.4", "PCI_IMC_DEVICE_0_CH_2", "MBOX2", 0x7843},
 [PCI_IMC_DEVICE_0_CH_3] = {IMC, "0a.0", "PCI_IMC_DEVICE_0_CH_3", "MBOX3", 0x7843},
 [PCI_IMC_DEVICE_1_CH_0] = {IMC, "09.2", "PCI_IMC_DEVICE_1_CH_0", "MBOX4", 0x7843},
 [PCI_IMC_DEVICE_1_CH_1] = {IMC, "09.3", "PCI_IMC_DEVICE_1_CH_1", "MBOX5", 0x7843},
 [PCI_IMC_DEVICE_1_CH_2] = {IMC, "09.4", "PCI_IMC_DEVICE_1_CH_2", "MBOX6", 0x7843},
 [PCI_IMC_DEVICE_1_CH_3] = {IMC, "0b.0", "PCI_IMC_DEVICE_1_CH_3", "MBOX7", 0x7843},
 [PCI_R2PCIE_DEVICE] = {R2PCIE, "0c.1", "PCI_R2PCIE_DEVICE", "R2PCIE", 0x7817},
 [PCI_IRP_DEVICE] = {IRP, "05.6", "PCI_IRP_DEVICE", "IRP", 0x7814},
 [PCI_EDC0_UCLK_DEVICE] = {EDC, "0f.0", "PCI_EDC0_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC0_DCLK_DEVICE] = {EDC, "18.2", "PCI_EDC0_DCLK_DEVICE", "EDC", 0x7835},
 [PCI_EDC1_UCLK_DEVICE] = {EDC, "10.0", "PCI_EDC1_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC1_DCLK_DEVICE] = {EDC, "19.2", "PCI_EDC1_DCLK_DEVICE", "EDC", 0x7835},
 [PCI_EDC2_UCLK_DEVICE] = {EDC, "11.0", "PCI_EDC2_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC2_DCLK_DEVICE] = {EDC, "1a.2", "PCI_EDC2_DCLK_DEVICE", "EDC", 0x7835},
 [PCI_EDC3_UCLK_DEVICE] = {EDC, "12.0", "PCI_EDC3_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC3_DCLK_DEVICE] = {EDC, "1b.2", "PCI_EDC3_DCLK_DEVICE", "EDC", 0x7835},
 [PCI_EDC4_UCLK_DEVICE] = {EDC, "13.0", "PCI_EDC4_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC4_DCLK_DEVICE] = {EDC, "1c.2", "PCI_EDC4_DCLK_DEVICE", "EDC", 0x7835},
 [PCI_EDC5_UCLK_DEVICE] = {EDC, "14.0", "PCI_EDC5_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC5_DCLK_DEVICE] = {EDC, "1d.2", "PCI_EDC5_DCLK_DEVICE", "EDC", 0x7835},
 [PCI_EDC6_UCLK_DEVICE] = {EDC, "15.0", "PCI_EDC6_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC6_DCLK_DEVICE] = {EDC, "1e.2", "PCI_EDC6_DCLK_DEVICE", "EDC", 0x7835},
 [PCI_EDC7_UCLK_DEVICE] = {EDC, "16.0", "PCI_EDC7_UCLK_DEVICE", "EDC", 0x7833},
 [PCI_EDC7_DCLK_DEVICE] = {EDC, "1f.2", "PCI_EDC7_DCLK_DEVICE", "EDC", 0x7835},
};

static char* knl_translate_types[NUM_UNITS] = {
    [FIXED] = "/sys/bus/event_source/devices/cpu",
    [PMC] = "/sys/bus/event_source/devices/cpu",
    [POWER] = "/sys/bus/event_source/devices/power",
    [MBOX0] = "/sys/bus/event_source/devices/uncore_imc_0",
    [MBOX1] = "/sys/bus/event_source/devices/uncore_imc_1",
    [MBOX2] = "/sys/bus/event_source/devices/uncore_imc_2",
    [MBOX4] = "/sys/bus/event_source/devices/uncore_imc_3",
    [MBOX5] = "/sys/bus/event_source/devices/uncore_imc_4",
    [MBOX6] = "/sys/bus/event_source/devices/uncore_imc_5",
    [CBOX0] = "/sys/bus/event_source/devices/uncore_cbox_0",
    [CBOX1] = "/sys/bus/event_source/devices/uncore_cbox_1",
    [CBOX2] = "/sys/bus/event_source/devices/uncore_cbox_2",
    [CBOX3] = "/sys/bus/event_source/devices/uncore_cbox_3",
    [CBOX4] = "/sys/bus/event_source/devices/uncore_cbox_4",
    [CBOX5] = "/sys/bus/event_source/devices/uncore_cbox_5",
    [CBOX6] = "/sys/bus/event_source/devices/uncore_cbox_6",
    [CBOX7] = "/sys/bus/event_source/devices/uncore_cbox_7",
    [CBOX8] = "/sys/bus/event_source/devices/uncore_cbox_8",
    [CBOX9] = "/sys/bus/event_source/devices/uncore_cbox_9",
    [CBOX10] = "/sys/bus/event_source/devices/uncore_cbox_10",
    [CBOX11] = "/sys/bus/event_source/devices/uncore_cbox_11",
    [CBOX12] = "/sys/bus/event_source/devices/uncore_cbox_12",
    [CBOX13] = "/sys/bus/event_source/devices/uncore_cbox_13",
    [CBOX14] = "/sys/bus/event_source/devices/uncore_cbox_14",
    [CBOX15] = "/sys/bus/event_source/devices/uncore_cbox_15",
    [CBOX16] = "/sys/bus/event_source/devices/uncore_cbox_16",
    [CBOX17] = "/sys/bus/event_source/devices/uncore_cbox_17",
    [CBOX18] = "/sys/bus/event_source/devices/uncore_cbox_18",
    [CBOX19] = "/sys/bus/event_source/devices/uncore_cbox_19",
    [CBOX20] = "/sys/bus/event_source/devices/uncore_cbox_20",
    [CBOX21] = "/sys/bus/event_source/devices/uncore_cbox_21",
    [CBOX22] = "/sys/bus/event_source/devices/uncore_cbox_22",
    [CBOX23] = "/sys/bus/event_source/devices/uncore_cbox_23",
    [CBOX24] = "/sys/bus/event_source/devices/uncore_cbox_24",
    [CBOX25] = "/sys/bus/event_source/devices/uncore_cbox_25",
    [CBOX26] = "/sys/bus/event_source/devices/uncore_cbox_26",
    [CBOX27] = "/sys/bus/event_source/devices/uncore_cbox_27",
    [CBOX28] = "/sys/bus/event_source/devices/uncore_cbox_28",
    [CBOX29] = "/sys/bus/event_source/devices/uncore_cbox_29",
    [CBOX30] = "/sys/bus/event_source/devices/uncore_cbox_30",
    [CBOX31] = "/sys/bus/event_source/devices/uncore_cbox_31",
    [CBOX32] = "/sys/bus/event_source/devices/uncore_cbox_32",
    [CBOX33] = "/sys/bus/event_source/devices/uncore_cbox_33",
    [CBOX34] = "/sys/bus/event_source/devices/uncore_cbox_34",
    [CBOX35] = "/sys/bus/event_source/devices/uncore_cbox_35",
    [CBOX36] = "/sys/bus/event_source/devices/uncore_cbox_36",
    [CBOX37] = "/sys/bus/event_source/devices/uncore_cbox_37",
    [WBOX] = "/sys/bus/event_source/devices/uncore_pcu",
    [PBOX] = "/sys/bus/event_source/devices/uncore_m2pcie",
    [UBOX] = "/sys/bus/event_source/devices/uncore_ubox",
    [IBOX0] = "/sys/bus/event_source/devices/uncore_irp",
    [EUBOX0] = "/sys/bus/event_source/devices/uncore_edc_uclk_0",
    [EUBOX1] = "/sys/bus/event_source/devices/uncore_edc_uclk_1",
    [EUBOX2] = "/sys/bus/event_source/devices/uncore_edc_uclk_2",
    [EUBOX3] = "/sys/bus/event_source/devices/uncore_edc_uclk_3",
    [EUBOX4] = "/sys/bus/event_source/devices/uncore_edc_uclk_4",
    [EUBOX5] = "/sys/bus/event_source/devices/uncore_edc_uclk_5",
    [EUBOX6] = "/sys/bus/event_source/devices/uncore_edc_uclk_6",
    [EUBOX7] = "/sys/bus/event_source/devices/uncore_edc_uclk_7",
    [EDBOX0] = "/sys/bus/event_source/devices/uncore_edc_eclk_0",
    [EDBOX1] = "/sys/bus/event_source/devices/uncore_edc_eclk_1",
    [EDBOX2] = "/sys/bus/event_source/devices/uncore_edc_eclk_2",
    [EDBOX3] = "/sys/bus/event_source/devices/uncore_edc_eclk_3",
    [EDBOX4] = "/sys/bus/event_source/devices/uncore_edc_eclk_4",
    [EDBOX5] = "/sys/bus/event_source/devices/uncore_edc_eclk_5",
    [EDBOX6] = "/sys/bus/event_source/devices/uncore_edc_eclk_6",
    [EDBOX7] = "/sys/bus/event_source/devices/uncore_edc_eclk_7",
    [MBOX3FIX] = "/sys/bus/event_source/devices/uncore_imc_uclk_0",
    [MBOX7FIX] = "/sys/bus/event_source/devices/uncore_imc_uclk_1",
};
