Object.defineProperty(exports, '__esModule', { value: true });

const browser = require('@sentry/browser');
const sdk = require('./sdk.js');
const error = require('./error.js');
const profiler = require('./profiler.js');
const errorboundary = require('./errorboundary.js');
const redux = require('./redux.js');
const reactrouterv3 = require('./reactrouterv3.js');
const tanstackrouter = require('./tanstackrouter.js');
const reactrouter = require('./reactrouter.js');
const reactrouterv6 = require('./reactrouterv6.js');



exports.init = sdk.init;
exports.reactErrorHandler = error.reactErrorHandler;
exports.Profiler = profiler.Profiler;
exports.useProfiler = profiler.useProfiler;
exports.withProfiler = profiler.withProfiler;
exports.ErrorBoundary = errorboundary.ErrorBoundary;
exports.withErrorBoundary = errorboundary.withErrorBoundary;
exports.createReduxEnhancer = redux.createReduxEnhancer;
exports.reactRouterV3BrowserTracingIntegration = reactrouterv3.reactRouterV3BrowserTracingIntegration;
exports.tanstackRouterBrowserTracingIntegration = tanstackrouter.tanstackRouterBrowserTracingIntegration;
exports.reactRouterV4BrowserTracingIntegration = reactrouter.reactRouterV4BrowserTracingIntegration;
exports.reactRouterV5BrowserTracingIntegration = reactrouter.reactRouterV5BrowserTracingIntegration;
exports.withSentryRouting = reactrouter.withSentryRouting;
exports.reactRouterV6BrowserTracingIntegration = reactrouterv6.reactRouterV6BrowserTracingIntegration;
exports.withSentryReactRouterV6Routing = reactrouterv6.withSentryReactRouterV6Routing;
exports.wrapCreateBrowserRouter = reactrouterv6.wrapCreateBrowserRouter;
exports.wrapUseRoutes = reactrouterv6.wrapUseRoutes;
Object.prototype.hasOwnProperty.call(browser, '__proto__') &&
  !Object.prototype.hasOwnProperty.call(exports, '__proto__') &&
  Object.defineProperty(exports, '__proto__', {
    enumerable: true,
    value: browser['__proto__']
  });

Object.keys(browser).forEach(k => {
  if (k !== 'default' && !Object.prototype.hasOwnProperty.call(exports, k)) exports[k] = browser[k];
});
//# sourceMappingURL=index.js.map
