import { Exporter } from './commons';
/**
 * JSONv* values can be any valid value for JSON file.
 *
 * See i18next's "returnObjects" option.
 */
type JsonVxValue = string | number | null | JsonVxValue[] | {
    [k: string]: JsonVxValue;
};
/**
 * Content of a JSONv* file.
 */
interface JsonVxFile {
    whitespacesBefore: string;
    whitespacesAfter: string;
    content: {
        [k: string]: JsonVxValue;
    };
}
declare const exporter: Exporter<JsonVxFile, JsonVxValue>;
export default exporter;
