'use strict';

const node_worker_threads = require('node:worker_threads');
const node_path = require('node:path');
const node_url = require('node:url');
const chokidar = require('chokidar');
const debugWrap = require('debug');
const utils = require('./shared/vite-plugin-eslint2.5ee885a0.cjs');
require('tty');
require('@rollup/pluginutils');

var _documentCurrentScript = typeof document !== 'undefined' ? document.currentScript : null;
function _interopDefaultCompat (e) { return e && typeof e === 'object' && 'default' in e ? e.default : e; }

const chokidar__default = /*#__PURE__*/_interopDefaultCompat(chokidar);
const debugWrap__default = /*#__PURE__*/_interopDefaultCompat(debugWrap);

const debug = debugWrap__default(utils.PLUGIN_NAME);
const __filename$1 = node_url.fileURLToPath((typeof document === 'undefined' ? require('u' + 'rl').pathToFileURL(__filename).href : (_documentCurrentScript && _documentCurrentScript.src || new URL('index.cjs', document.baseURI).href)));
const __dirname$1 = node_path.dirname(__filename$1);
const ext = node_path.extname(__filename$1);
function ESLintPlugin(userOptions = {}) {
  const options = utils.getOptions(userOptions);
  let worker;
  let watcher;
  const filter = utils.getFilter(options);
  let eslintInstance;
  let formatter;
  let outputFixes;
  return {
    name: utils.PLUGIN_NAME,
    apply(config, { command }) {
      debug(`==== apply hook ====`);
      if (config.mode === "test" || process.env.VITEST)
        return options.test;
      const shouldApply = command === "serve" && options.dev || command === "build" && options.build;
      debug(`should apply this plugin: ${shouldApply}`);
      return shouldApply;
    },
    async buildStart() {
      debug(`==== buildStart hook ====`);
      if (options.lintInWorker) {
        if (worker)
          return;
        debug(`Initialize worker`);
        worker = new node_worker_threads.Worker(node_path.resolve(__dirname$1, `worker${ext}`), { workerData: { options } });
        return;
      }
      debug(`Initial ESLint`);
      const result = await utils.initializeESLint(options);
      eslintInstance = result.eslintInstance;
      formatter = result.formatter;
      outputFixes = result.outputFixes;
      if (options.lintOnStart) {
        debug(`Lint on start`);
        await utils.lintFiles(
          {
            files: options.include,
            eslintInstance,
            formatter,
            outputFixes,
            options
          },
          this
          // use buildStart hook context
        );
      }
    },
    async transform(_, id) {
      debug("==== transform hook ====");
      if (options.chokidar) {
        if (watcher)
          return;
        debug(`Initialize watcher`);
        watcher = chokidar__default.watch(options.include, { ignored: options.exclude }).on("change", async (path) => {
          debug(`==== change event ====`);
          const fullPath = node_path.resolve(utils.CWD, path);
          if (worker)
            return worker.postMessage(fullPath);
          const shouldIgnore2 = await utils.shouldIgnoreModule(fullPath, filter, eslintInstance);
          debug(`should ignore: ${shouldIgnore2}`);
          if (shouldIgnore2)
            return;
          return await utils.lintFiles(
            {
              files: options.lintDirtyOnly ? fullPath : options.include,
              eslintInstance,
              formatter,
              outputFixes,
              options
            }
            // this, // TODO: use transform hook context will breaks build
          );
        });
        return;
      }
      debug("id: ", id);
      const filePath = utils.getFilePath(id);
      debug(`filePath`, filePath);
      if (worker)
        return worker.postMessage(filePath);
      const shouldIgnore = await utils.shouldIgnoreModule(id, filter, eslintInstance);
      debug(`should ignore: ${shouldIgnore}`);
      if (shouldIgnore)
        return;
      return await utils.lintFiles(
        {
          files: options.lintDirtyOnly ? filePath : options.include,
          eslintInstance,
          formatter,
          outputFixes,
          options
        },
        this
        // use transform hook context
      );
    },
    async buildEnd() {
      debug("==== buildEnd ====");
      if (watcher == null ? void 0 : watcher.close)
        await watcher.close();
    }
  };
}

module.exports = ESLintPlugin;
