#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include "clastfm.h"

int main(int argc, char **argv)
{
	LASTFM_SESSION *s;
	LASTFM_ALBUM_INFO *album;
	LASTFM_ARTIST_INFO *artist;
	LFMList *list = NULL,*i;
	int rv;
	const char *status = NULL;

	s = LASTFM_init("Your API_KEY Here", "Your API_SECRET Here");

	rv = LASTFM_login(s,"Usename Here","Password Here");

	time_t started;
	time(&started);
	started-=31; // simulate playtime

	/* Get a pointer to the internal status message buffer */
	LASTFM_status(s,&status,NULL,NULL);

	/* Scrobble API 2.0 */
	LASTFM_track_scrobble(s,"Believe","Unknown","Cher",started,0,0,0,NULL);
	printf("stauts=%s\n",status);

	LASTFM_user_shout(s,"Lastfm User name here","Shout msg in here");
	printf("stauts=%s\n",status);

	/* es = ISO 639 language code. NULL for english */
	artist = LASTFM_artist_get_info(s,"Cher","es");
	LASTFM_print_artist_info(stdout,artist);
	LASTFM_free_artist_info(artist);

	album = LASTFM_album_get_info(s,"Air","Moon Safari");
	LASTFM_print_album_info(stdout,album);
	LASTFM_free_album_info(album);

	/* 0 = default limit, 1 = page number */
	rv = LASTFM_album_search(s,"believe",LASTFM_IMAGE_URL_OG,0,1,&list);
	for(i=list;i;i=i->next){
		album = i->data;
		printf("-----------------------------\n");
		LASTFM_print_album_info(stdout,album);
	}
	LASTFM_free_album_info_list(list);

	/* NULL = Use authenticated user, 0 = default limit, 1 = page number */
	rv = LASTFM_user_get_top_albums(s,NULL,LASTFM_PERIOD_6MONTH,0,1,&list);
	for(i=list;i;i=i->next){
		printf("-----------------------------\n");
		LASTFM_print_album_info(stdout,i->data);
	}
	LASTFM_free_album_info_list(list);
	
	/* artist = "Michael Jackson", image size = small, 0 = default limit, 2 = page number */
	rv = LASTFM_artist_get_images(s,"Michael Jackson",LASTFM_IMAGE_S,0,2,&list);
	LASTFM_print_image_info_list(stdout,list);
	LASTFM_free_image_info_list(list);

	/* user = "rj", start = N/A, end = N/A (ie. all scrobbles) , page = 1 */
	rv = LASTFM_user_get_recent_tracks(s,"rj",0,0,1,&list);
	printf("Pages = %i\n",rv);

	for(i=list;i;i=i->next){
		LASTFM_print_track_info(stdout,i->data);
	}
	LASTFM_free_track_info_list(list);

	LASTFM_dinit(s);
	return 0;
}
