/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl.collect;

import java.util.Arrays;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.DependencyNode;

final class NodeStack {
    private DependencyNode[] nodes = new DependencyNode[96];
    private int size;

    NodeStack() {
    }

    public DependencyNode top() {
        if (this.size <= 0) {
            throw new IllegalStateException("stack empty");
        }
        return this.nodes[this.size - 1];
    }

    public void push(DependencyNode node) {
        if (this.size >= this.nodes.length) {
            DependencyNode[] tmp = new DependencyNode[this.size + 64];
            System.arraycopy(this.nodes, 0, tmp, 0, this.nodes.length);
            this.nodes = tmp;
        }
        this.nodes[this.size++] = node;
    }

    public void pop() {
        if (this.size <= 0) {
            throw new IllegalStateException("stack empty");
        }
        --this.size;
    }

    public int find(Artifact artifact) {
        DependencyNode node;
        Artifact a;
        for (int i = this.size - 1; i >= 0 && (a = (node = this.nodes[i]).getArtifact()) != null; --i) {
            if (!a.getArtifactId().equals(artifact.getArtifactId()) || !a.getGroupId().equals(artifact.getGroupId()) || !a.getExtension().equals(artifact.getExtension()) || !a.getClassifier().equals(artifact.getClassifier())) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public DependencyNode get(int index) {
        return this.nodes[index];
    }

    public String toString() {
        return Arrays.toString(this.nodes);
    }
}

