/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.tasks;

import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.Dependency;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.DependencyNode;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.DependencyVisitor;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.apache.tools.ant.Task;

class DependencyGraphLogger
implements DependencyVisitor {
    private Task task;
    private String indent = "";

    DependencyGraphLogger(Task task) {
        this.task = task;
    }

    @Override
    public boolean visitEnter(DependencyNode node) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.indent);
        Dependency dep = node.getDependency();
        if (dep != null) {
            String premanagedVersion;
            Artifact art = dep.getArtifact();
            buffer.append(art);
            buffer.append(':').append(dep.getScope());
            String premanagedScope = DependencyManagerUtils.getPremanagedScope(node);
            if (premanagedScope != null && !premanagedScope.equals(dep.getScope())) {
                buffer.append(" (scope managed from ").append(premanagedScope).append(")");
            }
            if ((premanagedVersion = DependencyManagerUtils.getPremanagedVersion(node)) != null && !premanagedVersion.equals(art.getVersion())) {
                buffer.append(" (version managed from ").append(premanagedVersion).append(")");
            }
        } else {
            buffer.append("Resolved Dependency Graph:");
        }
        this.task.log(buffer.toString(), 3);
        this.indent = this.indent + "   ";
        return true;
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        this.indent = this.indent.substring(0, this.indent.length() - 3);
        return true;
    }
}

