/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.resolver.internal.ant.types.RemoteRepository;
import org.apache.maven.resolver.internal.ant.types.RemoteRepositoryContainer;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class RemoteRepositories
extends DataType
implements RemoteRepositoryContainer {
    private List<RemoteRepositoryContainer> containers = new ArrayList<RemoteRepositoryContainer>();

    protected RemoteRepositories getRef() {
        return (RemoteRepositories)this.getCheckedRef();
    }

    @Override
    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            for (RemoteRepositoryContainer container : this.containers) {
                container.validate(task);
            }
        }
    }

    public void setRefid(Reference ref) {
        if (!this.containers.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public void addRemoterepo(RemoteRepository repository) {
        this.checkChildrenAllowed();
        this.containers.add(repository);
    }

    public void addRemoterepos(RemoteRepositories repositories) {
        this.checkChildrenAllowed();
        if (repositories == this) {
            throw this.circularReference();
        }
        this.containers.add(repositories);
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        if (this.isReference()) {
            return this.getRef().getRepositories();
        }
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (RemoteRepositoryContainer container : this.containers) {
            repos.addAll(container.getRepositories());
        }
        return repos;
    }
}

