/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jacoco.cli.internal.Command;
import org.jacoco.cli.internal.args4j.Argument;
import org.jacoco.cli.internal.core.data.ExecutionData;
import org.jacoco.cli.internal.core.data.ExecutionDataReader;
import org.jacoco.cli.internal.core.data.IExecutionDataVisitor;
import org.jacoco.cli.internal.core.data.ISessionInfoVisitor;
import org.jacoco.cli.internal.core.data.SessionInfo;

public class ExecInfo
extends Command {
    @Argument(usage="list of JaCoCo *.exec files to read", metaVar="<execfiles>")
    List<File> execfiles = new ArrayList<File>();

    public String description() {
        return "Print exec file content in human readable format.";
    }

    public int execute(PrintWriter out, PrintWriter err) throws IOException {
        if (this.execfiles.isEmpty()) {
            out.println("[WARN] No execution data files provided.");
        } else {
            for (File file : this.execfiles) {
                this.dump(file, out);
            }
        }
        return 0;
    }

    private void dump(File file, final PrintWriter out) throws IOException {
        out.printf("[INFO] Loading exec file %s.%n", file);
        out.println("CLASS ID         HITS/PROBES   CLASS NAME");
        FileInputStream in = new FileInputStream(file);
        ExecutionDataReader reader = new ExecutionDataReader(in);
        reader.setSessionInfoVisitor(new ISessionInfoVisitor(){

            public void visitSessionInfo(SessionInfo info) {
                out.printf("Session \"%s\": %s - %s%n", info.getId(), new Date(info.getStartTimeStamp()), new Date(info.getDumpTimeStamp()));
            }
        });
        reader.setExecutionDataVisitor(new IExecutionDataVisitor(){

            public void visitClassExecution(ExecutionData data) {
                out.printf("%016x  %3d of %3d   %s%n", data.getId(), ExecInfo.this.getHitCount(data.getProbes()), data.getProbes().length, data.getName());
            }
        });
        reader.read();
        in.close();
        out.println();
    }

    private int getHitCount(boolean[] data) {
        int count = 0;
        for (boolean hit : data) {
            if (!hit) continue;
            ++count;
        }
        return count;
    }
}

