(set-option :produce-proofs true)
(set-option :proof-check-mode true)
(set-option :model-check-mode true)

(set-logic QF_UF)
(declare-fun p1 () Bool)
(declare-fun p2 () Bool)
(declare-fun r () Bool)

(push 1)
; force or_pos literal with multiple occurences
(assert (let ((o (or p1 p2)))  (and (= o r) (= r o))))
(assert (not p1))
(assert (not p2))
(assert r)
;(@tautology (! (or (not (! (or p1 p2) :p2uoted)) p1 p2) :or+))

(check-sat)
(set-option :print-terms-cse false)
(get-proof)
(pop 1)

(declare-fun p3 () Bool)
(push 1)
(assert (let ((o (or p1 p2 p3)))  (and (= o r) (= r o))))
(assert (not p1))
(assert (not p2))
(assert (not p3))
(assert r)
; (@tautology (! (or (not (! (or p1 p2 p3) :quoted)) p1 p2 p3) :or+))

(check-sat)
(set-option :print-terms-cse false)
(get-proof)
(pop 1)

(push 1)
(assert (let ((o (or (not (and p1 p2)) p3)))  (and (= o r) (= r o))))
(assert p1)
(assert p2)
(assert (not p3))
(assert r)
; (@tautology (! (or (not (! (or (or (not p1) (not p2)) p3) :quoted)) (or (not p1) (not p2)) p3) :or+))
(check-sat)
(set-option :print-terms-cse false)
(get-proof)
(pop 1)
