/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _CALLBACKS_H
#define _CALLBACKS_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include "sys/wait.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>

#include <glade/glade.h>
#include <support.h>

typedef struct _xcave_application          xcave_application;
typedef struct _detail_application         detail_application;
typedef struct _rack_application           rack_application;
typedef struct _supp_application           supp_application;
typedef struct _about_application          about_application;
typedef struct _synthese_application       synthese_application;
typedef struct _config_application         config_application;
typedef struct _consdeg_application        consdeg_application;
typedef struct _degustation_application    degustation_application;
typedef struct _print_application          print_application;
typedef struct _som_application            som_application;
typedef struct _fileselection_application  fileselection_application;

#define xcave_debug_function if(debug) printf(":%-15s:%-40s:%-4d:\n",__FILE__,__FUNCTION__,__LINE__);
#define __FULL__           __FILE__,__FUNCTION__,__LINE__

/* glade interface file is in same path as the executable  */
#define XCAVE_GLADE_FILE XCAVE_PIX_DIR "xcave.glade"
/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#define SEPAR '|'

#define rackMax                   99
#define rackRowMax                99
#define rackColMax	          99

#define Size_DBPATH 	          80
#define Size_CONF   	          80

#define date_size      	          4
#define lw_size                   4

#define domain_size              64
/* general */
#define supplier_size 	         32
#define supplierAdr_size         128
#define producer_size            64
#define producerAdr_size         128
#define vintage_size   	          date_size
#define degree_size   	          4
#define color_size    	          32
#define country_size               32
#define region_size    	          32
#define appellation_size          64
#define cepage_size               128
#define potentielDeGarde_size     date_size 
/* stock */
#define emplacement_size          32
#define rang_size                 8
#define temperature_size          10
#define qty_size                  8 
/* achat */
#define purchaseDate_size      	  date_size
#define price_size                12
/* consommation */
#define drinkingDate_size         date_size 
#define drinkingRated_size        4
#define drinkingComment_size      128
/* commentaire */
#define comment_size              1024
#define rated_size    	          4 

#define print_entete "| REGION     | APPELLATION       | NOM                            |MILE.|QTE.|\n"
#define print_corps  "|            |                   |                                |     |    |\n"
#define print_ligne_separ "------------------------------------------------------------------------------\n"
#define print_colonne_separ " | "

enum {
	COL_TREEVIEW,
	NUM_COLS_TREEVIEW
};

enum {
	COL_TREELIST_MILLESIME,
	COL_TREELIST_QTY,
	COL_TREELIST_DOMAIN,
	COL_TREELIST_COUNTRY,
	COL_TREELIST_REGION,
	COL_TREELIST_APPELLATION,
	COL_TREELIST_COLOR,
	COL_TREELIST_MATURITE,
	COL_TREELIST_PDATA,
	COL_TREELIST_PGLIST,
	NUM_COLS_TREELIST
} ;

enum {
	COL_TREELIST_PURCHASE_DATE,
	COL_TREELIST_PURCHASE_QTY,
	COL_TREELIST_PURCHASE_PRICE,
	COL_TREELIST_SUPPLIER,
	COL_TREELIST_SUPPLIER_ADR,
	NUM_COLS_TREELIST_PURCHASE
};
enum {
	COL_TREELIST_ICON,
	COL_TREELIST_DRINKING_DATE,
	COL_TREELIST_DRINKING_QTY,
	COL_TREELIST_NOTE,
	COL_TREELIST_COMMENTAIRE,
	COL_TREELIST_SHEET_ID,
	NUM_COLS_TREELIST_DRINKING
};
enum {
	COL_TREELIST_DEGUSTATION_APPELLATION,
	COL_TREELIST_DEGUSTATION_ID,
	NUM_COLS_TREELIST_DEGUSTATION
};
enum {
	CALCULATE_COLOR,
	CALCULATE_COUNTRY,
	CALCULATE_REGION,
	CALCULATE_RACK,
	CALCULATE_VINTAGE,
	CALCULATE_APPELLATION
};

struct _xcave_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
    GtkWidget             *origin_treeview;
    GtkTreeStore          *origin_treestore;
    GtkWidget             *information_treeview;
    GtkTreeStore          *information_treestore;
    GtkWidget             *statusbar_v;
    gchar                  statusbar_txt[80];
    gint                   statusbar_id;	
    gint                   statusbar_ctxtid;

    GtkWidget             *color_combo;
    GtkListStore          *color_store;
    gint                   s_color;
};	

struct _rack_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
    GtkWidget             *scrolledwindow;
    GtkWidget             *viewport;
    GtkWidget             *hbox;
    GtkWidget             *frameRack[rackMax];
    GtkWidget             *tableRack[rackMax];
    GtkWidget             *labelRackUnit[rackMax][rackRowMax][rackColMax];
    GtkWidget             *checkbutton[rackMax][rackRowMax][rackColMax];
    GtkTooltips           *tooltips;
};	

struct _detail_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
    GtkWidget             *purchase_treeview;
    GtkListStore          *purchase_liststore;
    GtkWidget             *drinking_treeview;
    GtkListStore          *drinking_liststore;
    GtkWidget             *statusbar_v;
    gchar                  statusbar_txt[80];
    gint                   statusbar_id;
    gint                   statusbar_ctxtid;
    gint                   origine;
    GtkWidget             *appellation_combo;
    GtkListStore          *appellation_store;
    gint                   s_appellation;

    GtkWidget             *region_combo;
    GtkListStore          *region_store;
    gint                   s_region;

    GtkWidget             *country_combo;
    GtkListStore          *country_store;
    gint                   s_country;

    GtkWidget             *cepage_combo;
    GtkListStore          *cepage_store;
    gint                   s_cepage;

    GtkWidget             *color_combo;
    GtkListStore          *color_store;
    gint                   s_color;

    rack_application       rack;
};	

struct _supp_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
};	

struct _synthese_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
    GtkWidget             *frame_color;
    GtkWidget             *vbox_color;
};	

struct _config_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
    gint                   debug;
    GtkSpinButton         *nb_rack_spinbutton;
    gint                   s_nb_rack;
    GtkSpinButton         *nb_row_spinbutton;
    gint                   s_nb_row;
    GtkSpinButton         *nb_col_spinbutton;
    gint                   s_nb_col;
    GtkSpinButton         *num_rack_spinbutton;
    gint                   s_num_rack;
    GtkWidget             *length_combo;
    GtkListStore          *length_store;
    GtkWidget             *width_combo;
    GtkListStore          *width_store;
};	

struct _about_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
};	

struct _consdeg_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
    GtkWidget             *treeview;
    GtkListStore          *liststore;
};	

struct _print_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
};	

struct _som_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
};	

struct _degustation_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
    GtkWidget             *sight_image;
};	

struct _fileselection_application {
    GladeXML              *main_xml;
    GtkWidget             *window;
};	

xcave_application           xcave;
detail_application          detail;
rack_application            rack;
supp_application            supp;
synthese_application        synthese;
config_application          config;
consdeg_application         consdeg;
degustation_application     degustation;
print_application           print;
som_application             som;
about_application           about;
fileselection_application   fileselection;

gchar         ach[purchaseDate_size + 1];
gchar         an[vintage_size + 1];
gchar         cons[potentielDeGarde_size + 1];

/*
 * ********************************************************
 * variables issues du fichier de configuration ~/.xcaverc
 */
gchar DBPATH[Size_DBPATH];
gchar WindowsXcaveHeight[8];
gchar WindowsXcaveWidth[8];
gchar fileLocation[Size_CONF];
gchar printerLocation[Size_CONF];
gchar browserLocation[Size_CONF];

/*
 * dimension de la fenetre Detail
 */
gchar WindowsDetailHeight[8];
gchar WindowsDetailWidth[8];
/*
 * dimension de la fenetre rack
 */
gchar WindowsRackHeight[8];
gchar WindowsRackWidth[8];
/*
 * dimension de la fenetre degustation
 */
gchar WindowsDegustationHeight[8];
gchar WindowsDegustationWidth[8];
/*
 * dimension de la fenetre  consul degustation
 */
gchar WindowsConsultDegustationHeight[8];
gchar WindowsConsultDegustationWidth[8];
/*
 * dimension de la fenetre synthese
 */
gchar WindowsSyntheseHeight[8];
gchar WindowsSyntheseWidth[8];
/*
 * 0 pas d'affichage des vins ayant une quantite nulle
 * 1 affichage de tous les vins
 */
gint  QT;
/*
 */
gint  DetailMaxRowEmplacement;
gint  DetailMaxRowPurchase;
gint  DetailMaxRowDrinking;
/*
 * structure de l'emplacement de stockage
 */
gint  rackNb;
gint  rackRowNb;
gint  rackColNb;
GList *list_rackRow;
GList *list_rackCol;

/* */
gint   debug;

/*
 * ***********************************************************
 */

/*
 * structure de donnees pour les g_list
 */
typedef struct {
		gchar 		Nom[domain_size];
		gchar 		vintage[vintage_size];
		gchar 		supplier[supplier_size];     /* supplier */
		gchar 		qty[qty_size];
	} Detail;
typedef Detail *ptrDetail;

typedef struct {
		gchar      country[country_size];
		gchar 		Region[region_size];
		gchar 		Appellation[appellation_size];
		gchar 		color[color_size];
	} Categ;
typedef Categ *ptrCateg;

typedef struct {
	gchar 		Region[region_size];
	gchar 		Appellation[appellation_size];
	} Appellation;
typedef Appellation *ptrAppellation;

typedef struct {
		gchar       country[country_size];
		gchar 		Region[region_size];
	} Region;
typedef Region *ptrRegion;

typedef struct {
		gint		Rack;
		gint		Row;
 		gint		Column;
		gchar 		Nom[domain_size];
	} Emplacement;
typedef Emplacement *ptrEmplacement;

typedef struct {
		gint		Rack;
		gint		Row;
		gint		Column;
		gchar 		Nom[domain_size];
		gpointer	ptr_list_stock_data;
		gpointer	ptr_widget_name;		
	} Rack;
typedef Rack *ptrRack;

typedef struct {
		gint 	Achat;
		gint	qty;
		gfloat	Prix;
		gchar   Supplier[supplier_size + 1];
		gchar   SupplierAdr[supplierAdr_size + 1];
	} Purchase;
typedef Purchase *ptrPurchase;

typedef struct {
		gint	Conso;
		gint	qty;
		gchar 	Note[rated_size + 1];
		gchar 	Commentaire[drinkingComment_size + 1];
		time_t  degustation_sheet_id;
	} Drinking;
typedef Drinking *ptrDrinking;

typedef struct {
		gint	   qty;
		GList     *list_purchase;
	} purchase_info;
typedef purchase_info *ppurchase_info;

typedef struct {
		  gint		qty;
		  GList     *list_drinking;
	} drinking_info;
typedef drinking_info *pdrinking_info;

/* structure de l'enregistrement  partir de la version 1.1 */
typedef struct {
		/* general */
		gchar       country[country_size];
		gchar       Region[region_size];
		gchar       Appellation[appellation_size];
		gchar       Nom[domain_size];
		gint        vintage;
		gchar       color[color_size];
		gchar       supplier[supplier_size];     /*producer */
		gchar       wineMakerAdr[producerAdr_size];
		gchar       Cepage[cepage_size];
		gint        Conserv;		      /* dure de conservation */
		gchar       temperatureDeDegustation[temperature_size];
		/* stock */
		gint         qty;
		GList       *list_emplacement;
		/* Achat  - Purchase	 */
		gint         NbPurchase;
		GList       *list_purchase;
		/* Consommation - Drinking	 */
		gint         NbDrinking;
		GList       *list_drinking;
		GList       *list_degustation;
		/* Commentaire */
		gchar        Commentaire[comment_size];
		gchar        Note[rated_size];
		/* Global */
		gint         Maturite;  /* taux de maturit : champs calcul (=now - Achat / Conserv) */

	} Vin;
typedef Vin *ptrVin;

typedef struct {
    /*
	 * DEGUSTATION SHEET ID FRAME
	 */
        time_t    degustation_sheet_id;
        gchar     comment[80];
    /*
	 * WINE INFORMATION FRAME
	 */

        gchar     domain[domain_size];
        gchar     region[region_size];
        gchar     appellation[appellation_size];
        gint      vintage;
        gchar     color[color_size];
        gchar     degree[degree_size];
        gchar     producer[producer_size];
    /*
	 * VISUAL (COLOR) FRAME
	 */
        gint      depth_hscale;
        gchar     depth_text[80];
        gint      tint_hscale;
        gchar     tint_text[80];
    /*
	 * OLFACTIVE (NOSE) FRAME 
	 */
        gint      sos_hscale;
        gchar     sos_text[80];
        gint      floral_hscale;
        gchar     floral_text[80];
        gint      fruity_hscale;
        gchar     fruity_text[80];
        gint      vegetable_hscale;
        gchar     vegetable_text[80];
        gint      chemical_hscale;
        gchar     chemical_text[80];
        gint      balsam_hscale;
        gchar     balsam_text[80];
        gint      spicy_hscale;
        gchar     spicy_text[80];
        gint      wooded_hscale;
        gchar     wooded_text[80];
        gint      animal_hscale;
        gchar     animal_text[80];
        gint      other_hscale;
        gchar     other_text[80];
        gint      complexity_hscale;                  
	/*
	 * GUSTATIVE (MOUTH) FRAME 
	 */
        gint      acidity_hscale;
        gchar     acidity_text[80];
        gint      mellow_hscale;
        gchar     mellow_text[80];
        gint      bitterness_hscale;
        gchar     bitterness_text[80];
        gint      alcohol_hscale;
        gchar     alcohol_text[80];
        gint      chewing_hscale;
        gchar     chewing_text[80];
        gint      astringency_hscale;
        gchar     astringency_text[80];

    /*
	 * BALANCE FRAME 
	 */
        gchar     dbn_text[80];
        gint      persistency_hscale;
        gchar     persistency_text[80];
        gchar     default_text[80];
        gint      global_rate_spinbutton;
        gint      maturity_spinbutton;
        gint      worth_keeping_spinbutton;
        gchar     dish_text[400];
	} degustation_sheet;
typedef degustation_sheet *ptrDegustation_sheet;

/*
 * A xmlRacks record
 * an xmlChar * is really an UTF8 encoded gchar string (0 terminated)
 */
typedef struct xmlRacks {
    xmlChar *rackNb;
    xmlChar *row;
    xmlChar *column;
} xmlRacks, *xmlRacksPtr;

/*
 * A xmlDrinking record
 * an xmlChar * is really an UTF8 encoded gchar string (0 terminated)
 */
typedef struct xmlDrinking {
    xmlChar *date;
    xmlChar *qty;
    xmlChar *rated;
    xmlChar *comment;
    xmlChar *DSid;
} xmlDrinking, *xmlDrinkingPtr;

/*
 * A xmlPurchase record
 * an xmlChar * is really an UTF8 encoded gchar string (0 terminated)
 */
typedef struct xmlPurchase {
    xmlChar *date;
    xmlChar *qty;
    xmlChar *price;
    xmlChar *supplier;
    xmlChar *supplierAdr;
} xmlPurchase, *xmlPurchasePtr;

typedef struct xmlWine {
    xmlChar *country;
    xmlChar *region;
    xmlChar *appellation;
    xmlChar *domain;
    xmlChar *vintage;
    xmlChar *color;
    xmlChar *wineMaker;
    xmlChar *wineMakerAdr;
    xmlChar *cepage;
    xmlChar *potentielDeGarde;
    xmlChar *temperatureDeDegustation;
    gint nbRacks;
    xmlRacksPtr xmlRacks[100];
    gint nbPurchase;
    xmlPurchasePtr xmlPurchase[100];
    gint nbDrinking;
    xmlDrinkingPtr xmlDrinking[100];
    xmlChar *rated;
    xmlChar *comment;
} xmlWine, *xmlWinePtr;


typedef struct xmlDegustation {
   xmlChar    *degustation_sheet_id;
   xmlChar    *comment;
   xmlChar    *domain;
   xmlChar    *region;
   xmlChar    *appellation;
   xmlChar    *vintage;
   xmlChar    *color;
   xmlChar    *degree;
   xmlChar    *producer;
   xmlChar    *depth_hscale;
   xmlChar    *depth_text;
   xmlChar    *tint_hscale;
   xmlChar    *tint_text;
   xmlChar    *sos_hscale;
   xmlChar    *sos_text;
   xmlChar    *floral_hscale;
   xmlChar    *floral_text;
   xmlChar    *fruity_hscale;
   xmlChar    *fruity_text;
   xmlChar    *vegetable_hscale;
   xmlChar    *vegetable_text;
   xmlChar    *chemical_hscale;
   xmlChar    *chemical_text;
   xmlChar    *balsam_hscale;
   xmlChar    *balsam_text;
   xmlChar    *spicy_hscale;
   xmlChar    *spicy_text;
   xmlChar    *wooded_hscale;
   xmlChar    *wooded_text;
   xmlChar    *animal_hscale;
   xmlChar    *animal_text;
   xmlChar    *other_hscale;
   xmlChar    *other_text;
   xmlChar    *complexity_hscale;
   xmlChar    *acidity_hscale;
   xmlChar    *acidity_text;
   xmlChar    *mellow_hscale;
   xmlChar    *mellow_text;
   xmlChar    *bitterness_hscale;
   xmlChar    *bitterness_text;
   xmlChar    *alcohol_hscale;
   xmlChar    *alcohol_text;
   xmlChar    *chewing_hscale;
   xmlChar    *chewing_text;
   xmlChar    *astringency_hscale;
   xmlChar    *astringency_text;
   xmlChar    *dbn_text;
   xmlChar    *persistency_hscale;
   xmlChar    *persistency_text;
   xmlChar    *default_text;
   xmlChar    *global_rate_spinbutton;
   xmlChar    *maturity_spinbutton;
   xmlChar    *worth_keeping_spinbutton;
   xmlChar    *dish_text;
} xmlDegustation, *xmlDegustationPtr;

/*
 * degustation sheet 
 */
degustation_sheet       *lDS;

gint nowan;

gint NbBottleStock;  /* compteur 'Nombre de bouteille dans le stock */
gint NbBottleDetail; /* compteur 'Nombre de bouteille detail (ie d'un meme vin) */

/*
 * synthese
 */
gint          xcave_synthese_nb_emplacement;
gint          xcave_synthese_nb_emplacement_occupe;

gboolean flag_purchase_doubleclick;
gboolean flag_drinking_doubleclick;

/* Flag indiquant l'origine de la fenetre detail */
enum {
	NO_BUTTON = 0,
	BUTTON_ADD = 1,
	BUTTON_MODIF = 2,
	BUTTON_RACK = 3,
	BUTTON_RACK_ADD = 4,
	BUTTON_RACK_MODIF = 5,
	BUTTON_DUPLICATE = 6,
	BUTTON_RACK_DUPLICATE = 7
};

GList  *list_stock;

GList  *list_categ;
ptrCateg Ctg;

GList	*list_color;
GList	*list_country;
GList	*list_region;
GList	*list_country_region;
GList	*list_appellation;
GList	*list_region_appellation;
GList	*list_cepage;
GList	*list_rack;
GList	*list_full_ds;
GList	*list_ds;
GList	*list_lw;             /* length & width for windows size */

GdkFont		*fixed;

guint    signal_id_NbRow;
guint    signal_id_NbCol;
guint    signal_id_NbRack;
guint    signal_id_NumRack;

typedef enum {
	erreur = 0,
	existe = 1,
	nouvel = 2
} ecateg;

gint flagprint;
typedef enum { 
	lpr = 0, 
	file = 1,
	browser = 2
} eprinter;

gint flagrecord;
typedef enum { 
	all = 0, 
	record = 1
} erecord;

#include "callbacks_proto.h"

void on_main_color_combo_changed (GtkEditable       *editable, gpointer         user_data);
void on_modif_button_clicked                (GtkButton       *button,
                                        gpointer         user_data);

void on_supp_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data);

void on_button_add_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void on_entry_color_changed                 (GtkEditable     *editable,
                                        gpointer         user_data);

void on_button_add_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data);

void maturite_cell_data_function 		(GtkTreeViewColumn *col,
								   GtkCellRenderer   *renderer,
								   GtkTreeModel      *model,
								   GtkTreeIter       *iter,
								   gpointer           user_data);

void
fill_information_treeview (	gpointer	data,
							gint		colonne);
								
gint 
xcave_compute_maturity_value(gint	qt, 
							 gint	millesime,
							 gint	conservation);

void
xcave_create_treelist_purchase(void);

void
xcave_create_treelist_drinking(void);

ptrVin
xcave_id_selected_treelist_row 			(void);

ptrVin
xcave_id_selected_toggledbutton			(void);

void
on_button_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data);

/* add 'directory' plus subdirectories recursively to the list
   we browse when looking for files (e.g. pixmaps); */
void
add_support_directory_recursive                   (const gchar     *directory);

/* add 'directory' both to our directory list and
   GLADE's list */
void add_support_directory(const gchar *directory);
void xcave_fill_model (GtkTreeStore * Treeview, GtkTreeStore * Treelist);
GList* xcave_g_list_free(GList *list); 
void xcave_g_list_free_stock(void);
void on_entry_color_changed (GtkEditable *, gpointer);
void xcave_createRack (gchar *, GList *) ;
GList * xcave_rackTreatment (gchar *);
void on_xcave_rack_toggledbutton_toggled (GtkToggleButton *, gpointer);

void on_region_changed(GtkEditable *editable, gpointer  user_data);
void on_appellation_changed(GtkEditable *editable, gpointer  user_data);
void on_country_changed(GtkEditable *editable, gpointer user_data);
void on_color_changed(GtkEditable *editable, gpointer user_data);
void on_cepage_changed(GtkEditable *editable, gpointer user_data);

void list_append_length_width();

void list_append_stock ();
void list_append_color ();
void list_append_categ ();
void list_append_appellation ();
void list_append_region ();
void list_append_country ();
void list_append_cepage ();
void list_country_append_stock ();
void list_region_append_stock ();
void list_appellation_append_stock ();
void list_append_emplacement ();
void list_append_rack ();
void list_cepage_append_stock (); 
gint cmp_stock(gpointer , gpointer );
gint cmp_region(gpointer , gpointer ); 
gint cmp_nom(gpointer , gpointer ); 
gint cmp_country(gpointer , gpointer ); 
gint cmp_appellation(gpointer , gpointer ); 
gint cmp_categ_nom(gpointer , gpointer ); 
gint cmp_producteur(gpointer , gpointer ); 
gint cmp_millesime(gpointer , gpointer ); 
gint cmp_quantite(gpointer , gpointer ); 
gint cmp_cepage(gpointer , gpointer ); 
int find_existing_wine(gpointer , gpointer ); 
void on_xcave_display_modif(Vin	*Vin_rowSelected);
void quick_message (const gchar *);
void xcave_xmlWrite(const gchar *);
gint xcave_xmlread(void);
void testXmlwriterMemory(const gchar *file);
void testXmlwriterDoc(const gchar *file);
void testXmlwriterTree(const gchar *file);
void xcave_xmlWriteSingleWine(gchar *,  xmlTextWriterPtr);
void xcave_xmlWriteDegustationSheet(gchar *,  xmlTextWriterPtr);
xmlChar *xcave_utf8ToIsolat1(const gchar *in, const gchar *encoding);
xmlChar *xcave_isolat1toUtf8(const gchar *in);

void find_color(gpointer, gpointer);
void find_cepage(gpointer, gpointer);
gint fill_appellation_combo(gchar *);
gint fill_region_combo(gchar *);
gint fill_country_combo(gchar *);
gint fill_color_combo(gchar *);
gint fill_cepage_combo(gchar *);
void on_xcave_window_button_html_clicked    ();

void
on_xcave_button_add_clicked        (GtkButton   *button,
                                        gpointer         user_data);
void
on_xcave_button_modif_clicked        (GtkButton   *button,
                                        gpointer         user_data);
void
on_xcave_button_rack_clicked        (GtkButton   *button,
                                        gpointer         user_data);
void
on_nb_row_value_changed             (GtkSpinButton   *spinbutton,
                                        gpointer         user_data);

void
on_nb_col_value_changed             (GtkSpinButton   *spinbutton,
                                        gpointer         user_data);

void
on_nb_rack_value_changed          (GtkSpinButton   *spinbutton,
                                        gpointer         user_data);

void
on_num_rack_value_changed           (GtkSpinButton   *spinbutton,
                                        gpointer         user_data);

void
on_PurchaseDelete_clicked              (GtkButton       *button,
                                        gpointer         user_data);

void
on_PurchaseOk_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_PurchaseModify_clicked              (GtkButton       *button,
                                        gpointer         user_data);

void
on_DrinkingDelete_clicked              (GtkButton       *button,
                                        gpointer         user_data);

void
on_DrinkingOk_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_DrinkingModify_clicked              (GtkButton       *button,
                                        gpointer         user_data);

void
on_button_duplicate_clicked            (GtkButton       *button,
                                        gpointer         user_data);

void
on_button_degustation_form_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
on_xcave_degustation_button_ok_clicked (GtkButton       *button,
                                        gpointer         user_data);

void
on_xcave_degustation_button_cancel_clicked(GtkButton       *button,
                                        gpointer         user_data);

void
on_PurchaseDelete_clicked              (GtkButton       *button,
                                        gpointer         user_data);

void
on_DrinkingOk_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_PurchaseOk_clicked                  (GtkButton       *button,
                                        gpointer         user_data);

void
on_DrinkingDelete_clicked              (GtkButton       *button,
                                        gpointer         user_data);

GdkPixbuf *
xcave_drinking_degustation_sheet_treatment(gint *user_int);

void
on_xcave_degustation_sos_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_floral_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_fruity_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_vegetable_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_chemical_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_balsam_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_spicy_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_wooded_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_animal_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_other_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);


void
on_hscrollbar1_value_changed           (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_acidity_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);
void
on_xcave_degustation_mellow_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_bitterness_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_hscalexcave_degustation_alcohol__value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_cvave_degustation_chewing_hscale_value_changed(GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_astringency_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_persistency_hscale_value_changed(GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_depth_hscale_value_changed(GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_tint_hscale_value_changed(GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_degustation_complexity_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data);

void
on_xcave_print_radiobutton_file_pressed(GtkButton       *button,
                                        gpointer         user_data);

void
on_xcave_print_radiobutton_lpr_pressed (GtkButton       *button,
                                        gpointer         user_data);

void
on_xcave_print_radiobutton_browser_pressed
                                        (GtkButton       *button,
                                        gpointer         user_data);
void
on_xcave_print_radiobutton_all_pressed (GtkButton       *button,
                                        gpointer         user_data);

void
on_xcave_print_radiobutton_record_pressed(GtkButton       *button,
                                        gpointer         user_data);
gint
calculate_nb_bottle(gint , gchar *, gint);

void xcave_debug_int(const gchar*, const gchar*,gint, gchar*, gint); 
void xcave_debug_2int(const gchar*, const gchar*,gint, gchar*, gint, gint); 
void xcave_debug_2str(const gchar *, const gchar *, gint, gchar *, gint, gchar *); 
void xcave_debug_3str(const gchar *, const gchar *, gint, gchar *, gchar *, gchar *, gchar *); 
void xcave_debug_msg_int(const gchar *, const gchar *, gint, gchar *, gint, gint); 
void xcave_debug_msg(const gchar *, const gchar *, gint, gchar *); 
void xcave_debug_str(const gchar *, const gchar *, gint, gchar *); 
void xcave_debug_begin(const gchar *, const gchar *, gint); 
void xcave_debug_end(const gchar *, const gchar *, gint); 
void xcave_debug_ptr_int(const gchar *, const gchar *, gint, gchar *, gint);

gboolean
on_xcave_consdeg_treelist_double_click (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

GtkWidget* create_xcave (void);
GtkWidget* create_xcave_supp (void);
GtkWidget* create_xcave_detail (void);
GtkWidget* create_xcave_sommelier (void);
GtkWidget* create_xcave_config (void);
GtkWidget* create_xcave_print (void);
GtkWidget* create_xcave_about (void);
GtkWidget* create_xcave_rack (void);
GtkWidget* create_xcave_degustation (void);
GtkWidget* create_xcave_fileselection_stock (void);
GtkWidget* create_xcave_synthese (void);
GtkWidget* create_xcave_consdeg (void);

gint fill_length_combo(gchar *);

#endif /* callbacks.h */

