	/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"

void
on_xcave_degustation_check_resize     (GtkContainer    *container,
                                        gpointer         user_data)
{
   gint height = 0;
   gint width = 0;

   gdk_window_get_size( container->widget.window , &width, &height);

   sprintf(WindowsDegustationWidth,"%d",width);
   sprintf(WindowsDegustationHeight,"%d",height);
}


void
on_button_degustation_form_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
   struct tm * stnow;
   gint * ptmp_buf;
   GtkTreeIter  iter;

   /* 
    * desactive xcave.window
    */
   gtk_widget_set_sensitive(detail.window, FALSE);

   degustation.main_xml = glade_xml_new (XCAVE_GLADE_FILE, "xcave_degustation", NULL);

   /* get the xcave_degustation & label widgets from the glade XML file */
   degustation.window = glade_xml_get_widget(degustation.main_xml, "xcave_degustation");
   glade_xml_signal_autoconnect (degustation.main_xml);

   /*
    * Degustation Sheet already init ?
    */
   if (lDS != NULL) {
       /*
        * double click on a drinking line with a degustation sheet id 
        */
       degustation_sheet    *tmp_ds;
       GList                *tmp_list_ds; 

       xcave_debug_2str(__FULL__,"degustation_sheet_d",25,ctime(&lDS->degustation_sheet_id));

       tmp_ds = g_malloc ( sizeof(degustation_sheet) );

       for(tmp_list_ds = list_full_ds; tmp_list_ds != NULL ; tmp_list_ds = tmp_list_ds->next) {
          memset(tmp_ds,'\0',sizeof(degustation_sheet));
          memcpy(tmp_ds,tmp_list_ds->data,sizeof(degustation_sheet));
          if (lDS->degustation_sheet_id == tmp_ds->degustation_sheet_id) {
             memcpy(lDS,tmp_list_ds->data,sizeof(degustation_sheet));
             break; 
          }
       }

       /*
        * INFORMATION FRAME
        */
       stnow=localtime(&lDS->degustation_sheet_id);
       gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_year_spinbutton")), 
                                  (gfloat)stnow->tm_year+1900);
       gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_day_spinbutton")), 
                                 (gfloat)stnow->tm_mday);
       gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_month_spinbutton")), 
                                 (gfloat)stnow->tm_mon+1);

       /*
    	* degustation sheet id is not anymore sensitive
	    */
       gtk_widget_set_sensitive (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_year_spinbutton"), FALSE);
       gtk_widget_set_sensitive (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_month_spinbutton"), FALSE);
       gtk_widget_set_sensitive (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_day_spinbutton"), FALSE);

       /*
        * WINE FRAME
        */
       gtk_entry_set_text (
             GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_domain_entry")),
             lDS->domain);

       gtk_entry_set_text (
             GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_app_entry")),
             lDS->appellation);

       gtk_entry_set_text (
             GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_reg_entry")),
             lDS->region);

       sprintf (an, "%d", lDS->vintage);
       gtk_entry_set_text (
             GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_vintage_entry")),
             an);
       xcave_debug_function
       gtk_entry_set_text (
             GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_color_entry")),
             lDS->color);
       xcave_debug_function

       gtk_entry_set_text (
             GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_producer_entry")),
             lDS->producer);

       gtk_entry_set_text (
             GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_degree_entry")),
             lDS->degree);

       /*
        * BALANCE SHEET FRAME
        */
       gtk_entry_set_text (
             GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_dbn_entry")),
             lDS->dbn_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_persistency_hscale")),
              (gdouble)lDS->persistency_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_persistency_entry")),
             lDS->persistency_text);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_default_entry")),
             lDS->default_text);

       gtk_spin_button_set_value (GTK_SPIN_BUTTON(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_maturity_spinbutton")), 
            (gfloat)lDS->maturity_spinbutton);

       gtk_spin_button_set_value (GTK_SPIN_BUTTON(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_worth-keeping_spinbutton")), 
            (gfloat)lDS->worth_keeping_spinbutton);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_dish_entry")),
             lDS->dish_text);

       /*
        * VISUAL FRAME
        */
       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_depth_hscale")),
              (gdouble)lDS->depth_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_depth_entry")),
             lDS->depth_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_tint_hscale")),
              (gdouble)lDS->tint_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_tint_entry")),
             lDS->tint_text);

       /*
    	* Gestion d'une image presentant les differentes robes du vin en fonction de la couleur
    	*/
       /* gtk_widget_hide (xcave_degustation_sight_image); */

       degustation.sight_image = NULL;
       if (strcmp(_(lDS->color),_("RED")) == 0 )
          degustation.sight_image = create_pixmap (degustation.window, "xcave_red_tint.png");
       if (strcmp(_(lDS->color),_("WHITE")) == 0 )
          degustation.sight_image = create_pixmap (degustation.window, "xcave_white_tint.png");
       if (strcmp(_(lDS->color),_("SPARKLING")) == 0 )
          degustation.sight_image = create_pixmap (degustation.window, "xcave_sparkling.png");
       if (degustation.sight_image != NULL) {
          gtk_container_add (GTK_CONTAINER (degustation.window), degustation.sight_image);
          gtk_widget_show (degustation.sight_image);
       }

       /*
        * OLFACTIVE FRAME
        */
       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_sos_hscale")),
              (gdouble)lDS->sos_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_sos_entry")),
             lDS->sos_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_floral_hscale")),
              (gdouble)lDS->floral_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_floral_entry")),
             lDS->floral_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_fruity_hscale")),
              (gdouble)lDS->fruity_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_fruity_entry")),
             lDS->fruity_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_vegetable_hscale")),
              (gdouble)lDS->vegetable_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_vegetable_entry")),
             lDS->vegetable_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_chemical_hscale")),
              (gdouble)lDS->chemical_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_chemical_entry")),
             lDS->chemical_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_balsam_hscale")),
              (gdouble)lDS->balsam_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_balsam_entry")),
             lDS->balsam_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_spicy_hscale")),
              (gdouble)lDS->spicy_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_spicy_entry")),
             lDS->spicy_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_wooded_hscale")),
              (gdouble)lDS->wooded_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_wooded_entry")),
             lDS->wooded_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_animal_hscale")),
              (gdouble)lDS->animal_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_animal_entry")),
             lDS->animal_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_other_hscale")),
              (gdouble)lDS->other_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_other_entry")),
             lDS->other_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_complexity_hscale")),
              (gdouble)lDS->complexity_hscale);

       /*
        * GUSTATIVE FRAME
        */
       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_acidity_hscale")),
              (gdouble)lDS->acidity_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_acidity_entry")),
             lDS->acidity_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_mellow_hscale")),
              (gdouble)lDS->mellow_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_mellow_entry")),
             lDS->mellow_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_bitterness_hscale")),
              (gdouble)lDS->bitterness_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_bitterness_entry")),
             lDS->bitterness_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_alcohol_hscale")),
              (gdouble)lDS->alcohol_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_alcohol_entry")),
             lDS->alcohol_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_chewing_hscale")),
              (gdouble)lDS->chewing_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_chewing_entry")),
             lDS->chewing_text);

       gtk_range_set_value(GTK_RANGE(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_astringency_hscale")),
              (gdouble)lDS->astringency_hscale);

       gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_astringency_entry")),
             lDS->astringency_text);

    } else {
        /*
         * Degustation Sheet initialisation
         */
        lDS = g_malloc ( sizeof(degustation_sheet) );
        memset(lDS, '\0', sizeof( degustation_sheet ));

        /* 
         * various fields initialisation 
         */

        lDS->depth_hscale = 1;
        lDS->tint_hscale = 1;
        lDS->sos_hscale = 1;
        lDS->floral_hscale = 1;
        lDS->fruity_hscale = 1;
        lDS->vegetable_hscale = 1;
        lDS->chemical_hscale = 1;
        lDS->balsam_hscale = 1;
        lDS->spicy_hscale = 1;
        lDS->wooded_hscale = 1;
        lDS->animal_hscale = 1;
        lDS->other_hscale = 1;
        lDS->complexity_hscale = 1;
        lDS->acidity_hscale = 1;
        lDS->mellow_hscale = 1;
        lDS->bitterness_hscale = 1;
        lDS->alcohol_hscale = 1;
        lDS->chewing_hscale = 1;
        lDS->astringency_hscale = 1;
        lDS->persistency_hscale = 1;

        lDS->global_rate_spinbutton = 1;
        lDS->maturity_spinbutton = 1;
        lDS->worth_keeping_spinbutton = 1;

       /*
        * INFORMATION FRAME
        */
        lDS->degustation_sheet_id = time(&lDS->degustation_sheet_id);
        stnow=localtime(&lDS->degustation_sheet_id);
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_year_spinbutton")), 
                                  (gfloat)stnow->tm_year+1900);
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_day_spinbutton")), 
                                 (gfloat)stnow->tm_mday);
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_month_spinbutton")), 
                                 (gfloat)stnow->tm_mon+1);

       /*
        * VISUAL FRAME 2.3.2
        */
	GtkWidget *xcave_degustation_sight_image = NULL;

        xcave_degustation_sight_image = create_pixmap (degustation.window, "xcave_red_tint.png");
        gtk_widget_show (xcave_degustation_sight_image);
        gtk_box_pack_start (GTK_BOX (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_information_vbox")), xcave_degustation_sight_image, TRUE, TRUE, 0);

        /*
         * WINE FRAME
         */
        gtk_entry_set_text (
              GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_domain_entry")),
              gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "vinnom"))));

       if (gtk_combo_box_get_active_iter (GTK_COMBO_BOX( detail.appellation_combo), & iter)) {
          gtk_tree_model_get ( GTK_TREE_MODEL( detail.appellation_store), & iter, 0, & ptmp_buf, -1);

          gtk_entry_set_text (
              GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_app_entry")),
              (gchar *)ptmp_buf);
       }
	
       if (gtk_combo_box_get_active_iter (GTK_COMBO_BOX( detail.region_combo), & iter)) {
          gtk_tree_model_get ( GTK_TREE_MODEL( detail.region_store), & iter, 0, & ptmp_buf, -1);

          gtk_entry_set_text (
              GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_reg_entry")),
              (gchar *)ptmp_buf);
       }

        gtk_entry_set_text (
              GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_vintage_entry")),
              gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "vinan"))));

       xcave_debug_function
       /* On recupere le GtkTreeIter de l'element selectionné. */
       if (gtk_combo_box_get_active_iter (GTK_COMBO_BOX( detail.color_combo), & iter)) {
          gtk_tree_model_get ( GTK_TREE_MODEL( detail.color_store), & iter, 0, & ptmp_buf, -1);

          gtk_entry_set_text (
              GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_color_entry")),
              (gchar *)ptmp_buf);
       }
       xcave_debug_function

        gtk_entry_set_text (
              GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_producer_entry")),
              gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "vinprod"))));

    }

   /*
    * INFORMATION FRAME
    */
    gtk_entry_set_text (GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_comments_entry")),
                        gtk_entry_get_text (GTK_ENTRY(glade_xml_get_widget(detail.main_xml, "entry_drinking_comment"))));

   /*
    * BALANCE SHEET FRAME
    */
    gint tmprate = atoi((const gchar*) gtk_entry_get_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_rated"))));
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_rate_spinbutton")), 
                               (gfloat) tmprate);

    /*
     * redimensionnement de la fenetre
     */
    if ( strlen(WindowsDegustationHeight) != 0 && strlen (WindowsDegustationWidth) != 0 ) {
        gtk_window_resize (GTK_WINDOW (degustation.window), atoi(WindowsDegustationWidth), atoi(WindowsDegustationHeight));
        printf(":%s:%s:%d:%d:%d:\n",__FILE__,__FUNCTION__,__LINE__,atoi(WindowsDegustationWidth), atoi(WindowsDegustationHeight));
    }

    gtk_widget_show (degustation.window);

}

void
on_xcave_degustation_button_ok_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
       xcave_debug_function
    /*
     * WINE FRAME
     */
	strcpy (lDS->domain, 
                gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_domain_entry"))));
	lDS->vintage = atoi( 
                gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_vintage_entry"))));
	strcpy (lDS->color, 
                gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_color_entry"))));
	strcpy (lDS->appellation, 
                gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_app_entry"))));
	strcpy (lDS->region, 
                gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_reg_entry"))));
	strcpy (lDS->degree, 
                gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_degree_entry"))));
	strcpy (lDS->producer, 
                gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_producer_entry"))));
    /*
     * VISUAL FRAME
     */
    strcpy (lDS->depth_text, 
           gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_depth_entry"))));
    strcpy (lDS->tint_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_tint_entry"))));
    /*
     * OLFACTIVE FRAME
     */
    strcpy (lDS->sos_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_sos_entry"))));
    strcpy (lDS->floral_text, 
               gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_floral_entry"))));
    strcpy (lDS->fruity_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_fruity_entry"))));
    strcpy (lDS->vegetable_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_vegetable_entry"))));
    strcpy (lDS->chemical_text, 
               gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_chemical_entry"))));
    strcpy (lDS->balsam_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_balsam_entry"))));
    strcpy (lDS->spicy_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_spicy_entry"))));
    strcpy (lDS->wooded_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_wooded_entry"))));
    strcpy (lDS->animal_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_animal_entry"))));
    strcpy (lDS->other_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_other_entry"))));
    /*
     * GUSTATIVE FRAME
     */
    strcpy (lDS->acidity_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_acidity_entry"))));
    strcpy (lDS->mellow_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_mellow_entry"))));
    strcpy (lDS->bitterness_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_bitterness_entry"))));
    strcpy (lDS->alcohol_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_alcohol_entry"))));
    strcpy (lDS->chewing_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_chewing_entry"))));
    strcpy (lDS->astringency_text, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_astringency_entry"))));
    /*
	 *  INFORMATION FRAME
	 */	
    strcpy (lDS->comment, 
                gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_comments_entry"))));

    struct tm * stnow;
    stnow=localtime(&lDS->degustation_sheet_id);
    stnow->tm_year = atoi(gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_year_spinbutton")))) - 1900; 
    stnow->tm_mday = atoi(gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_day_spinbutton"))));
    stnow->tm_mon  = atoi(gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_month_spinbutton")))) - 1;
    lDS->degustation_sheet_id = mktime(stnow);
       
    xcave_debug_2str(__FULL__,"degustation_sheet_d",25,ctime(&lDS->degustation_sheet_id));

    /*
     * BALANCE SHEET FRAME
     */
    strcpy (lDS->dbn_text, 
            gtk_entry_get_text (GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_dbn_entry"))));
    strcpy (lDS->persistency_text, 
               gtk_entry_get_text (GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_persistency_entry"))));
    strcpy (lDS->default_text, 
               gtk_entry_get_text (GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_default_entry"))));
    lDS->global_rate_spinbutton = atoi(
               gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_rate_spinbutton"))));
    lDS->maturity_spinbutton = atoi(
               gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_maturity_spinbutton"))));
	lDS->worth_keeping_spinbutton = atoi(
               gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(degustation.main_xml, "xcave_degustation_worth-keeping_spinbutton"))));
    strcpy (lDS->dish_text, 
               gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(degustation.main_xml, "xcave_degustation_dish_entry"))));

   /*
    * update comment of the drinking line
    */
    gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_comment")),lDS->comment);

   /*
    * update comment of the drinking line
    */
    gchar    rate[4];   /* 2.4.0 */
    sprintf (rate, "%d", lDS->global_rate_spinbutton);
    gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_drinking_rated")),rate);

    gtk_object_destroy (GTK_OBJECT (degustation.window));

    gtk_widget_set_sensitive(detail.window, TRUE);
       xcave_debug_function
}

void
on_xcave_degustation_destroy          (GtkObject       *object,
                                        gpointer         user_data)
{
    gtk_object_destroy (GTK_OBJECT (degustation.window));
    gtk_widget_set_sensitive(detail.window, TRUE);
}

void
on_xcave_degustation_button_cancel_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_object_destroy (GTK_OBJECT (degustation.window));
    gtk_widget_set_sensitive(detail.window, TRUE);
}

void
on_xcave_degustation_depth_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->depth_hscale = gtk_range_get_value(GTK_RANGE(range));
}

void
on_xcave_degustation_tint_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->tint_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_sos_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->sos_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_floral_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->floral_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_fruity_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->fruity_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_vegetable_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->vegetable_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_chemical_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->chemical_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_balsam_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->balsam_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_spicy_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->spicy_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_wooded_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->wooded_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_animal_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->animal_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_other_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->other_hscale = gtk_range_get_value(GTK_RANGE(range));
}

void
on_xcave_degustation_complexity_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->complexity_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_acidity_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->acidity_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_mellow_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->mellow_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_bitterness_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->bitterness_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_hscalexcave_degustation_alcohol__value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->alcohol_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_cvave_degustation_chewing_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->chewing_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_astringency_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->astringency_hscale = gtk_range_get_value(GTK_RANGE(range));
}


void
on_xcave_degustation_persistency_hscale_value_changed
                                        (GtkRange        *range,
                                        gpointer         user_data)
{
  lDS->persistency_hscale = gtk_range_get_value(GTK_RANGE(range));
}

