/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include "sys/wait.h"

#include "callbacks.h"


void
on_xcave_button_print_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
    /* initialisation */
    memset(fileLocation,'\0',sizeof(fileLocation));
    strcpy(fileLocation,getenv("HOME"));
    strncat(fileLocation,"/xcave.txt",10);

    /* 
     * desactive xcave.window
     */
    gtk_widget_set_sensitive(xcave.window, FALSE);

    /* get the xcave_print widget from the glade XML file  */
    print.main_xml = glade_xml_new(XCAVE_GLADE_FILE,"xcave_print",NULL);
    glade_xml_signal_autoconnect (print.main_xml);

    print.window = glade_xml_get_widget(print.main_xml, "xcave_print");
    
    flagprint = lpr;
    gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(print.main_xml, "xcave_print_hbox2_entry_printer")),printerLocation);

    flagrecord = all;

}


void
on_xcave_print_destroy    (GtkObject       *object,
							gpointer         user_data)
{

   gtk_object_destroy (GTK_OBJECT (print.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);
}


void
on_xcave_print_button_cancel_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_object_destroy (GTK_OBJECT (print.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);
}


void
on_xcave_print_button_ok_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{

  GList            *tmp_list_stock;
  GList            *tmp_list_emplacement;
  Vin              *tmpVin;
  ptrEmplacement    tmpEmplacement = NULL;
  gint              ret = 0;
		
  pid_t   pid = 1;
  gchar    bprinter[80];
  gint     fd;
  gchar    print_buffer[80];

	/* where shall we write */
	
	memset(bprinter,'\0',sizeof(bprinter));
	memset(print_buffer,'\0',sizeof(print_buffer));

	switch ( flagprint ) {
		case lpr :
			sprintf(bprinter,"%s/.xcave.lst",getenv("HOME"));
			strcpy(printerLocation,gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(print.main_xml, "xcave_print_hbox2_entry_printer"))));
			break;
		case file :
			strcpy(bprinter,gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(print.main_xml, "xcave_print_hbox2_entry_printer"))));
			break;
		case browser :
			on_xcave_window_button_html_clicked();
			gtk_object_destroy (GTK_OBJECT (print.window));

			/* 
			 * reactive xcave.window
			 */
			gtk_widget_set_sensitive(xcave.window, TRUE);
			return;
			break;
		default:
			break;
	}
       
  /* open file for writing */
  fd = open (bprinter,O_RDWR|O_CREAT|O_TRUNC,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
  if (fd<0) {
     g_warning ("file error");
  }

  /*
   * Impression de la totalite du stock
   */
  if ( flagrecord == all ) {
	 tmpVin = g_malloc (sizeof (Vin));
  
     /* c'est parti pour l'entete */
     ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
     sprintf(print_buffer,"| %-11s| %-18s| %-31s| %-4.4s| %-3.3s|\n",_("Region"),
		                             _("Appellation"),
								     _("Domain"),
								     _("v.year"),
								     _("qty."));
     ret = write(fd,print_buffer,strlen(print_entete)); 
     ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 

     /* et maintenant le fichier Stocks */
     list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_region);
     for(tmp_list_stock = list_stock; tmp_list_stock != NULL; tmp_list_stock = tmp_list_stock->next) {
        memset(tmpVin,'\0',sizeof(Vin));
        memcpy(tmpVin,tmp_list_stock->data,sizeof(Vin));
	
        memset(print_buffer,'\0',sizeof(print_buffer));
	 
		/*
		gchar * tmp;
		tmp = xcave_isolat1toUtf8(tmpVin->Nom);
		*/
	 
        sprintf(print_buffer,"|%-12.12s|%-19.19s|%-32.32s| %4.4d| %3.d|\n",tmpVin->Region,
			                            tmpVin->Appellation,
									    tmpVin->Nom,
									    tmpVin->vintage,
									    tmpVin->qty);
        if (tmpVin->qty != 0) ret = write(fd,print_buffer,sizeof(print_buffer)-1); 

     } /* END for */

     ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 

     g_free(tmpVin);
	  
  } 
  else {

	tmpVin = xcave_id_selected_treelist_row();
    /*
     * Impression de l'element selectionn dans le stock
     */
	if (tmpVin != NULL) {
		ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
		 
		sprintf(print_buffer,_("| Domain: %-48s Vintage Year: %d |\n"),tmpVin->Nom,tmpVin->vintage);
		ret = write(fd,print_buffer,strlen(print_buffer)); 
		memset(print_buffer,'\0',sizeof(print_buffer));
	
		ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
	
		/*
		 * General
		 */
		sprintf(print_buffer,_("| Country: %-24s         %32.32s |\n"),tmpVin->country,tmpVin->Region);
		ret = write(fd,print_buffer,strlen(print_buffer)); 
		memset(print_buffer,'\0',sizeof(print_buffer));
		sprintf(print_buffer,_("| Appellation: %-61s |\n"),tmpVin->Appellation);
		ret = write(fd,print_buffer,strlen(print_buffer)); 
		memset(print_buffer,'\0',sizeof(print_buffer));
		sprintf(print_buffer,_("| Variety: %-65s |\n"),tmpVin->Cepage);
		ret = write(fd,print_buffer,strlen(print_buffer)); 
		memset(print_buffer,'\0',sizeof(print_buffer));
		sprintf(print_buffer,_("| Color: %-32s                                    |\n"),tmpVin->color);
		ret = write(fd,print_buffer,strlen(print_buffer)); 
		memset(print_buffer,'\0',sizeof(print_buffer));
	
		/*
		 * Stock
		 */
		ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
		sprintf(print_buffer,_("| Stock  %-52s Quantity:  %3.d |\n")," ",tmpVin->qty);
		ret = write(fd,print_buffer,strlen(print_buffer)); 
	
		tmpEmplacement = g_malloc (sizeof(Emplacement));
		for(tmp_list_emplacement = tmpVin->list_emplacement; 
			tmp_list_emplacement != NULL; 
			tmp_list_emplacement = tmp_list_emplacement->next) {
	
			memset(tmpEmplacement,'\0',sizeof(Emplacement));
			memcpy(tmpEmplacement,tmp_list_emplacement->data,sizeof(Emplacement));
	
			memset(print_buffer,'\0',sizeof(print_buffer));
			sprintf(print_buffer,_("| Rack: %2.d   Row: %2.d   Column: %2.d %-43s|\n"),
							     tmpEmplacement->Rack+1,
								 tmpEmplacement->Row,
								 tmpEmplacement->Column,
								 " ");
			ret = write(fd,print_buffer,strlen(print_buffer)); 
		}
		free(tmpEmplacement);
		memset(print_buffer,'\0',sizeof(print_buffer));
	
		/*
		 * Achat
		 */
		ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
		sprintf(print_buffer,_("| Purchase  %-64s |\n")," ");
		ret = write(fd,print_buffer,strlen(print_buffer)); 
	
		/*
		 * Consommation
		 */
		ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
		sprintf(print_buffer,_("| Drinking  %-64s |\n")," ");
		ret = write(fd,print_buffer,strlen(print_buffer)); 
		 
		/*
		 * Comment
		 */
		ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
		{
			int i = 0;
			for (i = 0 ; i < strlen(tmpVin->Commentaire);) {
				int j = 0;
				j = strcspn(tmpVin->Commentaire + i, "");
				if (  j < 74 ) {
					sprintf(print_buffer,_("| %*.*s %*s |\n"),j,j,&tmpVin->Commentaire[i],73-j," ");
					i=i+j+1;
				}
				else {
					sprintf(print_buffer,_("| %74.74s |\n"),tmpVin->Commentaire+i);
					if (j == 74) i++;
					i=i+74;
				}
				ret = write(fd,print_buffer,strlen(print_buffer)); 
				memset(print_buffer,'\0',sizeof(print_buffer));
			}
		}
	
		ret = write(fd,print_ligne_separ,strlen(print_ligne_separ)); 
	 } /* endif Vin_rowSelected != NULL */
  } /* end else */

  close (fd);

  if ( flagprint == lpr ) {
    pid = fork ();

    if (pid > 0) { /* Processus pre      */
	  waitpid(pid,0,0);
    } 
    else 
       if (pid == 0) { /* Processus fils      */
         gchar * argv [5];
         gint i=0,j=0,k=0;
         gint cr=0;

	 /* on recupere la commande d'impression et les arguments dans la zone de 
	  * saisie 
	  */
         for (i = 0; i < strlen(printerLocation) + 1; i++) {
            if ( (strncmp( printerLocation + i , " "  , 1) == 0) || printerLocation[i] == '\0' ) {
              argv[j] = ( gchar * ) g_malloc (i-k+1);
              memset(argv[j] , '\0' , i-k+1);
              strncpy(argv[j] , printerLocation + k , i-k);
              k = i;
              j++;
            }
         }
       
         argv[j] = ( gchar * ) g_malloc (strlen(bprinter)+1);
         strncpy(argv[j] , bprinter , strlen(bprinter)+1);
	  
	 /* je ne sais pas le nombre d'argument, limitation a ... quelques uns
	  * pour l'instant.
	  */
         switch(j) {
	   case 0: g_warning("printer fatal error");
		   break;
	   case 1: cr=execlp (argv[0],argv[0],argv[1],NULL);
		   break;
	   case 2: cr=execlp (argv[0],argv[0],argv[1],argv[2],NULL);
		   break;
	   case 3: cr=execlp (argv[0],argv[0],argv[1],argv[2],argv[3],NULL);
		   break;
	   case 4: cr=execlp (argv[0],argv[0],argv[1],argv[2],argv[3],argv[4],NULL);
		   break;
	   default: g_warning("printer fatal error"); break;
         }
	 
         /* cr=execlp ("lpr","lpr","/root/xcave.txt",NULL); */
          
	 for (i=j;i>0;i--) g_free(argv[i]);
         _exit(0);
       } 
       else {
            /* Traitement d'erreur */
            g_warning ("fork fatal error");
            }
  }

  gtk_object_destroy (GTK_OBJECT (print.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);

}

void
on_xcave_print_radiobutton_lpr_pressed (GtkButton       *button,
                                        gpointer         user_data)
{
	flagprint = lpr;
	/* 2.4 sprintf(printerLocation,printerLocation);  */
	gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(print.main_xml, "xcave_print_hbox2_entry_printer")),printerLocation);
}

void
on_xcave_print_radiobutton_file_pressed(GtkButton       *button,
                                        gpointer         user_data)
{
	flagprint = file;
	gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(print.main_xml, "xcave_print_hbox2_entry_printer")),fileLocation);
}

void
on_xcave_print_radiobutton_browser_pressed(GtkButton       *button,
                                           gpointer         user_data)
{
	flagprint = browser;
	gtk_entry_set_text(GTK_ENTRY(glade_xml_get_widget(print.main_xml, "xcave_print_hbox2_entry_printer")),browserLocation);
	

}

void
on_xcave_print_radiobutton_record_pressed(GtkButton       *button,
                                          gpointer         user_data)
{
	Vin		*Vin_rowSelected;


	Vin_rowSelected = xcave_id_selected_treelist_row();
	if (Vin_rowSelected != NULL)
		flagrecord = record;
	else
		quick_message (_("No selected row"));


}

void
on_xcave_print_radiobutton_all_pressed (GtkButton       *button,
                                        gpointer         user_data)
{
    flagrecord = all;
}
