/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

void
xcave_create_treelist_purchase(void)
{
    GtkTreeViewColumn   *col;
    GtkCellRenderer     *renderer;

    detail.purchase_treeview = glade_xml_get_widget(detail.main_xml,"xcave_detail_purchase_treeview");
    if (detail.purchase_treeview == NULL) {
       g_printerr("Could not build xcave_detail_purchase_treeview");
       return;
	}

    /* --- TreeList Column #1 --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("year"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_PURCHASE_DATE, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.purchase_treeview), col);

    /* --- TreeList Column #2 -- QUANTITY --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Qty"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_PURCHASE_QTY, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.purchase_treeview), col);

    /* --- TreeList Column #3 -- PRICE --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Price"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_PURCHASE_PRICE, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.purchase_treeview), col);

    /* --- TreeList Column #4 -- SUPPLIER --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Supplier"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_SUPPLIER, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.purchase_treeview), col);

    /* --- TreeList Column #5 -- SUPPLIER ADDRESS --- */
    col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, _("Supplier address"));
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_set_attributes(col, renderer, "text", COL_TREELIST_SUPPLIER_ADR, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(detail.purchase_treeview), col);
	
   /*
    * 2.3.1 alternance de couleur de fond pour chaque ligne
    */
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(detail.purchase_treeview),TRUE);

   /* Creates a new tree store as with n_columns columns each of the types passed in. */
    detail.purchase_liststore = gtk_list_store_new(NUM_COLS_TREELIST_PURCHASE, 
                                                   G_TYPE_UINT, 
                                                   G_TYPE_UINT, 
                                                   G_TYPE_STRING, 
                                                   G_TYPE_STRING, 
                                                   G_TYPE_STRING);

    gtk_tree_view_set_model(GTK_TREE_VIEW(detail.purchase_treeview), 
                           (GtkTreeModel *)detail.purchase_liststore);

    flag_purchase_doubleclick = FALSE;

    return;
}

void
on_PurchaseOk_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{

    GtkTreeIter     iter;
    Purchase	   *tmpPurchase;

    tmpPurchase = g_malloc (sizeof(Purchase));
    memset(tmpPurchase,'\0',sizeof(Purchase));

    strcpy(tmpPurchase->Supplier,
           gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier"))));
    strcpy(tmpPurchase->SupplierAdr,
           gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier_adr"))));
    tmpPurchase->Achat = atoi(
	       gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_year"))));

    tmpPurchase->qty = atoi(
           gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_qty"))));

	gchar tmp_price[12];
	g_snprintf(tmp_price,sizeof(tmp_price),"%.2f",atof(
           gtk_entry_get_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_price")))));

    detail.purchase_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.purchase_treeview);

    if (flag_purchase_doubleclick == FALSE) {
        gtk_list_store_append(detail.purchase_liststore, &iter);
        gtk_list_store_set(detail.purchase_liststore, &iter,
                                                 COL_TREELIST_PURCHASE_DATE, (guint)tmpPurchase->Achat,
                                                 COL_TREELIST_PURCHASE_QTY, (guint)tmpPurchase->qty,
                                                 COL_TREELIST_PURCHASE_PRICE, &tmp_price,
                                                 COL_TREELIST_SUPPLIER, &tmpPurchase->Supplier,
                                                 COL_TREELIST_SUPPLIER_ADR, &tmpPurchase->SupplierAdr,
                                                 -1);			
    
        NbBottleDetail += tmpPurchase->qty;
        NbBottleStock  += tmpPurchase->qty;

        sprintf (ach, "%d", nowan);
        gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_year")),(gchar *) ach);
		guint digits = 2;
		gtk_spin_button_set_digits(GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_price")), digits);
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_price")), (gfloat) 0);
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_qty")), (guint) 1);
        gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier"))," ");
        gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier_adr")),"");
	
        /*
        * update de la statusbar indiquant le nb de bouteille du vin selectionne
        * se trouvant dans le stock
        */
        xcave_debug_function
        sprintf (detail.statusbar_txt, _("Number of bottles for the selection : %d"), NbBottleDetail);
        if (detail.statusbar_id != 0) gtk_statusbar_remove ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_id);
        detail.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_txt);
        xcave_debug_function
	
    } else {

        GtkTreeSelection     *selection;
        GtkTreeModel         *model;
        GtkTreeIter           selected_row;
        gint                  tmpQty;

	    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(detail.purchase_treeview));

        if (gtk_tree_selection_get_selected(selection, &model, &selected_row)) {
            gtk_tree_model_get (model, &selected_row, 
                                COL_TREELIST_PURCHASE_QTY, &tmpQty, -1);
            NbBottleDetail -= tmpQty;
            NbBottleStock  -= tmpQty;
            gtk_list_store_set(detail.purchase_liststore, &selected_row,
							COL_TREELIST_PURCHASE_DATE, (guint)tmpPurchase->Achat,
							COL_TREELIST_PURCHASE_QTY, (guint)tmpPurchase->qty,
							COL_TREELIST_PURCHASE_PRICE, &tmp_price,
							COL_TREELIST_SUPPLIER, &tmpPurchase->Supplier,
							COL_TREELIST_SUPPLIER_ADR, &tmpPurchase->SupplierAdr,
									-1);			

		  NbBottleDetail += tmpPurchase->qty;
		  NbBottleStock  += tmpPurchase->qty;

		  sprintf (ach, "%d", nowan);
		  gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_year")),(gchar *) ach);
		  guint digits = 2;
		  gtk_spin_button_set_digits(GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_price")), digits);
		  gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_price")), (gfloat) 0);
		  gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_qty")), (guint) 1);
		  gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier"))," ");
		  gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier_adr")),"");
		
		  /*
		   * update de la statusbar indiquant le nb de bouteille du vin selectionne
		   * se trouvant dans le stock
		   */
        xcave_debug_function
		  sprintf (detail.statusbar_txt, _("Number of bottles for the selection : %d"), NbBottleDetail);
		  if (detail.statusbar_id != 0) gtk_statusbar_remove ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_id);
		  detail.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_txt);
        xcave_debug_function
          }
          else {
                quick_message (_("You must select a line!!!"));
        }
    }

    g_free(tmpPurchase);

    flag_purchase_doubleclick = FALSE;

}

gboolean
on_xcave_detail_purchase_treeview_row_activated (GtkWidget       *widget,
                                   GdkEventButton  *event,
                                   gpointer         user_data)
{
    GtkTreeModel 		*model;
    GtkTreeIter          iter;
    GtkTreeSelection    *selection;

    gint             date_achat = 0;
    gint             qty = 0;
    gfloat           price = 0.0;
    gchar            *pSupplier = NULL;
    gchar            *pSupplierAdr = NULL;	
	gchar            *pPrice = NULL;

	detail.purchase_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.purchase_treeview);

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(detail.purchase_treeview));
	gtk_tree_selection_get_selected (selection, &model, &iter);

    gtk_tree_model_get (model, &iter,
                        COL_TREELIST_PURCHASE_DATE, &date_achat,
                        COL_TREELIST_PURCHASE_QTY, &qty,
                        COL_TREELIST_PURCHASE_PRICE, &pPrice,
                        COL_TREELIST_SUPPLIER, (gchar *)&pSupplier,
                        COL_TREELIST_SUPPLIER_ADR,(gchar *)&pSupplierAdr,
                        -1);
    sprintf (ach, "%4d", date_achat);
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_year")),(gchar *) ach);
	
	price = atof(pPrice);
	guint digits = 2;
	gtk_spin_button_set_digits(GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_price")), digits);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_price")), (gfloat) price);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (glade_xml_get_widget(detail.main_xml, "spinbutton_purchase_qty")), (guint) qty);
    gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier_adr")),(gchar *)pSupplierAdr);
    gtk_entry_set_text(GTK_ENTRY (glade_xml_get_widget(detail.main_xml, "entry_purchase_supplier")),(gchar *)pSupplier);

    flag_purchase_doubleclick = TRUE;

    return FALSE;

}
void
on_PurchaseDelete_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkTreeModel 		*model;
    GtkTreeIter          iter;
    GtkTreeSelection    *selection;
	gint                 tmpQty;
	
    detail.purchase_liststore = (GtkListStore *) gtk_tree_view_get_model((GtkTreeView *)detail.purchase_treeview);

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(detail.purchase_treeview));
	if (gtk_tree_selection_get_selected (selection, &model, &iter)) {

        gtk_tree_model_get (model, &iter, COL_TREELIST_PURCHASE_QTY, &tmpQty,-1);

		NbBottleDetail -= tmpQty;
		NbBottleStock  -= tmpQty;
		gtk_list_store_remove( detail.purchase_liststore, &iter);
		sprintf (detail.statusbar_txt, _("Number of bottles for the selection : %d"), NbBottleDetail);
		if (detail.statusbar_id != 0) gtk_statusbar_remove ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_id);
		detail.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)detail.statusbar_v, detail.statusbar_ctxtid, detail.statusbar_txt);
	}
	else {
		 GtkWidget	*dialog;
		 dialog = gtk_message_dialog_new ((GtkWindow *)detail.window,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  _("You must select a line!!!")
                                  );
 		gtk_dialog_run (GTK_DIALOG (dialog));
 		gtk_widget_destroy (dialog);
	}

    flag_purchase_doubleclick = FALSE;

}

