/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include <gtk/gtk.h>

#include "callbacks.h"

GList *tmp_list_combo_region;
GList *tmp_list_combo_country;
GList *tmp_list_combo_app;

/***************************************************************************
 * Traitement d'un signal
 * GtkWindows: 'xcave'
 * Comment: Gestion des changements de taille de la fenetre
 */
void on_xcave_check_resize                  (GtkContainer    *container,
                                        gpointer         user_data)
{
   gint height = 0;
   gint width = 0;

   gdk_window_get_size( container->widget.window , &width, &height);

   sprintf(WindowsXcaveWidth ,"%d",width);
   sprintf(WindowsXcaveHeight,"%d",height);
   
}

void find_color(gpointer list_color_data, gpointer colorItems)
{
    GtkTreeIter   iter;

    if (strcasecmp(colorItems, list_color_data) == 0) {
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.color_store, &iter);
        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set (detail.color_store, &iter, 0, list_color_data, -1);
    }
}

void find_cepage(gpointer list_cepage_data, gpointer cepageItems)
{
    GtkTreeIter   iter;

    if (strcasecmp(cepageItems, list_cepage_data) == 0) {
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.cepage_store, &iter);
        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set (detail.cepage_store, &iter, 0, list_cepage_data, -1);
    }
}

void find_appellation_from_country(gpointer	list_app_data, gpointer region)
{
    GtkTreeIter   iter;

    if (strcasecmp(region, list_app_data) == 0) {	
        /* need to fillup combo country for this region */
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.appellation_store, &iter);
        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set (detail.appellation_store, &iter, 0, list_app_data + region_size, -1);
    }
}

void
find_region_from_country(gpointer	list_region_data, gpointer country)
{
    GtkTreeIter   iter;

    if (strcasecmp(country, list_region_data) == 0) {
        /* need to fillup combo country for this region */
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.region_store, &iter);
        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set (detail.region_store, &iter, 0, list_region_data + country_size , -1);

        /* need to know originated country */
        g_list_foreach(list_region_appellation,find_appellation_from_country,list_region_data + country_size);
    }
}

void find_country(gpointer	list_country_data, gpointer countryItems)
{

    if (strcasecmp(countryItems, list_country_data) == 0) {
       /* need to fillup combo country for this region */
       g_list_foreach(list_country_region,find_region_from_country,countryItems);
    }
}

void
find_country_from_region(gpointer	list_country_data, gpointer region)
{
    GtkTreeIter   iter;
    if (strcasecmp(region, list_country_data + country_size) == 0) {
       /* need to fillup combo country for this region */
       /* 
        * Appends a new row to list_store. iter will be changed to point to this new row.
        * The row will be empty after this function is called.
        */
       gtk_list_store_append(detail.country_store, &iter);
       /*
        * Sets the value of one or more cells in the row referenced by iter.
        */
       gtk_list_store_set (detail.country_store, &iter, 0, list_country_data , -1);
    }

}

void
find_appellation_from_region(gpointer	list_app_data, gpointer region)
{
    GtkTreeIter   iter;
    if (strcasecmp(region, list_app_data) == 0) {
        /* need to fillup combo country for this region */
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.appellation_store, &iter);
        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set (detail.appellation_store, &iter, 0, list_app_data + region_size, -1);
    }
}

void
find_region(gpointer	list_region_data, gpointer regitems)
{
     if (strcasecmp(regitems, list_region_data) == 0) {
        /* need to fillup combo country for this region */
        g_list_foreach(list_country_region,find_country_from_region,regitems);

        /* need to fillup combo appellation for this region */
        g_list_foreach(list_region_appellation,find_appellation_from_region,regitems);
     }
}

void
find_country_from_appellation(gpointer	list_country_data, gpointer items)
{ 
    GtkTreeIter   iter;
    if (strcasecmp(items, list_country_data + country_size) == 0) {	
	    /* need to fillup combo country for this region */
        gtk_list_store_append(detail.country_store, &iter);
        gtk_list_store_set (detail.country_store, &iter, 0, list_country_data , -1);
    }
}

void
find_region_from_appellation(gpointer	list_region_data, gpointer items)
{
    GtkTreeIter   iter;
    /* 
     * need to fillup combo region for this appellation 
     */
    if (strcasecmp(items, list_region_data + region_size) == 0) {
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.region_store, &iter);

        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set (detail.region_store, &iter, 0, list_region_data , -1);

	/* need to know originated country */
        g_list_foreach(list_country_region,find_country_from_appellation,list_region_data);

    }
}

void find_appellation(gpointer	list_appellation_data, gpointer appitems)
{
    GtkTreeIter   iter;
    if (strcasecmp(appitems, list_appellation_data) == 0) {
        xcave_debug_str(__FULL__,list_appellation_data);
        /* 
         * Appends a new row to list_store. iter will be changed to point to this new row.
         * The row will be empty after this function is called.
         */
        gtk_list_store_append(detail.appellation_store, &iter);

        /*
         * Sets the value of one or more cells in the row referenced by iter.
         */
        gtk_list_store_set (detail.appellation_store, &iter, 0, list_appellation_data , -1);

        /* need to know originated region */
        g_list_foreach(list_region_appellation,find_region_from_appellation,appitems);
    }
}

/***************************************************************************
 * Traitement d'un signal
 * Windows: 'detail'
 * GtkEntry: wineCountryEntry
 * Comment: Selection d'un country different dans la GtkCombo wineCountryList
 */
void on_country_changed                (GtkEditable     *editable,
                                   gpointer      p_data)
{
    gchar         appitems[appellation_size];
    gchar         regitems[region_size];
    gchar         countryitems[country_size];
    GtkTreeIter   iter;
	
    xcave_debug_begin(__FULL__);
    /* 
     * Un pays est selectionne - 
     *   Si region pas encore selectionne - alors on selectionne les regions du pays
     *   Si app pas encore selectionne - alors on selectionne les app associe au region
     */

    g_signal_handler_block (GTK_OBJECT (detail.appellation_combo), detail.s_appellation);
    g_signal_handler_block (GTK_OBJECT (detail.region_combo), detail.s_region);
    g_signal_handler_block (GTK_OBJECT (detail.country_combo), detail.s_country);
	
    memset(countryitems,'\0',country_size);
    strcpy(countryitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.country_combo)));
    if (strlen(countryitems) != 0) {

      memset(appitems,'\0',appellation_size);
      strcpy (appitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.appellation_combo)));

      memset(regitems,'\0',region_size);
      strcpy (regitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.region_combo)));

        gtk_list_store_clear(detail.region_store);
        gtk_list_store_clear(detail.appellation_store);
  
        /* need to fillup combo region for this country */
        g_list_foreach(list_country, find_country, countryitems);

       /* 
        * mettre a jour le champ appellation_combo avec le nom respectant la 'case' 
        */
        gint ind = fill_country_combo(countryitems);
        gtk_combo_box_set_active( GTK_COMBO_BOX (detail.country_combo), ind);

        /* display on screen app combo */
        if ( (strlen(appitems) != 0) &&
  	     (g_list_find_custom(tmp_list_combo_app, appitems, (GCompareFunc) g_ascii_strcasecmp) != NULL) ) {
            /*
             * Appends a new row to tree_store
             */
            gtk_list_store_append(detail.appellation_store, &iter);
            /*
             * Sets the value of one or more cells in the row referenced by iter
             */
            gtk_list_store_set (detail.appellation_store, &iter, 0, appitems, -1);
        }
        gtk_combo_box_set_model( GTK_COMBO_BOX ( detail.appellation_combo ),
                                 GTK_TREE_MODEL( detail.appellation_store ) );

        /* gtk_combo_box_set_active(GTK_COMBO_BOX ( detail.appellation_combo ),0); */

        /* display on screen region combo */
        if ( (strlen(regitems) != 0) &&
             (g_list_find_custom(tmp_list_combo_region, regitems, (GCompareFunc) g_ascii_strcasecmp) != NULL) ) {
             /*
              * Appends a new row to tree_store
              */
              gtk_list_store_append(detail.appellation_store, &iter);
             /*
              * Sets the value of one or more cells in the row referenced by iter
              */
              gtk_list_store_set (detail.appellation_store, &iter, 0, regitems, -1);
        }
        gtk_combo_box_set_model( GTK_COMBO_BOX( detail.region_combo ),
                                 GTK_TREE_MODEL( detail.region_store ) );
        /* gtk_combo_box_set_active(GTK_COMBO_BOX ( detail.region_combo ),0); */
	
        tmp_list_combo_region  = xcave_g_list_free(tmp_list_combo_region);
        tmp_list_combo_app     = xcave_g_list_free(tmp_list_combo_app);
       /* } if (strlen(appitems) && strlen(regitems) == 0) */
    } /* if (strlen(countryitems) != 0) */

    g_signal_handler_unblock (GTK_OBJECT (detail.appellation_combo), detail.s_appellation);
    g_signal_handler_unblock (GTK_OBJECT (detail.region_combo), detail.s_region);
    g_signal_handler_unblock (GTK_OBJECT (detail.country_combo), detail.s_country);

    /*
     * need trace
     */
    xcave_debug_str(__FULL__,countryitems);
    xcave_debug_str(__FULL__,regitems);
    xcave_debug_str(__FULL__,appitems);

    xcave_debug_end(__FULL__);

}


/*
 * Traitement d'un signal
 * Windows: 'detail'
 * GtkEntry: vinregentry
 * Comment: Selection d'une region differente dans la GtkCombo vinreglist
 */
void
on_region_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
    gchar	appitems[appellation_size];
    gchar	regitems[region_size];
    gchar	countryitems[country_size];
    GtkTreeIter   iter;

    xcave_debug_begin(__FULL__);

    g_signal_handler_block (GTK_OBJECT (detail.appellation_combo), detail.s_appellation);
    g_signal_handler_block (GTK_OBJECT (detail.region_combo),      detail.s_region);
    g_signal_handler_block (GTK_OBJECT (detail.country_combo),     detail.s_country);

    /* 
     * Une region est selectionnee - 
     *   Si region pas encore selectionne - alors on selectionne la region associee a l appellation
     *   Si pays pas encore selectionne - alors on selectionne le pays associe a la region
     */

     memset(regitems,'\0',region_size);
     strcpy (regitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.region_combo)));
     if (strlen(regitems) != 0) {
		
       memset(appitems,'\0',appellation_size);
       strcpy (appitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.appellation_combo)));

       memset(countryitems,'\0',country_size);
       strcpy (countryitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.country_combo)));
 	
       gtk_list_store_clear(detail.country_store);
       gtk_list_store_clear(detail.region_store);
       gtk_list_store_clear(detail.appellation_store);
 
       /* need to fillup app and country combos for this region */
       g_list_foreach(list_region,find_region,regitems);

       /* 
        * mettre a jour le champ appellation_combo avec le nom respectant la 'case' 
        */
        gint ind = fill_region_combo(regitems);
        gtk_combo_box_set_active( GTK_COMBO_BOX (detail.region_combo), ind);

       /* display on screen app combo */
       if ( (strlen(appitems) != 0) &&
          (g_list_find_custom(tmp_list_combo_app, appitems, (GCompareFunc) g_ascii_strcasecmp) != NULL)) {
            /*
             * Appends a new row to tree_store
             */
            gtk_list_store_append ( detail.appellation_store, &iter);
            /*
             * Sets the value of one or more cells in the row referenced by iter
             */
            gtk_list_store_set ( detail.appellation_store, &iter, 0, appitems, -1);
       }
       gtk_combo_box_set_model( GTK_COMBO_BOX( detail.appellation_combo ),
                              GTK_TREE_MODEL( detail.appellation_store ) );
       gtk_combo_box_set_active(GTK_COMBO_BOX ( detail.appellation_combo ),0);
       
       /* display on screen country combo */
       if ( (strlen(countryitems) != 0) &&
            (g_list_find_custom(tmp_list_combo_country, countryitems, (GCompareFunc) g_ascii_strcasecmp) != NULL)) {
            /*
             * Appends a new row to tree_store
             */
            gtk_list_store_append ( detail.country_store, &iter);
            /*
             * Sets the value of one or more cells in the row referenced by iter
             */
            gtk_list_store_set ( detail.country_store, &iter, 0, countryitems, -1);
       }
       gtk_combo_box_set_model( GTK_COMBO_BOX( detail.country_combo ),
                              GTK_TREE_MODEL( detail.country_store ) );
       gtk_combo_box_set_active(GTK_COMBO_BOX ( detail.country_combo ),0);
	
       tmp_list_combo_country = xcave_g_list_free(tmp_list_combo_country);
       tmp_list_combo_app	    = xcave_g_list_free(tmp_list_combo_app);

    }

    g_signal_handler_unblock (GTK_OBJECT (detail.appellation_combo), detail.s_appellation);
    g_signal_handler_unblock (GTK_OBJECT (detail.region_combo),      detail.s_region);
    g_signal_handler_unblock (GTK_OBJECT (detail.country_combo),     detail.s_country);

    /*
     * need trace
     */
    xcave_debug_str(__FULL__,countryitems);
    xcave_debug_str(__FULL__,regitems);
    xcave_debug_str(__FULL__,appitems);

    xcave_debug_end(__FULL__);
}

/*
 * Traitement d'un signal
 * Windows: 'detail'
 * GtkEntry: vinapentry
 * Comment: Selection ou modification d'une appellation (GtkCombo vinaplist)
 */
void on_appellation_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{

     gchar	appitems[appellation_size];
     gchar	regitems[region_size];
     gchar	countryitems[country_size];

     xcave_debug_begin(__FULL__);

     g_signal_handler_block (GTK_OBJECT (detail.appellation_combo), detail.s_appellation);
     g_signal_handler_block (GTK_OBJECT (detail.region_combo), detail.s_region);
     g_signal_handler_block (GTK_OBJECT (detail.country_combo), detail.s_country);

     /* 
     * Une appelation est selectionnee - 
     *   2.5.1 NON Si region pas encore selectionne - alors on selectionne la region associee a l appellation
     *   2.5.1 NON Si country pas encore selectionne - alors on selectionne le country associe a la region
     *   une appellation etant unique - si elle est dans la liste alors on force region et pays
     */

     memset(appitems,'\0',appellation_size);
     strcpy (appitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.appellation_combo)));
     if (strlen(appitems) != 0) {
	
        memset(regitems,'\0',region_size);
        strcpy (regitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.region_combo)));

        memset(countryitems,'\0',country_size);
        strcpy (countryitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.country_combo)));

        gtk_list_store_clear(detail.region_store);
        gtk_list_store_clear(detail.country_store);
  
        /* need to fillup combo region for this appellation */
        g_list_foreach(list_appellation,find_appellation,appitems);

        /* 
         * mettre a jour le champ appellation_combo avec le nom respectant la 'case' 
         */
        gint ind = fill_appellation_combo(appitems);
        gtk_combo_box_set_active( GTK_COMBO_BOX (detail.appellation_combo), ind);

        /* display on screen region combo */
        gtk_combo_box_set_model( GTK_COMBO_BOX( detail.region_combo ),
                                 GTK_TREE_MODEL( detail.region_store ) );
        gtk_combo_box_set_active(GTK_COMBO_BOX ( detail.region_combo ),0);

        /* display on screen country combo */
        gtk_combo_box_set_model( GTK_COMBO_BOX( detail.country_combo ),
                                 GTK_TREE_MODEL( detail.country_store ) );
        gtk_combo_box_set_active(GTK_COMBO_BOX ( detail.country_combo ),0);
	
        tmp_list_combo_country   = xcave_g_list_free(tmp_list_combo_country);
        tmp_list_combo_region = xcave_g_list_free(tmp_list_combo_region);
     } /* if (strlen(appitems) == 0)*/
 
     /*
      * need trace
      */
     xcave_debug_str(__FULL__,countryitems);
     xcave_debug_str(__FULL__,regitems);
     xcave_debug_str(__FULL__,appitems);

     g_signal_handler_unblock (GTK_OBJECT (detail.appellation_combo), detail.s_appellation);
     g_signal_handler_unblock (GTK_OBJECT (detail.region_combo), detail.s_region);
     g_signal_handler_unblock (GTK_OBJECT (detail.country_combo), detail.s_country);

     xcave_debug_end(__FULL__);
}

/*
 * Traitement d'un signal
 * Windows: 'detail'
 * GtkComboBoxEntry: color_combo
 * Comment: Selection ou modification d'une couleur
 */
void on_color_changed (GtkEditable     *editable, gpointer         user_data)
{
    gchar   coloritems[color_size];

    xcave_debug_begin(__FULL__);

    g_signal_handler_block (GTK_OBJECT (detail.color_combo), detail.s_color);
    memset(coloritems,'\0',color_size);
    strcpy(coloritems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.color_combo)));
    if (strlen(coloritems) != 0) {
        gtk_list_store_clear(detail.color_store);

        /* need to fillup combo region for this country */
        g_list_foreach(list_color, find_color, coloritems);

       /* 
        * mettre a jour le champ color_combo avec le nom respectant la 'case' 
        */
        gint ind = fill_color_combo(coloritems);
        gtk_combo_box_set_active( GTK_COMBO_BOX (detail.color_combo), ind);
    }
    g_signal_handler_unblock (GTK_OBJECT (detail.color_combo), detail.s_color);
    xcave_debug_end(__FULL__);
}

/*
 * Traitement d'un signal
 * Windows: 'xcave'
 * GtkComboBoxEntry: color_combo
 * Comment: Selection ou modification d'une couleur
 */
void on_main_color_combo_changed (GtkEditable * editable, gpointer 	user_data)
{
   gchar       *color;
   GtkTreeIter  iter;

   xcave_debug_begin(__FULL__);

   /* On recupere le GtkTreeIter de l'element selectionné. */
   if (gtk_combo_box_get_active_iter (GTK_COMBO_BOX( xcave.color_combo), & iter)) {
      gtk_tree_model_get ( GTK_TREE_MODEL( xcave.color_store), & iter, 0, & color, -1);
   }

   fill_information_treeview(color,COL_TREELIST_COLOR);
   xcave_debug_end(__FULL__);
}

/*
 * Traitement d'un signal
 * Windows: 'detail'
 * GtkComboBoxEntry: cepage_combo
 * Comment: Selection ou modification d'une couleur (GtkCombo vinaplist)
 */
void on_cepage_changed (GtkEditable     *editable, gpointer         user_data)
{
    gchar   cepageitems[cepage_size];

    xcave_debug_begin(__FULL__);

    g_signal_handler_block (GTK_OBJECT (detail.cepage_combo), detail.s_cepage);
    memset(cepageitems,'\0',cepage_size);
    strcpy(cepageitems,gtk_combo_box_get_active_text (GTK_COMBO_BOX (detail.cepage_combo)));
    if (strlen(cepageitems) != 0) {
        gtk_list_store_clear(detail.cepage_store);

        /* need to fillup combo region for this country */
        g_list_foreach(list_cepage, find_cepage, cepageitems);

       /* 
        * mettre a jour le champ cepage_combo avec le nom respectant la 'case' 
        */
        gint ind = fill_cepage_combo(cepageitems);
        gtk_combo_box_set_active( GTK_COMBO_BOX (detail.cepage_combo), ind);
    }
    g_signal_handler_unblock (GTK_OBJECT (detail.cepage_combo), detail.s_cepage);
    xcave_debug_end(__FULL__);
}
