/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

void
on_xcave_button_som_clicked (GtkButton       *button,
                             gpointer         user_data)
{
    /* 
     * desactive xcave.window
     */
    gtk_widget_set_sensitive(xcave.window, FALSE);

    /* get the xcave_som & label widgets from the glade XML file */
    som.main_xml = glade_xml_new(XCAVE_GLADE_FILE,"xcave_sommelier",NULL);
    glade_xml_signal_autoconnect (som.main_xml);

    som.window = glade_xml_get_widget(som.main_xml, "xcave_sommelier");


}

void
on_xcave_som_destroy             (GtkObject       *object,
                                  gpointer         user_data)
{

   gtk_object_destroy (GTK_OBJECT (som.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);
}
