/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"
/*
 * supp_modif clicked -> display
 * GtkWindow "ConSupp".
 */

void
on_xcave_button_supp_clicked   (GtkButton       *button,
                                       gpointer         user_data)
{

    Vin		*Vin_rowSelected;

   /*
    * we need selected data 
    */
   Vin_rowSelected = xcave_id_selected_treelist_row();

   if (Vin_rowSelected != NULL) {

      /* 
       * desactive xcave.window
       */
      gtk_widget_set_sensitive(xcave.window, FALSE);
      supp.main_xml = glade_xml_new (XCAVE_GLADE_FILE, "xcave_supp", NULL);
 	  glade_xml_signal_autoconnect (supp.main_xml);

      /* get the xcave_supp & label widgets from the glade XML file */
      supp.window = glade_xml_get_widget(supp.main_xml,"xcave_supp");

   }

}

/*
 * GtkWindow "ConSupp".
 * cancel_button clicked
 */
void
on_xcave_supp_button_ok_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkTreeSelection *selection;
	GtkTreeModel     *model;
	GtkTreeIter       selected_row;

	GList  *list_stock_rowSelected;
	ptrVin	Vin_rowSelected;

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(xcave.information_treeview));
	g_assert(gtk_tree_selection_get_mode(selection) == GTK_SELECTION_SINGLE);

    if (gtk_tree_selection_get_selected(selection, &model, &selected_row)) {
       /*
        * update list_stock by removing selected wine
        */
        gtk_tree_model_get (model, &selected_row, 
                            COL_TREELIST_PDATA, &Vin_rowSelected,
                            COL_TREELIST_PGLIST, &list_stock_rowSelected,
                            -1);
       /*
        * suppression des fiches de degustations associees
        */

        list_stock = g_list_remove_link(list_stock,list_stock_rowSelected);
        list_stock = g_list_sort(list_stock,(GCompareFunc)cmp_stock);
        xcave_xmlWrite(DBPATH);

       /*
        * update TreeList
        */
        gtk_tree_store_remove(GTK_TREE_STORE(model), &selected_row);
	}

	/*
	 * need to update storeview_xcave_wine_origin and storelist
	 */
	xcave.information_treestore = (GtkTreeStore *) gtk_tree_view_get_model((GtkTreeView *)xcave.information_treeview);
	gtk_tree_store_clear(xcave.information_treestore);

	xcave.origin_treestore = (GtkTreeStore *) gtk_tree_view_get_model((GtkTreeView *)xcave.origin_treeview);
	gtk_tree_store_clear(xcave.origin_treestore);
	
	xcave_fill_model (xcave.origin_treestore, xcave.information_treestore);

	/*
	 * penser à mettre à jour la liste emplacement
	 */
	list_append_rack();

	/*
	 *
	 */
	NbBottleStock -= Vin_rowSelected->qty;
    if (xcave.statusbar_id != 0) 
       gtk_statusbar_remove ((GtkStatusbar *)xcave.statusbar_v, xcave.statusbar_ctxtid, xcave.statusbar_id);

    sprintf (xcave.statusbar_txt, _("Number of bottles in cellar : %d"), NbBottleStock);
    xcave.statusbar_id = gtk_statusbar_push ((GtkStatusbar *)xcave.statusbar_v, xcave.statusbar_ctxtid, xcave.statusbar_txt);
		
	gtk_object_destroy (GTK_OBJECT (supp.window));
	
	/* 
	 * reactive xcave.window
	 */
	gtk_widget_set_sensitive(xcave.window, TRUE);
	
}

/*
 * GtkWindow "ConSupp".
 * cancel_button clicked
 */
void
on_xcave_supp_button_cancel_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_object_destroy (GTK_OBJECT (supp.window));

	/* 
	 * reactive xcave.window
	 */
	gtk_widget_set_sensitive(xcave.window, TRUE);
}


void
on_xcave_supp_destroy   (GtkObject       *object,
                          gpointer         user_data)
{

   gtk_object_destroy (GTK_OBJECT (supp.window));

   /* 
    * reactive xcave.window
    */
   gtk_widget_set_sensitive(xcave.window, TRUE);
}
