/*
 * Copyright (C) 2003 Jean-Philippe Hergott <hergott@free.fr>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <errno.h>

#include "callbacks.h"

/* #define DEBUG_LEVEL_1 1 */

/* list of pixmap directories */
static GList *support_directories = NULL;

/* add 'directory' plus subdirectories recursively to the list
   we browse when looking for files (e.g. pixmaps) */
void
add_support_directory_recursive (const gchar     *directory)
{
    GDir *newdir =
	g_dir_open(directory, 0, NULL);
    const gchar *file;
    gchar *fullpath;

    if(newdir == NULL)
	return;

    support_directories = g_list_prepend (support_directories,
					     g_strdup (directory));

    while(TRUE)
    {
	file = g_dir_read_name(newdir);

	if(file == NULL)
	    break;

	fullpath = g_strdup_printf ("%s%s%s", directory,
				    G_DIR_SEPARATOR_S, file);

	if(g_file_test(fullpath, G_FILE_TEST_IS_DIR))
	    add_support_directory_recursive(fullpath);
	
	g_free(fullpath);
    }

    g_dir_close(newdir);
}


/* add 'directory' both to our directory list and
   GLADE's list */
void
add_support_directory(const gchar *directory)
{
    add_pixmap_directory(directory);
    add_support_directory_recursive(directory);
}

void
maturite_cell_data_function	(GtkTreeViewColumn *col,
							GtkCellRenderer   *renderer,
							GtkTreeModel      *model,
							GtkTreeIter       *selected_row,
							gpointer           user_data)
{
	GList  *list_stock_rowSelected;
	ptrVin	Vin_rowSelected;

	gtk_tree_model_get (model, selected_row, 
						COL_TREELIST_PDATA, &Vin_rowSelected,
						COL_TREELIST_PGLIST, &list_stock_rowSelected,
						-1);
	/*
	 * set the tree column background color 
	 */
	g_object_set(renderer,"visible", TRUE,"background", "White","background-set", TRUE,NULL);
	
	/*
	 * set the tree column text color, depends of wine maturity
	 */
	/*
     * g_object_set(renderer,"visible", TRUE,"background-gdk", "White","background-set", TRUE,NULL);
	 */
	// GdkColor c;
	// c.pixel = 0;
	// c.red = c.green = c.blue = 0xeeee;
    // g_object_set(renderer, "weight", PANGO_WEIGHT_BOLD, "weight-set", TRUE, NULL);
    if ( Vin_rowSelected->qty == 0 || Vin_rowSelected->vintage == 0 || Vin_rowSelected->Conserv == 0) {
        // g_object_set(renderer, "weight", PANGO_WEIGHT_BOLD, "weight-set", TRUE, NULL);
		g_object_set(renderer,"visible", TRUE,"foreground", "Black","foreground-set", TRUE,NULL);
		// g_object_set(renderer,"visible", TRUE,"background-gdk", "White","background-set", TRUE,NULL);
		}
	else
		if ((100*(nowan-(Vin_rowSelected->vintage))/Vin_rowSelected->Conserv) < 21)
			/* Wine is green - too young to be drink */
			g_object_set(renderer,"visible", TRUE,"foreground", "DarkGreen","foreground-set", TRUE,NULL);
			// g_object_set(renderer,"visible", TRUE,"background-gdk", "DarkGreen","background-set", TRUE,NULL);
		else
			if ((100*(nowan-(Vin_rowSelected->vintage))/Vin_rowSelected->Conserv) > 99) {
				/* Time to drink it */
				g_object_set(renderer,"visible", TRUE,"foreground", "Red","foreground-set", TRUE,NULL);
				// g_object_set(renderer,"background-gdk", &c,"background-set", TRUE,NULL);
			 }
			else
				/* wine to be keep in cellar */
				g_object_set(renderer,"visible", TRUE,"foreground", "DarkRed","foreground-set", TRUE,NULL);
				// g_object_set(renderer,"visible", TRUE,"background-gdk", "DarkRed","background-set", TRUE,NULL);

}

gint cmp_stock(gpointer vin1, gpointer vin2)
{
  Vin tmpVin1;
  Vin tmpVin2;
  
  memcpy(&tmpVin1,vin1,sizeof(Vin));
  memcpy(&tmpVin2,vin2,sizeof(Vin));

  return (memcmp(&tmpVin1,&tmpVin2,sizeof(Vin)));
}

gint cmp_nom(gpointer vin1, gpointer vin2)
{
  Vin tmpVin1;
  Vin tmpVin2;
  
  memcpy(&tmpVin1,vin1,sizeof(Vin));
  memcpy(&tmpVin2,vin2,sizeof(Vin));

  return (memcmp(&tmpVin1.Nom,&tmpVin2.Nom,domain_size));
}

gint cmp_region(gpointer vin1, gpointer vin2)
{
  Vin tmpVin1;
  Vin tmpVin2;
  
  memcpy(&tmpVin1,vin1,sizeof(Vin));
  memcpy(&tmpVin2,vin2,sizeof(Vin));

  return (memcmp(&tmpVin1,&tmpVin2,country_size + region_size + appellation_size + domain_size + vintage_size));
}

gint cmp_country(gpointer country1, gpointer country2)
{
  return (memcmp(country1, country2 ,country_size));
}

gint cmp_appellation(gpointer app1, gpointer app2)
{
	return (memcmp(app1, app2 ,appellation_size));
}

gint cmp_cepage(gpointer cep1, gpointer cep2)
{
	return (memcmp(cep1, cep2 ,cepage_size));
}

gint cmp_producteur(gpointer vin1, gpointer vin2)
{
  Vin tmpVin1;
  Vin tmpVin2;
  
  memcpy(&tmpVin1,vin1,sizeof(Vin));
  memcpy(&tmpVin2,vin2,sizeof(Vin));

  return (memcmp(&tmpVin1.supplier,&tmpVin2.supplier,supplier_size));
}

gint cmp_millesime(gpointer vin1, gpointer vin2)
{
  Vin tmpVin1;
  Vin tmpVin2;
  
  memcpy(&tmpVin1,vin1,sizeof(Vin));
  memcpy(&tmpVin2,vin2,sizeof(Vin));

  return (memcmp(&tmpVin1.vintage,&tmpVin2.vintage,vintage_size));
}

gint cmp_quantite(gpointer vin1, gpointer vin2)
{
  Vin tmpVin1;
  Vin tmpVin2;
  
  memcpy(&tmpVin1,vin1,sizeof(Vin));
  memcpy(&tmpVin2,vin2,sizeof(Vin));

  return (memcmp(&tmpVin1.qty,&tmpVin2.qty,qty_size));
}

gint cmp_categ_nom(gpointer categ1, gpointer categ2)
{
  return (memcmp(categ1,categ2,sizeof(Categ)));
}

gint find_existing_wine(gpointer vin1, gpointer vin2)
{
	Vin tmpVin1;
	Vin tmpVin2;
	
	memcpy(&tmpVin1,vin1,sizeof(Vin));
	memcpy(&tmpVin2,vin2,sizeof(Vin));

	if (strcasecmp(tmpVin1.country,tmpVin2.country) != 0) return(1);
	if (strcasecmp(tmpVin1.Region,tmpVin2.Region) != 0) return(1);
	if (strcasecmp(tmpVin1.Appellation,tmpVin2.Appellation) != 0) return(1);
	if (strcasecmp(tmpVin1.Nom,tmpVin2.Nom) != 0) return(1);
	if (tmpVin1.vintage != tmpVin2.vintage)return(1);
	
	return (0);
}


//************************************ TOOLBOX             

void
stocks2char (gchar *data_input, gchar *data_output, gint *pi, gint *pn)
{
  gint i,n;

  i = *pi;
  n = *pn;
  
  for (i++; (data_input[i] != '\n' && data_input[i] != '\0' && data_input[i] != SEPAR && i < sizeof (Vin) ) ; i++)
  strncpy(data_output, data_input + n, i - n + 1);

  *pn = i+1;
  *pi = i;

}

void
stocks2inte (gchar *data_input, gint *data_output, gint *pi, gint *pn)
{
  gchar lbu[32];
  gint i,n;

  i = *pi;
  n = *pn;
  
  for (i++; (data_input[i] != '\n' && data_input[i] != '\0' && data_input[i] != SEPAR && i < sizeof (Vin) ) ; i++);
  memset(lbu, '\0', sizeof (lbu));
  strncpy(lbu, data_input + n, i - n );
  *data_output = atoi (lbu);

  *pn = i+1;
  *pi = i;
}

void
stocks2float (gchar *data_input, gfloat *data_output, gint *pi, gint *pn)
{
  gchar lbu[32];
  gint i,n;

  i = *pi;
  n = *pn;
  
  for (i++; (data_input[i] != '\n' && data_input[i] != '\0' && data_input[i] != SEPAR && i < sizeof (Vin) ) ; i++);
  memset(lbu, '\0', sizeof (lbu));
  strncpy(lbu, data_input + n, i - n );
  *data_output = atof (lbu);

  *pn = i+1;
  *pi = i;
}

void
char2stocks (gchar *data_output, gchar *data_input)
{
  strcat (data_output, data_input);
  strcat (data_output, "|");
}

void 
inte2stocks (gchar *data_output, gint data_input)
{
  gchar lbu[32];

  memset (lbu, '\0', sizeof (lbu));
  sprintf (lbu, "%d", data_input);
  strcat (data_output, lbu);
  strcat (data_output, "|");
}

void 
float2stocks (gchar *data_output, gfloat data_input)
{
  gchar lbu[32];

  memset (lbu, '\0', sizeof (lbu));
  sprintf (lbu, "%.2f", data_input);
  strcat (data_output, lbu);
  strcat (data_output, "|");
}

//************************************ Descriptions **************************
gint
find_categ (gchar *p, gchar *r)
{
  Categ     tmpList;
  Categ     tmpCtg;


  memcpy(&tmpList, p, sizeof(Categ));
  memcpy(&tmpCtg , r, sizeof(Categ));

  return (  strcasecmp(tmpList.Appellation,tmpCtg.Appellation)
          | strcasecmp(tmpList.Region,tmpCtg.Region)
          | strcasecmp(tmpList.country,tmpCtg.country));

}

gint 
xcave_compute_maturity_value(gint	qt, gint millesime, gint conservation)
{
	if (qt == 0) return(0);
    if (millesime == 0 || conservation == 0) return(0); 
    return(100*(nowan - millesime) / conservation);
}

ptrVin 
xcave_id_selected_treelist_row (void)
{
  	GtkTreeSelection    *selection;
	GtkTreeModel        *model;
	GtkTreeIter          selected_row;

	GList               *list_stock_rowSelected;
	ptrVin               ptr_rowSelected;

	ptr_rowSelected = g_malloc (sizeof (Vin));
	memset(ptr_rowSelected,'\0',sizeof(Vin));

	xcave.information_treeview = glade_xml_get_widget(xcave.main_xml,"information_treeview");
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(xcave.information_treeview));
	g_assert(gtk_tree_selection_get_mode(selection) == GTK_SELECTION_SINGLE);

	if (gtk_tree_selection_get_selected(selection, &model, &selected_row))/* C */
	{
		gtk_tree_model_get (model, &selected_row,/* C */
					COL_TREELIST_PDATA, &ptr_rowSelected,
					COL_TREELIST_PGLIST, &list_stock_rowSelected,
					-1);
	} 
	else
	{
		/* If no row is selected, the button should
		 *  not be clickable in the first place 
		 */
		g_free(ptr_rowSelected);
		return(NULL);
	}
#if (defined DEBUG_LEVEL_1)
	printf("%s:xcave_id_selected_treelist_row:%d:%p:%s:\n",__FILE__,__LINE__,(void *)ptr_rowSelected,ptr_rowSelected->Nom);
	printf("%s:xcave_id_selected_treelist_row:%d:%p:%s:\n",__FILE__,__LINE__,(void *)ptr_rowSelected,ptr_rowSelected->country);
	printf("%s:xcave_id_selected_treelist_row:%d:%p:%s:\n",__FILE__,__LINE__,(void *)ptr_rowSelected,ptr_rowSelected->Region);
	Vin		*tmpvin;
	tmpvin = g_malloc(sizeof(Vin));
	memset(tmpvin, '\0', sizeof(Vin));
	memcpy(tmpvin,list_stock_rowSelected->data,sizeof(Vin));
	printf("xcave_id_selected_treelist_row:%d:%s:\n",__LINE__,tmpvin->Nom);
	printf("xcave_id_selected_treelist_row:%d:%s:\n",__LINE__,tmpvin->country);
	printf("xcave_id_selected_treelist_row:%d:%s:\n",__LINE__,tmpvin->Region);
	g_free(tmpvin);
#endif

	return(ptr_rowSelected);
}

/*
 * XCAVE DEBUG FUNCTION 
 */

void xcave_debug_int(const gchar *file, const gchar *function, gint line, gchar *str, gint i)
{
   if (debug)
     fprintf(stderr,":%-15s:%-40s:%4d::%s:%d\n",file,function,line,str,i);
     fflush(stderr);
}

void xcave_debug_2int(const gchar *file, const gchar *function, gint line, gchar *str,gint s, gint i)
{
   if (debug)
     fprintf(stderr,":%-15s:%-40s:%4d::%s:%d:%d\n",file,function,line,str,s,i);
     fflush(stderr);
}

void xcave_debug_msg_int(const gchar *file, const gchar *function, gint line, gchar *msg,gint s,gint i)
{
   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::%s:%*d\n",file,function,line,msg,s,i);
     fflush(stderr);
   }
}

void xcave_debug_2str(const gchar *file, const gchar *function, gint line, gchar *msg, gint s, gchar *str)
{
   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::%s:%*s\n",file,function,line,msg,s,str);
     fflush(stderr);
   }
}

void xcave_debug_3str(const gchar *file, const gchar *function, gint line, gchar *msg, gchar *str1, gchar *str2, gchar *str3)
{
   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::%s:%s:%s:%s:\n",file,function,line,msg,str1,str2,str3);
     fflush(stderr);
   }
}

void xcave_debug_msg(const gchar *file, const gchar *function, gint line, gchar *str)
{
   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::%s\n",file,function,line,str);
     fflush(stderr);
   }
}
void xcave_debug_str(const gchar *file,const gchar *function,gint line,gchar *str)
{
   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::%s\n",file,function,line,str);
     fflush(stderr);
   }
}

void xcave_debug_ptr_int(const gchar *file, const gchar *function, gint line, gchar *ptr, gint i)
{

   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::%p:%d:\n",file,function,line,ptr,i);
     fflush(stderr);
   }
}


void xcave_debug_begin (const gchar *file, const gchar *function, gint line)
{

   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::begin:\n",file,function,line);
     fflush(stderr);
   }
}

void xcave_debug_end (const gchar *file, const gchar *function, gint line)
{

   if (debug) {
     fprintf(stderr,":%-15s:%-40s:%4d::end:\n",file,function,line);
     fflush(stderr);
   }
}
