/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class LineNumbers {
    private static final int ASM_API_LEVEL = 589824;
    private final Class<?> type;
    private final Map<String, Integer> lines = Maps.newHashMap();
    private String source;
    private int firstLine = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineNumbers(Class<?> type) throws IOException {
        this.type = type;
        if (!type.isArray()) {
            InputStream in = null;
            try {
                in = type.getResourceAsStream("/" + type.getName().replace('.', '/') + ".class");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (in != null) {
                try {
                    new ClassReader(in).accept((ClassVisitor)new LineNumberReader(), 4);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String getSource() {
        return this.source;
    }

    public Integer getLineNumber(Member member) {
        Preconditions.checkArgument((this.type == member.getDeclaringClass() ? 1 : 0) != 0, (String)"Member %s belongs to %s, not %s", (Object)member, member.getDeclaringClass(), this.type);
        return this.lines.get(this.memberKey(member));
    }

    public int getFirstLine() {
        return this.firstLine == Integer.MAX_VALUE ? 1 : this.firstLine;
    }

    private String memberKey(Member member) {
        Preconditions.checkNotNull((Object)member, (Object)"member");
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            return member.getName() + Type.getMethodDescriptor((Method)((Method)member));
        }
        if (member instanceof Constructor) {
            StringBuilder sb = new StringBuilder().append("<init>(");
            for (Class<?> param : ((Constructor)member).getParameterTypes()) {
                sb.append(Type.getDescriptor(param));
            }
            return sb.append(")V").toString();
        }
        throw new IllegalArgumentException("Unsupported implementation class for Member, " + member.getClass());
    }

    private class LineNumberReader
    extends ClassVisitor {
        private int line;
        private String pendingMethod;
        private String name;

        LineNumberReader() {
            super(589824);
            this.line = -1;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 2) != 0) {
                return null;
            }
            this.pendingMethod = name + desc;
            this.line = -1;
            return new LineNumberMethodVisitor();
        }

        public void visitSource(String source, String debug) {
            LineNumbers.this.source = source;
        }

        public void visitLineNumber(int line, Label start) {
            if (line < LineNumbers.this.firstLine) {
                LineNumbers.this.firstLine = line;
            }
            this.line = line;
            if (this.pendingMethod != null) {
                LineNumbers.this.lines.put(this.pendingMethod, line);
                this.pendingMethod = null;
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new LineNumberAnnotationVisitor();
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return new LineNumberAnnotationVisitor();
        }

        class LineNumberAnnotationVisitor
        extends AnnotationVisitor {
            LineNumberAnnotationVisitor() {
                super(589824);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return this;
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            }
        }

        class LineNumberMethodVisitor
        extends MethodVisitor {
            LineNumberMethodVisitor() {
                super(589824);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return new LineNumberAnnotationVisitor();
            }

            public AnnotationVisitor visitAnnotationDefault() {
                return new LineNumberAnnotationVisitor();
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (opcode == 181 && LineNumberReader.this.name.equals(owner) && !LineNumbers.this.lines.containsKey(name) && LineNumberReader.this.line != -1) {
                    LineNumbers.this.lines.put(name, LineNumberReader.this.line);
                }
            }

            public void visitLineNumber(int line, Label start) {
                LineNumberReader.this.visitLineNumber(line, start);
            }
        }
    }
}

