#include <ns9750_bbdma.h>
void NS9750_SerialInit(BBusDMACtrl *bbdma);
#define __REG(x) (x)

#define SER_CTRLA_B                       __REG(0x90200000)
#define         SER_CE          (1<<31)
#define         SER_BRK         (1<<30)
#define         SER_STICKP      (1<<29)
#define         SER_EPS         (1<<28)
#define         SER_PE          (1<<27)
#define         SER_STP         (1<<26)
#define         SER_WLS_MASK    (3<<24)
#define                 SER_WLS_5 (0<<24)
#define                 SER_WLS_6 (1<<24)
#define                 SER_WLS_7 (2<<24)
#define                 SER_WLS_8 (3<<24)
#define         SER_CTSTX      (1<<23)
#define         SER_RTSRX       (1<<22)
#define         SER_RL          (1<<21)
#define         SER_LL          (1<<20)
#define         SER_DTR         (1<<17)
#define         SER_RTS         (1<<16)
#define         SER_RIE         (7<<9)
#define                 SER_RIE_RRDY    (1<<11)
#define                 SER_RIE_RHALF   (1<<10)
#define                 SER_RIE_RBC     (1<<9)
#define         SER_ERXDMA      (1<<8)
#define         SER_RIC         (7<<5)
#define                 SER_RIC_DSR     (1<<5)
#define                 SER_RIC_RI      (1<<6)
#define                 SER_RIC_DCD     (1<<7)
#define         SER_TIC         (15<<1)
#define                 SER_TIC_CLOSED  (1<<1)
#define                 SER_TIC_HALF    (1<<2)
#define                 SER_TIC_EMPTY   (1<<3)
#define                 SER_TIC_CTS     (1<<4)
#define         SER_ETXDMA      (1)



#define SER_CTRLB_B                       __REG(0x90200004)
#define         SER_RDM                   (0xf<<28)
#define         SER_RBGT                  (1<<27)
#define         SER_RCGT                  (1<<26)
#define         SER_MODE                  (3<<20)
#define         SER_BITOR                 (1<<19)
#define         SER_RTSTX                 (1<<15)
#define         SER_ENDEC                 (3f<<6)

#define SER_STATA_B                       __REG(0x90200008)
#define         SER_MATCH               (0xf<<28)
#define         SER_BGAP                (1<<27)
#define         SER_CGAP                (1<<26)
#define         SER_RXFDB               (3<<20)
#define         SER_RXFDB_SHIFT         (20)
#define         SER_DCD                 (1<<19)
#define         SER_RI                  (1<<18)
#define         SER_DSR                 (1<<17)
#define         SER_CTS                 (1<<16)
#define         SER_RBRK                (1<<15)
#define         SER_RFE                 (1<<14)
#define         SER_RPE                 (1<<13)
#define         SER_ROVER               (1<<12)
#define         SER_RRDY                (1<<11)
#define         SER_RHALF               (1<<10)
#define         SER_RBC                 (1<<9)
#define         SER_RFS                 (1<<8)
#define         SER_DCDI                (1<<7)
#define         SER_RII                 (1<<6)
#define         SER_DSRI                (1<<5)
#define         SER_CTSI                (1<<4)
#define         SER_TRDY                (1<<3)
#define         SER_THALF               (1<<2)
#define         SER_TEMPTY              (1<<0)

#define SER_RATE_B                        __REG(0x9020000c)
#define         SER_EBIT                (1<<31)
#define         SER_EBIT_SHIFT          (31)
#define         SER_TMODE               (1<<30)
#define         SER_TMODE_SHIFT         (30)
#define         SER_RXSRC               (1<<29)
#define         SER_TXSRC               (1<<28)
#define         SER_RXEXT               (1<<27)
#define         SER_TXEXT               (1<<26)
#define         SER_CLKMUX_MASK         (3<<24)
#define         SER_CLKMUX_SHIFT        (24)
#define         SER_TXCINV              (1<<23)
#define         SER_RXCINV              (1<<22)
#define         SER_TDCR_MASK           (3<<19)
#define                 SER_TDCR_1X             (0<<19)
#define                 SER_TDCR_8X             (1<<19)
#define                 SER_TDCR_16X            (2<<19)
#define                 SER_TDCR_32X            (3<<19)
#define         SER_RDCR_MASK                (3<<17)
#define                 SER_RDCR_1X             (0<<17)
#define                 SER_RDCR_8X             (1<<17)
#define                 SER_RDCR_16X            (2<<17)
#define                 SER_RDCR_32X            (3<<17)
#define         SER_TICS                (1<<16)
#define         SER_RICS                (1<<15)
#define         SER_N_MASK                   (0x7fff<<0)

#define SER_CTRLA_C                       __REG(0x90300000)
#define SER_CTRLB_C                       __REG(0x90300004)
#define SER_STATA_C                       __REG(0x90300008)
#define SER_RATE_C                        __REG(0x9030000c)
#define SER_FIFO_C                        __REG(0x90300010)
#define SER_RXBUF_GAP_C                   __REG(0x90300014)
#define SER_RXCHAR_GAP_C                  __REG(0x90300018)
#define SER_RXMATCH_C                     __REG(0x9030001c)
#define SER_RXMATCH_MASK_C                __REG(0x90300020)
#define SER_FLOW_CTRL_C                   __REG(0x90300034)
#define SER_FLOW_FORCE_C                  __REG(0x90300038)

#define SER_CTRLA_D                       __REG(0x90300040)
#define SER_CTRLB_D                       __REG(0x90300044)
#define SER_STATA_D                       __REG(0x90300048)
#define SER_RATE_D                        __REG(0x9030004c)
#define SER_FIFO_D                        __REG(0x90300050)
#define SER_RXBUF_GAP_D                   __REG(0x90300054)
#define SER_RXCHAR_GAP_D                  __REG(0x90300058)
#define SER_RXMATCH_D                     __REG(0x9030005c)
#define SER_RXMATCH_MASK_D                __REG(0x90300060)
#define SER_FLOW_CTRL_D                   __REG(0x90300074)
#define SER_FLOW_FORCE_D                  __REG(0x90300078)

#define SER_BASE_A                      __REG(0x90200040)
#define SER_BASE_B                      __REG(0x90200000)
#define SER_BASE_C                      __REG(0x90300000)
#define SER_BASE_D                      __REG(0x90300040)

#define SER_CTRLA                         (0)
#define SER_CTRLB                         (4)
#define SER_STATA                         (8)
#define SER_RATE                          (0xc)
#define SER_FIFO                          (0x10)
#define SER_RXBUF_GAP                     (0x14)
#define SER_RXCHAR_GAP                    (0x18)
#define SER_RXMATCH                       (0x1c)
#define SER_RXMATCH_MASK                  (0x20)
#define SER_FLOW_CTRL                     (0x34)
#define SER_FLOW_FORCE                    (0x38)

