/* $Id: debug.c,v 1.3 2003/05/03 02:44:12 andrewbaker Exp $ */
/*
** Copyright (C) 1998-2001 Martin Roesch <roesch@clark.net>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifdef DEBUG


#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>

#include "barnyard.h"
#include "debug.h"
#include "util.h"

int debuglevel = DEBUG_ALL;
char *DebugMessageFile = NULL;
int DebugMessageLine = 0;


int GetDebugLevel (void)
{
    if (getenv(DEBUG_VARIABLE))
        debuglevel = atoi(getenv(DEBUG_VARIABLE));

    return debuglevel;
}


void DebugMessageFunc(int level, char *fmt, ...)
{
    va_list ap;
    char buf[STD_BUF+1];


    if (!(level & GetDebugLevel()))
        return;

    /* filename and line number information */
    if (DebugMessageFile != NULL)
        printf("%s:%d: ", DebugMessageFile, DebugMessageLine);

    va_start(ap, fmt);
        
    if(pv.daemon_flag)
    {
        vsnprintf(buf, STD_BUF, fmt, ap);
        syslog(LOG_DAEMON | LOG_DEBUG, "%s", buf);
    }
    else
    {
        vprintf(fmt, ap);
    }

    va_end(ap);
}
#endif /* DEBUG */
