/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AuthMethodUpdateAwsIam authMethodUpdateAwsIam is a command that Updates a new Auth Method that will be able to authenticate using AWS IAM credentials.
type AuthMethodUpdateAwsIam struct {
	// Access expiration date in Unix timestamp (select 0 for access without expiry date)
	AccessExpires *int64 `json:"access-expires,omitempty"`
	// Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"
	AuditLogsClaims *[]string `json:"audit-logs-claims,omitempty"`
	// A list of full arns that the access is restricted to
	BoundArn *[]string `json:"bound-arn,omitempty"`
	// A list of AWS account-IDs that the access is restricted to
	BoundAwsAccountId []string `json:"bound-aws-account-id"`
	// A CIDR whitelist with the IPs that the access is restricted to
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// A list of full resource ids that the access is restricted to
	BoundResourceId *[]string `json:"bound-resource-id,omitempty"`
	// A list of full role ids that the access is restricted to
	BoundRoleId *[]string `json:"bound-role-id,omitempty"`
	// A list of full role-name that the access is restricted to
	BoundRoleName *[]string `json:"bound-role-name,omitempty"`
	// A list of full user ids that the access is restricted to
	BoundUserId *[]string `json:"bound-user-id,omitempty"`
	// A list of full user-name that the access is restricted to
	BoundUserName *[]string `json:"bound-user-name,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Auth Method description
	Description *string `json:"description,omitempty"`
	// if true: enforce role-association must include sub claims
	ForceSubClaims *bool `json:"force-sub-claims,omitempty"`
	// A CIDR whitelist with the GW IPs that the access is restricted to
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Jwt TTL
	JwtTtl *int64 `json:"jwt-ttl,omitempty"`
	// Auth Method name
	Name string `json:"name"`
	// Auth Method new name
	NewName *string `json:"new-name,omitempty"`
	// Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]
	ProductType *[]string `json:"product-type,omitempty"`
	// sts URL
	StsUrl *string `json:"sts-url,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// A unique identifier (ID) value which is a \"sub claim\" name that contains details uniquely identifying that resource. This \"sub claim\" is used to distinguish between different identities.
	UniqueIdentifier *string `json:"unique-identifier,omitempty"`
}

// NewAuthMethodUpdateAwsIam instantiates a new AuthMethodUpdateAwsIam object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAuthMethodUpdateAwsIam(boundAwsAccountId []string, name string, ) *AuthMethodUpdateAwsIam {
	this := AuthMethodUpdateAwsIam{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	this.BoundAwsAccountId = boundAwsAccountId
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	this.Name = name
	var stsUrl string = "https://sts.amazonaws.com"
	this.StsUrl = &stsUrl
	return &this
}

// NewAuthMethodUpdateAwsIamWithDefaults instantiates a new AuthMethodUpdateAwsIam object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAuthMethodUpdateAwsIamWithDefaults() *AuthMethodUpdateAwsIam {
	this := AuthMethodUpdateAwsIam{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	var stsUrl string = "https://sts.amazonaws.com"
	this.StsUrl = &stsUrl
	return &this
}

// GetAccessExpires returns the AccessExpires field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetAccessExpires() int64 {
	if o == nil || o.AccessExpires == nil {
		var ret int64
		return ret
	}
	return *o.AccessExpires
}

// GetAccessExpiresOk returns a tuple with the AccessExpires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetAccessExpiresOk() (*int64, bool) {
	if o == nil || o.AccessExpires == nil {
		return nil, false
	}
	return o.AccessExpires, true
}

// HasAccessExpires returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasAccessExpires() bool {
	if o != nil && o.AccessExpires != nil {
		return true
	}

	return false
}

// SetAccessExpires gets a reference to the given int64 and assigns it to the AccessExpires field.
func (o *AuthMethodUpdateAwsIam) SetAccessExpires(v int64) {
	o.AccessExpires = &v
}

// GetAuditLogsClaims returns the AuditLogsClaims field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetAuditLogsClaims() []string {
	if o == nil || o.AuditLogsClaims == nil {
		var ret []string
		return ret
	}
	return *o.AuditLogsClaims
}

// GetAuditLogsClaimsOk returns a tuple with the AuditLogsClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetAuditLogsClaimsOk() (*[]string, bool) {
	if o == nil || o.AuditLogsClaims == nil {
		return nil, false
	}
	return o.AuditLogsClaims, true
}

// HasAuditLogsClaims returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasAuditLogsClaims() bool {
	if o != nil && o.AuditLogsClaims != nil {
		return true
	}

	return false
}

// SetAuditLogsClaims gets a reference to the given []string and assigns it to the AuditLogsClaims field.
func (o *AuthMethodUpdateAwsIam) SetAuditLogsClaims(v []string) {
	o.AuditLogsClaims = &v
}

// GetBoundArn returns the BoundArn field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetBoundArn() []string {
	if o == nil || o.BoundArn == nil {
		var ret []string
		return ret
	}
	return *o.BoundArn
}

// GetBoundArnOk returns a tuple with the BoundArn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundArnOk() (*[]string, bool) {
	if o == nil || o.BoundArn == nil {
		return nil, false
	}
	return o.BoundArn, true
}

// HasBoundArn returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasBoundArn() bool {
	if o != nil && o.BoundArn != nil {
		return true
	}

	return false
}

// SetBoundArn gets a reference to the given []string and assigns it to the BoundArn field.
func (o *AuthMethodUpdateAwsIam) SetBoundArn(v []string) {
	o.BoundArn = &v
}

// GetBoundAwsAccountId returns the BoundAwsAccountId field value
func (o *AuthMethodUpdateAwsIam) GetBoundAwsAccountId() []string {
	if o == nil  {
		var ret []string
		return ret
	}

	return o.BoundAwsAccountId
}

// GetBoundAwsAccountIdOk returns a tuple with the BoundAwsAccountId field value
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundAwsAccountIdOk() (*[]string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.BoundAwsAccountId, true
}

// SetBoundAwsAccountId sets field value
func (o *AuthMethodUpdateAwsIam) SetBoundAwsAccountId(v []string) {
	o.BoundAwsAccountId = v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *AuthMethodUpdateAwsIam) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetBoundResourceId returns the BoundResourceId field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetBoundResourceId() []string {
	if o == nil || o.BoundResourceId == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceId
}

// GetBoundResourceIdOk returns a tuple with the BoundResourceId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundResourceIdOk() (*[]string, bool) {
	if o == nil || o.BoundResourceId == nil {
		return nil, false
	}
	return o.BoundResourceId, true
}

// HasBoundResourceId returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasBoundResourceId() bool {
	if o != nil && o.BoundResourceId != nil {
		return true
	}

	return false
}

// SetBoundResourceId gets a reference to the given []string and assigns it to the BoundResourceId field.
func (o *AuthMethodUpdateAwsIam) SetBoundResourceId(v []string) {
	o.BoundResourceId = &v
}

// GetBoundRoleId returns the BoundRoleId field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetBoundRoleId() []string {
	if o == nil || o.BoundRoleId == nil {
		var ret []string
		return ret
	}
	return *o.BoundRoleId
}

// GetBoundRoleIdOk returns a tuple with the BoundRoleId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundRoleIdOk() (*[]string, bool) {
	if o == nil || o.BoundRoleId == nil {
		return nil, false
	}
	return o.BoundRoleId, true
}

// HasBoundRoleId returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasBoundRoleId() bool {
	if o != nil && o.BoundRoleId != nil {
		return true
	}

	return false
}

// SetBoundRoleId gets a reference to the given []string and assigns it to the BoundRoleId field.
func (o *AuthMethodUpdateAwsIam) SetBoundRoleId(v []string) {
	o.BoundRoleId = &v
}

// GetBoundRoleName returns the BoundRoleName field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetBoundRoleName() []string {
	if o == nil || o.BoundRoleName == nil {
		var ret []string
		return ret
	}
	return *o.BoundRoleName
}

// GetBoundRoleNameOk returns a tuple with the BoundRoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundRoleNameOk() (*[]string, bool) {
	if o == nil || o.BoundRoleName == nil {
		return nil, false
	}
	return o.BoundRoleName, true
}

// HasBoundRoleName returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasBoundRoleName() bool {
	if o != nil && o.BoundRoleName != nil {
		return true
	}

	return false
}

// SetBoundRoleName gets a reference to the given []string and assigns it to the BoundRoleName field.
func (o *AuthMethodUpdateAwsIam) SetBoundRoleName(v []string) {
	o.BoundRoleName = &v
}

// GetBoundUserId returns the BoundUserId field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetBoundUserId() []string {
	if o == nil || o.BoundUserId == nil {
		var ret []string
		return ret
	}
	return *o.BoundUserId
}

// GetBoundUserIdOk returns a tuple with the BoundUserId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundUserIdOk() (*[]string, bool) {
	if o == nil || o.BoundUserId == nil {
		return nil, false
	}
	return o.BoundUserId, true
}

// HasBoundUserId returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasBoundUserId() bool {
	if o != nil && o.BoundUserId != nil {
		return true
	}

	return false
}

// SetBoundUserId gets a reference to the given []string and assigns it to the BoundUserId field.
func (o *AuthMethodUpdateAwsIam) SetBoundUserId(v []string) {
	o.BoundUserId = &v
}

// GetBoundUserName returns the BoundUserName field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetBoundUserName() []string {
	if o == nil || o.BoundUserName == nil {
		var ret []string
		return ret
	}
	return *o.BoundUserName
}

// GetBoundUserNameOk returns a tuple with the BoundUserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetBoundUserNameOk() (*[]string, bool) {
	if o == nil || o.BoundUserName == nil {
		return nil, false
	}
	return o.BoundUserName, true
}

// HasBoundUserName returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasBoundUserName() bool {
	if o != nil && o.BoundUserName != nil {
		return true
	}

	return false
}

// SetBoundUserName gets a reference to the given []string and assigns it to the BoundUserName field.
func (o *AuthMethodUpdateAwsIam) SetBoundUserName(v []string) {
	o.BoundUserName = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *AuthMethodUpdateAwsIam) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *AuthMethodUpdateAwsIam) SetDescription(v string) {
	o.Description = &v
}

// GetForceSubClaims returns the ForceSubClaims field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetForceSubClaims() bool {
	if o == nil || o.ForceSubClaims == nil {
		var ret bool
		return ret
	}
	return *o.ForceSubClaims
}

// GetForceSubClaimsOk returns a tuple with the ForceSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetForceSubClaimsOk() (*bool, bool) {
	if o == nil || o.ForceSubClaims == nil {
		return nil, false
	}
	return o.ForceSubClaims, true
}

// HasForceSubClaims returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasForceSubClaims() bool {
	if o != nil && o.ForceSubClaims != nil {
		return true
	}

	return false
}

// SetForceSubClaims gets a reference to the given bool and assigns it to the ForceSubClaims field.
func (o *AuthMethodUpdateAwsIam) SetForceSubClaims(v bool) {
	o.ForceSubClaims = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *AuthMethodUpdateAwsIam) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *AuthMethodUpdateAwsIam) SetJson(v bool) {
	o.Json = &v
}

// GetJwtTtl returns the JwtTtl field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetJwtTtl() int64 {
	if o == nil || o.JwtTtl == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtl
}

// GetJwtTtlOk returns a tuple with the JwtTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetJwtTtlOk() (*int64, bool) {
	if o == nil || o.JwtTtl == nil {
		return nil, false
	}
	return o.JwtTtl, true
}

// HasJwtTtl returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasJwtTtl() bool {
	if o != nil && o.JwtTtl != nil {
		return true
	}

	return false
}

// SetJwtTtl gets a reference to the given int64 and assigns it to the JwtTtl field.
func (o *AuthMethodUpdateAwsIam) SetJwtTtl(v int64) {
	o.JwtTtl = &v
}

// GetName returns the Name field value
func (o *AuthMethodUpdateAwsIam) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AuthMethodUpdateAwsIam) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *AuthMethodUpdateAwsIam) SetNewName(v string) {
	o.NewName = &v
}

// GetProductType returns the ProductType field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetProductType() []string {
	if o == nil || o.ProductType == nil {
		var ret []string
		return ret
	}
	return *o.ProductType
}

// GetProductTypeOk returns a tuple with the ProductType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetProductTypeOk() (*[]string, bool) {
	if o == nil || o.ProductType == nil {
		return nil, false
	}
	return o.ProductType, true
}

// HasProductType returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasProductType() bool {
	if o != nil && o.ProductType != nil {
		return true
	}

	return false
}

// SetProductType gets a reference to the given []string and assigns it to the ProductType field.
func (o *AuthMethodUpdateAwsIam) SetProductType(v []string) {
	o.ProductType = &v
}

// GetStsUrl returns the StsUrl field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetStsUrl() string {
	if o == nil || o.StsUrl == nil {
		var ret string
		return ret
	}
	return *o.StsUrl
}

// GetStsUrlOk returns a tuple with the StsUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetStsUrlOk() (*string, bool) {
	if o == nil || o.StsUrl == nil {
		return nil, false
	}
	return o.StsUrl, true
}

// HasStsUrl returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasStsUrl() bool {
	if o != nil && o.StsUrl != nil {
		return true
	}

	return false
}

// SetStsUrl gets a reference to the given string and assigns it to the StsUrl field.
func (o *AuthMethodUpdateAwsIam) SetStsUrl(v string) {
	o.StsUrl = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *AuthMethodUpdateAwsIam) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *AuthMethodUpdateAwsIam) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value if set, zero value otherwise.
func (o *AuthMethodUpdateAwsIam) GetUniqueIdentifier() string {
	if o == nil || o.UniqueIdentifier == nil {
		var ret string
		return ret
	}
	return *o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodUpdateAwsIam) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil || o.UniqueIdentifier == nil {
		return nil, false
	}
	return o.UniqueIdentifier, true
}

// HasUniqueIdentifier returns a boolean if a field has been set.
func (o *AuthMethodUpdateAwsIam) HasUniqueIdentifier() bool {
	if o != nil && o.UniqueIdentifier != nil {
		return true
	}

	return false
}

// SetUniqueIdentifier gets a reference to the given string and assigns it to the UniqueIdentifier field.
func (o *AuthMethodUpdateAwsIam) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = &v
}

func (o AuthMethodUpdateAwsIam) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessExpires != nil {
		toSerialize["access-expires"] = o.AccessExpires
	}
	if o.AuditLogsClaims != nil {
		toSerialize["audit-logs-claims"] = o.AuditLogsClaims
	}
	if o.BoundArn != nil {
		toSerialize["bound-arn"] = o.BoundArn
	}
	if true {
		toSerialize["bound-aws-account-id"] = o.BoundAwsAccountId
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.BoundResourceId != nil {
		toSerialize["bound-resource-id"] = o.BoundResourceId
	}
	if o.BoundRoleId != nil {
		toSerialize["bound-role-id"] = o.BoundRoleId
	}
	if o.BoundRoleName != nil {
		toSerialize["bound-role-name"] = o.BoundRoleName
	}
	if o.BoundUserId != nil {
		toSerialize["bound-user-id"] = o.BoundUserId
	}
	if o.BoundUserName != nil {
		toSerialize["bound-user-name"] = o.BoundUserName
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.ForceSubClaims != nil {
		toSerialize["force-sub-claims"] = o.ForceSubClaims
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwtTtl != nil {
		toSerialize["jwt-ttl"] = o.JwtTtl
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.ProductType != nil {
		toSerialize["product-type"] = o.ProductType
	}
	if o.StsUrl != nil {
		toSerialize["sts-url"] = o.StsUrl
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UniqueIdentifier != nil {
		toSerialize["unique-identifier"] = o.UniqueIdentifier
	}
	return json.Marshal(toSerialize)
}

type NullableAuthMethodUpdateAwsIam struct {
	value *AuthMethodUpdateAwsIam
	isSet bool
}

func (v NullableAuthMethodUpdateAwsIam) Get() *AuthMethodUpdateAwsIam {
	return v.value
}

func (v *NullableAuthMethodUpdateAwsIam) Set(val *AuthMethodUpdateAwsIam) {
	v.value = val
	v.isSet = true
}

func (v NullableAuthMethodUpdateAwsIam) IsSet() bool {
	return v.isSet
}

func (v *NullableAuthMethodUpdateAwsIam) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAuthMethodUpdateAwsIam(val *AuthMethodUpdateAwsIam) *NullableAuthMethodUpdateAwsIam {
	return &NullableAuthMethodUpdateAwsIam{value: val, isSet: true}
}

func (v NullableAuthMethodUpdateAwsIam) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAuthMethodUpdateAwsIam) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


