/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// KmipDescribeServerOutput struct for KmipDescribeServerOutput
type KmipDescribeServerOutput struct {
	Active *bool `json:"active,omitempty"`
	CaCert *[]int32 `json:"ca_cert,omitempty"`
	CertificateIssueDate *time.Time `json:"certificate_issue_date,omitempty"`
	CertificateTtlInSeconds *int64 `json:"certificate_ttl_in_seconds,omitempty"`
	Hostname *string `json:"hostname,omitempty"`
	Root *string `json:"root,omitempty"`
}

// NewKmipDescribeServerOutput instantiates a new KmipDescribeServerOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKmipDescribeServerOutput() *KmipDescribeServerOutput {
	this := KmipDescribeServerOutput{}
	return &this
}

// NewKmipDescribeServerOutputWithDefaults instantiates a new KmipDescribeServerOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKmipDescribeServerOutputWithDefaults() *KmipDescribeServerOutput {
	this := KmipDescribeServerOutput{}
	return &this
}

// GetActive returns the Active field value if set, zero value otherwise.
func (o *KmipDescribeServerOutput) GetActive() bool {
	if o == nil || o.Active == nil {
		var ret bool
		return ret
	}
	return *o.Active
}

// GetActiveOk returns a tuple with the Active field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipDescribeServerOutput) GetActiveOk() (*bool, bool) {
	if o == nil || o.Active == nil {
		return nil, false
	}
	return o.Active, true
}

// HasActive returns a boolean if a field has been set.
func (o *KmipDescribeServerOutput) HasActive() bool {
	if o != nil && o.Active != nil {
		return true
	}

	return false
}

// SetActive gets a reference to the given bool and assigns it to the Active field.
func (o *KmipDescribeServerOutput) SetActive(v bool) {
	o.Active = &v
}

// GetCaCert returns the CaCert field value if set, zero value otherwise.
func (o *KmipDescribeServerOutput) GetCaCert() []int32 {
	if o == nil || o.CaCert == nil {
		var ret []int32
		return ret
	}
	return *o.CaCert
}

// GetCaCertOk returns a tuple with the CaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipDescribeServerOutput) GetCaCertOk() (*[]int32, bool) {
	if o == nil || o.CaCert == nil {
		return nil, false
	}
	return o.CaCert, true
}

// HasCaCert returns a boolean if a field has been set.
func (o *KmipDescribeServerOutput) HasCaCert() bool {
	if o != nil && o.CaCert != nil {
		return true
	}

	return false
}

// SetCaCert gets a reference to the given []int32 and assigns it to the CaCert field.
func (o *KmipDescribeServerOutput) SetCaCert(v []int32) {
	o.CaCert = &v
}

// GetCertificateIssueDate returns the CertificateIssueDate field value if set, zero value otherwise.
func (o *KmipDescribeServerOutput) GetCertificateIssueDate() time.Time {
	if o == nil || o.CertificateIssueDate == nil {
		var ret time.Time
		return ret
	}
	return *o.CertificateIssueDate
}

// GetCertificateIssueDateOk returns a tuple with the CertificateIssueDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipDescribeServerOutput) GetCertificateIssueDateOk() (*time.Time, bool) {
	if o == nil || o.CertificateIssueDate == nil {
		return nil, false
	}
	return o.CertificateIssueDate, true
}

// HasCertificateIssueDate returns a boolean if a field has been set.
func (o *KmipDescribeServerOutput) HasCertificateIssueDate() bool {
	if o != nil && o.CertificateIssueDate != nil {
		return true
	}

	return false
}

// SetCertificateIssueDate gets a reference to the given time.Time and assigns it to the CertificateIssueDate field.
func (o *KmipDescribeServerOutput) SetCertificateIssueDate(v time.Time) {
	o.CertificateIssueDate = &v
}

// GetCertificateTtlInSeconds returns the CertificateTtlInSeconds field value if set, zero value otherwise.
func (o *KmipDescribeServerOutput) GetCertificateTtlInSeconds() int64 {
	if o == nil || o.CertificateTtlInSeconds == nil {
		var ret int64
		return ret
	}
	return *o.CertificateTtlInSeconds
}

// GetCertificateTtlInSecondsOk returns a tuple with the CertificateTtlInSeconds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipDescribeServerOutput) GetCertificateTtlInSecondsOk() (*int64, bool) {
	if o == nil || o.CertificateTtlInSeconds == nil {
		return nil, false
	}
	return o.CertificateTtlInSeconds, true
}

// HasCertificateTtlInSeconds returns a boolean if a field has been set.
func (o *KmipDescribeServerOutput) HasCertificateTtlInSeconds() bool {
	if o != nil && o.CertificateTtlInSeconds != nil {
		return true
	}

	return false
}

// SetCertificateTtlInSeconds gets a reference to the given int64 and assigns it to the CertificateTtlInSeconds field.
func (o *KmipDescribeServerOutput) SetCertificateTtlInSeconds(v int64) {
	o.CertificateTtlInSeconds = &v
}

// GetHostname returns the Hostname field value if set, zero value otherwise.
func (o *KmipDescribeServerOutput) GetHostname() string {
	if o == nil || o.Hostname == nil {
		var ret string
		return ret
	}
	return *o.Hostname
}

// GetHostnameOk returns a tuple with the Hostname field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipDescribeServerOutput) GetHostnameOk() (*string, bool) {
	if o == nil || o.Hostname == nil {
		return nil, false
	}
	return o.Hostname, true
}

// HasHostname returns a boolean if a field has been set.
func (o *KmipDescribeServerOutput) HasHostname() bool {
	if o != nil && o.Hostname != nil {
		return true
	}

	return false
}

// SetHostname gets a reference to the given string and assigns it to the Hostname field.
func (o *KmipDescribeServerOutput) SetHostname(v string) {
	o.Hostname = &v
}

// GetRoot returns the Root field value if set, zero value otherwise.
func (o *KmipDescribeServerOutput) GetRoot() string {
	if o == nil || o.Root == nil {
		var ret string
		return ret
	}
	return *o.Root
}

// GetRootOk returns a tuple with the Root field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipDescribeServerOutput) GetRootOk() (*string, bool) {
	if o == nil || o.Root == nil {
		return nil, false
	}
	return o.Root, true
}

// HasRoot returns a boolean if a field has been set.
func (o *KmipDescribeServerOutput) HasRoot() bool {
	if o != nil && o.Root != nil {
		return true
	}

	return false
}

// SetRoot gets a reference to the given string and assigns it to the Root field.
func (o *KmipDescribeServerOutput) SetRoot(v string) {
	o.Root = &v
}

func (o KmipDescribeServerOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Active != nil {
		toSerialize["active"] = o.Active
	}
	if o.CaCert != nil {
		toSerialize["ca_cert"] = o.CaCert
	}
	if o.CertificateIssueDate != nil {
		toSerialize["certificate_issue_date"] = o.CertificateIssueDate
	}
	if o.CertificateTtlInSeconds != nil {
		toSerialize["certificate_ttl_in_seconds"] = o.CertificateTtlInSeconds
	}
	if o.Hostname != nil {
		toSerialize["hostname"] = o.Hostname
	}
	if o.Root != nil {
		toSerialize["root"] = o.Root
	}
	return json.Marshal(toSerialize)
}

type NullableKmipDescribeServerOutput struct {
	value *KmipDescribeServerOutput
	isSet bool
}

func (v NullableKmipDescribeServerOutput) Get() *KmipDescribeServerOutput {
	return v.value
}

func (v *NullableKmipDescribeServerOutput) Set(val *KmipDescribeServerOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableKmipDescribeServerOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableKmipDescribeServerOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKmipDescribeServerOutput(val *KmipDescribeServerOutput) *NullableKmipDescribeServerOutput {
	return &NullableKmipDescribeServerOutput{value: val, isSet: true}
}

func (v NullableKmipDescribeServerOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKmipDescribeServerOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


