/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// SignPKCS1 signPKCS1 is a command that calculates the signature of hashed data using RSASSA-PKCS1-V1_5-SIGN from RSA PKCS#1 v1.5.
type SignPKCS1 struct {
	// The display id of the key to use in the signing process
	DisplayId *string `json:"display-id,omitempty"`
	// HashFunction defines the hash function (e.g. sha-256)
	HashFunction *string `json:"hash-function,omitempty"`
	// Select default assumed format for the plaintext message. Currently supported options: [base64]
	InputFormat *string `json:"input-format,omitempty"`
	// The item id of the key to use in the signing process
	ItemId *int64 `json:"item-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of the RSA key to use in the signing process
	KeyName *string `json:"key-name,omitempty"`
	// The message to be signed
	Message string `json:"message"`
	// Markes that the message is already hashed
	Prehashed *bool `json:"prehashed,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// The version of the key to use for signing
	Version *int32 `json:"version,omitempty"`
}

// NewSignPKCS1 instantiates a new SignPKCS1 object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSignPKCS1(message string, ) *SignPKCS1 {
	this := SignPKCS1{}
	var json bool = false
	this.Json = &json
	this.Message = message
	return &this
}

// NewSignPKCS1WithDefaults instantiates a new SignPKCS1 object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSignPKCS1WithDefaults() *SignPKCS1 {
	this := SignPKCS1{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetDisplayId returns the DisplayId field value if set, zero value otherwise.
func (o *SignPKCS1) GetDisplayId() string {
	if o == nil || o.DisplayId == nil {
		var ret string
		return ret
	}
	return *o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetDisplayIdOk() (*string, bool) {
	if o == nil || o.DisplayId == nil {
		return nil, false
	}
	return o.DisplayId, true
}

// HasDisplayId returns a boolean if a field has been set.
func (o *SignPKCS1) HasDisplayId() bool {
	if o != nil && o.DisplayId != nil {
		return true
	}

	return false
}

// SetDisplayId gets a reference to the given string and assigns it to the DisplayId field.
func (o *SignPKCS1) SetDisplayId(v string) {
	o.DisplayId = &v
}

// GetHashFunction returns the HashFunction field value if set, zero value otherwise.
func (o *SignPKCS1) GetHashFunction() string {
	if o == nil || o.HashFunction == nil {
		var ret string
		return ret
	}
	return *o.HashFunction
}

// GetHashFunctionOk returns a tuple with the HashFunction field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetHashFunctionOk() (*string, bool) {
	if o == nil || o.HashFunction == nil {
		return nil, false
	}
	return o.HashFunction, true
}

// HasHashFunction returns a boolean if a field has been set.
func (o *SignPKCS1) HasHashFunction() bool {
	if o != nil && o.HashFunction != nil {
		return true
	}

	return false
}

// SetHashFunction gets a reference to the given string and assigns it to the HashFunction field.
func (o *SignPKCS1) SetHashFunction(v string) {
	o.HashFunction = &v
}

// GetInputFormat returns the InputFormat field value if set, zero value otherwise.
func (o *SignPKCS1) GetInputFormat() string {
	if o == nil || o.InputFormat == nil {
		var ret string
		return ret
	}
	return *o.InputFormat
}

// GetInputFormatOk returns a tuple with the InputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetInputFormatOk() (*string, bool) {
	if o == nil || o.InputFormat == nil {
		return nil, false
	}
	return o.InputFormat, true
}

// HasInputFormat returns a boolean if a field has been set.
func (o *SignPKCS1) HasInputFormat() bool {
	if o != nil && o.InputFormat != nil {
		return true
	}

	return false
}

// SetInputFormat gets a reference to the given string and assigns it to the InputFormat field.
func (o *SignPKCS1) SetInputFormat(v string) {
	o.InputFormat = &v
}

// GetItemId returns the ItemId field value if set, zero value otherwise.
func (o *SignPKCS1) GetItemId() int64 {
	if o == nil || o.ItemId == nil {
		var ret int64
		return ret
	}
	return *o.ItemId
}

// GetItemIdOk returns a tuple with the ItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetItemIdOk() (*int64, bool) {
	if o == nil || o.ItemId == nil {
		return nil, false
	}
	return o.ItemId, true
}

// HasItemId returns a boolean if a field has been set.
func (o *SignPKCS1) HasItemId() bool {
	if o != nil && o.ItemId != nil {
		return true
	}

	return false
}

// SetItemId gets a reference to the given int64 and assigns it to the ItemId field.
func (o *SignPKCS1) SetItemId(v int64) {
	o.ItemId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *SignPKCS1) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *SignPKCS1) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *SignPKCS1) SetJson(v bool) {
	o.Json = &v
}

// GetKeyName returns the KeyName field value if set, zero value otherwise.
func (o *SignPKCS1) GetKeyName() string {
	if o == nil || o.KeyName == nil {
		var ret string
		return ret
	}
	return *o.KeyName
}

// GetKeyNameOk returns a tuple with the KeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetKeyNameOk() (*string, bool) {
	if o == nil || o.KeyName == nil {
		return nil, false
	}
	return o.KeyName, true
}

// HasKeyName returns a boolean if a field has been set.
func (o *SignPKCS1) HasKeyName() bool {
	if o != nil && o.KeyName != nil {
		return true
	}

	return false
}

// SetKeyName gets a reference to the given string and assigns it to the KeyName field.
func (o *SignPKCS1) SetKeyName(v string) {
	o.KeyName = &v
}

// GetMessage returns the Message field value
func (o *SignPKCS1) GetMessage() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Message
}

// GetMessageOk returns a tuple with the Message field value
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetMessageOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Message, true
}

// SetMessage sets field value
func (o *SignPKCS1) SetMessage(v string) {
	o.Message = v
}

// GetPrehashed returns the Prehashed field value if set, zero value otherwise.
func (o *SignPKCS1) GetPrehashed() bool {
	if o == nil || o.Prehashed == nil {
		var ret bool
		return ret
	}
	return *o.Prehashed
}

// GetPrehashedOk returns a tuple with the Prehashed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetPrehashedOk() (*bool, bool) {
	if o == nil || o.Prehashed == nil {
		return nil, false
	}
	return o.Prehashed, true
}

// HasPrehashed returns a boolean if a field has been set.
func (o *SignPKCS1) HasPrehashed() bool {
	if o != nil && o.Prehashed != nil {
		return true
	}

	return false
}

// SetPrehashed gets a reference to the given bool and assigns it to the Prehashed field.
func (o *SignPKCS1) SetPrehashed(v bool) {
	o.Prehashed = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *SignPKCS1) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *SignPKCS1) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *SignPKCS1) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *SignPKCS1) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *SignPKCS1) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *SignPKCS1) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *SignPKCS1) GetVersion() int32 {
	if o == nil || o.Version == nil {
		var ret int32
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignPKCS1) GetVersionOk() (*int32, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *SignPKCS1) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int32 and assigns it to the Version field.
func (o *SignPKCS1) SetVersion(v int32) {
	o.Version = &v
}

func (o SignPKCS1) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DisplayId != nil {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.HashFunction != nil {
		toSerialize["hash-function"] = o.HashFunction
	}
	if o.InputFormat != nil {
		toSerialize["input-format"] = o.InputFormat
	}
	if o.ItemId != nil {
		toSerialize["item-id"] = o.ItemId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeyName != nil {
		toSerialize["key-name"] = o.KeyName
	}
	if true {
		toSerialize["message"] = o.Message
	}
	if o.Prehashed != nil {
		toSerialize["prehashed"] = o.Prehashed
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableSignPKCS1 struct {
	value *SignPKCS1
	isSet bool
}

func (v NullableSignPKCS1) Get() *SignPKCS1 {
	return v.value
}

func (v *NullableSignPKCS1) Set(val *SignPKCS1) {
	v.value = val
	v.isSet = true
}

func (v NullableSignPKCS1) IsSet() bool {
	return v.isSet
}

func (v *NullableSignPKCS1) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSignPKCS1(val *SignPKCS1) *NullableSignPKCS1 {
	return &NullableSignPKCS1{value: val, isSet: true}
}

func (v NullableSignPKCS1) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSignPKCS1) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


