#ifndef _VTREE_H_
#define _VTREE_H_

struct vtree;

struct ventry {
    struct list_head 	children;
    struct list_head	list;
    struct lufs_fattr	fattr;
    struct vtree	*vtree;
    unsigned 		nr_children;
    char		*name;
    char		*link;
    void		*private;
    time_t		stamp;
};

struct vtree {
    struct ventry	root;
    unsigned		entries;
};

struct vtree *lu_vtree_create(struct lufs_fattr*);
struct ventry *lu_vtree_search(struct ventry*, char*);
struct ventry *lu_vtree_find(struct vtree*, char*);
void lu_vtree_destroy(struct vtree*);
void lu_vtree_delete(struct ventry*);
int lu_vtree_add(struct vtree*, char*, char*, char*, struct lufs_fattr*, void*);int lu_vtree_lookup(struct vtree*, char*, struct lufs_fattr*, char*, int, void**);
int lu_vtree_readdir(struct vtree*, char*, int, char*, int);

#endif
