/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;

class ValuesDoubleAggregator {
    ValuesDoubleAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, double v) {
        state.values.add(Double.doubleToLongBits(v));
    }

    public static void combineIntermediate(SingleState state, DoubleBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesDoubleAggregator.combine(state, values.getDouble(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, double v) {
        state.values.add((long)groupId, Double.doubleToLongBits(v));
    }

    public static void combineIntermediate(GroupingState state, int groupId, DoubleBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            ValuesDoubleAggregator.combine(state, groupId, values.getDouble(i));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        int id = 0;
        while ((long)id < state.values.size()) {
            if (state.values.getKey1((long)id) == (long)statePosition) {
                double value = Double.longBitsToDouble(state.values.getKey2((long)id));
                ValuesDoubleAggregator.combine(current, currentGroupId, value);
            }
            ++id;
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements AggregatorState {
        private final LongHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new LongHash(1L, bigArrays);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            if (this.values.size() == 1L) {
                return blockFactory.newConstantDoubleBlockWith(Double.longBitsToDouble(this.values.get(0L)), 1);
            }
            try (DoubleBlock.Builder builder = blockFactory.newDoubleBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendDouble(Double.longBitsToDouble(this.values.get((long)id)));
                    ++id;
                }
                builder.endPositionEntry();
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final LongLongHash values;

        private GroupingState(BigArrays bigArrays) {
            this.values = new LongLongHash(1L, bigArrays);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            long selectedCountsSize = 0L;
            long idsSize = 0L;
            try {
                DoubleBlock doubleBlock;
                block21: {
                    int selectedCountsLen = selected.max() + 1;
                    long adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + selectedCountsLen * 4));
                    blockFactory.adjustBreaker(adjust);
                    selectedCountsSize = adjust;
                    int[] selectedCounts = new int[selectedCountsLen];
                    int id = 0;
                    while ((long)id < this.values.size()) {
                        int group = (int)this.values.getKey1((long)id);
                        if (group < selectedCounts.length) {
                            int n = group;
                            selectedCounts[n] = selectedCounts[n] - 1;
                        }
                        ++id;
                    }
                    int total = 0;
                    for (int s = 0; s < selected.getPositionCount(); ++s) {
                        int group = selected.getInt(s);
                        int count = -selectedCounts[group];
                        selectedCounts[group] = total;
                        total += count;
                    }
                    adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + total * 4));
                    blockFactory.adjustBreaker(adjust);
                    idsSize = adjust;
                    int[] ids = new int[total];
                    int id2 = 0;
                    while ((long)id2 < this.values.size()) {
                        int group = (int)this.values.getKey1((long)id2);
                        if (group < selectedCounts.length && selectedCounts[group] >= 0) {
                            int n = group;
                            int n2 = selectedCounts[n];
                            selectedCounts[n] = n2 + 1;
                            ids[n2] = id2;
                        }
                        ++id2;
                    }
                    DoubleBlock.Builder builder = blockFactory.newDoubleBlockBuilder(selected.getPositionCount());
                    try {
                        int start = 0;
                        for (int s = 0; s < selected.getPositionCount(); ++s) {
                            int group = selected.getInt(s);
                            int end = selectedCounts[group];
                            int count = end - start;
                            switch (count) {
                                case 0: {
                                    builder.appendNull();
                                    break;
                                }
                                case 1: {
                                    this.append(builder, ids[start]);
                                    break;
                                }
                                default: {
                                    builder.beginPositionEntry();
                                    for (int i = start; i < end; ++i) {
                                        this.append(builder, ids[i]);
                                    }
                                    builder.endPositionEntry();
                                }
                            }
                            start = end;
                        }
                        doubleBlock = builder.build();
                        if (builder == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    builder.close();
                }
                return doubleBlock;
            }
            finally {
                blockFactory.adjustBreaker(-selectedCountsSize - idsSize);
            }
        }

        private void append(DoubleBlock.Builder builder, int id) {
            double value = Double.longBitsToDouble(this.values.getKey2((long)id));
            builder.appendDouble(value);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            this.values.close();
        }
    }
}

