/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.BitSet;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Nullable;

abstract class AbstractArrayBlock
extends AbstractNonThreadSafeRefCounted
implements Block {
    private final Block.MvOrdering mvOrdering;
    protected final int positionCount;
    @Nullable
    protected final int[] firstValueIndexes;
    @Nullable
    protected final BitSet nullsMask;

    protected AbstractArrayBlock(int positionCount, @Nullable int[] firstValueIndexes, @Nullable BitSet nullsMask, Block.MvOrdering mvOrdering) {
        this.positionCount = positionCount;
        this.firstValueIndexes = firstValueIndexes;
        this.mvOrdering = mvOrdering;
        BitSet bitSet = this.nullsMask = nullsMask == null || nullsMask.isEmpty() ? null : nullsMask;
        assert (nullsMask != null || firstValueIndexes != null) : "Create VectorBlock instead";
        assert (this.assertInvariants());
    }

    @Override
    public final boolean mayHaveMultivaluedFields() {
        return this.firstValueIndexes != null;
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        if (!this.mayHaveMultivaluedFields()) {
            return false;
        }
        for (int p = 0; p < this.getPositionCount(); ++p) {
            if (this.getValueCount(p) <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Block.MvOrdering mvOrdering() {
        return this.mvOrdering;
    }

    protected final BitSet shiftNullsToExpandedPositions() {
        BitSet expanded = new BitSet(this.nullsMask.size());
        int next = -1;
        while ((next = this.nullsMask.nextSetBit(next + 1)) != -1) {
            expanded.set(this.getFirstValueIndex(next));
        }
        return expanded;
    }

    private boolean assertInvariants() {
        int i;
        if (this.firstValueIndexes != null) {
            assert (this.firstValueIndexes.length >= this.getPositionCount() + 1) : this.firstValueIndexes.length + " < " + this.positionCount;
            for (i = 0; i < this.getPositionCount(); ++i) {
                assert (this.firstValueIndexes[i + 1] > this.firstValueIndexes[i]) : this.firstValueIndexes[i + 1] + " <= " + this.firstValueIndexes[i];
            }
        }
        if (this.nullsMask != null) assert (this.nullsMask.nextSetBit(this.getPositionCount() + 1) == -1);
        if (this.firstValueIndexes != null && this.nullsMask != null) {
            for (i = 0; i < this.getPositionCount(); ++i) {
                assert (!this.nullsMask.get(i) || this.firstValueIndexes[i + 1] - this.firstValueIndexes[i] == 1);
            }
        }
        return true;
    }

    @Override
    public final int getTotalValueCount() {
        if (this.firstValueIndexes == null) {
            return this.positionCount - this.nullValuesCount();
        }
        return this.firstValueIndexes[this.positionCount] - this.nullValuesCount();
    }

    @Override
    public final int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public final int getFirstValueIndex(int position) {
        return this.firstValueIndexes == null ? position : this.firstValueIndexes[position];
    }

    @Override
    public final int getValueCount(int position) {
        return this.isNull(position) ? 0 : (this.firstValueIndexes == null ? 1 : this.firstValueIndexes[position + 1] - this.firstValueIndexes[position]);
    }

    @Override
    public final boolean isNull(int position) {
        return this.mayHaveNulls() && this.nullsMask.get(position);
    }

    @Override
    public final boolean mayHaveNulls() {
        return this.nullsMask != null;
    }

    final int nullValuesCount() {
        return this.mayHaveNulls() ? this.nullsMask.cardinality() : 0;
    }

    @Override
    public final boolean areAllValuesNull() {
        return this.nullValuesCount() == this.getPositionCount();
    }

    void writeSubFields(StreamOutput out) throws IOException {
        out.writeVInt(this.positionCount);
        out.writeBoolean(this.firstValueIndexes != null);
        if (this.firstValueIndexes != null) {
            out.writeVInt(this.firstValueIndexes[0]);
            for (int i = 1; i <= this.positionCount; ++i) {
                out.writeVInt(this.firstValueIndexes[i] - this.firstValueIndexes[i - 1]);
            }
        }
        out.writeBoolean(this.nullsMask != null);
        if (this.nullsMask != null) {
            out.writeLongArray(this.nullsMask.toLongArray());
        }
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_15_0) && this.mvOrdering == Block.MvOrdering.SORTED_ASCENDING) {
            out.writeEnum((Enum)Block.MvOrdering.UNORDERED);
        } else {
            out.writeEnum((Enum)this.mvOrdering);
        }
    }

    static final class SubFields {
        long bytesReserved = 0L;
        final int positionCount;
        final int[] firstValueIndexes;
        final BitSet nullsMask;
        final Block.MvOrdering mvOrdering;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SubFields(BlockFactory blockFactory, StreamInput in) throws IOException {
            this.positionCount = in.readVInt();
            boolean success = false;
            try {
                if (in.readBoolean()) {
                    this.bytesReserved += blockFactory.preAdjustBreakerForInt(this.positionCount + 1);
                    int[] values = new int[this.positionCount + 1];
                    values[0] = in.readVInt();
                    for (int i = 1; i <= this.positionCount; ++i) {
                        values[i] = values[i - 1] + in.readVInt();
                    }
                    this.firstValueIndexes = values;
                } else {
                    this.firstValueIndexes = null;
                }
                if (in.readBoolean()) {
                    this.bytesReserved += blockFactory.preAdjustBreakerForLong(this.positionCount / 8);
                    this.nullsMask = BitSet.valueOf(in.readLongArray());
                } else {
                    this.nullsMask = null;
                }
                this.mvOrdering = (Block.MvOrdering)in.readEnum(Block.MvOrdering.class);
                success = true;
            }
            finally {
                if (!success) {
                    blockFactory.adjustBreaker(-this.bytesReserved);
                }
            }
        }

        int vectorPositions() {
            return this.firstValueIndexes == null ? this.positionCount : this.firstValueIndexes[this.positionCount];
        }
    }
}

