/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.elasticsearch.common.Strings;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;

public final class LuceneTopNSourceOperator
extends LuceneOperator {
    private ScoreDoc[] scoreDocs;
    private int offset = 0;
    private PerShardCollector perShardCollector;
    private final List<SortBuilder<?>> sorts;
    private final int limit;
    private final ScoreMode scoreMode;

    public LuceneTopNSourceOperator(BlockFactory blockFactory, int maxPageSize, List<SortBuilder<?>> sorts, int limit, LuceneSliceQueue sliceQueue, ScoreMode scoreMode) {
        super(blockFactory, maxPageSize, sliceQueue);
        this.sorts = sorts;
        this.limit = limit;
        this.scoreMode = scoreMode;
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting && !this.isEmitting();
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
        this.scoreDocs = null;
        assert (this.isFinished());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getCheckedOutput() throws IOException {
        if (this.isFinished()) {
            return null;
        }
        long start = System.nanoTime();
        try {
            if (this.isEmitting()) {
                Page page = this.emit(false);
                return page;
            }
            Page page = this.collect();
            return page;
        }
        finally {
            this.processingNanos += System.nanoTime() - start;
        }
    }

    private Page collect() throws IOException {
        LuceneOperator.LuceneScorer nextScorer;
        assert (!this.doneCollecting);
        LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
        if (scorer == null) {
            this.doneCollecting = true;
            return this.emit(true);
        }
        try {
            if (this.perShardCollector == null || this.perShardCollector.shardContext.index() != scorer.shardContext().index()) {
                this.perShardCollector = this.newPerShardCollector(scorer.shardContext(), this.sorts, this.limit);
            }
            LeafCollector leafCollector = this.perShardCollector.getLeafCollector(scorer.leafReaderContext());
            scorer.scoreNextRange(leafCollector, scorer.leafReaderContext().reader().getLiveDocs(), this.maxPageSize);
        }
        catch (CollectionTerminatedException cte) {
            scorer.markAsDone();
        }
        if (scorer.isDone() && ((nextScorer = this.getCurrentOrLoadNextScorer()) == null || nextScorer.shardContext().index() != scorer.shardContext().index())) {
            return this.emit(true);
        }
        return null;
    }

    private boolean isEmitting() {
        return this.scoreDocs != null && this.offset < this.scoreDocs.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Page emit(boolean startEmitting) {
        if (startEmitting) {
            assert (!this.isEmitting()) : "offset=" + this.offset + " score_docs=" + Arrays.toString(this.scoreDocs);
            this.offset = 0;
            this.scoreDocs = this.perShardCollector != null ? this.perShardCollector.collector.topDocs().scoreDocs : new ScoreDoc[0];
        }
        if (this.offset >= this.scoreDocs.length) {
            return null;
        }
        int size = Math.min(this.maxPageSize, this.scoreDocs.length - this.offset);
        IntBlock shard = null;
        IntVector segments = null;
        IntVector docs = null;
        DocBlock docBlock = null;
        DoubleBlock scores = null;
        Page page = null;
        try {
            try (IntVector.FixedBuilder currentSegmentBuilder = this.blockFactory.newIntVectorFixedBuilder(size);
                 IntVector.FixedBuilder currentDocsBuilder = this.blockFactory.newIntVectorFixedBuilder(size);
                 DoubleVector.Builder currentScoresBuilder = this.scoreVectorOrNull(size);){
                int start = this.offset;
                this.offset += size;
                List leafContexts = this.perShardCollector.shardContext.searcher().getLeafContexts();
                for (int i = start; i < this.offset; ++i) {
                    int doc = this.scoreDocs[i].doc;
                    int segment = ReaderUtil.subIndex((int)doc, (List)leafContexts);
                    currentSegmentBuilder.appendInt(segment);
                    currentDocsBuilder.appendInt(doc - ((LeafReaderContext)leafContexts.get((int)segment)).docBase);
                    if (currentScoresBuilder == null) continue;
                    float score = this.getScore(this.scoreDocs[i]);
                    currentScoresBuilder.appendDouble(score);
                }
                shard = this.blockFactory.newConstantIntBlockWith(this.perShardCollector.shardContext.index(), size);
                segments = currentSegmentBuilder.build();
                docs = currentDocsBuilder.build();
                docBlock = new DocVector(shard.asVector(), segments, docs, null).asBlock();
                shard = null;
                segments = null;
                docs = null;
                if (currentScoresBuilder == null) {
                    page = new Page(size, docBlock);
                } else {
                    scores = currentScoresBuilder.build().asBlock();
                    page = new Page(size, docBlock, scores);
                }
            }
            if (page != null) return page;
        }
        catch (Throwable throwable) {
            if (page != null) throw throwable;
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, segments, docs, docBlock, scores});
            throw throwable;
        }
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, segments, docs, docBlock, scores});
        return page;
    }

    private float getScore(ScoreDoc scoreDoc) {
        if (scoreDoc instanceof FieldDoc) {
            FieldDoc fieldDoc = (FieldDoc)scoreDoc;
            if (Float.isNaN(fieldDoc.score)) {
                if (this.sorts != null) {
                    return ((Float)fieldDoc.fields[this.sorts.size() + 1]).floatValue();
                }
                return ((Float)fieldDoc.fields[0]).floatValue();
            }
            return fieldDoc.score;
        }
        return scoreDoc.score;
    }

    private DoubleVector.Builder scoreVectorOrNull(int size) {
        if (this.scoreMode.needsScores()) {
            return this.blockFactory.newDoubleVectorFixedBuilder(size);
        }
        return null;
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", limit = ").append(this.limit);
        sb.append(", scoreMode = ").append(this.scoreMode);
        String notPrettySorts = this.sorts.stream().map(Strings::toString).collect(Collectors.joining(","));
        sb.append(", sorts = [").append(notPrettySorts).append("]");
    }

    PerShardCollector newPerShardCollector(ShardContext shardContext, List<SortBuilder<?>> sorts, int limit) throws IOException {
        Optional<SortAndFormats> sortAndFormats = shardContext.buildSort(sorts);
        if (sortAndFormats.isEmpty()) {
            throw new IllegalStateException("sorts must not be disabled in TopN");
        }
        if (!this.scoreMode.needsScores()) {
            return new NonScoringPerShardCollector(shardContext, sortAndFormats.get().sort, limit);
        }
        SortField[] sortFields = sortAndFormats.get().sort.getSort();
        if (sortFields != null && sortFields.length == 1 && sortFields[0].needsScores() && !sortFields[0].getReverse()) {
            return new ScoringPerShardCollector(shardContext, (TopDocsCollector<?>)new TopScoreDocCollectorManager(limit, null, limit, false).newCollector());
        }
        Sort sort = new Sort();
        if (sortFields != null) {
            ArrayList<SortField> l = new ArrayList<SortField>(Arrays.asList(sortFields));
            l.add(SortField.FIELD_DOC);
            l.add(SortField.FIELD_SCORE);
            sort = new Sort((SortField[])l.toArray(SortField[]::new));
        }
        return new ScoringPerShardCollector(shardContext, (TopDocsCollector<?>)new TopFieldCollectorManager(sort, limit, null, limit, false).newCollector());
    }

    static abstract class PerShardCollector {
        private final ShardContext shardContext;
        private final TopDocsCollector<?> collector;
        private int leafIndex;
        private LeafCollector leafCollector;
        private Thread currentThread;

        PerShardCollector(ShardContext shardContext, TopDocsCollector<?> collector) {
            this.shardContext = shardContext;
            this.collector = collector;
        }

        LeafCollector getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            if (this.currentThread != Thread.currentThread() || this.leafIndex != leafReaderContext.ord) {
                this.leafCollector = this.collector.getLeafCollector(leafReaderContext);
                this.leafIndex = leafReaderContext.ord;
                this.currentThread = Thread.currentThread();
            }
            return this.leafCollector;
        }
    }

    static final class NonScoringPerShardCollector
    extends PerShardCollector {
        NonScoringPerShardCollector(ShardContext shardContext, Sort sort, int limit) {
            super(shardContext, (TopDocsCollector<?>)new TopFieldCollectorManager(sort, limit, null, 0, false).newCollector());
        }
    }

    static final class ScoringPerShardCollector
    extends PerShardCollector {
        ScoringPerShardCollector(ShardContext shardContext, TopDocsCollector<?> topDocsCollector) {
            super(shardContext, topDocsCollector);
        }
    }

    public static class Factory
    extends LuceneOperator.Factory {
        private final int maxPageSize;
        private final List<SortBuilder<?>> sorts;

        public Factory(List<? extends ShardContext> contexts, Function<ShardContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int maxPageSize, int limit, List<SortBuilder<?>> sorts, boolean scoring) {
            super(contexts, queryFunction, dataPartitioning, taskConcurrency, limit, scoring ? ScoreMode.COMPLETE : ScoreMode.TOP_DOCS);
            this.maxPageSize = maxPageSize;
            this.sorts = sorts;
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneTopNSourceOperator(driverContext.blockFactory(), this.maxPageSize, this.sorts, this.limit, this.sliceQueue, this.scoreMode);
        }

        public int maxPageSize() {
            return this.maxPageSize;
        }

        @Override
        public String describe() {
            String notPrettySorts = this.sorts.stream().map(Strings::toString).collect(Collectors.joining(","));
            return "LuceneTopNSourceOperator[dataPartitioning = " + String.valueOf((Object)this.dataPartitioning) + ", maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + ", scoreMode = " + String.valueOf(this.scoreMode) + ", sorts = [" + notPrettySorts + "]]";
        }
    }
}

