/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class CanMatchNodeRequest
extends TransportRequest
implements IndicesRequest {
    private final SearchSourceBuilder source;
    private final List<Shard> shards;
    private final SearchType searchType;
    private final Boolean requestCache;
    private final boolean allowPartialSearchResults;
    @Nullable
    private final TimeValue scroll;
    private final int numberOfShards;
    private final long nowInMillis;
    @Nullable
    private final String clusterAlias;
    private final String[] indices;
    private final IndicesOptions indicesOptions;
    private final TimeValue waitForCheckpointsTimeout;

    public CanMatchNodeRequest(SearchRequest searchRequest, IndicesOptions indicesOptions, List<Shard> shards, int numberOfShards, long nowInMillis, @Nullable String clusterAlias) {
        this.source = this.getCanMatchSource(searchRequest);
        this.indicesOptions = indicesOptions;
        this.shards = shards;
        this.searchType = searchRequest.searchType();
        this.requestCache = searchRequest.requestCache();
        assert (searchRequest.allowPartialSearchResults() != null);
        this.allowPartialSearchResults = searchRequest.allowPartialSearchResults();
        this.scroll = searchRequest.scroll();
        this.numberOfShards = numberOfShards;
        this.nowInMillis = nowInMillis;
        this.clusterAlias = clusterAlias;
        this.waitForCheckpointsTimeout = searchRequest.getWaitForCheckpointsTimeout();
        this.indices = (String[])shards.stream().map(Shard::getOriginalIndices).flatMap(Arrays::stream).distinct().toArray(String[]::new);
    }

    private static void collectAggregationQueries(Collection<AggregationBuilder> aggregations, List<QueryBuilder> aggregationQueries) {
        for (AggregationBuilder aggregation : aggregations) {
            QueryBuilder aggregationQuery = aggregation.getQuery();
            if (aggregationQuery != null) {
                aggregationQueries.add(aggregationQuery);
            }
            CanMatchNodeRequest.collectAggregationQueries(aggregation.getSubAggregations(), aggregationQueries);
        }
    }

    private SearchSourceBuilder getCanMatchSource(SearchRequest searchRequest) {
        ArrayList<QueryBuilder> aggregationQueries = new ArrayList<QueryBuilder>();
        if (searchRequest.source() != null && searchRequest.source().aggregations() != null) {
            CanMatchNodeRequest.collectAggregationQueries(searchRequest.source().aggregations().getAggregatorFactories(), aggregationQueries);
        }
        if (aggregationQueries.isEmpty()) {
            return searchRequest.source();
        }
        ArrayList<SubSearchSourceBuilder> subSearches = new ArrayList<SubSearchSourceBuilder>(searchRequest.source().subSearches());
        for (QueryBuilder aggregationQuery : aggregationQueries) {
            subSearches.add(new SubSearchSourceBuilder(aggregationQuery));
        }
        return searchRequest.source().shallowCopy().subSearches(subSearches);
    }

    public CanMatchNodeRequest(StreamInput in) throws IOException {
        super(in);
        Object[] types;
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.searchType = SearchType.fromId(in.readByte());
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (types = in.readStringArray()).length > 0) {
            throw new IllegalStateException("types are no longer supported in search requests but found [" + Arrays.toString(types) + "]");
        }
        this.scroll = in.readOptionalTimeValue();
        this.requestCache = in.readOptionalBoolean();
        this.allowPartialSearchResults = in.readBoolean();
        this.numberOfShards = in.readVInt();
        this.nowInMillis = in.readVLong();
        this.clusterAlias = in.readOptionalString();
        this.waitForCheckpointsTimeout = in.readTimeValue();
        this.shards = in.readCollectionAsList(Shard::new);
        this.indices = (String[])this.shards.stream().map(Shard::getOriginalIndices).flatMap(Arrays::stream).distinct().toArray(String[]::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.source);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeByte(this.searchType.id());
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        out.writeOptionalTimeValue(this.scroll);
        out.writeOptionalBoolean(this.requestCache);
        out.writeBoolean(this.allowPartialSearchResults);
        out.writeVInt(this.numberOfShards);
        out.writeVLong(this.nowInMillis);
        out.writeOptionalString(this.clusterAlias);
        out.writeTimeValue(this.waitForCheckpointsTimeout);
        out.writeCollection(this.shards);
    }

    public List<Shard> getShardLevelRequests() {
        return this.shards;
    }

    public ShardSearchRequest createShardSearchRequest(Shard r) {
        ShardSearchRequest shardSearchRequest = new ShardSearchRequest(new OriginalIndices(r.indices, this.indicesOptions), r.shardId, r.shardRequestIndex, this.numberOfShards, this.searchType, this.source, this.requestCache, r.aliasFilter, r.indexBoost, this.allowPartialSearchResults, this.scroll, this.nowInMillis, this.clusterAlias, r.readerId, r.keepAlive, r.waitForCheckpoint, this.waitForCheckpointsTimeout, false);
        shardSearchRequest.setParentTask(this.getParentTask());
        return shardSearchRequest;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "shardIds[" + String.valueOf(this.shards.stream().map(slr -> slr.shardId).toList()) + "]";
    }

    public static class Shard
    implements Writeable {
        private final String[] indices;
        private final ShardId shardId;
        private final int shardRequestIndex;
        private final AliasFilter aliasFilter;
        private final float indexBoost;
        private final ShardSearchContextId readerId;
        private final TimeValue keepAlive;
        private final long waitForCheckpoint;

        public Shard(String[] indices, ShardId shardId, int shardRequestIndex, AliasFilter aliasFilter, float indexBoost, ShardSearchContextId readerId, TimeValue keepAlive, long waitForCheckpoint) {
            this.indices = indices;
            this.shardId = shardId;
            this.shardRequestIndex = shardRequestIndex;
            this.aliasFilter = aliasFilter;
            this.indexBoost = indexBoost;
            this.readerId = readerId;
            this.keepAlive = keepAlive;
            this.waitForCheckpoint = waitForCheckpoint;
            assert (keepAlive == null || readerId != null) : "readerId: " + String.valueOf(readerId) + " keepAlive: " + String.valueOf(keepAlive);
        }

        public Shard(StreamInput in) throws IOException {
            this.indices = in.readStringArray();
            this.shardId = new ShardId(in);
            this.shardRequestIndex = in.readVInt();
            this.aliasFilter = AliasFilter.readFrom(in);
            this.indexBoost = in.readFloat();
            this.readerId = in.readOptionalWriteable(ShardSearchContextId::new);
            this.keepAlive = in.readOptionalTimeValue();
            this.waitForCheckpoint = in.readLong();
            assert (this.keepAlive == null || this.readerId != null) : "readerId: " + String.valueOf(this.readerId) + " keepAlive: " + String.valueOf(this.keepAlive);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.indices);
            this.shardId.writeTo(out);
            out.writeVInt(this.shardRequestIndex);
            this.aliasFilter.writeTo(out);
            out.writeFloat(this.indexBoost);
            out.writeOptionalWriteable(this.readerId);
            out.writeOptionalTimeValue(this.keepAlive);
            out.writeLong(this.waitForCheckpoint);
        }

        public int getShardRequestIndex() {
            return this.shardRequestIndex;
        }

        public String[] getOriginalIndices() {
            return this.indices;
        }

        public ShardId shardId() {
            return this.shardId;
        }
    }
}

