/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.util.SameThreadExecutorService;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.engine.ElasticsearchMergeScheduler;
import org.elasticsearch.index.engine.MergeTracking;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.shard.ShardId;

public class ElasticsearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler
implements ElasticsearchMergeScheduler {
    protected final Logger logger;
    private final Settings indexSettings;
    private final ShardId shardId;
    private final MergeTracking mergeTracking;
    private final MergeSchedulerConfig config;
    private final SameThreadExecutorService sameThreadExecutorService = new SameThreadExecutorService();
    private static final String MERGE_THREAD_MESSAGE_PREFIX = "merge thread";

    ElasticsearchConcurrentMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
        this.config = indexSettings.getMergeSchedulerConfig();
        this.shardId = shardId;
        this.indexSettings = indexSettings.getSettings();
        this.logger = Loggers.getLogger(this.getClass(), shardId, new String[0]);
        this.mergeTracking = new MergeTracking(this.logger, () -> indexSettings.getMergeSchedulerConfig().isAutoThrottle() ? this.getIORateLimitMBPerSec() : Double.POSITIVE_INFINITY);
        this.refreshConfig();
    }

    @Override
    public Set<OnGoingMerge> onGoingMerges() {
        return this.mergeTracking.onGoingMerges();
    }

    public Executor getIntraMergeExecutor(MergePolicy.OneMerge merge) {
        return this.sameThreadExecutorService;
    }

    public void close() throws IOException {
        super.close();
        this.sameThreadExecutorService.shutdown();
    }

    protected boolean verbose() {
        if (this.logger.isTraceEnabled() && Thread.currentThread() instanceof ConcurrentMergeScheduler.MergeThread) {
            return true;
        }
        return super.verbose();
    }

    protected void message(String message) {
        if (this.logger.isTraceEnabled() && Thread.currentThread() instanceof ConcurrentMergeScheduler.MergeThread && message.startsWith(MERGE_THREAD_MESSAGE_PREFIX)) {
            this.logger.trace("{}", (Object)message);
        }
        super.message(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        long timeNS = System.nanoTime();
        OnGoingMerge onGoingMerge = new OnGoingMerge(merge);
        this.mergeTracking.mergeStarted(onGoingMerge);
        try {
            this.beforeMerge(onGoingMerge);
            super.doMerge(mergeSource, merge);
        }
        finally {
            long tookMS = TimeValue.nsecToMSec((long)(System.nanoTime() - timeNS));
            this.mergeTracking.mergeFinished(merge, onGoingMerge, tookMS);
            this.afterMerge(onGoingMerge);
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    public MergeScheduler clone() {
        return this;
    }

    protected boolean maybeStall(MergeScheduler.MergeSource mergeSource) {
        return true;
    }

    protected ConcurrentMergeScheduler.MergeThread getMergeThread(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(mergeSource, merge);
        thread.setName(EsExecutors.threadName(this.indexSettings, "[" + this.shardId.getIndexName() + "][" + this.shardId.id() + "]: " + thread.getName()));
        return thread;
    }

    @Override
    public MergeStats stats() {
        return this.mergeTracking.stats();
    }

    @Override
    public void refreshConfig() {
        boolean isEnabled;
        if (this.getMaxMergeCount() != this.config.getMaxMergeCount() || this.getMaxThreadCount() != this.config.getMaxThreadCount()) {
            this.setMaxMergesAndThreads(this.config.getMaxMergeCount(), this.config.getMaxThreadCount());
        }
        boolean bl = isEnabled = this.getIORateLimitMBPerSec() != Double.POSITIVE_INFINITY;
        if (this.config.isAutoThrottle() && !isEnabled) {
            this.enableAutoIOThrottle();
        } else if (!this.config.isAutoThrottle() && isEnabled) {
            this.disableAutoIOThrottle();
        }
    }

    @Override
    public MergeScheduler getMergeScheduler() {
        return this;
    }
}

