/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.HandlingTimeTracker;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.TransportActionStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TransportStats
implements Writeable,
ChunkedToXContent {
    private final long serverOpen;
    private final long totalOutboundConnections;
    private final long rxCount;
    private final long rxSize;
    private final long txCount;
    private final long txSize;
    private final long[] inboundHandlingTimeBucketFrequencies;
    private final long[] outboundHandlingTimeBucketFrequencies;
    private final Map<String, TransportActionStats> transportActionStats;

    public TransportStats(long serverOpen, long totalOutboundConnections, long rxCount, long rxSize, long txCount, long txSize, long[] inboundHandlingTimeBucketFrequencies, long[] outboundHandlingTimeBucketFrequencies, Map<String, TransportActionStats> transportActionStats) {
        this.serverOpen = serverOpen;
        this.totalOutboundConnections = totalOutboundConnections;
        this.rxCount = rxCount;
        this.rxSize = rxSize;
        this.txCount = txCount;
        this.txSize = txSize;
        this.inboundHandlingTimeBucketFrequencies = inboundHandlingTimeBucketFrequencies;
        this.outboundHandlingTimeBucketFrequencies = outboundHandlingTimeBucketFrequencies;
        this.transportActionStats = transportActionStats;
        assert (this.assertHistogramsConsistent());
    }

    public TransportStats(StreamInput in) throws IOException {
        int i;
        this.serverOpen = in.readVLong();
        this.totalOutboundConnections = in.readVLong();
        this.rxCount = in.readVLong();
        this.rxSize = in.readVLong();
        this.txCount = in.readVLong();
        this.txSize = in.readVLong();
        if (in.getTransportVersion().before(TransportVersions.TRANSPORT_STATS_HANDLING_TIME_REQUIRED_90)) {
            in.readBoolean();
        }
        this.inboundHandlingTimeBucketFrequencies = new long[HandlingTimeTracker.BUCKET_COUNT];
        for (i = 0; i < this.inboundHandlingTimeBucketFrequencies.length; ++i) {
            this.inboundHandlingTimeBucketFrequencies[i] = in.readVLong();
        }
        this.outboundHandlingTimeBucketFrequencies = new long[HandlingTimeTracker.BUCKET_COUNT];
        for (i = 0; i < this.inboundHandlingTimeBucketFrequencies.length; ++i) {
            this.outboundHandlingTimeBucketFrequencies[i] = in.readVLong();
        }
        this.transportActionStats = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? Collections.unmodifiableMap(in.readOrderedMap(StreamInput::readString, TransportActionStats::new)) : Map.of();
        assert (this.assertHistogramsConsistent());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.totalOutboundConnections);
        out.writeVLong(this.rxCount);
        out.writeVLong(this.rxSize);
        out.writeVLong(this.txCount);
        out.writeVLong(this.txSize);
        assert (this.inboundHandlingTimeBucketFrequencies.length == HandlingTimeTracker.BUCKET_COUNT);
        assert (this.outboundHandlingTimeBucketFrequencies.length == HandlingTimeTracker.BUCKET_COUNT);
        if (out.getTransportVersion().before(TransportVersions.TRANSPORT_STATS_HANDLING_TIME_REQUIRED_90)) {
            out.writeBoolean(true);
        }
        for (long handlingTimeBucketFrequency : this.inboundHandlingTimeBucketFrequencies) {
            out.writeVLong(handlingTimeBucketFrequency);
        }
        for (long handlingTimeBucketFrequency : this.outboundHandlingTimeBucketFrequencies) {
            out.writeVLong(handlingTimeBucketFrequency);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeMap(this.transportActionStats, StreamOutput::writeWriteable);
        }
    }

    public long serverOpen() {
        return this.serverOpen;
    }

    public long getServerOpen() {
        return this.serverOpen();
    }

    public long rxCount() {
        return this.rxCount;
    }

    public long getRxCount() {
        return this.rxCount();
    }

    public ByteSizeValue rxSize() {
        return ByteSizeValue.ofBytes(this.rxSize);
    }

    public ByteSizeValue getRxSize() {
        return this.rxSize();
    }

    public long txCount() {
        return this.txCount;
    }

    public long getTxCount() {
        return this.txCount();
    }

    public ByteSizeValue txSize() {
        return ByteSizeValue.ofBytes(this.txSize);
    }

    public ByteSizeValue getTxSize() {
        return this.txSize();
    }

    public long[] getInboundHandlingTimeBucketFrequencies() {
        return Arrays.copyOf(this.inboundHandlingTimeBucketFrequencies, this.inboundHandlingTimeBucketFrequencies.length);
    }

    public long[] getOutboundHandlingTimeBucketFrequencies() {
        return Arrays.copyOf(this.outboundHandlingTimeBucketFrequencies, this.outboundHandlingTimeBucketFrequencies.length);
    }

    public Map<String, TransportActionStats> getTransportActionStats() {
        return this.transportActionStats;
    }

    private boolean assertHistogramsConsistent() {
        assert (this.inboundHandlingTimeBucketFrequencies.length == this.outboundHandlingTimeBucketFrequencies.length);
        assert (this.inboundHandlingTimeBucketFrequencies.length == HandlingTimeTracker.BUCKET_COUNT);
        return true;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject("transport");
            builder.field("server_open", this.serverOpen);
            builder.field("total_outbound_connections", this.totalOutboundConnections);
            builder.field("rx_count", this.rxCount);
            builder.humanReadableField("rx_size_in_bytes", "rx_size", (Object)ByteSizeValue.ofBytes(this.rxSize));
            builder.field("tx_count", this.txCount);
            builder.humanReadableField("tx_size_in_bytes", "tx_size", (Object)ByteSizeValue.ofBytes(this.txSize));
            assert (this.inboundHandlingTimeBucketFrequencies.length > 0);
            TransportStats.histogramToXContent(builder, this.inboundHandlingTimeBucketFrequencies, "inbound_handling_time_histogram");
            TransportStats.histogramToXContent(builder, this.outboundHandlingTimeBucketFrequencies, "outbound_handling_time_histogram");
            builder.startObject("actions");
            return builder;
        }), Iterators.map(this.transportActionStats.entrySet().iterator(), entry -> (builder, params) -> {
            builder.field((String)entry.getKey());
            ((TransportActionStats)entry.getValue()).toXContent(builder, params);
            return builder;
        }), Iterators.single((builder, params) -> builder.endObject().endObject()));
    }

    static void histogramToXContent(XContentBuilder builder, long[] bucketFrequencies, String fieldName) throws IOException {
        int i;
        int[] bucketBounds = HandlingTimeTracker.getBucketUpperBounds();
        int firstBucket = 0;
        long remainingCount = 0L;
        for (i = 0; i < bucketFrequencies.length; ++i) {
            if (remainingCount == 0L) {
                firstBucket = i;
            }
            remainingCount += bucketFrequencies[i];
        }
        assert (bucketFrequencies.length == bucketBounds.length + 1);
        builder.startArray(fieldName);
        for (i = firstBucket; i < bucketFrequencies.length && 0L < remainingCount; remainingCount -= bucketFrequencies[i], ++i) {
            builder.startObject();
            if (i > 0 && i <= bucketBounds.length) {
                builder.humanReadableField("ge_millis", "ge", (Object)TimeValue.timeValueMillis((long)bucketBounds[i - 1]));
            }
            if (i < bucketBounds.length) {
                builder.humanReadableField("lt_millis", "lt", (Object)TimeValue.timeValueMillis((long)bucketBounds[i]));
            }
            builder.field("count", bucketFrequencies[i]);
            builder.endObject();
        }
        builder.endArray();
    }

    static final class Fields {
        static final String TRANSPORT = "transport";
        static final String SERVER_OPEN = "server_open";
        static final String TOTAL_OUTBOUND_CONNECTIONS = "total_outbound_connections";
        static final String RX_COUNT = "rx_count";
        static final String RX_SIZE = "rx_size";
        static final String RX_SIZE_IN_BYTES = "rx_size_in_bytes";
        static final String TX_COUNT = "tx_count";
        static final String TX_SIZE = "tx_size";
        static final String TX_SIZE_IN_BYTES = "tx_size_in_bytes";
        static final String INBOUND_HANDLING_TIME_HISTOGRAM = "inbound_handling_time_histogram";
        static final String OUTBOUND_HANDLING_TIME_HISTOGRAM = "outbound_handling_time_histogram";
        static final String ACTIONS = "actions";

        Fields() {
        }
    }
}

