/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.IOFunction;
import org.elasticsearch.common.CheckedIntFunction;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;

public final class SourceConfirmedTextQuery
extends Query {
    private static final Similarity FREQ_SIMILARITY = new Similarity(){

        public long computeNorm(FieldInvertState state) {
            return 1L;
        }

        public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
            return new Similarity.SimScorer(this){

                public float score(float freq, long norm) {
                    return freq;
                }
            };
        }
    };
    private final Query in;
    private final IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> valueFetcherProvider;
    private final Analyzer indexAnalyzer;

    public static Query approximate(Query query) {
        if (query instanceof TermQuery) {
            return query;
        }
        if (query instanceof PhraseQuery) {
            return SourceConfirmedTextQuery.approximate((PhraseQuery)query);
        }
        if (query instanceof MultiPhraseQuery) {
            return SourceConfirmedTextQuery.approximate((MultiPhraseQuery)query);
        }
        if (query instanceof MultiPhrasePrefixQuery) {
            return SourceConfirmedTextQuery.approximate((MultiPhrasePrefixQuery)query);
        }
        return new MatchAllDocsQuery();
    }

    private static Query approximate(PhraseQuery query) {
        BooleanQuery.Builder approximation = new BooleanQuery.Builder();
        for (Term term : query.getTerms()) {
            approximation.add((Query)new TermQuery(term), BooleanClause.Occur.FILTER);
        }
        return approximation.build();
    }

    private static Query approximate(MultiPhraseQuery query) {
        BooleanQuery.Builder approximation = new BooleanQuery.Builder();
        for (Term[] termArray : query.getTermArrays()) {
            BooleanQuery.Builder approximationClause = new BooleanQuery.Builder();
            for (Term term : termArray) {
                approximationClause.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            approximation.add((Query)approximationClause.build(), BooleanClause.Occur.FILTER);
        }
        return approximation.build();
    }

    private static Query approximate(MultiPhrasePrefixQuery query) {
        Term[][] terms = query.getTerms();
        if (terms.length == 0) {
            return new MatchNoDocsQuery();
        }
        if (terms.length == 1) {
            BooleanQuery.Builder approximation = new BooleanQuery.Builder();
            for (Term term : terms[0]) {
                approximation.add((Query)new PrefixQuery(term), BooleanClause.Occur.FILTER);
            }
            return approximation.build();
        }
        BooleanQuery.Builder approximation = new BooleanQuery.Builder();
        for (int i = 0; i < terms.length - 1; ++i) {
            Term[] termArray = terms[i];
            BooleanQuery.Builder approximationClause = new BooleanQuery.Builder();
            for (Term term : termArray) {
                approximationClause.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            approximation.add((Query)approximationClause.build(), BooleanClause.Occur.FILTER);
        }
        return approximation.build();
    }

    public SourceConfirmedTextQuery(Query in, IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> valueFetcherProvider, Analyzer indexAnalyzer) {
        this.in = in;
        this.valueFetcherProvider = valueFetcherProvider;
        this.indexAnalyzer = indexAnalyzer;
    }

    public Query getQuery() {
        return this.in;
    }

    public String toString(String field) {
        return this.in.toString(field);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        SourceConfirmedTextQuery that = (SourceConfirmedTextQuery)((Object)obj);
        return Objects.equals(this.in, that.in) && Objects.equals(this.valueFetcherProvider, that.valueFetcherProvider) && Objects.equals(this.indexAnalyzer, that.indexAnalyzer);
    }

    public int hashCode() {
        return 31 * Objects.hash(this.in, this.valueFetcherProvider, this.indexAnalyzer) + this.classHash();
    }

    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query inRewritten = this.in.rewrite(searcher);
        if (inRewritten != this.in) {
            return new SourceConfirmedTextQuery(inRewritten, this.valueFetcherProvider, this.indexAnalyzer);
        }
        if (this.in instanceof ConstantScoreQuery) {
            Query sub = ((ConstantScoreQuery)this.in).getQuery();
            return new ConstantScoreQuery((Query)new SourceConfirmedTextQuery(sub, this.valueFetcherProvider, this.indexAnalyzer));
        }
        if (this.in instanceof BoostQuery) {
            Query sub = ((BoostQuery)this.in).getQuery();
            float boost = ((BoostQuery)this.in).getBoost();
            return new BoostQuery((Query)new SourceConfirmedTextQuery(sub, this.valueFetcherProvider, this.indexAnalyzer), boost);
        }
        if (this.in instanceof MatchNoDocsQuery) {
            return this.in;
        }
        return super.rewrite(searcher);
    }

    public Weight createWeight(final IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Weight approximationWeight;
        Similarity.SimScorer simScorer;
        if (!scoreMode.needsScores() && this.in instanceof TermQuery) {
            return this.in.createWeight(searcher, scoreMode, boost);
        }
        LinkedHashSet terms = new LinkedHashSet();
        this.in.visit(QueryVisitor.termCollector(terms));
        if (terms.isEmpty()) {
            throw new IllegalStateException("Query " + String.valueOf(this.in) + " doesn't have any term");
        }
        final String field = ((Term)terms.iterator().next()).field();
        CollectionStatistics collectionStatistics = searcher.collectionStatistics(field);
        if (collectionStatistics == null) {
            simScorer = null;
            approximationWeight = null;
        } else {
            HashMap<Term, TermStates> termStates = new HashMap<Term, TermStates>();
            ArrayList<TermStatistics> termStats = new ArrayList<TermStatistics>();
            for (Term term : terms) {
                TermStates ts = termStates.computeIfAbsent(term, t -> {
                    try {
                        return TermStates.build((IndexSearcher)searcher, (Term)t, (boolean)scoreMode.needsScores());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                if (scoreMode.needsScores()) {
                    if (ts.docFreq() <= 0) continue;
                    termStats.add(searcher.termStatistics(term, ts.docFreq(), ts.totalTermFreq()));
                    continue;
                }
                termStats.add(new TermStatistics(term.bytes(), 1L, 1L));
            }
            if (termStats.size() > 0) {
                simScorer = searcher.getSimilarity().scorer(boost, collectionStatistics, (TermStatistics[])termStats.toArray(TermStatistics[]::new));
                approximationWeight = searcher.createWeight(SourceConfirmedTextQuery.approximate(this.in), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            } else {
                simScorer = null;
                approximationWeight = null;
            }
        }
        return new Weight(this){

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                NumericDocValues norms = context.reader().getNormValues(field);
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return Explanation.noMatch((String)"No matching phrase", (Explanation[])new Explanation[0]);
                }
                RuntimePhraseScorer scorer = (RuntimePhraseScorer)scorerSupplier.get(0L);
                if (scorer == null) {
                    return Explanation.noMatch((String)"No matching phrase", (Explanation[])new Explanation[0]);
                }
                TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
                if (twoPhase.approximation().advance(doc) != doc || !scorer.twoPhaseIterator().matches()) {
                    return Explanation.noMatch((String)"No matching phrase", (Explanation[])new Explanation[0]);
                }
                float phraseFreq = scorer.freq();
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(phraseFreq), (String)("phraseFreq=" + phraseFreq), (Explanation[])new Explanation[0]);
                assert (simScorer != null);
                Explanation scoreExplanation = simScorer.explain(freqExplanation, SourceConfirmedTextQuery.getNormValue(norms, doc));
                return Explanation.match((Number)scoreExplanation.getValue(), (String)("weight(" + String.valueOf(this.getQuery()) + " in " + doc + ") [" + searcher.getSimilarity().getClass().getSimpleName() + "], result of:"), (Explanation[])new Explanation[]{scoreExplanation});
            }

            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                ScorerSupplier approximationSupplier;
                ScorerSupplier scorerSupplier = approximationSupplier = approximationWeight != null ? approximationWeight.scorerSupplier(context) : null;
                if (approximationSupplier == null) {
                    return null;
                }
                return new ScorerSupplier(){

                    public Scorer get(long leadCost) throws IOException {
                        Scorer approximationScorer = approximationSupplier.get(leadCost);
                        DocIdSetIterator approximation = approximationScorer.iterator();
                        CheckedIntFunction valueFetcher = (CheckedIntFunction)SourceConfirmedTextQuery.this.valueFetcherProvider.apply((Object)context);
                        NumericDocValues norms = context.reader().getNormValues(field);
                        return new RuntimePhraseScorer(approximation, simScorer, norms, (CheckedIntFunction<List<Object>, IOException>)valueFetcher, field, SourceConfirmedTextQuery.this.in);
                    }

                    public long cost() {
                        return approximationSupplier.cost();
                    }
                };
            }

            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                Terms terms = context.reader().terms(field);
                if (terms == null) {
                    return null;
                }
                if (terms.hasOffsets()) {
                    Weight innerWeight = SourceConfirmedTextQuery.this.in.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                    return innerWeight.matches(context, doc);
                }
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                RuntimePhraseScorer scorer = (RuntimePhraseScorer)scorerSupplier.get(0L);
                if (scorer == null) {
                    return null;
                }
                TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
                if (twoPhase.approximation().advance(doc) != doc || !scorer.twoPhaseIterator().matches()) {
                    return null;
                }
                return scorer.matches();
            }
        };
    }

    private static long getNormValue(NumericDocValues norms, int doc) throws IOException {
        if (norms != null) {
            boolean found = norms.advanceExact(doc);
            assert (found);
            return norms.longValue();
        }
        return 1L;
    }

    private static class MemoryIndexEntry {
        private int docID = -1;
        private MemoryIndex memoryIndex;

        private MemoryIndexEntry() {
        }
    }

    private class RuntimePhraseScorer
    extends Scorer {
        private final Similarity.SimScorer scorer;
        private final CheckedIntFunction<List<Object>, IOException> valueFetcher;
        private final String field;
        private final Query query;
        private final TwoPhaseIterator twoPhase;
        private final NumericDocValues norms;
        private final MemoryIndexEntry cacheEntry = new MemoryIndexEntry();
        private int doc = -1;
        private float freq;

        private RuntimePhraseScorer(DocIdSetIterator approximation, Similarity.SimScorer scorer, NumericDocValues norms, CheckedIntFunction<List<Object>, IOException> valueFetcher, String field, Query query) {
            this.scorer = scorer;
            this.norms = norms;
            this.valueFetcher = valueFetcher;
            this.field = field;
            this.query = query;
            this.twoPhase = new TwoPhaseIterator(approximation){

                public boolean matches() throws IOException {
                    return RuntimePhraseScorer.this.freq() > 0.0f;
                }

                public float matchCost() {
                    return 10000.0f;
                }
            };
        }

        public DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator());
        }

        public TwoPhaseIterator twoPhaseIterator() {
            return this.twoPhase;
        }

        public float getMaxScore(int upTo) throws IOException {
            return this.scorer.score(Float.MAX_VALUE, 1L);
        }

        public float score() throws IOException {
            return this.scorer.score(this.freq(), SourceConfirmedTextQuery.getNormValue(this.norms, this.doc));
        }

        public int docID() {
            return this.twoPhase.approximation().docID();
        }

        private float freq() throws IOException {
            if (this.doc != this.docID()) {
                this.doc = this.docID();
                this.freq = this.computeFreq();
            }
            return this.freq;
        }

        private MemoryIndex getOrCreateMemoryIndex() throws IOException {
            if (this.cacheEntry.docID != this.docID()) {
                this.cacheEntry.docID = this.docID();
                this.cacheEntry.memoryIndex = new MemoryIndex(true, false);
                this.cacheEntry.memoryIndex.setSimilarity(FREQ_SIMILARITY);
                List values = (List)this.valueFetcher.apply(this.docID());
                for (Object value : values) {
                    if (value == null) continue;
                    this.cacheEntry.memoryIndex.addField(this.field, value.toString(), SourceConfirmedTextQuery.this.indexAnalyzer);
                }
            }
            return this.cacheEntry.memoryIndex;
        }

        private float computeFreq() throws IOException {
            return this.getOrCreateMemoryIndex().search(this.query);
        }

        private Matches matches() throws IOException {
            IndexSearcher searcher = this.getOrCreateMemoryIndex().createSearcher();
            Weight w = searcher.createWeight(searcher.rewrite(this.query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            return w.matches((LeafReaderContext)searcher.getLeafContexts().get(0), 0);
        }
    }
}

