/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.api;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.net.ContentHandlerFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImplFactory;
import java.net.FileNameMap;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ResponseCache;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketImplFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.security.KeyStore;
import java.security.Provider;
import java.security.cert.CertStoreParameters;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.logging.FileHandler;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import jdk.nio.Channels;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;

@SuppressForbidden(reason="Explicitly checking APIs that are forbidden")
public class ElasticsearchEntitlementChecker
implements EntitlementChecker {
    private final PolicyManager policyManager;
    private static final Set<String> NETWORK_PROTOCOLS = Set.of("http", "https", "ftp", "mailto");
    private static final List<String> ADDITIONAL_NETWORK_URL_CONNECT_CLASS_NAMES = List.of("sun.net.www.protocol.ftp.FtpURLConnection", "sun.net.www.protocol.mailto.MailToURLConnection");

    public ElasticsearchEntitlementChecker(PolicyManager policyManager) {
        this.policyManager = policyManager;
    }

    public void check$java_lang_Runtime$exit(Class<?> callerClass, Runtime runtime, int status) {
        this.policyManager.checkExitVM(callerClass);
    }

    public void check$java_lang_Runtime$halt(Class<?> callerClass, Runtime runtime, int status) {
        this.policyManager.checkExitVM(callerClass);
    }

    public void check$java_lang_System$$exit(Class<?> callerClass, int status) {
        this.policyManager.checkExitVM(callerClass);
    }

    public void check$java_lang_ClassLoader$(Class<?> callerClass) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_lang_ClassLoader$(Class<?> callerClass, ClassLoader parent) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_lang_ClassLoader$(Class<?> callerClass, String name, ClassLoader parent) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_net_URLClassLoader$(Class<?> callerClass, URL[] urls) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_net_URLClassLoader$(Class<?> callerClass, URL[] urls, ClassLoader parent) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_net_URLClassLoader$(Class<?> callerClass, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_net_URLClassLoader$(Class<?> callerClass, String name, URL[] urls, ClassLoader parent) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_net_URLClassLoader$(Class<?> callerClass, String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_security_SecureClassLoader$(Class<?> callerClass) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_security_SecureClassLoader$(Class<?> callerClass, ClassLoader parent) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$java_security_SecureClassLoader$(Class<?> callerClass, String name, ClassLoader parent) {
        this.policyManager.checkCreateClassLoader(callerClass);
    }

    public void check$javax_net_ssl_HttpsURLConnection$setSSLSocketFactory(Class<?> callerClass, HttpsURLConnection connection, SSLSocketFactory sf) {
        this.policyManager.checkSetHttpsConnectionProperties(callerClass);
    }

    public void check$javax_net_ssl_HttpsURLConnection$$setDefaultSSLSocketFactory(Class<?> callerClass, SSLSocketFactory sf) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$javax_net_ssl_HttpsURLConnection$$setDefaultHostnameVerifier(Class<?> callerClass, HostnameVerifier hv) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$javax_net_ssl_SSLContext$$setDefault(Class<?> callerClass, SSLContext context) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_lang_ProcessBuilder$start(Class<?> callerClass, ProcessBuilder processBuilder) {
        this.policyManager.checkStartProcess(callerClass);
    }

    public void check$java_lang_ProcessBuilder$$startPipeline(Class<?> callerClass, List<ProcessBuilder> builders) {
        this.policyManager.checkStartProcess(callerClass);
    }

    public void check$java_lang_System$$clearProperty(Class<?> callerClass, String key) {
        this.policyManager.checkWriteProperty(callerClass, key);
    }

    public void check$java_lang_System$$setProperties(Class<?> callerClass, Properties props) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_lang_System$$setProperty(Class<?> callerClass, String key, String value) {
        this.policyManager.checkWriteProperty(callerClass, key);
    }

    public void check$java_lang_System$$setIn(Class<?> callerClass, InputStream in) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_lang_System$$setOut(Class<?> callerClass, PrintStream out) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_lang_System$$setErr(Class<?> callerClass, PrintStream err) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_lang_Runtime$addShutdownHook(Class<?> callerClass, Runtime runtime, Thread hook) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_lang_Runtime$removeShutdownHook(Class<?> callerClass, Runtime runtime, Thread hook) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$jdk_tools_jlink_internal_Jlink$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$jdk_tools_jlink_internal_Main$$run(Class<?> callerClass, PrintWriter out, PrintWriter err, String ... args) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$jdk_vm_ci_services_JVMCIServiceLocator$$getProviders(Class<?> callerClass, Class<?> service) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$jdk_vm_ci_services_Services$$load(Class<?> callerClass, Class<?> service) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$jdk_vm_ci_services_Services$$loadSingle(Class<?> callerClass, Class<?> service, boolean required) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_nio_charset_spi_CharsetProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$com_sun_tools_jdi_VirtualMachineManagerImpl$$virtualMachineManager(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_lang_Thread$$setDefaultUncaughtExceptionHandler(Class<?> callerClass, Thread.UncaughtExceptionHandler ueh) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_spi_LocaleServiceProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_text_spi_BreakIteratorProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_text_spi_CollatorProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_text_spi_DateFormatProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_text_spi_DateFormatSymbolsProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_text_spi_DecimalFormatSymbolsProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_text_spi_NumberFormatProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_spi_CalendarDataProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_spi_CalendarNameProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_spi_CurrencyNameProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_spi_LocaleNameProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_spi_TimeZoneNameProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_logging_LogManager$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_Locale$$setDefault(Class<?> callerClass, Locale.Category category, Locale locale) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_Locale$$setDefault(Class<?> callerClass, Locale locale) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_TimeZone$$setDefault(Class<?> callerClass, TimeZone zone) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_DatagramSocket$$setDatagramSocketImplFactory(Class<?> callerClass, DatagramSocketImplFactory fac) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_HttpURLConnection$$setFollowRedirects(Class<?> callerClass, boolean set) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_ServerSocket$$setSocketFactory(Class<?> callerClass, SocketImplFactory fac) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_Socket$$setSocketImplFactory(Class<?> callerClass, SocketImplFactory fac) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_URL$$setURLStreamHandlerFactory(Class<?> callerClass, URLStreamHandlerFactory fac) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_URLConnection$$setFileNameMap(Class<?> callerClass, FileNameMap map) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_URLConnection$$setContentHandlerFactory(Class<?> callerClass, ContentHandlerFactory fac) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_net_ProxySelector$$setDefault(Class<?> callerClass, ProxySelector ps) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_net_ResponseCache$$setDefault(Class<?> callerClass, ResponseCache rc) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_net_spi_InetAddressResolverProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_net_spi_URLStreamHandlerProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_net_URL$(Class<?> callerClass, String protocol, String host, int port, String file, URLStreamHandler handler) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_net_URL$(Class<?> callerClass, URL context, String spec, URLStreamHandler handler) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_net_DatagramSocket$bind(Class<?> callerClass, DatagramSocket that, SocketAddress addr) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_DatagramSocket$connect(Class<?> callerClass, DatagramSocket that, InetAddress addr) {
        this.policyManager.checkAllNetworkAccess(callerClass);
    }

    public void check$java_net_DatagramSocket$connect(Class<?> callerClass, DatagramSocket that, SocketAddress addr) {
        this.policyManager.checkAllNetworkAccess(callerClass);
    }

    public void check$java_net_DatagramSocket$send(Class<?> callerClass, DatagramSocket that, DatagramPacket p) {
        if (p.getAddress().isMulticastAddress()) {
            this.policyManager.checkAllNetworkAccess(callerClass);
        } else {
            this.policyManager.checkOutboundNetworkAccess(callerClass);
        }
    }

    public void check$java_net_DatagramSocket$receive(Class<?> callerClass, DatagramSocket that, DatagramPacket p) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_DatagramSocket$joinGroup(Class<?> caller, DatagramSocket that, SocketAddress addr, NetworkInterface ni) {
        this.policyManager.checkAllNetworkAccess(caller);
    }

    public void check$java_net_DatagramSocket$leaveGroup(Class<?> caller, DatagramSocket that, SocketAddress addr, NetworkInterface ni) {
        this.policyManager.checkAllNetworkAccess(caller);
    }

    public void check$java_net_MulticastSocket$joinGroup(Class<?> caller, MulticastSocket that, InetAddress addr) {
        this.policyManager.checkAllNetworkAccess(caller);
    }

    public void check$java_net_MulticastSocket$joinGroup(Class<?> caller, MulticastSocket that, SocketAddress addr, NetworkInterface ni) {
        this.policyManager.checkAllNetworkAccess(caller);
    }

    public void check$java_net_MulticastSocket$leaveGroup(Class<?> caller, MulticastSocket that, InetAddress addr) {
        this.policyManager.checkAllNetworkAccess(caller);
    }

    public void check$java_net_MulticastSocket$leaveGroup(Class<?> caller, MulticastSocket that, SocketAddress addr, NetworkInterface ni) {
        this.policyManager.checkAllNetworkAccess(caller);
    }

    public void check$java_net_MulticastSocket$send(Class<?> callerClass, MulticastSocket that, DatagramPacket p, byte ttl) {
        this.policyManager.checkAllNetworkAccess(callerClass);
    }

    public void check$java_net_ServerSocket$(Class<?> callerClass, int port) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_ServerSocket$(Class<?> callerClass, int port, int backlog) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_ServerSocket$(Class<?> callerClass, int port, int backlog, InetAddress bindAddr) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_ServerSocket$accept(Class<?> callerClass, ServerSocket that) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_ServerSocket$implAccept(Class<?> callerClass, ServerSocket that, Socket s) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_ServerSocket$bind(Class<?> callerClass, ServerSocket that, SocketAddress endpoint) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_ServerSocket$bind(Class<?> callerClass, ServerSocket that, SocketAddress endpoint, int backlog) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$(Class<?> callerClass, Proxy proxy) {
        if (proxy.type() == Proxy.Type.SOCKS || proxy.type() == Proxy.Type.HTTP) {
            this.policyManager.checkOutboundNetworkAccess(callerClass);
        }
    }

    public void check$java_net_Socket$(Class<?> callerClass, String host, int port) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$(Class<?> callerClass, InetAddress address, int port) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$(Class<?> callerClass, String host, int port, InetAddress localAddr, int localPort) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$(Class<?> callerClass, InetAddress address, int port, InetAddress localAddr, int localPort) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$(Class<?> callerClass, String host, int port, boolean stream) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$(Class<?> callerClass, InetAddress host, int port, boolean stream) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$bind(Class<?> callerClass, Socket that, SocketAddress endpoint) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$connect(Class<?> callerClass, Socket that, SocketAddress endpoint) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_Socket$connect(Class<?> callerClass, Socket that, SocketAddress endpoint, int backlog) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    private URL extractJarFileUrl(URL jarUrl) {
        String spec = jarUrl.getFile();
        int separator = spec.indexOf("!/");
        if (separator == -1) {
            return null;
        }
        try {
            return new URL(spec.substring(0, separator));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private boolean handleNetworkOrFileUrlCheck(Class<?> callerClass, URL url) {
        if (ElasticsearchEntitlementChecker.isNetworkUrl(url)) {
            this.policyManager.checkOutboundNetworkAccess(callerClass);
            return true;
        }
        if (ElasticsearchEntitlementChecker.isFileUrl(url)) {
            this.checkURLFileRead(callerClass, url);
            return true;
        }
        return false;
    }

    private void checkJarURLAccess(Class<?> callerClass, JarURLConnection that) {
        URL jarFileUrl = that.getJarFileURL();
        if (this.handleNetworkOrFileUrlCheck(callerClass, jarFileUrl)) {
            return;
        }
        this.policyManager.checkUnsupportedURLProtocolConnection(callerClass, jarFileUrl.getProtocol());
    }

    private void checkEntitlementForUrl(Class<?> callerClass, URL that) {
        if (this.handleNetworkOrFileUrlCheck(callerClass, that)) {
            return;
        }
        if (ElasticsearchEntitlementChecker.isJarUrl(that)) {
            URL jarFileUrl = this.extractJarFileUrl(that);
            if (jarFileUrl == null || !this.handleNetworkOrFileUrlCheck(callerClass, jarFileUrl)) {
                this.policyManager.checkUnsupportedURLProtocolConnection(callerClass, "jar with unsupported inner protocol");
            }
        } else {
            this.policyManager.checkUnsupportedURLProtocolConnection(callerClass, that.getProtocol());
        }
    }

    public void check$java_net_URL$openConnection(Class<?> callerClass, URL that) {
        this.checkEntitlementForUrl(callerClass, that);
    }

    public void check$java_net_URL$openConnection(Class<?> callerClass, URL that, Proxy proxy) {
        if (proxy.type() != Proxy.Type.DIRECT) {
            this.policyManager.checkOutboundNetworkAccess(callerClass);
        }
        this.checkEntitlementForUrl(callerClass, that);
    }

    public void check$java_net_URL$openStream(Class<?> callerClass, URL that) {
        this.checkEntitlementForUrl(callerClass, that);
    }

    public void check$java_net_URL$getContent(Class<?> callerClass, URL that) {
        this.checkEntitlementForUrl(callerClass, that);
    }

    public void check$java_net_URL$getContent(Class<?> callerClass, URL that, Class<?>[] classes) {
        this.checkEntitlementForUrl(callerClass, that);
    }

    private static boolean isNetworkUrl(URL url) {
        return NETWORK_PROTOCOLS.contains(url.getProtocol());
    }

    private static boolean isFileUrl(URL url) {
        return "file".equals(url.getProtocol());
    }

    private static boolean isJarUrl(URL url) {
        return "jar".equals(url.getProtocol());
    }

    private static boolean isNetworkUrlConnection(URLConnection urlConnection) {
        Class<?> connectionClass = urlConnection.getClass();
        return HttpURLConnection.class.isAssignableFrom(connectionClass) || ADDITIONAL_NETWORK_URL_CONNECT_CLASS_NAMES.contains(connectionClass.getName());
    }

    private static boolean isFileUrlConnection(URLConnection urlConnection) {
        Class<?> connectionClass = urlConnection.getClass();
        return "sun.net.www.protocol.file.FileURLConnection".equals(connectionClass.getName());
    }

    private void checkEntitlementForURLConnection(Class<?> callerClass, URLConnection that) {
        if (ElasticsearchEntitlementChecker.isNetworkUrlConnection(that)) {
            this.policyManager.checkOutboundNetworkAccess(callerClass);
        } else if (ElasticsearchEntitlementChecker.isFileUrlConnection(that)) {
            this.checkURLFileRead(callerClass, that.getURL());
        } else if (that instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)that;
            this.checkJarURLAccess(callerClass, jarURLConnection);
        } else {
            this.policyManager.checkUnsupportedURLProtocolConnection(callerClass, that.getURL().getProtocol());
        }
    }

    public void check$java_net_URLConnection$getContentLength(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getContentLengthLong(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getContentType(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getContentEncoding(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getExpiration(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getDate(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getLastModified(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getHeaderFieldInt(Class<?> callerClass, URLConnection that, String name, int defaultValue) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getHeaderFieldLong(Class<?> callerClass, URLConnection that, String name, long defaultValue) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getHeaderFieldDate(Class<?> callerClass, URLConnection that, String name, long defaultValue) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getContent(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_URLConnection$getContent(Class<?> callerClass, URLConnection that, Class<?>[] classes) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$java_net_HttpURLConnection$getResponseCode(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_HttpURLConnection$getResponseMessage(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$java_net_HttpURLConnection$getHeaderFieldDate(Class<?> callerClass, HttpURLConnection that, String name, long defaultValue) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_URLConnection$getHeaderField(Class<?> callerClass, URLConnection that, String name) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$sun_net_www_URLConnection$getHeaderFields(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$sun_net_www_URLConnection$getHeaderFieldKey(Class<?> callerClass, URLConnection that, int n) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$sun_net_www_URLConnection$getHeaderField(Class<?> callerClass, URLConnection that, int n) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$sun_net_www_URLConnection$getContentType(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$sun_net_www_URLConnection$getContentLength(Class<?> callerClass, URLConnection that) {
        this.checkEntitlementForURLConnection(callerClass, that);
    }

    public void check$sun_net_www_protocol_ftp_FtpURLConnection$connect(Class<?> callerClass, URLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_ftp_FtpURLConnection$getInputStream(Class<?> callerClass, URLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_ftp_FtpURLConnection$getOutputStream(Class<?> callerClass, URLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$$openConnectionCheckRedirects(Class<?> callerClass, URLConnection c) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$connect(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$getOutputStream(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$getInputStream(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$getErrorStream(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$getHeaderField(Class<?> callerClass, HttpURLConnection that, String name) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$getHeaderFields(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$getHeaderField(Class<?> callerClass, HttpURLConnection that, int n) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_http_HttpURLConnection$getHeaderFieldKey(Class<?> callerClass, HttpURLConnection that, int n) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$connect(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getOutputStream(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getInputStream(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getErrorStream(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getHeaderField(Class<?> callerClass, HttpsURLConnection that, String name) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getHeaderFields(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getHeaderField(Class<?> callerClass, HttpsURLConnection that, int n) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getHeaderFieldKey(Class<?> callerClass, HttpsURLConnection that, int n) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getResponseCode(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getResponseMessage(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getContentLength(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getContentLengthLong(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getContentType(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getContentEncoding(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getExpiration(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getDate(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getLastModified(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getHeaderFieldInt(Class<?> callerClass, HttpsURLConnection that, String name, int defaultValue) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getHeaderFieldLong(Class<?> callerClass, HttpsURLConnection that, String name, long defaultValue) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getHeaderFieldDate(Class<?> callerClass, HttpsURLConnection that, String name, long defaultValue) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getContent(Class<?> callerClass, HttpsURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_HttpsURLConnectionImpl$getContent(Class<?> callerClass, HttpsURLConnection that, Class<?>[] classes) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_https_AbstractDelegateHttpsURLConnection$connect(Class<?> callerClass, HttpURLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_mailto_MailToURLConnection$connect(Class<?> callerClass, URLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_net_www_protocol_mailto_MailToURLConnection$getOutputStream(Class<?> callerClass, URLConnection that) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$jdk_internal_net_http_HttpClientImpl$send(Class<?> callerClass, HttpClient that, HttpRequest request, HttpResponse.BodyHandler<?> responseBodyHandler) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$jdk_internal_net_http_HttpClientImpl$sendAsync(Class<?> callerClass, HttpClient that, HttpRequest userRequest, HttpResponse.BodyHandler<?> responseHandler) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$jdk_internal_net_http_HttpClientImpl$sendAsync(Class<?> callerClass, HttpClient that, HttpRequest userRequest, HttpResponse.BodyHandler<?> responseHandler, HttpResponse.PushPromiseHandler<?> pushPromiseHandler) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$jdk_internal_net_http_HttpClientFacade$send(Class<?> callerClass, HttpClient that, HttpRequest request, HttpResponse.BodyHandler<?> responseBodyHandler) {
        this.check$jdk_internal_net_http_HttpClientImpl$send(callerClass, that, request, responseBodyHandler);
    }

    public void check$jdk_internal_net_http_HttpClientFacade$sendAsync(Class<?> callerClass, HttpClient that, HttpRequest userRequest, HttpResponse.BodyHandler<?> responseHandler) {
        this.check$jdk_internal_net_http_HttpClientImpl$sendAsync(callerClass, that, userRequest, responseHandler);
    }

    public void check$jdk_internal_net_http_HttpClientFacade$sendAsync(Class<?> callerClass, HttpClient that, HttpRequest userRequest, HttpResponse.BodyHandler<?> responseHandler, HttpResponse.PushPromiseHandler<?> pushPromiseHandler) {
        this.check$jdk_internal_net_http_HttpClientImpl$sendAsync(callerClass, that, userRequest, responseHandler, pushPromiseHandler);
    }

    public void check$java_security_cert_CertStore$$getInstance(Class<?> callerClass, String type, CertStoreParameters params) {
        if ("LDAP".equals(type)) {
            this.policyManager.checkOutboundNetworkAccess(callerClass);
        }
    }

    public void check$java_nio_channels_AsynchronousServerSocketChannel$bind(Class<?> callerClass, AsynchronousServerSocketChannel that, SocketAddress local) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_AsynchronousServerSocketChannelImpl$bind(Class<?> callerClass, AsynchronousServerSocketChannel that, SocketAddress local, int backlog) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_AsynchronousSocketChannelImpl$bind(Class<?> callerClass, AsynchronousSocketChannel that, SocketAddress local) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_DatagramChannelImpl$bind(Class<?> callerClass, DatagramChannel that, SocketAddress local) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_nio_channels_ServerSocketChannel$bind(Class<?> callerClass, ServerSocketChannel that, SocketAddress local) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_ServerSocketChannelImpl$bind(Class<?> callerClass, ServerSocketChannel that, SocketAddress local, int backlog) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_SocketChannelImpl$bind(Class<?> callerClass, SocketChannel that, SocketAddress local) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_SocketChannelImpl$connect(Class<?> callerClass, SocketChannel that, SocketAddress remote) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_AsynchronousSocketChannelImpl$connect(Class<?> callerClass, AsynchronousSocketChannel that, SocketAddress remote) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_AsynchronousSocketChannelImpl$connect(Class<?> callerClass, AsynchronousSocketChannel that, SocketAddress remote, Object attachment, CompletionHandler<Void, Object> handler) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_DatagramChannelImpl$connect(Class<?> callerClass, DatagramChannel that, SocketAddress remote) {
        this.policyManager.checkOutboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_ServerSocketChannelImpl$accept(Class<?> callerClass, ServerSocketChannel that) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_AsynchronousServerSocketChannelImpl$accept(Class<?> callerClass, AsynchronousServerSocketChannel that) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_AsynchronousServerSocketChannelImpl$accept(Class<?> callerClass, AsynchronousServerSocketChannel that, Object attachment, CompletionHandler<AsynchronousSocketChannel, Object> handler) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$sun_nio_ch_DatagramChannelImpl$send(Class<?> callerClass, DatagramChannel that, ByteBuffer src, SocketAddress target) {
        InetSocketAddress isa;
        if (target instanceof InetSocketAddress && (isa = (InetSocketAddress)target).getAddress().isMulticastAddress()) {
            this.policyManager.checkAllNetworkAccess(callerClass);
        } else {
            this.policyManager.checkOutboundNetworkAccess(callerClass);
        }
    }

    public void check$sun_nio_ch_DatagramChannelImpl$receive(Class<?> callerClass, DatagramChannel that, ByteBuffer dst) {
        this.policyManager.checkInboundNetworkAccess(callerClass);
    }

    public void check$java_nio_channels_spi_SelectorProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_nio_channels_spi_AsynchronousChannelProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void checkSelectorProviderInheritedChannel(Class<?> callerClass, SelectorProvider that) {
        this.policyManager.checkChangeNetworkHandling(callerClass);
    }

    public void check$java_lang_Runtime$load(Class<?> callerClass, Runtime that, String filename) {
        this.policyManager.checkFileRead(callerClass, Path.of(filename, new String[0]));
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$java_lang_Runtime$loadLibrary(Class<?> callerClass, Runtime that, String libname) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$java_lang_System$$load(Class<?> callerClass, String filename) {
        this.policyManager.checkFileRead(callerClass, Path.of(filename, new String[0]));
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$java_lang_System$$loadLibrary(Class<?> callerClass, String libname) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$jdk_internal_foreign_layout_ValueLayouts$OfAddressImpl$withTargetLayout(Class<?> callerClass, AddressLayout that, MemoryLayout memoryLayout) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$jdk_internal_foreign_abi_AbstractLinker$downcallHandle(Class<?> callerClass, Linker that, FunctionDescriptor function, Linker.Option ... options) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$jdk_internal_foreign_abi_AbstractLinker$downcallHandle(Class<?> callerClass, Linker that, MemorySegment address, FunctionDescriptor function, Linker.Option ... options) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$jdk_internal_foreign_abi_AbstractLinker$upcallStub(Class<?> callerClass, Linker that, MethodHandle target, FunctionDescriptor function, Arena arena, Linker.Option ... options) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$jdk_internal_foreign_AbstractMemorySegmentImpl$reinterpret(Class<?> callerClass, MemorySegment that, long newSize) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$jdk_internal_foreign_AbstractMemorySegmentImpl$reinterpret(Class<?> callerClass, MemorySegment that, long newSize, Arena arena, Consumer<MemorySegment> cleanup) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$jdk_internal_foreign_AbstractMemorySegmentImpl$reinterpret(Class<?> callerClass, MemorySegment that, Arena arena, Consumer<MemorySegment> cleanup) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$java_lang_foreign_SymbolLookup$$libraryLookup(Class<?> callerClass, String name, Arena arena) {
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$java_lang_foreign_SymbolLookup$$libraryLookup(Class<?> callerClass, Path path, Arena arena) {
        this.policyManager.checkFileRead(callerClass, path);
        this.policyManager.checkLoadingNativeLibraries(callerClass);
    }

    public void check$java_lang_ModuleLayer$Controller$enableNativeAccess(Class<?> callerClass, ModuleLayer.Controller that, Module target) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_io_File$canExecute(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$canRead(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$canWrite(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$createNewFile(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$$createTempFile(Class<?> callerClass, String prefix, String suffix, File directory) {
        this.policyManager.checkFileWrite(callerClass, directory);
    }

    public void check$java_io_File$delete(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$deleteOnExit(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$exists(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$isDirectory(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$isFile(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$isHidden(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$lastModified(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$length(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$list(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$list(Class<?> callerClass, File file, FilenameFilter filter) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$listFiles(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$listFiles(Class<?> callerClass, File file, FileFilter filter) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$listFiles(Class<?> callerClass, File file, FilenameFilter filter) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_File$mkdir(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$mkdirs(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$renameTo(Class<?> callerClass, File file, File dest) {
        this.policyManager.checkFileRead(callerClass, file);
        this.policyManager.checkFileWrite(callerClass, dest);
    }

    public void check$java_io_File$setExecutable(Class<?> callerClass, File file, boolean executable) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$setExecutable(Class<?> callerClass, File file, boolean executable, boolean ownerOnly) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$setLastModified(Class<?> callerClass, File file, long time) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$setReadable(Class<?> callerClass, File file, boolean readable) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$setReadable(Class<?> callerClass, File file, boolean readable, boolean ownerOnly) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$setReadOnly(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$setWritable(Class<?> callerClass, File file, boolean writable) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_File$setWritable(Class<?> callerClass, File file, boolean writable, boolean ownerOnly) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_FileInputStream$(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_FileInputStream$(Class<?> callerClass, FileDescriptor fd) {
        this.policyManager.checkFileDescriptorRead(callerClass);
    }

    public void check$java_io_FileInputStream$(Class<?> callerClass, String name) {
        this.policyManager.checkFileRead(callerClass, new File(name));
    }

    public void check$java_io_FileOutputStream$(Class<?> callerClass, String name) {
        this.policyManager.checkFileWrite(callerClass, new File(name));
    }

    public void check$java_io_FileOutputStream$(Class<?> callerClass, String name, boolean append) {
        this.policyManager.checkFileWrite(callerClass, new File(name));
    }

    public void check$java_io_FileOutputStream$(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_FileOutputStream$(Class<?> callerClass, File file, boolean append) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_FileOutputStream$(Class<?> callerClass, FileDescriptor fd) {
        this.policyManager.checkFileDescriptorWrite(callerClass);
    }

    public void check$java_io_FileReader$(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_FileReader$(Class<?> callerClass, File file, Charset charset) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_io_FileReader$(Class<?> callerClass, FileDescriptor fd) {
        this.policyManager.checkFileDescriptorRead(callerClass);
    }

    public void check$java_io_FileReader$(Class<?> callerClass, String name) {
        this.policyManager.checkFileRead(callerClass, new File(name));
    }

    public void check$java_io_FileReader$(Class<?> callerClass, String name, Charset charset) {
        this.policyManager.checkFileRead(callerClass, new File(name));
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, File file) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, File file, boolean append) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, File file, Charset charset) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, File file, Charset charset, boolean append) {
        this.policyManager.checkFileWrite(callerClass, file);
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, FileDescriptor fd) {
        this.policyManager.checkFileDescriptorWrite(callerClass);
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, String name) {
        this.policyManager.checkFileWrite(callerClass, new File(name));
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, String name, boolean append) {
        this.policyManager.checkFileWrite(callerClass, new File(name));
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, String name, Charset charset) {
        this.policyManager.checkFileWrite(callerClass, new File(name));
    }

    public void check$java_io_FileWriter$(Class<?> callerClass, String name, Charset charset, boolean append) {
        this.policyManager.checkFileWrite(callerClass, new File(name));
    }

    public void check$java_io_RandomAccessFile$(Class<?> callerClass, String name, String mode) {
        if (mode.equals("r")) {
            this.policyManager.checkFileRead(callerClass, new File(name));
        } else {
            this.policyManager.checkFileWrite(callerClass, new File(name));
        }
    }

    public void check$java_io_RandomAccessFile$(Class<?> callerClass, File file, String mode) {
        if (mode.equals("r")) {
            this.policyManager.checkFileRead(callerClass, file);
        } else {
            this.policyManager.checkFileWrite(callerClass, file);
        }
    }

    public void check$java_security_KeyStore$$getInstance(Class<?> callerClass, File file, char[] password) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_security_KeyStore$$getInstance(Class<?> callerClass, File file, KeyStore.LoadStoreParameter param) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_security_KeyStore$Builder$$newInstance(Class<?> callerClass, File file, KeyStore.ProtectionParameter protection) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_security_KeyStore$Builder$$newInstance(Class<?> callerClass, String type, Provider provider, File file, KeyStore.ProtectionParameter protection) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_util_Scanner$(Class<?> callerClass, File source) {
        this.policyManager.checkFileRead(callerClass, source);
    }

    public void check$java_util_Scanner$(Class<?> callerClass, File source, String charsetName) {
        this.policyManager.checkFileRead(callerClass, source);
    }

    public void check$java_util_Scanner$(Class<?> callerClass, File source, Charset charset) {
        this.policyManager.checkFileRead(callerClass, source);
    }

    public void check$java_util_jar_JarFile$(Class<?> callerClass, String name) {
        this.policyManager.checkFileRead(callerClass, new File(name));
    }

    public void check$java_util_jar_JarFile$(Class<?> callerClass, String name, boolean verify) {
        this.policyManager.checkFileRead(callerClass, new File(name));
    }

    public void check$java_util_jar_JarFile$(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_util_jar_JarFile$(Class<?> callerClass, File file, boolean verify) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_util_jar_JarFile$(Class<?> callerClass, File file, boolean verify, int mode) {
        this.policyManager.checkFileWithZipMode(callerClass, file, mode);
    }

    public void check$java_util_jar_JarFile$(Class<?> callerClass, File file, boolean verify, int mode, Runtime.Version version) {
        this.policyManager.checkFileWithZipMode(callerClass, file, mode);
    }

    public void check$java_util_zip_ZipFile$(Class<?> callerClass, String name) {
        this.policyManager.checkFileRead(callerClass, new File(name));
    }

    public void check$java_util_zip_ZipFile$(Class<?> callerClass, String name, Charset charset) {
        this.policyManager.checkFileRead(callerClass, new File(name));
    }

    public void check$java_util_zip_ZipFile$(Class<?> callerClass, File file) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_util_zip_ZipFile$(Class<?> callerClass, File file, int mode) {
        this.policyManager.checkFileWithZipMode(callerClass, file, mode);
    }

    public void check$java_util_zip_ZipFile$(Class<?> callerClass, File file, Charset charset) {
        this.policyManager.checkFileRead(callerClass, file);
    }

    public void check$java_util_zip_ZipFile$(Class<?> callerClass, File file, int mode, Charset charset) {
        this.policyManager.checkFileWithZipMode(callerClass, file, mode);
    }

    public void check$java_nio_channels_FileChannel$(Class<?> callerClass) {
        this.policyManager.checkChangeFilesHandling(callerClass);
    }

    public void check$java_nio_channels_FileChannel$$open(Class<?> callerClass, Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void check$java_nio_channels_FileChannel$$open(Class<?> callerClass, Path path, OpenOption ... options) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void check$java_nio_channels_AsynchronousFileChannel$(Class<?> callerClass) {
        this.policyManager.checkChangeFilesHandling(callerClass);
    }

    public void check$java_nio_channels_AsynchronousFileChannel$$open(Class<?> callerClass, Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void check$java_nio_channels_AsynchronousFileChannel$$open(Class<?> callerClass, Path path, OpenOption ... options) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void check$jdk_nio_Channels$$readWriteSelectableChannel(Class<?> callerClass, FileDescriptor fd, Channels.SelectableChannelCloser closer) {
        this.policyManager.checkFileDescriptorWrite(callerClass);
    }

    public void check$java_nio_file_Files$$getOwner(Class<?> callerClass, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$probeContentType(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$setOwner(Class<?> callerClass, Path path, UserPrincipal principal) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$newInputStream(Class<?> callerClass, Path path, OpenOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$newOutputStream(Class<?> callerClass, Path path, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$newByteChannel(Class<?> callerClass, Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void check$java_nio_file_Files$$newByteChannel(Class<?> callerClass, Path path, OpenOption ... options) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void check$java_nio_file_Files$$newDirectoryStream(Class<?> callerClass, Path dir) {
        this.policyManager.checkFileRead(callerClass, dir);
    }

    public void check$java_nio_file_Files$$newDirectoryStream(Class<?> callerClass, Path dir, String glob) {
        this.policyManager.checkFileRead(callerClass, dir);
    }

    public void check$java_nio_file_Files$$newDirectoryStream(Class<?> callerClass, Path dir, DirectoryStream.Filter<? super Path> filter) {
        this.policyManager.checkFileRead(callerClass, dir);
    }

    public void check$java_nio_file_Files$$createFile(Class<?> callerClass, Path path, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$createDirectory(Class<?> callerClass, Path dir, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, dir);
    }

    public void check$java_nio_file_Files$$createDirectories(Class<?> callerClass, Path dir, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, dir);
    }

    public void check$java_nio_file_Files$$createTempFile(Class<?> callerClass, Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, dir);
    }

    public void check$java_nio_file_Files$$createTempFile(Class<?> callerClass, String prefix, String suffix, FileAttribute<?> ... attrs) {
        this.policyManager.checkCreateTempFile(callerClass);
    }

    public void check$java_nio_file_Files$$createTempDirectory(Class<?> callerClass, Path dir, String prefix, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, dir);
    }

    public void check$java_nio_file_Files$$createTempDirectory(Class<?> callerClass, String prefix, FileAttribute<?> ... attrs) {
        this.policyManager.checkCreateTempFile(callerClass);
    }

    private static Path resolveLinkTarget(Path path, Path target) {
        Path parent = path.getParent();
        return parent == null ? target : parent.resolve(target);
    }

    public void check$java_nio_file_Files$$createSymbolicLink(Class<?> callerClass, Path link, Path target, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, link);
        this.policyManager.checkFileRead(callerClass, ElasticsearchEntitlementChecker.resolveLinkTarget(link, target));
    }

    public void check$java_nio_file_Files$$createLink(Class<?> callerClass, Path link, Path existing) {
        this.policyManager.checkFileWrite(callerClass, link);
        this.policyManager.checkFileRead(callerClass, ElasticsearchEntitlementChecker.resolveLinkTarget(link, existing));
    }

    public void check$java_nio_file_Files$$delete(Class<?> callerClass, Path path) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$deleteIfExists(Class<?> callerClass, Path path) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$copy(Class<?> callerClass, Path source, Path target, CopyOption ... options) {
        this.policyManager.checkFileRead(callerClass, source);
        this.policyManager.checkFileWrite(callerClass, target);
    }

    public void check$java_nio_file_Files$$move(Class<?> callerClass, Path source, Path target, CopyOption ... options) {
        this.policyManager.checkFileWrite(callerClass, source);
        this.policyManager.checkFileWrite(callerClass, target);
    }

    public void check$java_nio_file_Files$$readSymbolicLink(Class<?> callerClass, Path link) {
        this.policyManager.checkFileRead(callerClass, link);
    }

    public void check$java_nio_file_Files$$getFileStore(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$isSameFile(Class<?> callerClass, Path path, Path path2) {
        this.policyManager.checkFileRead(callerClass, path);
        this.policyManager.checkFileRead(callerClass, path2);
    }

    public void check$java_nio_file_Files$$mismatch(Class<?> callerClass, Path path, Path path2) {
        this.policyManager.checkFileRead(callerClass, path);
        this.policyManager.checkFileRead(callerClass, path2);
    }

    public void check$java_nio_file_Files$$isHidden(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$getFileAttributeView(Class<?> callerClass, Path path, Class<? extends FileAttributeView> type, LinkOption ... options) {
        this.policyManager.checkGetFileAttributeView(callerClass);
    }

    public void check$java_nio_file_Files$$readAttributes(Class<?> callerClass, Path path, Class<? extends BasicFileAttributes> type, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$setAttribute(Class<?> callerClass, Path path, String attribute, Object value, LinkOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$getAttribute(Class<?> callerClass, Path path, String attribute, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$readAttributes(Class<?> callerClass, Path path, String attributes, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$getPosixFilePermissions(Class<?> callerClass, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$setPosixFilePermissions(Class<?> callerClass, Path path, Set<PosixFilePermission> perms) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$isSymbolicLink(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$isDirectory(Class<?> callerClass, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$isRegularFile(Class<?> callerClass, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$getLastModifiedTime(Class<?> callerClass, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$setLastModifiedTime(Class<?> callerClass, Path path, FileTime time) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$size(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$exists(Class<?> callerClass, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$notExists(Class<?> callerClass, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$isReadable(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$isWritable(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$isExecutable(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$walkFileTree(Class<?> callerClass, Path start, Set<FileVisitOption> options, int maxDepth, FileVisitor<? super Path> visitor) {
        this.policyManager.checkFileRead(callerClass, start);
    }

    public void check$java_nio_file_Files$$walkFileTree(Class<?> callerClass, Path start, FileVisitor<? super Path> visitor) {
        this.policyManager.checkFileRead(callerClass, start);
    }

    public void check$java_nio_file_Files$$newBufferedReader(Class<?> callerClass, Path path, Charset cs) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$newBufferedReader(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$newBufferedWriter(Class<?> callerClass, Path path, Charset cs, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$newBufferedWriter(Class<?> callerClass, Path path, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$copy(Class<?> callerClass, InputStream in, Path target, CopyOption ... options) {
        this.policyManager.checkFileWrite(callerClass, target);
    }

    public void check$java_nio_file_Files$$copy(Class<?> callerClass, Path source, OutputStream out) {
        this.policyManager.checkFileRead(callerClass, source);
    }

    public void check$java_nio_file_Files$$readAllBytes(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$readString(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$readString(Class<?> callerClass, Path path, Charset cs) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$readAllLines(Class<?> callerClass, Path path, Charset cs) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$readAllLines(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$write(Class<?> callerClass, Path path, byte[] bytes, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$write(Class<?> callerClass, Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$write(Class<?> callerClass, Path path, Iterable<? extends CharSequence> lines, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$writeString(Class<?> callerClass, Path path, CharSequence csq, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$writeString(Class<?> callerClass, Path path, CharSequence csq, Charset cs, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_nio_file_Files$$list(Class<?> callerClass, Path dir) {
        this.policyManager.checkFileRead(callerClass, dir);
    }

    public void check$java_nio_file_Files$$walk(Class<?> callerClass, Path start, int maxDepth, FileVisitOption ... options) {
        this.policyManager.checkFileRead(callerClass, start);
    }

    public void check$java_nio_file_Files$$walk(Class<?> callerClass, Path start, FileVisitOption ... options) {
        this.policyManager.checkFileRead(callerClass, start);
    }

    public void check$java_nio_file_Files$$find(Class<?> callerClass, Path start, int maxDepth, BiPredicate<Path, BasicFileAttributes> matcher, FileVisitOption ... options) {
        this.policyManager.checkFileRead(callerClass, start);
    }

    public void check$java_nio_file_Files$$lines(Class<?> callerClass, Path path, Charset cs) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_Files$$lines(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_nio_file_spi_FileSystemProvider$(Class<?> callerClass) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void check$java_util_logging_FileHandler$(Class<?> callerClass) {
        this.policyManager.checkLoggingFileHandler(callerClass);
    }

    public void check$java_util_logging_FileHandler$(Class<?> callerClass, String pattern) {
        this.policyManager.checkLoggingFileHandler(callerClass);
    }

    public void check$java_util_logging_FileHandler$(Class<?> callerClass, String pattern, boolean append) {
        this.policyManager.checkLoggingFileHandler(callerClass);
    }

    public void check$java_util_logging_FileHandler$(Class<?> callerClass, String pattern, int limit, int count) {
        this.policyManager.checkLoggingFileHandler(callerClass);
    }

    public void check$java_util_logging_FileHandler$(Class<?> callerClass, String pattern, int limit, int count, boolean append) {
        this.policyManager.checkLoggingFileHandler(callerClass);
    }

    public void check$java_util_logging_FileHandler$(Class<?> callerClass, String pattern, long limit, int count, boolean append) {
        this.policyManager.checkLoggingFileHandler(callerClass);
    }

    public void check$java_util_logging_FileHandler$close(Class<?> callerClass, FileHandler that) {
        this.policyManager.checkLoggingFileHandler(callerClass);
    }

    public void check$java_net_http_HttpRequest$BodyPublishers$$ofFile(Class<?> callerClass, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_net_http_HttpResponse$BodyHandlers$$ofFile(Class<?> callerClass, Path path) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_net_http_HttpResponse$BodyHandlers$$ofFile(Class<?> callerClass, Path path, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void check$java_net_http_HttpResponse$BodyHandlers$$ofFileDownload(Class<?> callerClass, Path directory, OpenOption ... openOptions) {
        this.policyManager.checkFileWrite(callerClass, directory);
    }

    public void check$java_net_http_HttpResponse$BodySubscribers$$ofFile(Class<?> callerClass, Path directory) {
        this.policyManager.checkFileWrite(callerClass, directory);
    }

    public void check$java_net_http_HttpResponse$BodySubscribers$$ofFile(Class<?> callerClass, Path directory, OpenOption ... openOptions) {
        this.policyManager.checkFileWrite(callerClass, directory);
    }

    public void checkNewFileSystem(Class<?> callerClass, FileSystemProvider that, URI uri, Map<String, ?> env) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void checkNewFileSystem(Class<?> callerClass, FileSystemProvider that, Path path, Map<String, ?> env) {
        this.policyManager.checkChangeJVMGlobalState(callerClass);
    }

    public void checkNewInputStream(Class<?> callerClass, FileSystemProvider that, Path path, OpenOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void checkNewOutputStream(Class<?> callerClass, FileSystemProvider that, Path path, OpenOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    private static boolean isOpenForWrite(Set<? extends OpenOption> options) {
        return options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND) || options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.DELETE_ON_CLOSE);
    }

    private static boolean isOpenForWrite(OpenOption ... options) {
        return Arrays.stream(options).anyMatch(o -> o.equals(StandardOpenOption.WRITE) || o.equals(StandardOpenOption.APPEND) || o.equals(StandardOpenOption.CREATE) || o.equals(StandardOpenOption.CREATE_NEW) || o.equals(StandardOpenOption.DELETE_ON_CLOSE));
    }

    public void checkNewFileChannel(Class<?> callerClass, FileSystemProvider that, Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void checkNewAsynchronousFileChannel(Class<?> callerClass, FileSystemProvider that, Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void checkNewByteChannel(Class<?> callerClass, FileSystemProvider that, Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        if (ElasticsearchEntitlementChecker.isOpenForWrite(options)) {
            this.policyManager.checkFileWrite(callerClass, path);
        } else {
            this.policyManager.checkFileRead(callerClass, path);
        }
    }

    public void checkNewDirectoryStream(Class<?> callerClass, FileSystemProvider that, Path dir, DirectoryStream.Filter<? super Path> filter) {
        this.policyManager.checkFileRead(callerClass, dir);
    }

    public void checkCreateDirectory(Class<?> callerClass, FileSystemProvider that, Path dir, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, dir);
    }

    public void checkCreateSymbolicLink(Class<?> callerClass, FileSystemProvider that, Path link, Path target, FileAttribute<?> ... attrs) {
        this.policyManager.checkFileWrite(callerClass, link);
        this.policyManager.checkFileRead(callerClass, ElasticsearchEntitlementChecker.resolveLinkTarget(link, target));
    }

    public void checkCreateLink(Class<?> callerClass, FileSystemProvider that, Path link, Path existing) {
        this.policyManager.checkFileWrite(callerClass, link);
        this.policyManager.checkFileRead(callerClass, ElasticsearchEntitlementChecker.resolveLinkTarget(link, existing));
    }

    public void checkDelete(Class<?> callerClass, FileSystemProvider that, Path path) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void checkDeleteIfExists(Class<?> callerClass, FileSystemProvider that, Path path) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void checkReadSymbolicLink(Class<?> callerClass, FileSystemProvider that, Path link) {
        this.policyManager.checkFileRead(callerClass, link);
    }

    public void checkCopy(Class<?> callerClass, FileSystemProvider that, Path source, Path target, CopyOption ... options) {
        this.policyManager.checkFileWrite(callerClass, target);
        this.policyManager.checkFileRead(callerClass, source);
    }

    public void checkMove(Class<?> callerClass, FileSystemProvider that, Path source, Path target, CopyOption ... options) {
        this.policyManager.checkFileWrite(callerClass, target);
        this.policyManager.checkFileWrite(callerClass, source);
    }

    public void checkIsSameFile(Class<?> callerClass, FileSystemProvider that, Path path, Path path2) {
        this.policyManager.checkFileRead(callerClass, path);
        this.policyManager.checkFileRead(callerClass, path2);
    }

    public void checkIsHidden(Class<?> callerClass, FileSystemProvider that, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void checkGetFileStore(Class<?> callerClass, FileSystemProvider that, Path path) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void checkCheckAccess(Class<?> callerClass, FileSystemProvider that, Path path, AccessMode ... modes) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void checkGetFileAttributeView(Class<?> callerClass, FileSystemProvider that, Path path, Class<?> type, LinkOption ... options) {
        this.policyManager.checkGetFileAttributeView(callerClass);
    }

    public void checkReadAttributes(Class<?> callerClass, FileSystemProvider that, Path path, Class<?> type, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void checkReadAttributes(Class<?> callerClass, FileSystemProvider that, Path path, String attributes, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void checkReadAttributesIfExists(Class<?> callerClass, FileSystemProvider that, Path path, Class<?> type, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void checkSetAttribute(Class<?> callerClass, FileSystemProvider that, Path path, String attribute, Object value, LinkOption ... options) {
        this.policyManager.checkFileWrite(callerClass, path);
    }

    public void checkExists(Class<?> callerClass, FileSystemProvider that, Path path, LinkOption ... options) {
        this.policyManager.checkFileRead(callerClass, path);
    }

    public void check$java_lang_Thread$start(Class<?> callerClass, Thread thread) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void check$java_lang_Thread$setDaemon(Class<?> callerClass, Thread thread, boolean on) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void check$java_lang_ThreadGroup$setDaemon(Class<?> callerClass, ThreadGroup threadGroup, boolean daemon) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void check$java_util_concurrent_ForkJoinPool$setParallelism(Class<?> callerClass, ForkJoinPool forkJoinPool, int size) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void check$java_lang_Thread$setName(Class<?> callerClass, Thread thread, String name) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void check$java_lang_Thread$setPriority(Class<?> callerClass, Thread thread, int newPriority) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void check$java_lang_Thread$setUncaughtExceptionHandler(Class<?> callerClass, Thread thread, Thread.UncaughtExceptionHandler ueh) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void check$java_lang_ThreadGroup$setMaxPriority(Class<?> callerClass, ThreadGroup threadGroup, int pri) {
        this.policyManager.checkManageThreadsEntitlement(callerClass);
    }

    public void checkGetFileStoreAttributeView(Class<?> callerClass, FileStore that, Class<?> type) {
        this.policyManager.checkWriteStoreAttributes(callerClass);
    }

    public void checkGetAttribute(Class<?> callerClass, FileStore that, String attribute) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkGetBlockSize(Class<?> callerClass, FileStore that) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkGetTotalSpace(Class<?> callerClass, FileStore that) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkGetUnallocatedSpace(Class<?> callerClass, FileStore that) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkGetUsableSpace(Class<?> callerClass, FileStore that) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkIsReadOnly(Class<?> callerClass, FileStore that) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkName(Class<?> callerClass, FileStore that) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkType(Class<?> callerClass, FileStore that) {
        this.policyManager.checkReadStoreAttributes(callerClass);
    }

    public void checkPathToRealPath(Class<?> callerClass, Path that, LinkOption ... options) throws NoSuchFileException {
        boolean followLinks = true;
        for (LinkOption option : options) {
            if (option != LinkOption.NOFOLLOW_LINKS) continue;
            followLinks = false;
        }
        this.policyManager.checkFileRead(callerClass, that, followLinks);
    }

    public void checkPathRegister(Class<?> callerClass, Path that, WatchService watcher, WatchEvent.Kind<?> ... events) {
        this.policyManager.checkFileRead(callerClass, that);
    }

    public void checkPathRegister(Class<?> callerClass, Path that, WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        this.policyManager.checkFileRead(callerClass, that);
    }

    private void checkURLFileRead(Class<?> callerClass, URL url) {
        try {
            this.policyManager.checkFileRead(callerClass, Paths.get(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$connect(Class<?> callerClass, URLConnection that) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getHeaderFields(Class<?> callerClass, URLConnection that) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getHeaderField(Class<?> callerClass, URLConnection that, String name) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getHeaderField(Class<?> callerClass, URLConnection that, int n) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getContentLength(Class<?> callerClass, URLConnection that) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getContentLengthLong(Class<?> callerClass, URLConnection that) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getHeaderFieldKey(Class<?> callerClass, URLConnection that, int n) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getLastModified(Class<?> callerClass, URLConnection that) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$sun_net_www_protocol_file_FileURLConnection$getInputStream(Class<?> callerClass, URLConnection that) {
        this.checkURLFileRead(callerClass, that.getURL());
    }

    public void check$java_net_JarURLConnection$getManifest(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$java_net_JarURLConnection$getJarEntry(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$java_net_JarURLConnection$getAttributes(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$java_net_JarURLConnection$getMainAttributes(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$java_net_JarURLConnection$getCertificates(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getJarFile(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getJarEntry(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$connect(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getInputStream(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getContentLength(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getContentLengthLong(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getContent(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getContentType(Class<?> callerClass, JarURLConnection that) {
        this.checkJarURLAccess(callerClass, that);
    }

    public void check$sun_net_www_protocol_jar_JarURLConnection$getHeaderField(Class<?> callerClass, JarURLConnection that, String name) {
        this.checkJarURLAccess(callerClass, that);
    }
}

