/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.blobcache.CachePopulationSource;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class BlobCacheMetrics {
    private static final Logger logger = LogManager.getLogger(BlobCacheMetrics.class);
    private static final double BYTES_PER_NANOSECONDS_TO_MEBIBYTES_PER_SECOND = 953.67431640625;
    public static final String CACHE_POPULATION_REASON_ATTRIBUTE_KEY = "reason";
    public static final String CACHE_POPULATION_SOURCE_ATTRIBUTE_KEY = "source";
    public static final String SHARD_ID_ATTRIBUTE_KEY = "shard_id";
    public static final String INDEX_ATTRIBUTE_KEY = "index_name";
    private final LongCounter cacheMissCounter;
    private final LongCounter evictedCountNonZeroFrequency;
    private final LongHistogram cacheMissLoadTimes;
    private final DoubleHistogram cachePopulationThroughput;
    private final LongCounter cachePopulationBytes;
    private final LongCounter cachePopulationTime;
    public static final BlobCacheMetrics NOOP = new BlobCacheMetrics(TelemetryProvider.NOOP.getMeterRegistry());

    public BlobCacheMetrics(MeterRegistry meterRegistry) {
        this(meterRegistry.registerLongCounter("es.blob_cache.miss_that_triggered_read.total", "The number of times there was a cache miss that triggered a read from the blob store", "count"), meterRegistry.registerLongCounter("es.blob_cache.count_of_evicted_used_regions.total", "The number of times a cache entry was evicted where the frequency was not zero", "entries"), meterRegistry.registerLongHistogram("es.blob_cache.cache_miss_load_times.histogram", "The time in milliseconds for populating entries in the blob store resulting from a cache miss, expressed as a histogram.", "ms"), meterRegistry.registerDoubleHistogram("es.blob_cache.population.throughput.histogram", "The throughput observed when populating the cache", "MiB/second"), meterRegistry.registerLongCounter("es.blob_cache.population.bytes.total", "The number of bytes that have been copied into the cache", "bytes"), meterRegistry.registerLongCounter("es.blob_cache.population.time.total", "The time spent copying data into the cache", "milliseconds"));
    }

    BlobCacheMetrics(LongCounter cacheMissCounter, LongCounter evictedCountNonZeroFrequency, LongHistogram cacheMissLoadTimes, DoubleHistogram cachePopulationThroughput, LongCounter cachePopulationBytes, LongCounter cachePopulationTime) {
        this.cacheMissCounter = cacheMissCounter;
        this.evictedCountNonZeroFrequency = evictedCountNonZeroFrequency;
        this.cacheMissLoadTimes = cacheMissLoadTimes;
        this.cachePopulationThroughput = cachePopulationThroughput;
        this.cachePopulationBytes = cachePopulationBytes;
        this.cachePopulationTime = cachePopulationTime;
    }

    public LongCounter getCacheMissCounter() {
        return this.cacheMissCounter;
    }

    public LongCounter getEvictedCountNonZeroFrequency() {
        return this.evictedCountNonZeroFrequency;
    }

    public LongHistogram getCacheMissLoadTimes() {
        return this.cacheMissLoadTimes;
    }

    public void recordCachePopulationMetrics(int bytesCopied, long copyTimeNanos, CachePopulationReason cachePopulationReason, CachePopulationSource cachePopulationSource) {
        Map<String, String> metricAttributes = Map.of(CACHE_POPULATION_REASON_ATTRIBUTE_KEY, cachePopulationReason.name(), CACHE_POPULATION_SOURCE_ATTRIBUTE_KEY, cachePopulationSource.name());
        assert (bytesCopied > 0) : "We shouldn't be recording zero-sized copies";
        this.cachePopulationBytes.incrementBy((long)bytesCopied, metricAttributes);
        if (copyTimeNanos > 0L) {
            this.cachePopulationThroughput.record(this.toMebibytesPerSecond(bytesCopied, copyTimeNanos), metricAttributes);
            this.cachePopulationTime.incrementBy(TimeUnit.NANOSECONDS.toMillis(copyTimeNanos), metricAttributes);
        } else {
            logger.warn("Zero-time copy being reported, ignoring");
        }
    }

    private double toMebibytesPerSecond(int numberOfBytes, long timeInNanoseconds) {
        return (double)numberOfBytes / (double)timeInNanoseconds * 953.67431640625;
    }

    public static enum CachePopulationReason {
        Warming,
        CacheMiss;

    }
}

