/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.common;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.LongConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Nullable;

class ProgressListenableActionFuture
extends PlainActionFuture<Long> {
    private static final Logger logger = LogManager.getLogger(ProgressListenableActionFuture.class);
    final long start;
    final long end;
    @Nullable
    private final LongConsumer progressConsumer;
    private List<PositionAndListener> listeners;
    private long progress;
    private volatile boolean completed;

    ProgressListenableActionFuture(long start, long end, @Nullable LongConsumer progressConsumer) {
        this.start = start;
        this.end = end;
        this.progress = start;
        this.completed = false;
        this.progressConsumer = progressConsumer;
        assert (this.invariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invariant() {
        assert (this.start < this.end) : this.start + " < " + this.end;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (!this.completed || this.listeners == null);
            assert (this.start <= this.progress) : this.start + " <= " + this.progress;
            assert (this.progress <= this.end) : this.progress + " <= " + this.end;
            assert (this.listeners == null || this.listeners.stream().allMatch(listener -> this.progress < listener.position()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(long progressValue) {
        this.ensureNotCompleted();
        if (progressValue <= this.start) {
            assert (false) : progressValue + " <= " + this.start;
            throw new IllegalArgumentException("Cannot update progress with a value less than [start=" + this.start + "]");
        }
        if (this.end < progressValue) {
            assert (false) : this.end + " < " + progressValue;
            throw new IllegalArgumentException("Cannot update progress with a value greater than [end=" + this.end + "]");
        }
        if (progressValue == this.end) {
            return;
        }
        ArrayList<ActionListener<Long>> listenersToExecute = null;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (this.progress < progressValue) : this.progress + " < " + progressValue;
            this.progress = progressValue;
            List<PositionAndListener> listenersCopy = this.listeners;
            if (listenersCopy != null) {
                ArrayList<PositionAndListener> listenersToKeep = null;
                for (PositionAndListener listener2 : listenersCopy) {
                    if (progressValue < listener2.position()) {
                        if (listenersToKeep == null) {
                            listenersToKeep = new ArrayList<PositionAndListener>();
                        }
                        listenersToKeep.add(listener2);
                        continue;
                    }
                    if (listenersToExecute == null) {
                        listenersToExecute = new ArrayList<ActionListener<Long>>();
                    }
                    listenersToExecute.add(listener2.listener());
                }
                this.listeners = listenersToKeep;
            }
        }
        if (listenersToExecute != null) {
            if (this.progressConsumer != null) {
                ProgressListenableActionFuture.safeAcceptProgress(this.progressConsumer, progressValue);
            }
            listenersToExecute.forEach(listener -> ProgressListenableActionFuture.executeListener((ActionListener<Long>)listener, () -> progressValue));
        }
        assert (this.invariant());
    }

    public void onResponse(Long result) {
        if (result == null || this.end != result) {
            assert (false) : result + " != " + this.end;
            throw new IllegalArgumentException("Invalid completion value [start=" + this.start + ",end=" + this.end + ",response=" + result + "]");
        }
        this.ensureNotCompleted();
        super.onResponse((Object)result);
    }

    public void onFailure(Exception e) {
        this.ensureNotCompleted();
        super.onFailure(e);
    }

    private void ensureNotCompleted() {
        if (this.completed) {
            throw new IllegalStateException("Future is already completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done(boolean success) {
        List<PositionAndListener> listenersToExecute;
        super.done(success);
        assert (this.invariant());
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            assert (!this.completed);
            this.completed = true;
            assert (this.listeners == null || this.listeners.stream().allMatch(l -> this.progress < l.position() && l.position() <= this.end));
            listenersToExecute = this.listeners;
            this.listeners = null;
        }
        if (listenersToExecute != null) {
            listenersToExecute.forEach(listener -> ProgressListenableActionFuture.executeListener(listener.listener(), this::actionResult));
        }
        assert (this.invariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<Long> listener, long value) {
        long progressValue;
        boolean executeImmediate = false;
        ProgressListenableActionFuture progressListenableActionFuture = this;
        synchronized (progressListenableActionFuture) {
            progressValue = this.progress;
            if (this.completed || value <= progressValue) {
                executeImmediate = true;
            } else {
                List<PositionAndListener> listenersCopy = this.listeners;
                if (listenersCopy == null) {
                    listenersCopy = new ArrayList<PositionAndListener>();
                }
                listenersCopy.add(new PositionAndListener(value, listener));
                this.listeners = listenersCopy;
            }
        }
        if (executeImmediate) {
            ProgressListenableActionFuture.executeListener(listener, this.completed ? this::actionResult : () -> progressValue);
        }
        assert (this.invariant());
    }

    private Long actionResult() throws Exception {
        try {
            return (Long)this.result();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception exCause = (Exception)throwable;
                throw exCause;
            }
            throw e;
        }
    }

    private static void executeListener(ActionListener<Long> listener, CheckedSupplier<Long, ?> result) {
        try {
            listener.onResponse((Object)((Long)result.get()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static void safeAcceptProgress(LongConsumer consumer, long progress) {
        assert (consumer != null);
        try {
            consumer.accept(progress);
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn("Failed to consume progress value", (Throwable)e);
        }
    }

    public synchronized String toString() {
        return "ProgressListenableActionFuture[start=" + this.start + ", end=" + this.end + ", progress=" + this.progress + ", completed=" + this.completed + ", listeners=" + (this.listeners != null ? this.listeners.size() : 0) + "]";
    }

    private record PositionAndListener(long position, ActionListener<Long> listener) {
    }
}

