/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.tree.Source;

public class NestedQuery
extends Query {
    private static long COUNTER = 0L;
    private static final int MAX_INNER_HITS = 99;
    private static final List<String> NO_STORED_FIELD = Collections.singletonList("_none_");
    private final String path;
    private final Map<String, Map.Entry<Boolean, String>> fields;
    private final Query child;

    public NestedQuery(Source source, String path, Query child) {
        this(source, path, Collections.emptyMap(), child);
    }

    public NestedQuery(Source source, String path, Map<String, Map.Entry<Boolean, String>> fields, Query child) {
        super(source);
        if (path == null) {
            throw new IllegalArgumentException("path is required");
        }
        if (fields == null) {
            throw new IllegalArgumentException("fields is required");
        }
        if (child == null) {
            throw new IllegalArgumentException("child is required");
        }
        this.path = path;
        this.fields = fields;
        this.child = child;
    }

    @Override
    public boolean containsNestedField(String otherPath, String field) {
        boolean iContainThisField = this.path.equals(otherPath) && this.fields.containsKey(field);
        boolean myChildContainsThisField = this.child.containsNestedField(otherPath, field);
        return iContainThisField || myChildContainsThisField;
    }

    @Override
    public Query addNestedField(String otherPath, String field, String format, boolean hasDocValues) {
        if (!this.path.equals(otherPath)) {
            Query rewrittenChild = this.child.addNestedField(otherPath, field, format, hasDocValues);
            if (rewrittenChild == this.child) {
                return this;
            }
            return new NestedQuery(this.source(), otherPath, this.fields, rewrittenChild);
        }
        if (this.fields.containsKey(field)) {
            return this;
        }
        Map newFields = Maps.newMapWithExpectedSize((int)(this.fields.size() + 1));
        newFields.putAll(this.fields);
        newFields.put(field, new AbstractMap.SimpleImmutableEntry<Boolean, String>(hasDocValues, format));
        return new NestedQuery(this.source(), otherPath, Collections.unmodifiableMap(newFields), this.child);
    }

    @Override
    public void enrichNestedSort(NestedSortBuilder sort) {
        this.child.enrichNestedSort(sort);
        if (!sort.getPath().equals(this.path)) {
            return;
        }
        QueryBuilder childAsBuilder = this.child.asBuilder();
        if (sort.getFilter() != null && !sort.getFilter().equals((Object)childAsBuilder)) {
            return;
        }
        sort.setFilter(childAsBuilder);
    }

    @Override
    public QueryBuilder asBuilder() {
        NestedQueryBuilder query = QueryBuilders.nestedQuery((String)this.path, (QueryBuilder)this.child.asBuilder(), (ScoreMode)ScoreMode.None);
        if (!this.fields.isEmpty()) {
            InnerHitBuilder ihb = new InnerHitBuilder();
            ihb.setSize(0);
            ihb.setSize(99);
            ihb.setName(this.path + "_" + COUNTER++);
            for (Map.Entry<String, Map.Entry<Boolean, String>> entry : this.fields.entrySet()) {
                if (entry.getValue().getKey().booleanValue()) {
                    ihb.addFetchField(entry.getKey(), entry.getValue().getValue());
                    continue;
                }
                ihb.addFetchField(entry.getKey());
            }
            ihb.setFetchSourceContext(FetchSourceContext.DO_NOT_FETCH_SOURCE);
            ihb.setStoredFieldNames(NO_STORED_FIELD);
            query.innerHit(ihb);
        }
        return query;
    }

    String path() {
        return this.path;
    }

    Map<String, Map.Entry<Boolean, String>> fields() {
        return this.fields;
    }

    Query child() {
        return this.child;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path, this.fields, this.child);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NestedQuery other = (NestedQuery)obj;
        return this.path.equals(other.path) && this.fields.equals(other.fields) && this.child.equals(other.child);
    }

    @Override
    protected String innerToString() {
        return this.path + "." + String.valueOf(this.fields) + "[" + String.valueOf(this.child) + "]";
    }
}

