/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;

public class TransportUnfollowAction
extends AcknowledgedTransportMasterNodeAction<UnfollowAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportUnfollowAction.class);
    private final Client client;
    private final Executor remoteClientResponseExecutor;

    @Inject
    public TransportUnfollowAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("indices:admin/xpack/ccr/unfollow", transportService, clusterService, threadPool, actionFilters, UnfollowAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = Objects.requireNonNull(client);
        this.remoteClientResponseExecutor = threadPool.executor("ccr");
    }

    protected void masterOperation(Task task, final UnfollowAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("unfollow_action", new ClusterStateUpdateTask(request.masterNodeTimeout()){

            public ClusterState execute(ClusterState current) {
                String followerIndex = request.getFollowerIndex();
                return TransportUnfollowAction.unfollow(followerIndex, current);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                RemoteClusterClient remoteClient;
                final IndexMetadata indexMetadata = oldState.metadata().index(request.getFollowerIndex());
                Map ccrCustomMetadata = indexMetadata.getCustomData("ccr");
                String remoteClusterName = (String)ccrCustomMetadata.get("remote_cluster_name");
                String leaderIndexName = (String)ccrCustomMetadata.get("leader_index_name");
                String leaderIndexUuid = (String)ccrCustomMetadata.get("leader_index_uuid");
                Index leaderIndex = new Index(leaderIndexName, leaderIndexUuid);
                final String retentionLeaseId = CcrRetentionLeases.retentionLeaseId(oldState.getClusterName().value(), indexMetadata.getIndex(), remoteClusterName, leaderIndex);
                int numberOfShards = (Integer)IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(indexMetadata.getSettings());
                try {
                    remoteClient = TransportUnfollowAction.this.client.getRemoteClusterClient(remoteClusterName, TransportUnfollowAction.this.remoteClientResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED);
                }
                catch (Exception e2) {
                    this.onLeaseRemovalFailure(indexMetadata.getIndex(), retentionLeaseId, e2);
                    return;
                }
                GroupedActionListener groupListener = new GroupedActionListener(numberOfShards, (ActionListener)new ActionListener<Collection<ActionResponse.Empty>>(){

                    public void onResponse(Collection<ActionResponse.Empty> responses) {
                        logger.trace("[{}] removed retention lease [{}] on all leader primary shards", (Object)indexMetadata.getIndex(), (Object)retentionLeaseId);
                        listener.onResponse((Object)AcknowledgedResponse.TRUE);
                    }

                    public void onFailure(Exception e) {
                        this.onLeaseRemovalFailure(indexMetadata.getIndex(), retentionLeaseId, e);
                    }
                });
                for (int i = 0; i < numberOfShards; ++i) {
                    ShardId followerShardId = new ShardId(indexMetadata.getIndex(), i);
                    ShardId leaderShardId = new ShardId(leaderIndex, i);
                    this.removeRetentionLeaseForShard(followerShardId, leaderShardId, retentionLeaseId, remoteClient, (ActionListener<ActionResponse.Empty>)ActionListener.wrap(arg_0 -> ((GroupedActionListener)groupListener).onResponse(arg_0), e -> 1.handleException(followerShardId, retentionLeaseId, leaderShardId, (ActionListener<ActionResponse.Empty>)groupListener, e)));
                }
            }

            private void onLeaseRemovalFailure(Index index, String retentionLeaseId, Exception e) {
                logger.warn(() -> Strings.format((String)"[%s] failure while removing retention lease [%s] on leader primary shards", (Object[])new Object[]{index, retentionLeaseId}), (Throwable)e);
                ElasticsearchException wrapper = new ElasticsearchException((Throwable)e);
                wrapper.addMetadata("es.failed_to_remove_retention_leases", new String[]{retentionLeaseId});
                listener.onFailure((Exception)wrapper);
            }

            private void removeRetentionLeaseForShard(ShardId followerShardId, ShardId leaderShardId, String retentionLeaseId, RemoteClusterClient remoteClient, ActionListener<ActionResponse.Empty> listener2) {
                logger.trace("{} removing retention lease [{}] while unfollowing leader index", (Object)followerShardId, (Object)retentionLeaseId);
                ThreadContext threadContext = TransportUnfollowAction.this.threadPool.getThreadContext();
                ContextPreservingActionListener preservedListener = new ContextPreservingActionListener(threadContext.newRestorableContext(true), listener2);
                try (ThreadContext.StoredContext ignore = TransportUnfollowAction.this.threadPool.getThreadContext().newEmptySystemContext();){
                    CcrRetentionLeases.asyncRemoveRetentionLease(leaderShardId, retentionLeaseId, remoteClient, (ActionListener<ActionResponse.Empty>)preservedListener);
                }
            }

            private static void handleException(ShardId followerShardId, String retentionLeaseId, ShardId leaderShardId, ActionListener<ActionResponse.Empty> listener2, Exception e) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                assert (!(cause instanceof ElasticsearchSecurityException)) : e;
                if (cause instanceof RetentionLeaseNotFoundException) {
                    logger.trace(() -> Strings.format((String)"%s retention lease [%s] not found on %s while unfollowing", (Object[])new Object[]{followerShardId, retentionLeaseId, leaderShardId}), (Throwable)e);
                    listener2.onResponse((Object)ActionResponse.Empty.INSTANCE);
                } else {
                    logger.warn(() -> Strings.format((String)"%s failed to remove retention lease [%s] on %s while unfollowing", (Object[])new Object[]{followerShardId, retentionLeaseId, leaderShardId}), (Throwable)e);
                    listener2.onFailure(e);
                }
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(UnfollowAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static ClusterState unfollow(String followerIndex, ClusterState current) {
        IndexMetadata followerIMD = current.metadata().index(followerIndex);
        if (followerIMD == null) {
            throw new IndexNotFoundException(followerIndex);
        }
        if (followerIMD.getCustomData("ccr") == null) {
            throw new IllegalArgumentException("index [" + followerIndex + "] is not a follower index");
        }
        if (followerIMD.getState() != IndexMetadata.State.CLOSE) {
            throw new IllegalArgumentException("cannot convert the follower index [" + followerIndex + "] to a non-follower, because it has not been closed");
        }
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)current.metadata().custom("persistent_tasks");
        if (persistentTasks != null) {
            for (PersistentTasksCustomMetadata.PersistentTask persistentTask : persistentTasks.tasks()) {
                ShardFollowTask shardFollowTask;
                if (!persistentTask.getTaskName().equals("xpack/ccr/shard_follow_task") || !(shardFollowTask = (ShardFollowTask)persistentTask.getParams()).getFollowShardId().getIndexName().equals(followerIndex)) continue;
                throw new IllegalArgumentException("cannot convert the follower index [" + followerIndex + "] to a non-follower, because it has not been paused");
            }
        }
        Settings.Builder builder = Settings.builder();
        builder.put(followerIMD.getSettings());
        builder.remove(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey());
        IndexMetadata.Builder newIndexMetadata = IndexMetadata.builder((IndexMetadata)followerIMD);
        newIndexMetadata.settings(builder);
        newIndexMetadata.settingsVersion(followerIMD.getSettingsVersion() + 1L);
        newIndexMetadata.removeCustom("ccr");
        return current.copyAndUpdateMetadata(metadata -> metadata.put(newIndexMetadata));
    }
}

