/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XPSPageContentHandler
extends DefaultHandler {
    private static final String GLYPHS = "Glyphs";
    private static final String CANVAS = "Canvas";
    private static final String CLIP = "Clip";
    private static final String NULL_CLIP = "NULL_CLIP";
    private static final String VISUAL_BRUSH = "VisualBrush";
    private static final String TRANSFORM = "Transform";
    private static final String UNICODE_STRING = "UnicodeString";
    private static final String ORIGIN_X = "OriginX";
    private static final String ORIGIN_Y = "OriginY";
    private static final String BIDI_LEVEL = "BidiLevel";
    private static final String INDICES = "Indices";
    private static final String NAME = "Name";
    private static final String FONT_RENDERING_EM_SIZE = "FontRenderingEmSize";
    private static final String FONT_URI = "FontUri";
    private static final String PATH = "Path";
    private static final String NAVIGATE_URI = "FixedPage.NavigateUri";
    private static final String IMAGE_SOURCE = "ImageSource";
    private static final String IMAGE_BRUSH = "ImageBrush";
    private static final String AUTOMATION_PROPERITES_HELP_TEXT = "AutomationProperties.HelpText";
    private static final String URL_DIV = "urls";
    private static final String DIV = "div";
    private static final String CLASS = "class";
    private static final String PAGE = "page";
    private static final String CANVAS_SAX = "canvas";
    private static final String P = "p";
    private static final String HREF = "href";
    private static final String A = "a";
    private static final char[] SPACE = new char[]{' '};
    private static final float ESTIMATE_GLYPH_WIDTH = 0.5f;
    private static final float WHITESPACE_THRESHOLD = 0.3f;
    private static final float SPLIT_THRESHOLD = 1.0f;
    private static final float ROW_COMBINE_THRESHOLD = 0.5f;
    private static Comparator<? super List<GlyphRun>> ROW_SORTER = (o1, o2) -> {
        if (((GlyphRun)o1.get(0)).originY < ((GlyphRun)o2.get(0)).originY) {
            return -1;
        }
        if (((GlyphRun)o1.get(0)).originY > ((GlyphRun)o2.get(0)).originY) {
            return 1;
        }
        return 0;
    };
    private static Comparator<GlyphRun> LTR_SORTER = new Comparator<GlyphRun>(){

        @Override
        public int compare(GlyphRun a, GlyphRun b) {
            return Float.compare(a.left(), b.left());
        }
    };
    private static Comparator<GlyphRun> RTL_SORTER = new Comparator<GlyphRun>(){

        @Override
        public int compare(GlyphRun a, GlyphRun b) {
            return Float.compare(b.left(), a.left());
        }
    };
    private final XHTMLContentHandler xhml;
    private final Map<String, Metadata> embeddedInfos;
    private String imageSourcePathInZip = null;
    private String originalLocationOnDrive = null;
    private Map<String, List<GlyphRun>> canvases = new LinkedHashMap<String, List<GlyphRun>>();
    private Set<String> urls = new LinkedHashSet<String>();
    private Stack<String> canvasStack = new Stack();

    public XPSPageContentHandler(XHTMLContentHandler xhtml, Map<String, Metadata> embeddedInfos) {
        this.xhml = xhtml;
        this.embeddedInfos = embeddedInfos;
    }

    private static String getVal(String localName, Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!localName.equals(atts.getLocalName(i))) continue;
            return atts.getValue(i);
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (CANVAS.equals(localName)) {
            String clip = XPSPageContentHandler.getVal(CLIP, atts);
            if (clip == null) {
                this.canvasStack.push(NULL_CLIP);
            } else {
                this.canvasStack.push(clip);
            }
            return;
        }
        if (VISUAL_BRUSH.equals(localName)) {
            String transform = XPSPageContentHandler.getVal(TRANSFORM, atts);
            if (transform == null) {
                this.canvasStack.push(NULL_CLIP);
            } else {
                this.canvasStack.push(transform);
            }
            return;
        }
        if (PATH.equals(localName)) {
            String url = XPSPageContentHandler.getVal(NAVIGATE_URI, atts);
            if (url != null) {
                this.urls.add(url);
            }
            this.originalLocationOnDrive = XPSPageContentHandler.getVal(AUTOMATION_PROPERITES_HELP_TEXT, atts);
        } else if (IMAGE_BRUSH.equals(localName)) {
            this.imageSourcePathInZip = XPSPageContentHandler.getVal(IMAGE_SOURCE, atts);
        }
        if (!GLYPHS.equals(localName)) {
            return;
        }
        String name = null;
        Float originX = null;
        Float originY = null;
        String unicodeString = null;
        Integer bidilevel = null;
        List<GlyphIndex> indices = null;
        float fontSize = 0.0f;
        String fontUri = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String lName = atts.getLocalName(i);
            String value = atts.getValue(i);
            String string = value = value == null ? "" : value.trim();
            if (ORIGIN_X.equals(lName) && value.length() > 0) {
                try {
                    originX = Float.valueOf(Float.parseFloat(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (ORIGIN_Y.equals(lName) && value.length() > 0) {
                try {
                    originY = Float.valueOf(Float.parseFloat(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (UNICODE_STRING.equals(lName)) {
                unicodeString = atts.getValue(i);
                continue;
            }
            if (BIDI_LEVEL.equals(lName) && value.length() > 0) {
                try {
                    bidilevel = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (INDICES.equals(lName)) {
                indices = this.parseIndicesString(value);
                continue;
            }
            if (NAME.equals(lName)) {
                name = value;
                continue;
            }
            if (FONT_RENDERING_EM_SIZE.equals(lName)) {
                fontSize = Float.parseFloat(value);
                continue;
            }
            if (!FONT_URI.equals(lName)) continue;
            fontUri = value;
        }
        if (unicodeString != null) {
            originX = Float.valueOf(originX == null ? -2.1474836E9f : originX.floatValue());
            originY = Float.valueOf(originY == null ? 2.1474836E9f : originY.floatValue());
            StringBuilder canvasStringBuilder = new StringBuilder();
            for (String s : this.canvasStack) {
                canvasStringBuilder.append(s);
                canvasStringBuilder.append(';');
            }
            String canvasCombined = canvasStringBuilder.toString();
            List<GlyphRun> runs = this.canvases.get(canvasCombined);
            if (runs == null) {
                runs = new ArrayList<GlyphRun>();
            }
            if (indices == null) {
                indices = new ArrayList<GlyphIndex>();
            }
            runs.add(new GlyphRun(name, originY.floatValue(), originX.floatValue(), unicodeString, bidilevel, indices, fontSize, fontUri));
            this.canvases.put(canvasCombined, runs);
        }
    }

    private List<GlyphIndex> parseIndicesString(String indicesString) throws SAXException {
        try {
            ArrayList<GlyphIndex> indices = new ArrayList<GlyphIndex>();
            for (String indexString : indicesString.split(";", -1)) {
                String[] commaSplit = indexString.split(",", -1);
                if (commaSplit.length < 2 || StringUtils.isBlank((String)commaSplit[1])) {
                    indices.add(new GlyphIndex(0.0f));
                    continue;
                }
                float advance = Float.parseFloat(commaSplit[1]) / 100.0f;
                indices.add(new GlyphIndex(advance));
            }
            return indices;
        }
        catch (NumberFormatException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (CANVAS.equals(localName)) {
            if (!this.canvasStack.isEmpty()) {
                this.canvasStack.pop();
            }
        } else if (PATH.equals(localName)) {
            if (this.imageSourcePathInZip != null) {
                String val;
                Metadata m = this.embeddedInfos.get(this.imageSourcePathInZip);
                if (m == null) {
                    m = new Metadata();
                }
                if (this.originalLocationOnDrive != null && (val = m.get(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)) == null) {
                    m.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, this.originalLocationOnDrive);
                }
                m.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
                this.embeddedInfos.put(this.imageSourcePathInZip, m);
            }
            this.imageSourcePathInZip = null;
            this.originalLocationOnDrive = null;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.xhml.startElement(DIV, CLASS, PAGE);
    }

    @Override
    public void endDocument() throws SAXException {
        this.writePage();
        this.xhml.endElement(DIV);
    }

    private final void writePage() throws SAXException {
        if (this.canvases.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<GlyphRun>> e : this.canvases.entrySet()) {
            List<GlyphRun> runs = e.getValue();
            if (runs.size() == 0) continue;
            this.xhml.startElement(DIV, CLASS, CANVAS_SAX);
            List<List<GlyphRun>> rows = this.buildRows(runs);
            for (List<GlyphRun> row : rows) {
                this.writeRow(row);
            }
            this.xhml.endElement(DIV);
        }
        if (this.urls.size() > 0) {
            this.xhml.startElement(DIV, CLASS, URL_DIV);
            for (String u : this.urls) {
                this.xhml.startElement(A, HREF, u);
                this.xhml.characters(u);
                this.xhml.endElement(A);
            }
            this.xhml.endElement(DIV);
        }
        this.canvases.clear();
    }

    private void writeRow(List<GlyphRun> row) throws SAXException {
        row = XPSPageContentHandler.splitRow(row);
        XPSPageContentHandler.sortRow(row);
        this.xhml.startElement(P);
        GlyphRun previous = null;
        for (GlyphRun run : row) {
            float averageFontSize;
            float distanceFromPrevious;
            if (previous != null && (distanceFromPrevious = run.left() - previous.right()) > (averageFontSize = (run.fontSize + previous.fontSize) / 2.0f) * 0.3f) {
                this.xhml.ignorableWhitespace(SPACE, 0, SPACE.length);
            }
            this.xhml.characters(run.unicodeString);
            previous = run;
        }
        this.xhml.endElement(P);
    }

    private static List<GlyphRun> splitRow(List<GlyphRun> row) {
        ArrayList<GlyphRun> newRuns = new ArrayList<GlyphRun>();
        for (int j = 0; j < row.size(); ++j) {
            GlyphRun run = row.get(j);
            if (run.direction != GlyphRun.DIRECTION.LTR) {
                newRuns.add(run);
                continue;
            }
            float width = 0.0f;
            for (int i = 0; i < run.indices.size() - 1; ++i) {
                GlyphIndex index = (GlyphIndex)run.indices.get(i);
                width = index.advance == 0.0f ? (i == 0 ? (width += 0.5f) : (width += width / (float)i)) : (width += index.advance);
                if (!(index.advance > 1.0f)) continue;
                newRuns.add(new GlyphRun(run.name, run.originY, run.originX, run.unicodeString.substring(0, i + 1), null, run.indices.subList(0, i + 1), run.fontSize, run.fontUri));
                run.indices.set(i, new GlyphIndex(0.0f));
                run = new GlyphRun(run.name, run.originY, run.originX + width * run.fontSize, run.unicodeString.substring(i + 1, run.unicodeString.length()), null, run.indices.subList(i + 1, run.indices.size()), run.fontSize, run.fontUri);
                i = 0;
                width = 0.0f;
            }
            newRuns.add(run);
        }
        return newRuns;
    }

    private static void sortRow(List<GlyphRun> row) {
        boolean allRTL = true;
        for (GlyphRun run : row) {
            if (run.unicodeString.trim().length() == 0 || run.direction != GlyphRun.DIRECTION.LTR) continue;
            allRTL = false;
            break;
        }
        if (allRTL) {
            Collections.sort(row, RTL_SORTER);
        } else {
            Collections.sort(row, LTR_SORTER);
        }
    }

    private List<List<GlyphRun>> buildRows(List<GlyphRun> glyphRuns) {
        ArrayList<List<GlyphRun>> rows = new ArrayList<List<GlyphRun>>();
        float maxY = -1.0f;
        for (GlyphRun glyphRun : glyphRuns) {
            if (rows.size() == 0) {
                ArrayList<GlyphRun> row = new ArrayList<GlyphRun>();
                row.add(glyphRun);
                rows.add(row);
                continue;
            }
            boolean addedNewRow = false;
            List<GlyphRun> row = this.findClosestRowVertically(rows, glyphRun.originY);
            GlyphRun firstRun = row.get(0);
            float averageFontSize = (glyphRun.fontSize + firstRun.fontSize) / 2.0f;
            if (Math.abs(glyphRun.originY - firstRun.originY) < averageFontSize * 0.5f) {
                row.add(glyphRun);
            } else {
                row = new ArrayList<GlyphRun>();
                row.add(glyphRun);
                rows.add(row);
                addedNewRow = true;
            }
            if (maxY > -1.0f && addedNewRow && glyphRun.originY < maxY) {
                rows.sort(ROW_SORTER);
            }
            if (!(glyphRun.originY > maxY)) continue;
            maxY = glyphRun.originY;
        }
        return rows;
    }

    private List<GlyphRun> findClosestRowVertically(List<List<GlyphRun>> rows, float y) {
        List<GlyphRun> best = null;
        float bestDistance = Float.POSITIVE_INFINITY;
        for (int i = rows.size() - 1; i >= 0; --i) {
            List<GlyphRun> row = rows.get(i);
            if (row.size() == 0) continue;
            float distance = Math.abs(row.get(row.size() - 1).originY - y);
            if (distance == 0.0f) {
                return row;
            }
            if (!(distance < bestDistance)) continue;
            best = row;
            bestDistance = distance;
        }
        return best;
    }

    static final class GlyphIndex {
        private final float advance;

        private GlyphIndex(float advance) {
            this.advance = advance;
        }
    }

    static final class GlyphRun {
        private final String name;
        private final float originY;
        private final float originX;
        private final String unicodeString;
        private final List<GlyphIndex> indices;
        private final DIRECTION direction;
        private final float fontSize;
        private final String fontUri;

        private GlyphRun(String name, float originY, float originX, String unicodeString, Integer bidiLevel, List<GlyphIndex> indices, float fontSize, String fontUri) {
            this.name = name;
            this.unicodeString = unicodeString;
            this.originY = originY;
            this.originX = originX;
            this.fontSize = fontSize;
            this.fontUri = fontUri;
            this.indices = indices;
            this.direction = bidiLevel == null ? DIRECTION.LTR : (bidiLevel % 2 == 0 ? DIRECTION.LTR : DIRECTION.RTL);
        }

        private float left() {
            if (this.direction == DIRECTION.LTR) {
                return this.originX;
            }
            return this.originX - this.width();
        }

        private float right() {
            if (this.direction == DIRECTION.LTR) {
                return this.originX + this.width();
            }
            return this.originX;
        }

        private float width() {
            float width = 0.0f;
            for (int i = 0; i < this.indices.size(); ++i) {
                if ((double)this.indices.get(i).advance == 0.0) {
                    if (i == 0) {
                        width += 0.5f;
                        continue;
                    }
                    width += width / (float)i;
                    continue;
                }
                width += this.indices.get(i).advance;
            }
            return width * this.fontSize;
        }

        private static enum DIRECTION {
            LTR,
            RTL;

        }
    }
}

