/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.concurrent.Executor;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class EsqlResolveFieldsAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    public static final String NAME = "indices:data/read/esql/resolve_fields";
    public static final ActionType<FieldCapabilitiesResponse> TYPE = new ActionType("indices:data/read/esql/resolve_fields");
    public static final RemoteClusterActionType<FieldCapabilitiesResponse> RESOLVE_REMOTE_TYPE = new RemoteClusterActionType("indices:data/read/esql/resolve_fields", FieldCapabilitiesResponse::new);
    private final TransportFieldCapabilitiesAction fieldCapsAction;

    @Inject
    public EsqlResolveFieldsAction(TransportService transportService, ActionFilters actionFilters, TransportFieldCapabilitiesAction fieldCapsAction) {
        super(NAME, transportService, actionFilters, FieldCapabilitiesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.fieldCapsAction = fieldCapsAction;
    }

    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        this.fieldCapsAction.executeRequest(task, request, this::executeRemoteRequest, listener);
    }

    void executeRemoteRequest(RemoteClusterClient remoteClient, FieldCapabilitiesRequest remoteRequest, ActionListener<FieldCapabilitiesResponse> remoteListener) {
        remoteClient.getConnection((ActionRequest)remoteRequest, remoteListener.delegateFailure((l, conn) -> {
            RemoteClusterActionType remoteAction = conn.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? RESOLVE_REMOTE_TYPE : TransportFieldCapabilitiesAction.REMOTE_TYPE;
            remoteClient.execute(conn, remoteAction, (ActionRequest)remoteRequest, l);
        }));
    }
}

