/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistance;

public final class StDistanceGeoSourceAndConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator left;
    private final Point right;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StDistanceGeoSourceAndConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator left, Point right, DriverContext driverContext) {
        this.source = source;
        this.left = left;
        this.right = right;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock leftBlock = (BytesRefBlock)this.left.eval(page);){
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), leftBlock);
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, BytesRefBlock leftBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!leftBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StDistance.processGeoSourceAndConstant(result, p, leftBlock, this.right);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "StDistanceGeoSourceAndConstantEvaluator[left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.left);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory left;
        private final Point right;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory left, Point right) {
            this.source = source;
            this.left = left;
            this.right = right;
        }

        public StDistanceGeoSourceAndConstantEvaluator get(DriverContext context) {
            return new StDistanceGeoSourceAndConstantEvaluator(this.source, this.left.get(context), this.right, context);
        }

        public String toString() {
            return "StDistanceGeoSourceAndConstantEvaluator[left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "]";
        }
    }
}

