/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.function.Function;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Space;

public final class SpaceEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final BreakingBytesRefBuilder scratch;
    private final EvalOperator.ExpressionEvaluator number;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SpaceEvaluator(Source source, BreakingBytesRefBuilder scratch, EvalOperator.ExpressionEvaluator number, DriverContext driverContext) {
        this.source = source;
        this.scratch = scratch;
        this.number = number;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock numberBlock = (IntBlock)this.number.eval(page);){
            IntVector numberVector = numberBlock.asVector();
            if (numberVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), numberBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), numberVector);
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, IntBlock numberBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (numberBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (numberBlock.getValueCount(p) != 1) {
                    if (numberBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBytesRef(Space.process(this.scratch, numberBlock.getInt(numberBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, IntVector numberVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBytesRef(Space.process(this.scratch, numberVector.getInt(p)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "SpaceEvaluator[number=" + String.valueOf(this.number) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.scratch, this.number});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final Function<DriverContext, BreakingBytesRefBuilder> scratch;
        private final EvalOperator.ExpressionEvaluator.Factory number;

        public Factory(Source source, Function<DriverContext, BreakingBytesRefBuilder> scratch, EvalOperator.ExpressionEvaluator.Factory number) {
            this.source = source;
            this.scratch = scratch;
            this.number = number;
        }

        public SpaceEvaluator get(DriverContext context) {
            return new SpaceEvaluator(this.source, this.scratch.apply(context), this.number.get(context), context);
        }

        public String toString() {
            return "SpaceEvaluator[number=" + String.valueOf(this.number) + "]";
        }
    }
}

