/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.nulls;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.querydsl.query.ExistsQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class IsNotNull
extends UnaryScalarFunction
implements Negatable<UnaryScalarFunction>,
TranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "IsNotNull", IsNotNull::new);

    public IsNotNull(Source source, Expression field) {
        super(source, field);
    }

    private IsNotNull(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return IsNotNull.ENTRY.name;
    }

    protected NodeInfo<IsNotNull> info() {
        return NodeInfo.create((Node)this, IsNotNull::new, (Object)this.field());
    }

    protected IsNotNull replaceChild(Expression newChild) {
        return new IsNotNull(this.source(), newChild);
    }

    public Object fold(FoldContext ctx) {
        return !DataType.isNull((DataType)this.field().dataType()) && this.field().fold(ctx) != null;
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public UnaryScalarFunction negate() {
        return new IsNull(this.source(), this.field());
    }

    @Override
    public boolean translatable(LucenePushdownPredicates pushdownPredicates) {
        return IsNull.isTranslatable(this.field(), pushdownPredicates);
    }

    @Override
    public Query asQuery(TranslatorHandler handler) {
        return new ExistsQuery(this.source(), handler.nameOf(this.field()));
    }
}

