/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStatsFilteredAggWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferIsNotNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferNonNullAggConstraint;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.LocalPropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceMissingFieldWithNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceTopNWithLimitAndSort;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LocalLogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LocalLogicalOptimizerContext> {
    public LocalLogicalPlanOptimizer(LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        super(localLogicalOptimizerContext);
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        RuleExecutor.Batch local = new RuleExecutor.Batch("Local rewrite", RuleExecutor.Limiter.ONCE, new ReplaceTopNWithLimitAndSort(), new ReplaceMissingFieldWithNull(), new InferIsNotNull(), new InferNonNullAggConstraint());
        ArrayList<RuleExecutor.Batch<LogicalPlan>> rules = new ArrayList<RuleExecutor.Batch<LogicalPlan>>();
        rules.add(local);
        rules.addAll(Arrays.asList(LogicalPlanOptimizer.operators(), LogicalPlanOptimizer.cleanup()));
        return this.replaceRules(rules);
    }

    private List<RuleExecutor.Batch<LogicalPlan>> replaceRules(List<RuleExecutor.Batch<LogicalPlan>> listOfRules) {
        ArrayList<RuleExecutor.Batch<LogicalPlan>> newBatches = new ArrayList<RuleExecutor.Batch<LogicalPlan>>(listOfRules.size());
        for (RuleExecutor.Batch<LogicalPlan> batch : listOfRules) {
            Rule<?, LogicalPlan>[] rules = batch.rules();
            ArrayList newRules = new ArrayList(rules.length);
            boolean updated = false;
            for (Rule<?, LogicalPlan> r : rules) {
                if (r instanceof PropagateEmptyRelation) {
                    newRules.add(new LocalPropagateEmptyRelation());
                    updated = true;
                    continue;
                }
                if (r instanceof ReplaceStatsFilteredAggWithEval) {
                    updated = true;
                    continue;
                }
                newRules.add(r);
            }
            batch = updated ? batch.with((Rule[])newRules.toArray(Rule[]::new)) : batch;
            newBatches.add(batch);
        }
        return newBatches;
    }

    public LogicalPlan localOptimize(LogicalPlan plan) {
        return this.execute(plan);
    }
}

