/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.parser.AbstractBuilder;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;

abstract class IdentifierBuilder
extends AbstractBuilder {
    IdentifierBuilder() {
    }

    @Override
    public String visitIdentifier(EsqlBaseParser.IdentifierContext ctx) {
        return ctx == null ? null : IdentifierBuilder.unquoteIdentifier(ctx.QUOTED_IDENTIFIER(), ctx.UNQUOTED_IDENTIFIER());
    }

    protected static String unquoteIdentifier(TerminalNode quotedNode, TerminalNode unquotedNode) {
        String result = quotedNode != null ? IdentifierBuilder.unquoteIdString(quotedNode.getText()) : unquotedNode.getText();
        return result;
    }

    protected static String unquoteIdString(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1).replace("``", "`");
    }

    protected static String quoteIdString(String unquotedString) {
        return "`" + unquotedString.replace("`", "``") + "`";
    }

    @Override
    public String visitClusterString(EsqlBaseParser.ClusterStringContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.UNQUOTED_SOURCE() != null) {
            return ctx.UNQUOTED_SOURCE().getText();
        }
        return IdentifierBuilder.unquote(ctx.QUOTED_STRING().getText());
    }

    @Override
    public String visitIndexString(EsqlBaseParser.IndexStringContext ctx) {
        if (ctx.UNQUOTED_SOURCE() != null) {
            return ctx.UNQUOTED_SOURCE().getText();
        }
        return IdentifierBuilder.unquote(ctx.QUOTED_STRING().getText());
    }

    public String visitIndexPattern(List<EsqlBaseParser.IndexPatternContext> ctx) {
        ArrayList patterns = new ArrayList(ctx.size());
        Holder hasSeenStar = new Holder((Object)false);
        ctx.forEach(c -> {
            String indexPattern = this.visitIndexString(c.indexString());
            String clusterString = this.visitClusterString(c.clusterString());
            if (clusterString == null) {
                hasSeenStar.set((Object)(indexPattern.contains("*") || (Boolean)hasSeenStar.get() != false ? 1 : 0));
                IdentifierBuilder.validateIndexPattern(indexPattern, c, (Boolean)hasSeenStar.get());
            } else {
                IdentifierBuilder.validateClusterString(clusterString, c);
            }
            patterns.add(clusterString != null ? clusterString + ":" + indexPattern : indexPattern);
        });
        return Strings.collectionToDelimitedString(patterns, (String)",");
    }

    protected static void validateClusterString(String clusterString, EsqlBaseParser.IndexPatternContext ctx) {
        if (clusterString.indexOf(58) != -1) {
            throw new ParsingException(ParserUtils.source(ctx), "cluster string [{}] must not contain ':'", clusterString);
        }
    }

    private static void validateIndexPattern(String indexPattern, EsqlBaseParser.IndexPatternContext ctx, boolean hasSeenStar) {
        String[] indices = indexPattern.split(",");
        boolean hasExclusion = false;
        for (String index : indices) {
            String tempName;
            if (RemoteClusterAware.isRemoteIndexName((String)index)) continue;
            hasSeenStar = index.contains("*") || hasSeenStar;
            if ((index = index.replace("*", "").strip()).isBlank()) continue;
            hasExclusion = index.startsWith("-");
            index = IdentifierBuilder.removeExclusion(index);
            try {
                tempName = IndexNameExpressionResolver.resolveDateMathExpression((String)index);
            }
            catch (ElasticsearchParseException e) {
                throw new ParsingException((Exception)((Object)e), ParserUtils.source(ctx), e.getMessage(), new Object[0]);
            }
            hasExclusion = tempName.startsWith("-") || hasExclusion;
            index = tempName.equals(index) ? index : IdentifierBuilder.removeExclusion(tempName);
            try {
                MetadataCreateIndexService.validateIndexOrAliasName((String)index, InvalidIndexNameException::new);
            }
            catch (InvalidIndexNameException e) {
                if (hasSeenStar && hasExclusion) continue;
                throw new ParsingException((Exception)((Object)e), ParserUtils.source(ctx), e.getMessage(), new Object[0]);
            }
        }
    }

    private static String removeExclusion(String indexPattern) {
        return indexPattern.charAt(0) == "-".charAt(0) ? indexPattern.substring(1) : indexPattern;
    }
}

