/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class UriPartsProcessor
extends AbstractProcessor {
    public static final String TYPE = "uri_parts";
    private final String field;
    private final String targetField;
    private final boolean removeIfSuccessful;
    private final boolean keepOriginal;
    private final boolean ignoreMissing;

    UriPartsProcessor(String tag, String description, String field, String targetField, boolean removeIfSuccessful, boolean keepOriginal, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.removeIfSuccessful = removeIfSuccessful;
        this.keepOriginal = keepOriginal;
        this.ignoreMissing = ignoreMissing;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public boolean getRemoveIfSuccessful() {
        return this.removeIfSuccessful;
    }

    public boolean getKeepOriginal() {
        return this.keepOriginal;
    }

    public Object getIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        String value = (String)ingestDocument.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (this.ignoreMissing && null == value) {
            return ingestDocument;
        }
        Map<String, Object> uriParts = UriPartsProcessor.apply(value);
        if (this.keepOriginal) {
            uriParts.put("original", value);
        }
        if (this.removeIfSuccessful && !this.targetField.equals(this.field)) {
            ingestDocument.removeField(this.field);
        }
        ingestDocument.setFieldValue(this.targetField, uriParts);
        return ingestDocument;
    }

    public static Map<String, Object> apply(String urlString) {
        URI uri = null;
        URL url = null;
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException("unable to parse URI [" + urlString + "]");
            }
        }
        return UriPartsProcessor.getUriParts(uri, url);
    }

    @SuppressForbidden(reason="URL.getPath is used only if URI.getPath is unavailable")
    private static Map<String, Object> getUriParts(URI uri, URL fallbackUrl) {
        String userInfo;
        String scheme;
        String query;
        int port;
        String path;
        String fragment;
        String domain;
        HashMap<String, Object> uriParts = new HashMap<String, Object>();
        if (uri != null) {
            domain = uri.getHost();
            fragment = uri.getFragment();
            path = uri.getPath();
            port = uri.getPort();
            query = uri.getQuery();
            scheme = uri.getScheme();
            userInfo = uri.getUserInfo();
        } else if (fallbackUrl != null) {
            domain = fallbackUrl.getHost();
            fragment = fallbackUrl.getRef();
            path = fallbackUrl.getPath();
            port = fallbackUrl.getPort();
            query = fallbackUrl.getQuery();
            scheme = fallbackUrl.getProtocol();
            userInfo = fallbackUrl.getUserInfo();
        } else {
            throw new IllegalArgumentException("at least one argument must be non-null");
        }
        uriParts.put("domain", domain);
        if (fragment != null) {
            uriParts.put("fragment", fragment);
        }
        if (path != null) {
            String lastSegment;
            int periodIndex;
            uriParts.put("path", path);
            int lastSegmentIndex = path.lastIndexOf(47);
            if (lastSegmentIndex >= 0 && (periodIndex = (lastSegment = path.substring(lastSegmentIndex)).lastIndexOf(46)) >= 0) {
                uriParts.put("extension", lastSegment.substring(periodIndex + 1));
            }
        }
        if (port != -1) {
            uriParts.put("port", port);
        }
        if (query != null) {
            uriParts.put("query", query);
        }
        uriParts.put("scheme", scheme);
        if (userInfo != null) {
            uriParts.put("user_info", userInfo);
            if (userInfo.contains(":")) {
                int colonIndex = userInfo.indexOf(58);
                uriParts.put("username", userInfo.substring(0, colonIndex));
                uriParts.put("password", colonIndex < userInfo.length() ? userInfo.substring(colonIndex + 1) : "");
            }
        }
        return uriParts;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public UriPartsProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)UriPartsProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)UriPartsProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)"url");
            boolean removeIfSuccessful = ConfigurationUtils.readBooleanProperty((String)UriPartsProcessor.TYPE, (String)processorTag, config, (String)"remove_if_successful", (boolean)false);
            boolean keepOriginal = ConfigurationUtils.readBooleanProperty((String)UriPartsProcessor.TYPE, (String)processorTag, config, (String)"keep_original", (boolean)true);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)UriPartsProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new UriPartsProcessor(processorTag, description, field, targetField, removeIfSuccessful, keepOriginal, ignoreMissing);
        }
    }
}

