/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.elasticsearch.analysis.common.LegacyRomanianStemmer;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.tartarus.snowball.SnowballStemmer;

public class RomanianAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StopwordAnalyzerBase> {
    private final StopwordAnalyzerBase analyzer;

    RomanianAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name);
        CharArraySet stopwords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)RomanianAnalyzer.getDefaultStopSet());
        final CharArraySet stemExclusionSet = Analysis.parseStemExclusion((Settings)settings, (CharArraySet)CharArraySet.EMPTY_SET);
        this.analyzer = indexSettings.getIndexVersionCreated().onOrAfter((VersionId)IndexVersions.UPGRADE_TO_LUCENE_10_0_0) ? new RomanianAnalyzer(stopwords, stemExclusionSet) : new StopwordAnalyzerBase(this, Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)RomanianAnalyzer.getDefaultStopSet())){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer source = new StandardTokenizer();
                LowerCaseFilter result = new LowerCaseFilter((TokenStream)source);
                result = new StopFilter((TokenStream)result, this.stopwords);
                if (!stemExclusionSet.isEmpty()) {
                    result = new SetKeywordMarkerFilter((TokenStream)result, stemExclusionSet);
                }
                result = new SnowballFilter((TokenStream)result, (SnowballStemmer)new LegacyRomanianStemmer());
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
            }

            protected TokenStream normalize(String fieldName, TokenStream in) {
                return new LowerCaseFilter(in);
            }
        };
    }

    public StopwordAnalyzerBase get() {
        return this.analyzer;
    }
}

