/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.action.DeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.action.TransportDeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportPutSnapshotLifecycleAction;

public class ReservedSnapshotAction
implements ReservedClusterStateHandler<List<SnapshotLifecyclePolicy>> {
    public static final String NAME = "slm";

    public String name() {
        return NAME;
    }

    private Collection<PutSnapshotLifecycleAction.Request> prepare(List<SnapshotLifecyclePolicy> policies, ClusterState state) {
        ArrayList<PutSnapshotLifecycleAction.Request> result = new ArrayList<PutSnapshotLifecycleAction.Request>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (SnapshotLifecyclePolicy policy : policies) {
            PutSnapshotLifecycleAction.Request request = new PutSnapshotLifecycleAction.Request(RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, policy.getId(), policy);
            try {
                this.validate((MasterNodeRequest)request);
                SnapshotLifecycleService.validateRepositoryExists(request.getLifecycle().getRepository(), state);
                SnapshotLifecycleService.validateMinimumInterval(request.getLifecycle(), state);
                result.add(request);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error on validating SLM requests");
            exceptions.forEach(illegalArgumentException::addSuppressed);
            throw illegalArgumentException;
        }
        return result;
    }

    public TransformState transform(Object source, TransformState prevState) throws Exception {
        Collection<PutSnapshotLifecycleAction.Request> requests = this.prepare((List)source, prevState.state());
        ClusterState state = prevState.state();
        for (PutSnapshotLifecycleAction.Request request : requests) {
            TransportPutSnapshotLifecycleAction.UpdateSnapshotPolicyTask task = new TransportPutSnapshotLifecycleAction.UpdateSnapshotPolicyTask(request);
            state = task.execute(state);
        }
        Set entities = requests.stream().map(r -> r.getLifecycle().getId()).collect(Collectors.toSet());
        HashSet toDelete = new HashSet(prevState.keys());
        toDelete.removeAll(entities);
        for (String policyToDelete : toDelete) {
            TransportDeleteSnapshotLifecycleAction.DeleteSnapshotPolicyTask task = new TransportDeleteSnapshotLifecycleAction.DeleteSnapshotPolicyTask(new DeleteSnapshotLifecycleAction.Request(RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, policyToDelete), (ActionListener<AcknowledgedResponse>)ActionListener.noop());
            state = task.execute(state);
        }
        return new TransformState(state, entities);
    }

    public List<SnapshotLifecyclePolicy> fromXContent(XContentParser parser) throws IOException {
        ArrayList<SnapshotLifecyclePolicy> result = new ArrayList<SnapshotLifecyclePolicy>();
        Map source = parser.map();
        for (String name : source.keySet()) {
            Map content = (Map)source.get(name);
            XContentParser policyParser = XContentHelper.mapToXContentParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (Map)content);
            try {
                result.add(SnapshotLifecyclePolicy.parse((XContentParser)policyParser, (String)name));
            }
            finally {
                if (policyParser == null) continue;
                policyParser.close();
            }
        }
        return result;
    }

    public Collection<String> optionalDependencies() {
        return List.of("snapshot_repositories");
    }
}

